(function () {
  try {
    // Ensure global stub to avoid errors if SDK isn't loaded
    window.adsbygoogle = window.adsbygoogle || [];

    var meta = document.querySelector('meta[name="google-adsense-account"]');
    var client = (meta && meta.content ? meta.content : '').trim();
    var isPlaceholder = !client || client === 'ca-pub-1234567890123456' || client === 'ca-pub-YOUR_PUBLISHER_ID';

    function hideAllAds() {
      var selectors = [
        '.adsense-container',
        '.adsense-sidebar',
        '.desktop-ads-container',
        'ins.adsbygoogle'
      ];
      document.querySelectorAll(selectors.join(',')).forEach(function (el) {
        try {
          el.style.display = 'none';
          el.setAttribute('aria-hidden', 'true');
        } catch (e) {}
      });
    }

    if (isPlaceholder) {
      // No valid client configured; don't load SDK and hide placeholders
      hideAllAds();
      return;
    }

    // Dynamically load the AdSense SDK with the provided client
    var script = document.createElement('script');
    script.async = true;
    script.src = 'https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=' + encodeURIComponent(client);
    script.crossOrigin = 'anonymous';
    document.head.appendChild(script);

    // Rely on inline pushes next to each ad slot in HTML. No auto-push here to avoid duplicates.
  } catch (err) {
    // On any unexpected error, fail closed: hide ad placeholders
    try {
      document.querySelectorAll('.adsense-container, .adsense-sidebar, .desktop-ads-container, ins.adsbygoogle').forEach(function (el) {
        el.style.display = 'none';
      });
    } catch (_) {}
  }
})();


