// Dil Rehberleri Çeviri Dosyası
// rehber_translations.js

    const rehberPageTranslations = {
    tr: {
     // Genel
        "learning-tactics-title": "Öğrenme Taktikleri",
            "culture-note-title": "💡 Dil ve Kültür Notu",
    
            // İngilizce
            "en-intro-title": "İngilizceye Giriş: Bir Dünya Dili",
            "en-intro-p": "Hint-Avrupa dil ailesinin Cermen koluna mensup olan İngilizce, günümüzde bilimden teknolojiye, ticaretten diplomasiye kadar küresel iletişimin ortak dili (lingua franca) konumundadır. Analitik bir dil yapısına sahip olması, yani kelimelerin cümle içindeki işlevinin kelime sonu eklerinden ziyade kelime sırası ve yardımcı kelimelerle (prepositions, auxiliary verbs) belirlenmesi, onu diğer birçok dilden ayırır. Bu yolculukta, İngilizcenin esnek ve mantıksal yapısını keşfedecek ve küresel bir topluluğun parçası olacaksınız.",
            "en-grammar-analysis-title": "İngilizce Gramer Analizi",
            "en-articles-title": "Articles (a/an, the)",
            "en-articles-exp": "<b>a/an:</b> Genel bir nesneden bahsederken kullanılır. <b>the:</b> Belirli, daha önce bahsedilmiş bir nesneden bahsederken kullanılır.",
            "en-present-simple-title": "Present Simple",
            "en-present-simple-exp": "<b>Kullanım:</b> Genel doğrular, alışkanlıklar. He/She/It ile fiil \"-s\" takısı alır.",
            "en-past-simple-title": "Past Simple",
            "en-past-simple-exp": "<b>Kullanım:</b> Geçmişte bitmiş eylemler. Düzenli fiiller \"-ed\" alır, düzensizler değişir (V2).",
            "en-past-simple-attn": "<b>Dikkat:</b> Olumsuz ve soruda `did` kullanıldığında fiil yalın hale döner.",
            "en-present-perfect-title": "Present Perfect",
            "en-present-perfect-exp": "<b>Kullanım:</b> Geçmişte başlayıp etkisi devam eden veya belirsiz bir zamanda olmuş eylemler. Yapı: have/has + V3.",
            "en-modal-verbs-title": "Modal Verbs",
            "en-modal-verbs-exp": "<b>İşlevi:</b> Cümleye yetenek (can), olasılık (may), gereklilik (must), tavsiye (should) gibi anlamlar katarlar.",
            "en-gerunds-infinitives-title": "Gerunds & Infinitives",
            "en-gerunds-infinitives-exp": "<b>Gerund (V-ing):</b> Bazı fiillerden sonra isim olarak kullanılır. (Enjoy, mind, suggest + V-ing).<br><b>Infinitive (to V):</b> Bazı fiillerden sonra amaç belirtmek için kullanılır. (Want, need, decide + to V).",
            "en-conditionals-title": "Conditional Sentences",
            "en-conditionals-exp": "<b>Zero Conditional:</b> Genel doğrular (If + Present, Present).<br><b>First Conditional:</b> Olası gelecek (If + Present, will + V).<br><b>Second Conditional:</b> Hayali durumlar (If + Past, would + V).",
            "en-passive-voice-title": "Passive Voice",
            "en-passive-voice-exp": "<b>Yapı:</b> be + V3. Eylemi yapan kişi önemli değilken veya bilinmediğinde kullanılır.",
            "en-reported-speech-title": "Reported Speech",
            "en-reported-speech-exp": "<b>Kural:</b> Başkasının sözünü aktarırken zaman geriye kayar. Present → Past, Past → Past Perfect.",
            "en-relative-clauses-title": "Relative Clauses",
            "en-relative-clauses-exp": "<b>Defining:</b> Tanımlayıcı bilgi verir, virgül kullanılmaz.<br><b>Non-defining:</b> Ek bilgi verir, virgülle ayrılır.",
            "en-learning-tips-title": "İngilizce Öğrenme İpuçları",
            "en-5-golden-rules-title": "Başarılı İngilizce Öğrenimi İçin 5 Altın Kural",
            "en-tip-1": "<b>Günlük Pratik:</b> Her gün en az 30 dakika İngilizce ile ilgilenin. Tutarlılık, yoğun çalışmadan daha etkilidir.",
            "en-tip-2": "<b>Çoklu Kaynak:</b> Sadece ders kitaplarına değil, film, müzik, podcast ve haber gibi gerçek materyallere de odaklanın.",
            "en-tip-3": "<b>Hata Yapmaktan Korkmayın:</b> Hatalar öğrenmenin doğal bir parçasıdır. Konuşmaya çalışın, mükemmel olmaya çalışmayın.",
            "en-tip-4": "<b>Bağlam İçinde Öğrenin:</b> Kelimeleri tek başına değil, cümle içinde öğrenin. Bu hem anlamı hem de kullanımı pekiştirir.",
            "en-tip-5": "<b>Kültürel Bağlam:</b> İngilizceyi sadece dil olarak değil, kültürün bir parçası olarak öğrenin. Bu, dili daha anlamlı hale getirir.",
            "en-tip-6": "<b>💬 Sohbet Pratiği:</b> Lingoano'nun İngilizce sohbet özelliğini kullanarak gerçek zamanlı konuşma pratiği yapın. Bu, öğrendiğiniz gramer kurallarını ve kelimeleri doğal bir şekilde kullanmanızı sağlar.",
            "en-learning-strategies-title": "İngilizce Öğrenme Stratejileri",
            "en-tactic-1": "<b>Kelime Öğrenme Stratejisi:</b> Kelimeleri bağlam içinde öğrenin. Tek başına kelime listesi yerine, cümle içinde kullanılan kelimeleri ezberleyin. Lingoano'nun İngilizce sohbet özelliğini kullanarak yeni öğrendiğiniz kelimeleri gerçek zamanlı konuşmada pratik edin.",
            "en-tactic-2": "<b>Gramer Öğrenme Yaklaşımı:</b> Gramer kurallarını sadece teorik olarak değil, pratik cümlelerle öğrenin. Her yeni kural öğrendiğinizde, o kuralı kullanarak en az 5 farklı cümle kurun. Lingoano ile bu cümleleri gerçek konuşma ortamında test edin.",
            "en-tactic-3": "<b>Dinleme ve Telaffuz Geliştirme:</b> Farklı aksanları dinleyin (İngiliz, Amerikan, Avustralya). Podcast'ler, YouTube videoları ve filmler izleyin. Lingoano'nun sesli sohbet özelliği ile telaffuzunuzu geliştirin ve gerçek İngilizce konuşmacılarla pratik yapın.",
            "en-tactic-4": "<b>Konuşma Pratiği:</b> Pasif öğrenme yerine aktif konuşma pratiği yapın. Lingoano'nun İngilizce sohbet odalarında günlük konular hakkında konuşun, sorular sorun ve cevaplar verin. Bu, öğrendiğiniz gramer kurallarını doğal bir şekilde kullanmanızı sağlar.",
            "en-tactic-5": "<b>Kültürel Bağlam:</b> İngilizceyi sadece dil olarak değil, kültürün bir parçası olarak öğrenin. İngilizce haberler, blog yazıları ve sosyal medya içeriklerini takip edin. Lingoano'da bu konular hakkında sohbet ederek kültürel farkındalığınızı artırın.",
            "en-did-you-know": "İngilizcedeki \"phrasal verbs\" (örn: look up, give up, get along) sayısı binlercedir ve günlük konuşmanın temelini oluşturur. Bu deyimsel fiilleri öğrenmek, dili anadili gibi konuşanları anlamada ve daha doğal bir ifadeye sahip olmada kilit rol oynar.",
            
            // Akademik Kaynaklar
            "academic-sources-title": "Akademik Kaynaklar",
            "cefr-guidelines-title": "CEFR Rehberleri",
            "cefr-guidelines-desc": "Avrupa Dilleri Ortak Başvuru Metni (CEFR)",
            "second-language-acquisition-title": "İkinci Dil Edinimi",
            "second-language-acquisition-desc": "Cambridge SLA ders kitapları",
            "corpora-title": "Dil Derlemleri",
            "corpora-desc": "COCA/BNC gibi derlem kaynakları",
            "peer-reviewed-title": "Hakemli Çalışmalar",
            "peer-reviewed-desc": "Google Scholar literatür taraması",
    
            // Almanca
            "de-intro-title": "Almancaya Giriş: Mantık ve Yapı Dili",
            "de-intro-p": "İngilizce gibi Cermen dil ailesine mensup olan Almanca, kurallı ve mantıksal yapısıyla öne çıkar. İsmin halleri (Kasus) ve fiillerin cümledeki konumu gibi yapısal özellikleri, ona bir mühendislik hassasiyeti kazandırır. Bu yapı, ilk başta karmaşık görünse de, temel prensipleri anlaşıldığında dilin ne kadar öngörülebilir ve tutarlı olduğunu göreceksiniz. Almanca öğrenmek, sadece yeni bir iletişim kapısı aralamakla kalmaz, aynı zamanda analitik düşünme becerilerinizi de geliştirir.",
            "de-grammar-analysis-title": "Almanca Gramer Analizi",
            "de-artikel-title": "Artikel ve Cinsiyet",
            "de-artikel-exp": "<b>Kural:</b> Her ismin bir cinsiyeti vardır: <b>der</b> (eril), <b>die</b> (dişil), <b>das</b> (nötr). Kelimeyle birlikte ezberlenmelidir.",
            "de-artikel-attn": "<b>Dikkat:</b> \"das Mädchen\" (kız çocuğu) kelimesinin nötr olması, dilbilgisel cinsiyetin önemini gösterir.",
            "de-kasus-title": "İsmin Halleri (Kasus)",
            "de-kasus-exp": "Bir ismin cümledeki görevini belirtir ve artikeli değiştirir.<br><b>Nominativ:</b> Özne - <b>Der Hund</b> ist klein.<br><b>Akkusativ:</b> Belirtili nesne (-i) - Ich sehe <b>den Hund</b>.<br><b>Dativ:</b> Yönelme/dolaylı nesne (-e) - Ich gebe <b>dem Hund</b> Wasser.",
            "de-satzbau-title": "Söz Dizimi (Satzbau)",
            "de-satzbau-exp": "<b>Temel Kural (V2):</b> Düz cümlelerde çekimli fiil <b>daima ikinci pozisyondadır.</b>",
            "de-perfekt-title": "Perfekt Tense",
            "de-perfekt-exp": "<b>Kullanım:</b> Konuşma dilinde geçmiş zamanı anlatmak için en yaygın kullanılan yapıdır. Yapı: haben/sein + Partizip II.",
            "de-trennbare-verben-title": "Ayrılabilen Fiiller",
            "de-trennbare-verben-exp": "<b>Yapı:</b> \"anrufen\" (telefon etmek) gibi fiillerin ön ekleri (an-), ana cümlede cümlenin sonuna gider.",
            "de-praepositionen-title": "Edatlar (Präpositionen)",
            "de-praepositionen-exp": "Almancada edatlar kendilerinden sonra gelen ismin halini (Akkusativ veya Dativ) belirler. Bu ezberlenmelidir.<br><b>Akkusativ:</b> für, durch, gegen...<br><b>Dativ:</b> mit, nach, von, zu...",
            "de-konjunktiv-title": "Konjunktiv II",
            "de-konjunktiv-exp": "<b>Kullanım:</b> Hayali durumlar, nazik istekler ve geçmişte olmayan olayları ifade etmek için kullanılır.",
            "de-relativsaetze-title": "Relativsätze",
            "de-relativsaetze-exp": "<b>Yapı:</b> İsimleri tanımlamak için kullanılan yan cümleler. Relativpronomen (der, die, das, denen) kullanılır.",
            "de-passiv-title": "Passiv",
            "de-passiv-exp": "<b>Yapı:</b> werden + Partizip II. Eylemi yapan kişi önemli değilken kullanılır.",
            "de-infinitiv-zu-title": "Infinitiv mit zu",
            "de-infinitiv-zu-exp": "<b>Kullanım:</b> Bazı fiillerden sonra amaç belirtmek için kullanılır. \"zu\" + fiil mastar hali.",
            "de-learning-tips-title": "Almanca Öğrenme İpuçları",
            "de-5-strategies-title": "Almanca Öğreniminde Başarı İçin 5 Strateji",
            "de-tip-1": "<b>Artikel Ezberleme:</b> Her yeni kelimeyi artikeliyle birlikte öğrenin. Renkli kartlar kullanarak cinsiyetleri görselleştirin.",
            "de-tip-2": "<b>Kasus Sistemi:</b> İsmin hallerini günlük hayattan örneklerle pratik edin. \"Ich gebe dem Hund Wasser\" gibi basit cümleler kurun.",
            "de-tip-3": "<b>Fiil Çekimleri:</b> Düzenli fiilleri (-en, -st, -t, -en, -t, -en) ritmik olarak tekrarlayın. Bu otomatikleşecektir.",
            "de-tip-4": "<b>Birleşik Kelimeler:</b> Uzun kelimeleri parçalara ayırın. \"Handschuh\" = Hand (el) + Schuh (ayakkabı) = eldiven.",
            "de-tip-5": "<b>Alman Kültürü:</b> Alman filmleri, müziği ve haberlerini takip edin. Bu, dili doğal bağlamında öğrenmenizi sağlar.",
            "de-tip-6": "<b>💬 Sohbet Pratiği:</b> Lingoano'nun Almanca sohbet özelliğini kullanarak öğrendiğiniz gramer kurallarını pratik edin. Gerçek zamanlı konuşma, dil becerilerinizi hızla geliştirir.",
            "de-learning-strategies-title": "Almanca Öğrenme Stratejileri",
            "de-tactic-1": "<b>Artikel ve Cinsiyet Sistemi:</b> Her yeni kelimeyi artikeliyle birlikte öğrenin. Renkli kartlar kullanarak cinsiyetleri görselleştirin. Lingoano'nun Almanca sohbet özelliğinde bu kelimeleri kullanarak artikelleri doğal bir şekilde öğrenin.",
            "de-tactic-2": "<b>Kasus (İsmin Halleri) Öğrenimi:</b> İsmin hallerini günlük hayattan örneklerle pratik edin. \"Ich gebe dem Hund Wasser\" gibi basit cümleler kurun. Lingoano'da bu yapıları gerçek konuşmada test edin ve hatalarınızı düzeltin.",
            "de-tactic-3": "<b>Fiil Çekimleri ve Söz Dizimi:</b> Düzenli fiilleri ritmik olarak tekrarlayın. V2 kuralını (çekimli fiil ikinci pozisyonda) günlük cümlelerle pratik edin. Lingoano'nun Almanca sohbet odalarında bu kuralları uygulayarak otomatikleştirin.",
            "de-tactic-4": "<b>Birleşik Kelimeler ve Kelime Yapısı:</b> Uzun kelimeleri parçalara ayırın. \"Handschuh\" = Hand (el) + Schuh (ayakkabı) = eldiven. Lingoano'da bu kelimeleri kullanarak anlamlarını pekiştirin.",
            "de-tactic-5": "<b>Alman Kültürü ve Gerçek Materyaller:</b> Alman filmleri, müziği ve haberlerini takip edin. Lingoano'nun Almanca sohbet özelliğinde bu kültürel konular hakkında konuşarak dili doğal bağlamında öğrenin.",
            "de-did-you-know": "Almancanın birleşik kelimeler (Komposita) oluşturma yeteneği meşhurdur. \"Handschuh\" (el ayakkabısı -> eldiven) gibi basit örneklerden, yasal metinlerdeki çok uzun kelimelere kadar bu özellik, dilin ne kadar modüler ve yaratıcı olabildiğini gösterir.",
            
            // Akademik Kaynaklar
            "academic-sources-title": "Akademische Ressourcen",
            "cefr-guidelines-title": "CEFR-Richtlinien",
            "cefr-guidelines-desc": "Gemeinsamer Europäischer Referenzrahmen für Sprachen (CEFR)",
            "second-language-acquisition-title": "Zweitspracherwerb",
            "second-language-acquisition-desc": "Cambridge SLA Lehrbücher",
            "corpora-title": "Sprachkorpora",
            "corpora-desc": "Korpusquellen wie COCA/BNC",
            "peer-reviewed-title": "Peer-Review-Studien",
            "peer-reviewed-desc": "Google Scholar Literaturrecherche",
    
            // İspanyolca
            "es-intro-title": "İspanyolcaya Giriş: Melodi ve Duygu Dili",
            "es-intro-p": "Hint-Avrupa dil ailesinin Roman koluna mensup olan İspanyolca, dünya üzerinde en çok konuşulan ikinci dildir. Fonetik yapısı (genellikle yazıldığı gibi okunması) ve melodik tonlamasıyla öğrenmesi keyifli bir dildir. \"Ser\" ve \"estar\" gibi iki farklı \"olmak\" fiiliyle durum ve öz arasındaki felsefi ayrımı dilbilgisine taşıması, dilin ne kadar zengin ve incelikli olduğunu gösterir. İspanyolca öğrenmek, sadece Latin Amerika'dan İspanya'ya uzanan devasa bir coğrafyanın kapılarını değil, aynı zamanda sıcak ve tutkulu bir kültürün kalbini de size açacaktır.",
            "es-grammar-analysis-title": "İspanyolca Gramer Analizi",
            "es-ser-estar-title": "Ser ve Estar Farkı",
            "es-ser-estar-exp": "<b>Ser:</b> Kalıcı, değişmeyen özellikler (kimlik, meslek). \"Yo <b>soy</b> profesor.\"<br><b>Estar:</b> Geçici durumlar ve konum (duygu, yer). \"Yo <b>estoy</b> cansado.\"",
            "es-ser-estar-attn": "<b>Dikkat:</b> Bu ayrım İspanyolcanın temelidir.",
            "es-gender-agreement-title": "Cinsiyet ve Uyum",
            "es-gender-agreement-exp": "<b>Kural:</b> İsimler eril (genellikle -o) veya dişildir (-a). Sıfatlar ve artikeller, ismin cinsiyetine ve sayısına uymak zorundadır.",
            "es-preterito-imperfecto-title": "Pretérito vs. Imperfecto",
            "es-preterito-imperfecto-exp": "İki temel geçmiş zaman vardır.<br><b>Pretérito:</b> Geçmişte bir kez olmuş ve bitmiş eylemler. \"Ayer <b>comí</b> paella.\" (Dün paella yedim).<br><b>Imperfecto:</b> Geçmişteki alışkanlıklar, tekrarlanan eylemler veya arka plan betimlemeleri. \"Cuando era niño, <b>jugaba</b> al fútbol.\" (Çocukken futbol oynardım).",
            "es-por-para-title": "Por ve Para Farkı",
            "es-por-para-exp": "İkisi de \"için\" anlamına gelebilir ama kullanımları farklıdır.<br><b>Por:</b> Neden, sebep, aracılık. \"Lo hice <b>por</b> ti.\" (Senin uğruna yaptım).<br><b>Para:</b> Amaç, hedef, alıcı. \"Este regalo es <b>para</b> ti.\" (Bu hediye senin için).",
            "es-subjuntivo-title": "Subjuntivo (Dilek Kipi)",
            "es-subjuntivo-exp": "<b>İşlevi:</b> Gerçeklerden ziyade, öznel duyguları, istekleri, şüpheleri, olasılıkları ifade etmek için kullanılan özel bir fiil çekimidir.",
            "es-punctuation-title": "Ters Soru/Ünlem İşareti",
            "es-punctuation-exp": "<b>İşlevi:</b> Soru (¿) ve ünlem (¡) işaretleri cümlenin hem başına (ters) hem de sonuna konulur. Bu, okuyucuya cümlenin tonlamasını en baştan verir.",
            "es-reflexive-verbs-title": "Reflexive Verbs",
            "es-reflexive-verbs-exp": "<b>Yapı:</b> Fiil + se. Eylemi yapan ve etkilenen aynı kişi olduğunda kullanılır.",
            "es-object-pronouns-title": "Direct/Indirect Objects",
            "es-object-pronouns-exp": "<b>Direct Object:</b> Eylemin doğrudan etkilediği nesne (lo, la, los, las).<br><b>Indirect Object:</b> Eylemden dolaylı olarak etkilenen (le, les).",
            "es-future-tense-title": "Future Tense",
            "es-future-tense-exp": "<b>Yapı:</b> Infinitive + ending (-é, -ás, -á, -emos, -éis, -án). Gelecekteki eylemler için kullanılır.",
            "es-conditional-tense-title": "Conditional Tense",
            "es-conditional-tense-exp": "<b>Yapı:</b> Infinitive + conditional ending (-ía, -ías, -ía, -íamos, -íais, -ían). Nazik istekler ve hayali durumlar için.",
            "es-learning-tips-title": "İspanyolca Öğrenme İpuçları",
            "es-5-strategies-title": "İspanyolca Öğreniminde Başarı İçin 5 Strateji",
            "es-tip-1": "<b>Ser vs Estar:</b> Bu iki fiili günlük hayattan örneklerle pratik edin. \"Soy estudiante\" (öğrenciyim) vs \"Estoy cansado\" (yorgunum).",
            "es-tip-2": "<b>Telaffuz Pratiği:</b> \"rr\", \"ñ\" ve \"j\" seslerini düzenli olarak çalışın. \"Perro\" (köpek) kelimesini tekrarlayın.",
            "es-tip-3": "<b>Fiil Çekimleri:</b> Düzenli fiillerin şimdiki zaman çekimlerini (-o, -as, -a, -amos, -áis, -an) ezberleyin.",
            "es-tip-4": "<b>Latin Kültürü:</b> İspanyolca konuşan ülkelerin müziğini, filmlerini ve haberlerini takip edin.",
            "es-tip-5": "<b>Günlük Konuşma:</b> \"¿Cómo estás?\", \"Mucho gusto\" gibi temel ifadeleri günlük hayatta kullanın.",
            "es-tip-6": "<b>💬 Sohbet Pratiği:</b> Lingoano'nun İspanyolca sohbet özelliğini kullanarak \"Ser\" ve \"Estar\" gibi karmaşık gramer kurallarını pratik edin. Gerçek konuşma, bu ayrımı anlamanızı kolaylaştırır.",
            "es-learning-strategies-title": "İspanyolca Öğrenme Stratejileri",
            "es-tactic-1": "<b>Ser vs Estar Ayrımı:</b> Bu iki fiili günlük hayattan örneklerle pratik edin. \"Soy estudiante\" (öğrenciyim) vs \"Estoy cansado\" (yorgunum). Lingoano'nun İspanyolca sohbet özelliğinde bu ayrımı gerçek konuşmada test edin.",
            "es-tactic-2": "<b>Telaffuz ve Ses Sistemi:</b> \"rr\", \"ñ\" ve \"j\" seslerini düzenli olarak çalışın. \"Perro\" (köpek) kelimesini tekrarlayın. Lingoano'nun sesli sohbet özelliği ile telaffuzunuzu geliştirin ve gerçek İspanyolca konuşmacılarla pratik yapın.",
            "es-tactic-3": "<b>Fiil Çekimleri ve Zaman Sistemleri:</b> Düzenli fiillerin şimdiki zaman çekimlerini (-o, -as, -a, -amos, -áis, -an) ezberleyin. Pretérito ve Imperfecto arasındaki farkı anlayın. Lingoano'da bu zamanları kullanarak cümleler kurun.",
            "es-tactic-4": "<b>Latin Kültürü ve Gerçek Materyaller:</b> İspanyolca konuşan ülkelerin müziğini, filmlerini ve haberlerini takip edin. Lingoano'nun İspanyolca sohbet odalarında bu kültürel konular hakkında konuşarak dili doğal bağlamında öğrenin.",
            "es-tactic-5": "<b>Günlük Konuşma ve İletişim:</b> \"¿Cómo estás?\", \"Mucho gusto\" gibi temel ifadeleri günlük hayatta kullanın. Lingoano'da günlük konular hakkında sohbet ederek bu ifadeleri pekiştirin.",
    
            // Fransızca
            "fr-intro-title": "Fransızcaya Giriş: Zarafet ve Kural Dili",
            "fr-intro-p": "İspanyolca gibi Roman dillerinden olan Fransızca, diplomasi, moda ve sanatın dili olarak bilinir. Zengin ses yapısı, nazal ünlüler (en, on, un) ve \"liaison\" (ulama) gibi fonetik kurallarıyla kendine has bir müzikaliteye sahiptir. Dilbilgisi kuralları oldukça yapılandırılmıştır ve fiil çekimleri (conjugaison) dilin merkezinde yer alır. Fransızca öğrenmek, sadece estetik bir dil öğrenmek değil, aynı zamanda dünya kültür ve düşünce tarihine derin bir yolculuk yapmaktır.",
            "fr-grammar-analysis-title": "Fransızca Gramer Analizi",
            "fr-etre-avoir-title": "Être & Avoir",
            "fr-etre-avoir-exp": "Bu iki düzensiz fiil, Fransızcanın temelidir. \"Être\" (olmak) ve \"Avoir\" (sahip olmak) aynı zamanda geçmiş zaman (passé composé) oluştururken yardımcı fiil olarak kullanılırlar.",
            "fr-negation-title": "Negasyon: Ne... pas",
            "fr-negation-exp": "<b>Yapı:</b> Fransızcada olumsuzluk, fiili \"ne\" ve \"pas\" arasına alarak yapılır.",
            "fr-negation-attn": "<b>Dikkat:</b> Konuşma dilinde \"ne\" sıklıkla düşer (\"Je parle pas\"), ama yazı dilinde zorunludur.",
            "fr-passe-compose-title": "Passé Composé",
            "fr-passe-compose-exp": "<b>Kullanım:</b> Konuşma dilinde en yaygın geçmiş zamandır. Yapı: avoir/être + fiilin geçmiş zaman hali (participe passé).<br><b>Être kullanımı:</b> Genellikle hareket ve durum değişikliği bildiren fiillerle kullanılır (aller, venir, partir...).",
            "fr-partitifs-title": "Partitif Artikeller",
            "fr-partitifs-exp": "<b>İşlevi:</b> Sayılamayan isimlerin \"bir miktar\"ını belirtmek için kullanılır.<br><b>du</b> (eril), <b>de la</b> (dişil), <b>de l'</b> (sesli harf), <b>des</b> (çoğul).",
            "fr-y-en-pronouns-title": "Y ve En Zamirleri",
            "fr-y-en-pronouns-exp": "<b>Y:</b> Genellikle \"à + yer\" veya \"à + bir şey\" yapısının yerini tutar. \"Oraya, orada\" anlamı katar.<br><b>En:</b> Genellikle \"de + bir şey\" yapısının veya bir miktarın yerini tutar. \"Ondan, ondan bir miktar\" anlamı katar.",
            "fr-liaison-title": "Liaison (Ulama)",
            "fr-liaison-exp": "<b>Kural:</b> Sessiz harfle biten bir kelime, sesli harfle başlayan bir sonraki kelimeye bağlanarak okunur. Bu, dile akıcılık katar.",
            "fr-subjonctif-title": "Subjonctif",
            "fr-subjonctif-exp": "<b>Kullanım:</b> Öznel duyguları, istekleri, şüpheleri ifade etmek için kullanılır. \"que\" ile başlayan yan cümlelerde görülür.",
            "fr-imparfait-title": "Imparfait",
            "fr-imparfait-exp": "<b>Kullanım:</b> Geçmişteki alışkanlıklar, sürekli durumlar ve arka plan betimlemeleri için kullanılır.",
            "fr-futur-simple-title": "Futur Simple",
            "fr-futur-simple-exp": "<b>Yapı:</b> Infinitive + future ending (-ai, -as, -a, -ons, -ez, -ont). Gelecekteki eylemler için kullanılır.",
            "fr-conditionnel-title": "Conditionnel Présent",
            "fr-conditionnel-exp": "<b>Yapı:</b> Futur simple kökü + imparfait ending. Nazik istekler ve hayali durumlar için kullanılır.",
            "fr-learning-tips-title": "Fransızca Öğrenme İpuçları",
            "fr-5-strategies-title": "Fransızca Öğreniminde Başarı İçin 5 Strateji",
            "fr-tip-1": "<b>Nazal Sesler:</b> \"en\", \"on\", \"un\" gibi nazal sesleri düzenli olarak pratik edin. \"Bonjour\" kelimesini doğru telaffuz edin.",
            "fr-tip-2": "<b>Liaison Kuralları:</b> Ulama kurallarını öğrenin ve uygulayın. \"Vous avez\" → \"vou-z-ave\" gibi.",
            "fr-tip-3": "<b>Fiil Çekimleri:</b> Düzenli \"-er\" fiillerin çekimlerini (-e, -es, -e, -ons, -ez, -ent) ezberleyin.",
            "fr-tip-4": "<b>Fransız Kültürü:</b> Fransız filmleri, müziği ve haberlerini takip edin. \"Chanson\" tarzı müzikleri dinleyin.",
            "fr-tip-5": "<b>Günlük İfadeler:</b> \"Bonjour\", \"Au revoir\", \"S'il vous plaît\" gibi temel ifadeleri günlük hayatta kullanın.",
            "fr-tip-6": "<b>💬 Sohbet Pratiği:</b> Lingoano'nun Fransızca sohbet özelliğini kullanarak nazal sesleri ve liaison kurallarını pratik edin. Gerçek konuşma, Fransızca telaffuzunuzu mükemmelleştirir.",
            "fr-learning-strategies-title": "Fransızca Öğrenme Stratejileri",
            "fr-tactic-1": "<b>Nazal Sesler ve Telaffuz:</b> \"en\", \"on\", \"un\" gibi nazal sesleri düzenli olarak pratik edin. \"Bonjour\" kelimesini doğru telaffuz edin. Lingoano'nun Fransızca sohbet özelliğinde bu sesleri gerçek konuşmada pratik edin.",
            "fr-tactic-2": "<b>Liaison Kuralları ve Akıcılık:</b> Ulama kurallarını öğrenin ve uygulayın. \"Vous avez\" → \"vou-z-ave\" gibi. Lingoano'nun sesli sohbet özelliği ile bu kuralları doğal konuşmada uygulayın.",
            "fr-tactic-3": "<b>Fiil Çekimleri ve Zaman Sistemleri:</b> Düzenli \"-er\" fiillerin çekimlerini (-e, -es, -e, -ons, -ez, -ent) ezberleyin. Passé Composé ve Imparfait arasındaki farkı anlayın. Lingoano'da bu zamanları kullanarak cümleler kurun.",
            "fr-tactic-4": "<b>Fransız Kültürü ve Gerçek Materyaller:</b> Fransız filmleri, müziği ve haberlerini takip edin. \"Chanson\" tarzı müzikleri dinleyin. Lingoano'nun Fransızca sohbet odalarında bu kültürel konular hakkında konuşarak dili doğal bağlamında öğrenin.",
            "fr-tactic-5": "<b>Günlük İletişim ve Pratik:</b> \"Bonjour\", \"Au revoir\", \"S'il vous plaît\" gibi temel ifadeleri günlük hayatta kullanın. Lingoano'da günlük konular hakkında sohbet ederek bu ifadeleri pekiştirin.",
    
            // Türkçe
            "tr-intro-title": "Türkçeye Giriş: Eklemeli ve Uyumlu Dil",
            "tr-intro-p": "Ural-Altay dil ailesinin Altay koluna mensup olan Türkçe, eklemeli (agglutinative) yapısıyla dikkat çeker. Bu, kelime köklerine anlam ve işlev katan eklerin birbiri ardına sıralanması demektir. Bu yapı, \"gözlükçülük\" gibi tek bir kelimeyle karmaşık bir kavramı ifade etme imkanı sunar. Büyük ve küçük ünlü uyumu gibi ses kuralları, dile fonetik bir ahenk ve matematiksel bir düzen kazandırır. Türkçe öğrenmek, kelimeleri bir lego gibi birleştirerek yeni anlamlar inşa etme sanatını keşfetmektir.",
            "tr-grammar-analysis-title": "Türkçe Gramer Analizi",
            "tr-vowel-harmony-title": "Ünlü Uyumu",
            "tr-vowel-harmony-exp": "<b>İşlevi:</b> Türkçenin temel ses kuralıdır. Bir kelimeye eklenecek ekin ünlüsü, kelimenin son ünlüsüne göre belirlenir.<br><b>Büyük Ünlü Uyumu:</b> Kalın ünlülerden (a, ı, o, u) sonra kalın, ince ünlülerden (e, i, ö, ü) sonra ince ünlü gelir.",
            "tr-agglutination-title": "Eklemeli Yapı",
            "tr-agglutination-exp": "<b>Kural:</b> Kelime köküne önce yapım ekleri (anlam değiştiren), sonra çekim ekleri (işlev belirten) gelir. Her ekin tek bir görevi vardır.",
            "tr-sov-structure-title": "Söz Dizimi (SOV)",
            "tr-sov-structure-exp": "<b>Yapı:</b> Türkçede temel cümle dizilimi <b>Özne-Nesne-Yüklem</b> (Subject-Object-Verb) şeklindedir. Yüklem (fiil) genellikle cümlenin en sonunda yer alır.",
            "tr-sov-structure-attn": "<b>Karşılaştırma:</b> İngilizcede bu cümle \"I read a book yesterday\" (SVO) şeklinde kurulur.",
            "tr-noun-compounds-title": "İsim Tamlamaları",
            "tr-noun-compounds-exp": "<b>Yapı:</b> İki ismin bir araya gelerek yeni bir kavram oluşturmasıdır.<br><b>Belirtili:</b> Tamlayan (-in) ve tamlanan (-i) ek alır. (kapı<b>nın</b> kol<b>u</b>)<br><b>Belirtisiz:</b> Sadece tamlanan (-i) ek alır. (okul kapı<b>sı</b>)",
            "tr-verbals-title": "Fiilimsiler",
            "tr-verbals-exp": "<b>İşlevi:</b> Fiil köklerinden türeyerek cümlede isim, sıfat veya zarf görevi gören kelimelerdir. Cümleleri birleştirmek ve kısaltmak için kullanılır.<br><b>İsim-fiil:</b> -ma, -ış, -mak<br><b>Sıfat-fiil:</b> -an, -ası, -mez, -ar, -dik, -ecek, -miş<br><b>Zarf-fiil:</b> -ken, -alı, -ip...",
            "tr-var-yok-title": "\"Var\" ve \"Yok\"",
            "tr-var-yok-exp": "<b>Kullanım:</b> Sahiplik belirtmek için İngilizcedeki \"have/has\" yerine kullanılır. Bir şeyin varlığını veya yokluğunu belirtir.",
            "tr-tense-suffixes-title": "Zaman Ekleri",
            "tr-tense-suffixes-exp": "<b>Şimdiki Zaman:</b> -iyor eki ile yapılır. \"Ben okuyorum, sen okuyorsun...\"<br><b>Geçmiş Zaman:</b> -di/-dı eki ile yapılır. \"Ben okudum, sen okudun...\"<br><b>Gelecek Zaman:</b> -ecek/-acak eki ile yapılır. \"Ben okuyacağım, sen okuyacaksın...\"",
            "tr-plural-suffix-title": "Çoğul Eki",
            "tr-plural-suffix-exp": "<b>Kural:</b> İsimlere -ler/-lar eki eklenerek çoğul yapılır. Ünlü uyumuna göre -ler (ince) veya -lar (kalın) kullanılır.",
            "tr-case-suffixes-title": "Hâl Ekleri",
            "tr-case-suffixes-exp": "<b>Yönelme (-e/-a):</b> \"Eve gidiyorum\"<br><b>Bulunma (-de/-da):</b> \"Evde oturuyorum\"<br><b>Ayrılma (-den/-dan):</b> \"Evden çıkıyorum\"<br><b>Belirtme (-i/-ı):</b> \"Kitabı okuyorum\"",
            "tr-adjectives-title": "Sıfatlar",
            "tr-adjectives-exp": "<b>Yapı:</b> Türkçede sıfatlar çekim eki almaz. İsimlerle birlikte kullanıldığında isim çekim eki alır.<br><b>Karşılaştırma:</b> -daha, -en, -daha çok ile yapılır.",
            "tr-learning-tips-title": "Türkçe Öğrenme İpuçları",
            "tr-5-strategies-title": "Türkçe Öğreniminde Başarı İçin 5 Strateji",
            "tr-tip-1": "<b>Ek Sistemi:</b> Türkçenin eklemeli yapısını anlayın. Her ekin tek bir işlevi vardır ve bunları birleştirerek yeni anlamlar oluşturabilirsiniz.",
            "tr-tip-2": "<b>Ünlü Uyumu:</b> Bu kuralı iyi öğrenin. Kalın ünlülerden sonra kalın, ince ünlülerden sonra ince ünlü gelir.",
            "tr-tip-3": "<b>Söz Dizimi:</b> Türkçede yüklem cümlenin sonunda yer alır. Bu yapıyı alışkanlık haline getirin.",
            "tr-tip-4": "<b>Günlük Konuşma:</b> \"Merhaba\", \"Nasılsın?\", \"Teşekkür ederim\" gibi temel ifadeleri sık sık kullanın.",
            "tr-tip-5": "<b>Türk Kültürü:</b> Türk filmleri, müziği ve haberlerini takip edin. Bu, dili doğal bağlamında öğrenmenizi sağlar.",
            "tr-tip-6": "<b>💬 Sohbet Pratiği:</b> Lingoano'nun Türkçe sohbet özelliğini kullanarak ek sistemini ve ünlü uyumunu pratik edin. Gerçek konuşma, Türkçenin mantığını anlamanızı hızlandırır.",
            "tr-learning-strategies-title": "Türkçe Öğrenme Stratejileri",
            "tr-tactic-1": "<b>Ek Sistemi ve Kelime Yapısı:</b> Türkçenin eklemeli yapısını anlayın. Her ekin tek bir işlevi vardır ve bunları birleştirerek yeni anlamlar oluşturabilirsiniz. Lingoano'nun Türkçe sohbet özelliğinde bu ekleri gerçek konuşmada pratik edin.",
            "tr-tactic-2": "<b>Ünlü Uyumu ve Ses Kuralları:</b> Bu kuralı iyi öğrenin. Kalın ünlülerden sonra kalın, ince ünlülerden sonra ince ünlü gelir. Lingoano'da yeni kelimeler oluştururken bu kuralı uygulayın.",
            "tr-tactic-3": "<b>Söz Dizimi ve Cümle Yapısı:</b> Türkçede yüklem cümlenin sonunda yer alır. Bu yapıyı alışkanlık haline getirin. Lingoano'nun Türkçe sohbet odalarında bu yapıyı doğal konuşmada uygulayın.",
            "tr-tactic-4": "<b>Günlük Konuşma ve İletişim:</b> \"Merhaba\", \"Nasılsın?\", \"Teşekkür ederim\" gibi temel ifadeleri sık sık kullanın. Lingoano'da günlük konular hakkında sohbet ederek bu ifadeleri pekiştirin.",
            "tr-tactic-5": "<b>Türk Kültürü ve Gerçek Materyaller:</b> Türk filmleri, müziği ve haberlerini takip edin. Lingoano'nun Türkçe sohbet özelliğinde bu kültürel konular hakkında konuşarak dili doğal bağlamında öğrenin.",
    
            // Rusça
            "ru-intro-title": "Rusçaya Giriş: Zengin ve İfade Dolu Dil",
            "ru-intro-p": "Hint-Avrupa dil ailesinin Slav koluna mensup olan Rusça, Kiril alfabesi ve zengin fonetik yapısıyla kendine özgü bir karaktere sahiptir. Almanca gibi, ismin hallerine (6 padej) dayalı karmaşık bir gramer yapısı vardır. Bu yapı, kelime sırasının oldukça esnek olmasına olanak tanır ve vurgu ile tonlamanın anlamda büyük rol oynamasını sağlar. Fiillerdeki \"vid\" (görünüş) ayrımı, bir eylemin tamamlanmış mı yoksa süreç halinde mi olduğunu ifade ederek dile inanılmaz bir incelik katar. Rusça öğrenmek, Dostoyevski ve Tolstoy'un eserlerine orijinal dilinde dokunma ve derin bir kültürel mirası keşfetme fırsatıdır.",
            "ru-grammar-analysis-title": "Rusça Gramer Analizi",
            "ru-cyrillic-title": "Kiril Alfabesi",
            "ru-cyrillic-exp": "<b>Yapı:</b> 33 harften oluşur. Bazı harfler Latin alfabesine benzer (А, К, М, О, Т), bazıları benzer görünür ama farklı okunur (В 'v', Н 'n', Р 'r'), bazıları ise tamamen yenidir (Ж 'j', Ц 'ts', Я 'ya').",
            "ru-cases-title": "İsmin Halleri (Падежи)",
            "ru-cases-exp": "<b>İşlevi:</b> Rusçada 6 hal vardır ve kelimelerin son eklerini değiştirerek cümledeki rollerini belirler.<br><b>Örnek:</b> \"книга\" (kitap) -> \"Я читаю <b>книгу</b>\" (-i hali).",
            "ru-verb-aspect-title": "Fiil Görünüşü (Вид)",
            "ru-verb-aspect-exp": "<b>Kural:</b> Çoğu fiilin iki formu vardır:<br><b>Несовершенный (Süreç):</b> Eylemin sürecini, tekrarlandığını belirtir. (читать - okumak)<br><b>Совершенный (Sonуç):</b> Eylemin tamamlandığını belirtir. (прочитать - okuyup bitirmek)",
            "ru-gender-system-title": "Cinsiyet Sistemi",
            "ru-gender-system-exp": "<b>Kural:</b> 3 cinsiyet vardır: Eril (sessiz harf/-й), Dişil (-а/-я), Nötr (-о/-е). Sıfatlar ve geçmiş zaman fiilleri ismin cinsiyetine göre değişir.",
            "ru-motion-verbs-title": "Hareket Fiilleri",
            "ru-motion-verbs-exp": "<b>Kural:</b> Rusçada hareket fiilleri ikiye ayrılır: Tek yönlü (идти - yürüyerek gitmek) ve çok yönlü/alışkanlık (ходить - yürüyerek gidip gelmek, gezinmek).",
            "ru-genitive-negation-title": "\"Yokluk\" için Genitif Hali",
            "ru-genitive-negation-exp": "<b>Kural:</b> Bir şeye sahip olmamayı veya bir şeyin bir yerde olmadığını belirtmek için \"нет\" (yok) kelimesi ve ardından ismin genitif (-in hali) kullanılır.",
            "ru-stress-system-title": "Vurgu Sistemi",
            "ru-stress-system-exp": "<b>Önem:</b> Rusçada vurgu çok önemlidir. Aynı kelime farklı vurgularla farklı anlamlar taşıyabilir. Vurgu işareti (´) ile gösterilir.",
            "ru-stress-system-attn": "<b>Dikkat:</b> Vurgu yanlış yerde olursa kelime anlaşılmaz hale gelebilir.",
            "ru-adjective-declension-title": "Sıfat Çekimleri",
            "ru-adjective-declension-exp": "<b>Kural:</b> Sıfatlar ismin cinsiyetine, sayısına ve haline göre değişir. Eril, dişil, nötr ve çoğul formları vardır.",
            "ru-future-tense-ru-title": "Gelecek Zaman",
            "ru-future-tense-ru-exp": "<b>Yapı:</b> быть (olmak) + infinitive. Gelecekteki eylemler için kullanılır. быть fiili çekilir.",
            "ru-imperative-title": "Imperative (Emir Kipi)",
            "ru-imperative-exp": "<b>Yapı:</b> Fiil kökü + imperative ending. Emir, rica ve tavsiye için kullanılır.",
            "ru-reflexive-verbs-ru-title": "Reflexive Verbs",
            "ru-reflexive-verbs-ru-exp": "<b>Yapı:</b> Fiil + -ся/-сь. Eylemi yapan ve etkilenen aynı kişi olduğunda kullanılır.",
            "ru-learning-tips-title": "Rusça Öğrenme İpuçları",
            "ru-5-strategies-title": "Rusça Öğreniminde Başarı İçin 5 Strateji",
            "ru-tip-1": "<b>Kiril Alfabesi:</b> İlk hafta alfabeye odaklanın. Her harfi yazma ve okuma pratiği yapın. \"Привет\" gibi basit kelimelerle başlayın.",
            "ru-tip-2": "<b>Vurgu Sistemi:</b> Vurgunun nerede olduğuna dikkat edin. Yanlış vurgu kelimeyi anlaşılmaz yapabilir.",
            "ru-tip-3": "<b>İsmin Halleri:</b> 6 hal sistemini günlük hayattan örneklerle öğrenin. Her gün bir ismin farklı hallerdeki çekimlerini çalışın.",
            "ru-tip-4": "<b>Fiil Görünüşü:</b> Süreç (несовершенный) ve sonuç (совершенный) ayrımını anlayın. Bu, Rusçanın en önemli özelliklerinden biridir.",
            "ru-tip-5": "<b>Rus Kültürü:</b> Rus filmleri, müziği ve haberlerini takip edin. Çizgi filmler genellikle daha basit bir dil kullanır.",
            "ru-tip-6": "<b>💬 Sohbet Pratiği:</b> Lingoano'nun Rusça sohbet özelliğini kullanarak Kiril alfabesini ve vurgu sistemini pratik edin. Gerçek konuşma, Rusça telaffuzunuzu ve anlama becerinizi geliştirir.",
            "ru-learning-strategies-title": "Rusça Öğrenme Stratejileri",
            "ru-tactic-1": "<b>Kiril Alfabesi ve Temel Sesler:</b> İlk hafta alfabeye odaklanın. Her harfi yazma ve okuma pratiği yapın. \"Привет\" gibi basit kelimelerle başlayın. Lingoano'nun Rusça sohbet özelliğinde bu kelimeleri gerçek konuşmada pratik edin.",
            "ru-tactic-2": "<b>Vurgu Sistemi ve Telaffuz:</b> Vurgunun nerede olduğuna dikkat edin. Yanlış vurgu kelimeyi anlaşılmaz yapabilir. Lingoano'nun sesli sohbet özelliği ile telaffuzunuzu geliştirin ve gerçek Rusça konuşmacılarla pratik yapın.",
            "ru-tactic-3": "<b>İsmin Halleri (Падежи) Öğrenimi:</b> 6 hal sistemini günlük hayattan örneklerle öğrenin. Her gün bir ismin farklı hallerdeki çekimlerini çalışın. Lingoano'da bu yapıları gerçek konuşmada test edin.",
            "ru-tactic-4": "<b>Fiil Görünüşü (Вид) ve Zaman Sistemleri:</b> Süreç (несовершенный) ve sonuç (совершенный) ayrımını anlayın. Bu, Rusçanın en önemli özelliklerinden biridir. Lingoano'nun Rusça sohbet odalarında bu ayrımı uygulayın.",
            "ru-tactic-5": "<b>Rus Kültürü ve Gerçek Materyaller:</b> Rus filmleri, müziği ve haberlerini takip edin. Çizgi filmler genellikle daha basit bir dil kullanır. Lingoano'nun Rusça sohbet özelliğinde bu kültürel konular hakkında konuşarak dili doğal bağlamında öğrenin."
        },

        en: {
            // General
            "learning-tactics-title": "Learning Tactics",
            "culture-note-title": "💡 Language & Culture Note",
    
            // English Guide Section
            "en-intro-title": "Introduction to English: A World Language",
            "en-intro-p": "Belonging to the Germanic branch of the Indo-European language family, English is the lingua franca of global communication, from science and technology to trade and diplomacy. Its analytical structure, where the function of words is determined by word order and prepositions/auxiliary verbs rather than suffixes, sets it apart from many other languages. On this journey, you will discover the flexible and logical structure of English and become part of a global community.",
            "en-grammar-analysis-title": "English Grammar Analysis",
            "en-articles-title": "Articles (a/an, the)",
            "en-articles-exp": "<b>a/an:</b> Used for a general object. <b>the:</b> Used for a specific object that has been mentioned before.",
            "en-present-simple-title": "Present Simple",
            "en-present-simple-exp": "<b>Usage:</b> General truths, habits. The verb takes an \"-s\" with He/She/It.",
            "en-past-simple-title": "Past Simple",
            "en-past-simple-exp": "<b>Usage:</b> Actions completed in the past. Regular verbs take \"-ed\"; irregulars change (V2).",
            "en-past-simple-attn": "<b>Note:</b> In negative sentences and questions with `did`, the verb returns to its base form.",
            "en-present-perfect-title": "Present Perfect",
            "en-present-perfect-exp": "<b>Usage:</b> Actions that started in the past and continue to have an effect, or actions that happened at an unspecified time. Structure: have/has + V3.",
            "en-modal-verbs-title": "Modal Verbs",
            "en-modal-verbs-exp": "<b>Function:</b> They add meanings like ability (can), possibility (may), necessity (must), and advice (should) to a sentence.",
            "en-gerunds-infinitives-title": "Gerunds & Infinitives",
            "en-gerunds-infinitives-exp": "<b>Gerund (V-ing):</b> Used as a noun after certain verbs (Enjoy, mind, suggest + V-ing).<br><b>Infinitive (to V):</b> Used to express purpose after certain verbs (Want, need, decide + to V).",
            "en-conditionals-title": "Conditional Sentences",
            "en-conditionals-exp": "<b>Zero Conditional:</b> General truths (If + Present, Present).<br><b>First Conditional:</b> Possible future (If + Present, will + V).<br><b>Second Conditional:</b> Imaginary situations (If + Past, would + V).",
            "en-passive-voice-title": "Passive Voice",
            "en-passive-voice-exp": "<b>Structure:</b> be + V3. Used when the doer of the action is unknown or unimportant.",
            "en-reported-speech-title": "Reported Speech",
            "en-reported-speech-exp": "<b>Rule:</b> When reporting someone else's words, the tense shifts back. Present → Past, Past → Past Perfect.",
            "en-relative-clauses-title": "Relative Clauses",
            "en-relative-clauses-exp": "<b>Defining:</b> Provides essential information, no commas used.<br><b>Non-defining:</b> Provides extra information, separated by commas.",
            "en-learning-tips-title": "English Learning Tips",
            "en-5-golden-rules-title": "5 Golden Rules for Successful English Learning",
            "en-tip-1": "<b>Daily Practice:</b> Engage with English for at least 30 minutes every day. Consistency is more effective than intensive study.",
            "en-tip-2": "<b>Multiple Sources:</b> Focus not only on textbooks but also on authentic materials like movies, music, podcasts, and news.",
            "en-tip-3": "<b>Don't Fear Mistakes:</b> Mistakes are a natural part of learning. Try to speak, not to be perfect.",
            "en-tip-4": "<b>Learn in Context:</b> Learn words in sentences, not just in lists. This reinforces both meaning and usage.",
            "en-tip-5": "<b>Cultural Context:</b> Learn English not just as a language but as part of a culture. This makes the language more meaningful.",
            "en-tip-6": "<b>💬 Conversation Practice:</b> Use Lingoano's English chat feature to practice speaking in real-time. This helps you use the grammar rules and vocabulary you've learned naturally.",
            "en-learning-strategies-title": "English Learning Strategies",
            "en-tactic-1": "<b>Vocabulary Strategy:</b> Learn words in context. Instead of memorizing word lists, learn words used in sentences. Practice your newly learned vocabulary in real-time conversations using Lingoano's English chat feature.",
            "en-tactic-2": "<b>Grammar Approach:</b> Learn grammar rules with practical sentences, not just theory. For every new rule, create at least 5 different sentences. Test these sentences in a real conversation environment with Lingoano.",
            "en-tactic-3": "<b>Listening and Pronunciation:</b> Listen to different accents (British, American, Australian). Watch podcasts, YouTube videos, and movies. Improve your pronunciation with Lingoano's voice chat feature and practice with native English speakers.",
            "en-tactic-4": "<b>Speaking Practice:</b> Engage in active speaking practice instead of passive learning. Talk about daily topics, ask questions, and give answers in Lingoano's English chat rooms.",
            "en-tactic-5": "<b>Cultural Context:</b> Learn English as part of its culture. Follow English news, blogs, and social media content. Enhance your cultural awareness by chatting about these topics on Lingoano.",
            "en-did-you-know": "There are thousands of \"phrasal verbs\" (e.g., look up, give up, get along) in English, forming the basis of daily conversation. Learning these idiomatic verbs plays a key role in understanding native speakers and achieving a more natural expression.",
            
            // Academic Resources
            "academic-sources-title": "Academic Resources",
            "cefr-guidelines-title": "CEFR Guidelines",
            "cefr-guidelines-desc": "Common European Framework of Reference for Languages (CEFR)",
            "second-language-acquisition-title": "Second Language Acquisition",
            "second-language-acquisition-desc": "Cambridge SLA textbooks",
            "corpora-title": "Language Corpora",
            "corpora-desc": "Corpus sources like COCA/BNC",
            "peer-reviewed-title": "Peer-Reviewed Studies",
            "peer-reviewed-desc": "Google Scholar literature search",
    
            // German Guide Section
            "de-intro-title": "Introduction to German: The Language of Logic and Structure",
            "de-intro-p": "Like English, German belongs to the Germanic language family and stands out for its rule-based and logical structure. Its structural features, such as noun cases (Kasus) and the position of verbs in a sentence, give it an engineering-like precision. While this structure may seem complex at first, you'll see how predictable and consistent the language is once you understand its basic principles. Learning German not only opens a new door to communication but also enhances your analytical thinking skills.",
            "de-grammar-analysis-title": "German Grammar Analysis",
            "de-artikel-title": "Articles and Gender",
            "de-artikel-exp": "<b>Rule:</b> Every noun has a gender: <b>der</b> (masculine), <b>die</b> (feminine), <b>das</b> (neuter). It must be memorized with the word.",
            "de-artikel-attn": "<b>Note:</b> The fact that \"das Mädchen\" (the girl) is neuter highlights the importance of grammatical gender.",
            "de-kasus-title": "Noun Cases (Kasus)",
            "de-kasus-exp": "Indicates the function of a noun in a sentence and changes its article.<br><b>Nominative:</b> Subject - <b>Der Hund</b> ist klein.<br><b>Accusative:</b> Direct object - Ich sehe <b>den Hund</b>.<br><b>Dative:</b> Indirect object - Ich gebe <b>dem Hund</b> Wasser.",
            "de-satzbau-title": "Sentence Structure (Satzbau)",
            "de-satzbau-exp": "<b>Basic Rule (V2):</b> In main clauses, the conjugated verb is <b>always in the second position.</b>",
            "de-perfekt-title": "Perfect Tense (Perfekt)",
            "de-perfekt-exp": "<b>Usage:</b> The most common past tense in spoken language. Structure: haben/sein + Partizip II.",
            "de-trennbare-verben-title": "Separable Verbs",
            "de-trennbare-verben-exp": "<b>Structure:</b> The prefix of verbs like \"anrufen\" (to call), which is \"an-\", goes to the end of the main clause.",
            "de-praepositionen-title": "Prepositions",
            "de-praepositionen-exp": "In German, prepositions determine the case (Accusative or Dative) of the noun that follows. This must be memorized.<br><b>Accusative:</b> für, durch, gegen...<br><b>Dative:</b> mit, nach, von, zu...",
            "de-konjunktiv-title": "Subjunctive II (Konjunktiv II)",
            "de-konjunktiv-exp": "<b>Usage:</b> Used for hypothetical situations, polite requests, and events that did not happen in the past.",
            "de-relativsaetze-title": "Relative Clauses",
            "de-relativsaetze-exp": "<b>Structure:</b> Subordinate clauses used to describe nouns. Relative pronouns (der, die, das, denen) are used.",
            "de-passiv-title": "Passive Voice",
            "de-passiv-exp": "<b>Structure:</b> werden + Partizip II. Used when the doer of the action is unimportant.",
            "de-infinitiv-zu-title": "Infinitive with 'zu'",
            "de-infinitiv-zu-exp": "<b>Usage:</b> Used after certain verbs to indicate purpose. \"zu\" + infinitive form of the verb.",
            "de-learning-tips-title": "German Learning Tips",
            "de-5-strategies-title": "5 Strategies for Success in Learning German",
            "de-tip-1": "<b>Memorize Articles:</b> Learn every new noun with its article. Use color-coded flashcards to visualize genders.",
            "de-tip-2": "<b>The Case System:</b> Practice the noun cases with real-life examples. Form simple sentences like \"Ich gebe dem Hund Wasser.\"",
            "de-tip-3": "<b>Verb Conjugations:</b> Rhythmically repeat regular verbs (-en, -st, -t, -en, -t, -en). It will become automatic.",
            "de-tip-4": "<b>Compound Words:</b> Break down long words into their components. \"Handschuh\" = Hand (hand) + Schuh (shoe) = glove.",
            "de-tip-5": "<b>German Culture:</b> Follow German movies, music, and news. This helps you learn the language in its natural context.",
            "de-tip-6": "<b>💬 Conversation Practice:</b> Use Lingoano's German chat feature to practice the grammar rules you've learned. Real-time conversation rapidly improves your language skills.",
            "de-learning-strategies-title": "German Learning Strategies",
            "de-tactic-1": "<b>Article and Gender System:</b> Learn every new word with its article. Use color-coded cards to visualize genders. Learn articles naturally by using these words in Lingoano's German chat feature.",
            "de-tactic-2": "<b>Learning Cases (Kasus):</b> Practice the cases with everyday examples. Form simple sentences like \"Ich gebe dem Hund Wasser.\" Test these structures in real conversation on Lingoano and correct your mistakes.",
            "de-tactic-3": "<b>Verb Conjugation and Syntax:</b> Repeat regular verb conjugations rhythmically. Practice the V2 rule (conjugated verb in second position) with daily sentences. Automate these rules in Lingoano's German chat rooms.",
            "de-tactic-4": "<b>Compound Words and Word Structure:</b> Break down long words. \"Handschuh\" = Hand + Schuh = glove. Reinforce their meanings by using these words on Lingoano.",
            "de-tactic-5": "<b>German Culture and Authentic Materials:</b> Follow German movies, music, and news. Learn the language in its natural context by discussing these cultural topics in Lingoano's German chat feature.",
            "de-did-you-know": "German's ability to form compound words (Komposita) is famous. From simple examples like \"Handschuh\" (hand-shoe -> glove) to very long words in legal texts, this feature shows how modular and creative the language can be.",
    
            // Spanish Guide Section
            "es-intro-title": "Introduction to Spanish: The Language of Melody and Emotion",
            "es-intro-p": "A member of the Romance branch of the Indo-European family, Spanish is the world's second most-spoken native language. Its phonetic nature (generally read as it is written) and melodic intonation make it a joy to learn. The language incorporates a philosophical distinction between state and essence into its grammar with two different verbs for \"to be\" (ser and estar), showcasing its richness and subtlety. Learning Spanish opens the doors not only to a vast geography from Latin America to Spain but also to the heart of a warm and passionate culture.",
            "es-grammar-analysis-title": "Spanish Grammar Analysis",
            "es-ser-estar-title": "The Difference Between Ser & Estar",
            "es-ser-estar-exp": "<b>Ser:</b> Permanent, unchanging characteristics (identity, profession). \"Yo <b>soy</b> profesor.\"<br><b>Estar:</b> Temporary states and locations (emotion, place). \"Yo <b>estoy</b> cansado.\"",
            "es-ser-estar-attn": "<b>Note:</b> This distinction is fundamental to Spanish.",
            "es-gender-agreement-title": "Gender and Agreement",
            "es-gender-agreement-exp": "<b>Rule:</b> Nouns are either masculine (often ending in -o) or feminine (-a). Adjectives and articles must agree with the noun's gender and number.",
            "es-preterito-imperfecto-title": "Preterite vs. Imperfect",
            "es-preterito-imperfecto-exp": "There are two main past tenses.<br><b>Preterite:</b> For actions that happened once and were completed in the past. \"Ayer <b>comí</b> paella.\" (Yesterday I ate paella).<br><b>Imperfect:</b> For past habits, repeated actions, or background descriptions. \"Cuando era niño, <b>jugaba</b> al fútbol.\" (When I was a child, I used to play soccer).",
            "es-por-para-title": "The Difference Between Por & Para",
            "es-por-para-exp": "Both can mean \"for,\" but their uses differ.<br><b>Por:</b> Reason, cause, means. \"Lo hice <b>por</b> ti.\" (I did it for your sake).<br><b>Para:</b> Purpose, destination, recipient. \"Este regalo es <b>para</b> ti.\" (This gift is for you).",
            "es-subjuntivo-title": "Subjunctive Mood",
            "es-subjuntivo-exp": "<b>Function:</b> A special verb mood used to express subjective feelings, wishes, doubts, and possibilities rather than facts.",
            "es-punctuation-title": "Inverted Question/Exclamation Marks",
            "es-punctuation-exp": "<b>Function:</b> Question (¿) and exclamation (¡) marks are placed at both the beginning (inverted) and end of a sentence. This informs the reader of the sentence's tone from the start.",
            "es-reflexive-verbs-title": "Reflexive Verbs",
            "es-reflexive-verbs-exp": "<b>Structure:</b> Verb + se. Used when the subject and object of the action are the same person.",
            "es-object-pronouns-title": "Direct/Indirect Objects",
            "es-object-pronouns-exp": "<b>Direct Object:</b> The object directly affected by the action (lo, la, los, las).<br><b>Indirect Object:</b> The object indirectly affected by the action (le, les).",
            "es-future-tense-title": "Future Tense",
            "es-future-tense-exp": "<b>Structure:</b> Infinitive + ending (-é, -ás, -á, -emos, -éis, -án). Used for future actions.",
            "es-conditional-tense-title": "Conditional Tense",
            "es-conditional-tense-exp": "<b>Structure:</b> Infinitive + conditional ending (-ía, -ías, -ía, -íamos, -íais, -ían). For polite requests and hypothetical situations.",
            "es-learning-tips-title": "Spanish Learning Tips",
            "es-5-strategies-title": "5 Strategies for Success in Learning Spanish",
            "es-tip-1": "<b>Ser vs Estar:</b> Practice these two verbs with everyday examples. \"Soy estudiante\" (I am a student) vs. \"Estoy cansado\" (I am tired).",
            "es-tip-2": "<b>Pronunciation Practice:</b> Regularly practice the \"rr\", \"ñ\", and \"j\" sounds. Repeat the word \"perro\" (dog).",
            "es-tip-3": "<b>Verb Conjugations:</b> Memorize the present tense conjugations of regular verbs (-o, -as, -a, -amos, -áis, -an).",
            "es-tip-4": "<b>Latin Culture:</b> Follow the music, movies, and news of Spanish-speaking countries.",
            "es-tip-5": "<b>Daily Conversation:</b> Use basic phrases like \"¿Cómo estás?\" and \"Mucho gusto\" in daily life.",
            "es-tip-6": "<b>💬 Conversation Practice:</b> Use Lingoano's Spanish chat feature to practice complex grammar rules like \"Ser\" and \"Estar.\" Real conversation makes it easier to understand this distinction.",
            "es-learning-strategies-title": "Spanish Learning Strategies",
            "es-tactic-1": "<b>Ser vs. Estar Distinction:</b> Practice these two verbs with everyday examples. Test this distinction in real conversation on Lingoano's Spanish chat feature.",
            "es-tactic-2": "<b>Pronunciation and Sound System:</b> Regularly practice the \"rr\", \"ñ\", and \"j\" sounds. Improve your pronunciation with Lingoano's voice chat feature and practice with native Spanish speakers.",
            "es-tactic-3": "<b>Verb Conjugations and Tense Systems:</b> Memorize the present tense conjugations of regular verbs. Understand the difference between Preterite and Imperfect. Form sentences using these tenses on Lingoano.",
            "es-tactic-4": "<b>Latin Culture and Authentic Materials:</b> Follow the music, movies, and news of Spanish-speaking countries. Learn the language in its natural context by discussing these cultural topics in Lingoano's Spanish chat rooms.",
            "es-tactic-5": "<b>Daily Conversation and Communication:</b> Use basic phrases like \"¿Cómo estás?\" and \"Mucho gusto\" in daily life. Reinforce these expressions by chatting about everyday topics on Lingoano.",
    
            // French Guide Section
            "fr-intro-title": "Introduction to French: The Language of Elegance and Rules",
            "fr-intro-p": "Like Spanish, French is a Romance language known as the language of diplomacy, fashion, and art. It has a unique musicality with its rich sound system, nasal vowels (en, on, un), and phonetic rules like \"liaison.\" The grammar rules are highly structured, and verb conjugations (conjugaison) are central to the language. Learning French is not just about learning an aesthetic language but also about taking a deep journey into the history of world culture and thought.",
            "fr-grammar-analysis-title": "French Grammar Analysis",
            "fr-etre-avoir-title": "Être & Avoir",
            "fr-etre-avoir-exp": "These two irregular verbs are the foundation of French. \"Être\" (to be) and \"Avoir\" (to have) are also used as auxiliary verbs to form the past tense (passé composé).",
            "fr-negation-title": "Negation: Ne... pas",
            "fr-negation-exp": "<b>Structure:</b> In French, negation is formed by placing \"ne\" and \"pas\" around the verb.",
            "fr-negation-attn": "<b>Note:</b> In spoken language, \"ne\" is often dropped (\"Je parle pas\"), but it is mandatory in writing.",
            "fr-passe-compose-title": "Passé Composé",
            "fr-passe-compose-exp": "<b>Usage:</b> The most common past tense in spoken language. Structure: avoir/être + the past participle of the verb.<br><b>Use of Être:</b> Generally used with verbs of motion and state change (aller, venir, partir...).",
            "fr-partitifs-title": "Partitive Articles",
            "fr-partitifs-exp": "<b>Function:</b> Used to refer to an unspecified quantity of an uncountable noun.<br><b>du</b> (masculine), <b>de la</b> (feminine), <b>de l'</b> (vowel), <b>des</b> (plural).",
            "fr-y-en-pronouns-title": "The Pronouns 'Y' and 'En'",
            "fr-y-en-pronouns-exp": "<b>Y:</b> Generally replaces \"à + a place\" or \"à + a thing.\" It adds the meaning of \"there.\"<br><b>En:</b> Generally replaces \"de + a thing\" or a quantity. It adds the meaning of \"some\" or \"of it/them.\"",
            "fr-liaison-title": "Liaison",
            "fr-liaison-exp": "<b>Rule:</b> A word ending in a silent consonant is pronounced by linking it to the following word that begins with a vowel. This gives the language its fluency.",
            "fr-subjonctif-title": "Subjunctive (Subjonctif)",
            "fr-subjonctif-exp": "<b>Usage:</b> Used to express subjective feelings, wishes, and doubts. It often appears in subordinate clauses starting with \"que.\"",
            "fr-imparfait-title": "Imperfect (Imparfait)",
            "fr-imparfait-exp": "<b>Usage:</b> Used for past habits, ongoing situations, and background descriptions.",
            "fr-futur-simple-title": "Simple Future (Futur Simple)",
            "fr-futur-simple-exp": "<b>Structure:</b> Infinitive + future ending (-ai, -as, -a, -ons, -ez, -ont). Used for future actions.",
            "fr-conditionnel-title": "Present Conditional (Conditionnel Présent)",
            "fr-conditionnel-exp": "<b>Structure:</b> Future simple stem + imparfait ending. Used for polite requests and hypothetical situations.",
            "fr-learning-tips-title": "French Learning Tips",
            "fr-5-strategies-title": "5 Strategies for Success in Learning French",
            "fr-tip-1": "<b>Nasal Sounds:</b> Regularly practice nasal sounds like \"en\", \"on\", \"un.\" Pronounce the word \"Bonjour\" correctly.",
            "fr-tip-2": "<b>Liaison Rules:</b> Learn and apply the liaison rules. E.g., \"Vous avez\" → \"vou-z-ave.\"",
            "fr-tip-3": "<b>Verb Conjugations:</b> Memorize the conjugations of regular \"-er\" verbs (-e, -es, -e, -ons, -ez, -ent).",
            "fr-tip-4": "<b>French Culture:</b> Follow French movies, music, and news. Listen to \"Chanson\" style music.",
            "fr-tip-5": "<b>Daily Expressions:</b> Use basic expressions like \"Bonjour,\" \"Au revoir,\" and \"S'il vous plaît\" in daily life.",
            "fr-tip-6": "<b>💬 Conversation Practice:</b> Use Lingoano's French chat feature to practice nasal sounds and liaison rules. Real conversation perfects your French pronunciation.",
            "fr-learning-strategies-title": "French Learning Strategies",
            "fr-tactic-1": "<b>Nasal Sounds and Pronunciation:</b> Regularly practice nasal sounds like \"en\", \"on\", \"un.\" Practice these sounds in real conversation in Lingoano's French chat feature.",
            "fr-tactic-2": "<b>Liaison Rules and Fluency:</b> Learn and apply liaison rules. E.g., \"Vous avez\" → \"vou-z-ave.\" Apply these rules in natural speech with Lingoano's voice chat feature.",
            "fr-tactic-3": "<b>Verb Conjugations and Tense Systems:</b> Memorize the conjugations of regular \"-er\" verbs. Understand the difference between Passé Composé and Imparfait. Form sentences using these tenses on Lingoano.",
            "fr-tactic-4": "<b>French Culture and Authentic Materials:</b> Follow French movies, music, and news. Learn the language in its natural context by discussing these cultural topics in Lingoano's French chat rooms.",
            "fr-tactic-5": "<b>Daily Communication and Practice:</b> Use basic expressions like \"Bonjour\" and \"S'il vous plaît\" in daily life. Reinforce these expressions by chatting about everyday topics on Lingoano.",
    
            // Turkish Guide Section
            "tr-intro-title": "Introduction to Turkish: An Agglutinative and Harmonious Language",
            "tr-intro-p": "Belonging to the Altaic branch of the Ural-Altaic language family, Turkish is notable for its agglutinative structure. This means that suffixes, which add meaning and function, are sequenced one after another onto a root word. This structure allows for complex concepts to be expressed in a single word, like \"gözlükçülük\" (the business of being an optician). Phonetic rules like major and minor vowel harmony give the language a phonetic rhythm and a mathematical order. Learning Turkish is to discover the art of building new meanings by combining words like Lego bricks.",
            "tr-grammar-analysis-title": "Turkish Grammar Analysis",
            "tr-vowel-harmony-title": "Vowel Harmony",
            "tr-vowel-harmony-exp": "<b>Function:</b> This is the fundamental sound rule of Turkish. The vowel of a suffix is determined by the last vowel of the word.<br><b>Major Vowel Harmony:</b> Back vowels (a, ı, o, u) are followed by back vowels, and front vowels (e, i, ö, ü) are followed by front vowels.",
            "tr-agglutination-title": "Agglutinative Structure",
            "tr-agglutination-exp": "<b>Rule:</b> Derivational suffixes (which change meaning) come first, followed by inflectional suffixes (which indicate function). Each suffix has a single role.",
            "tr-sov-structure-title": "Sentence Structure (SOV)",
            "tr-sov-structure-exp": "<b>Structure:</b> The basic sentence order in Turkish is <b>Subject-Object-Verb</b>. The verb is usually at the very end of the sentence.",
            "tr-sov-structure-attn": "<b>Comparison:</b> In English, this sentence would be \"I read a book yesterday\" (SVO).",
            "tr-noun-compounds-title": "Noun Compounds",
            "tr-noun-compounds-exp": "<b>Structure:</b> Two nouns come together to form a new concept.<br><b>Definite:</b> Both the possessor (-in) and the possessed (-i) take suffixes. (kapı<b>nın</b> kol<b>u</b> - the door's handle)<br><b>Indefinite:</b> Only the possessed (-i) takes a suffix. (okul kapı<b>sı</b> - school door)",
            "tr-verbals-title": "Verbals (Fiilimsiler)",
            "tr-verbals-exp": "<b>Function:</b> Words derived from verb stems that function as nouns, adjectives, or adverbs in a sentence. They are used to combine and shorten sentences.<br><b>Verbal Noun:</b> -ma, -ış, -mak<br><b>Participle:</b> -an, -ası, -mez, -ar, -dik, -ecek, -miş<br><b>Gerund/Adverbial:</b> -ken, -alı, -ip...",
            "tr-var-yok-title": "\"Var\" and \"Yok\"",
            "tr-var-yok-exp": "<b>Usage:</b> Used to express possession instead of \"have/has\" in English. It indicates the existence or absence of something.",
            "tr-tense-suffixes-title": "Tense Suffixes",
            "tr-tense-suffixes-exp": "<b>Present Continuous:</b> Formed with the -iyor suffix. \"Ben okuyorum, sen okuyorsun...\"<br><b>Past Tense:</b> Formed with the -di/-dı suffix. \"Ben okudum, sen okudun...\"<br><b>Future Tense:</b> Formed with the -ecek/-acak suffix. \"Ben okuyacağım, sen okuyacaksın...\"",
            "tr-plural-suffix-title": "Plural Suffix",
            "tr-plural-suffix-exp": "<b>Rule:</b> Nouns are made plural by adding the -ler/-lar suffix. Based on vowel harmony, either -ler (front) or -lar (back) is used.",
            "tr-case-suffixes-title": "Case Suffixes",
            "tr-case-suffixes-exp": "<b>Dative (-e/-a):</b> \"Eve gidiyorum\" (to the house)<br><b>Locative (-de/-da):</b> \"Evde oturuyorum\" (at the house)<br><b>Ablative (-den/-dan):</b> \"Evden çıkıyorum\" (from the house)<br><b>Accusative (-i/-ı):</b> \"Kitabı okuyorum\" (the book)",
            "tr-adjectives-title": "Adjectives",
            "tr-adjectives-exp": "<b>Structure:</b> In Turkish, adjectives are not inflected. When used with nouns, the noun takes the inflectional suffixes.<br><b>Comparison:</b> Formed with -daha (more), -en (most).",
            "tr-learning-tips-title": "Turkish Learning Tips",
            "tr-5-strategies-title": "5 Strategies for Success in Learning Turkish",
            "tr-tip-1": "<b>The Suffix System:</b> Understand the agglutinative nature of Turkish. Each suffix has a single function, and you can create new meanings by combining them.",
            "tr-tip-2": "<b>Vowel Harmony:</b> Learn this rule well. Back vowels are followed by back vowels, front vowels by front vowels.",
            "tr-tip-3": "<b>Sentence Structure:</b> The verb is at the end of the sentence in Turkish. Make this structure a habit.",
            "tr-tip-4": "<b>Daily Conversation:</b> Use basic phrases like \"Merhaba,\" \"Nasılsın?,\" and \"Teşekkür ederim\" frequently.",
            "tr-tip-5": "<b>Turkish Culture:</b> Follow Turkish movies, music, and news. This helps you learn the language in its natural context.",
            "tr-tip-6": "<b>💬 Conversation Practice:</b> Use Lingoano's Turkish chat feature to practice the suffix system and vowel harmony. Real conversation speeds up your understanding of Turkish logic.",
            "tr-learning-strategies-title": "Turkish Learning Strategies",
            "tr-tactic-1": "<b>Suffix System and Word Structure:</b> Understand the agglutinative nature of Turkish. Practice these suffixes in real conversation in Lingoano's Turkish chat feature.",
            "tr-tactic-2": "<b>Vowel Harmony and Sound Rules:</b> Learn this rule well. Apply this rule when forming new words on Lingoano.",
            "tr-tactic-3": "<b>Syntax and Sentence Structure:</b> The verb is at the end of the sentence in Turkish. Apply this structure in natural speech in Lingoano's Turkish chat rooms.",
            "tr-tactic-4": "<b>Daily Conversation and Communication:</b> Use basic phrases like \"Merhaba\" and \"Nasılsın?\" frequently. Reinforce these expressions by chatting about everyday topics on Lingoano.",
            "tr-tactic-5": "<b>Turkish Culture and Authentic Materials:</b> Follow Turkish movies, music, and news. Learn the language in its natural context by discussing these cultural topics on Lingoano.",
    
            // Russian Guide Section
            "ru-intro-title": "Introduction to Russian: A Rich and Expressive Language",
            "ru-intro-p": "Belonging to the Slavic branch of the Indo-European family, Russian has a unique character with its Cyrillic alphabet and rich phonetic system. Like German, it has a complex grammar based on noun cases (6 padezhi). This structure allows for highly flexible word order, where stress and intonation play a major role in meaning. The aspect distinction in verbs (vid) adds incredible subtlety by indicating whether an action is completed or ongoing. Learning Russian is an opportunity to touch the works of Dostoevsky and Tolstoy in their original language and to explore a deep cultural heritage.",
            "ru-grammar-analysis-title": "Russian Grammar Analysis",
            "ru-cyrillic-title": "The Cyrillic Alphabet",
            "ru-cyrillic-exp": "<b>Structure:</b> It consists of 33 letters. Some letters look like Latin ones (А, К, М, О, Т), some look similar but sound different (В 'v', Н 'n', Р 'r'), and some are completely new (Ж 'zh', Ц 'ts', Я 'ya').",
            "ru-cases-title": "Noun Cases (Падежи)",
            "ru-cases-exp": "<b>Function:</b> Russian has 6 cases that determine a word's role in a sentence by changing its ending.<br><b>Example:</b> \"книга\" (book) -> \"Я читаю <b>книгу</b>\" (accusative case).",
            "ru-verb-aspect-title": "Verb Aspect (Вид)",
            "ru-verb-aspect-exp": "<b>Rule:</b> Most verbs come in two forms:<br><b>Imperfective (Несовершенный):</b> Indicates the process or repetition of an action. (читать - to be reading)<br><b>Perfective (Совершенный):</b> Indicates the completion of an action. (прочитать - to have read)",
            "ru-gender-system-title": "Gender System",
            "ru-gender-system-exp": "<b>Rule:</b> There are 3 genders: Masculine (ends in a consonant/-й), Feminine (-а/-я), and Neuter (-о/-е). Adjectives and past tense verbs change according to the noun's gender.",
            "ru-motion-verbs-title": "Verbs of Motion",
            "ru-motion-verbs-exp": "<b>Rule:</b> In Russian, verbs of motion are divided into two types: Unidirectional (идти - to be going by foot) and Multidirectional/habitual (ходить - to go by foot, to wander).",
            "ru-genitive-negation-title": "Genitive Case for Negation",
            "ru-genitive-negation-exp": "<b>Rule:</b> To express not having something or the absence of something, the word \"нет\" (no/not) is used, followed by the noun in the genitive case.",
            "ru-stress-system-title": "Stress System",
            "ru-stress-system-exp": "<b>Importance:</b> Stress is very important in Russian. The same word can have different meanings with different stress patterns, indicated by an accent mark (´).",
            "ru-stress-system-attn": "<b>Note:</b> If the stress is in the wrong place, the word can become incomprehensible.",
            "ru-adjective-declension-title": "Adjective Declension",
            "ru-adjective-declension-exp": "<b>Rule:</b> Adjectives change according to the gender, number, and case of the noun they modify. They have masculine, feminine, neuter, and plural forms.",
            "ru-future-tense-ru-title": "Future Tense",
            "ru-future-tense-ru-exp": "<b>Structure:</b> быть (to be) + infinitive. Used for future actions. The verb быть is conjugated.",
            "ru-imperative-title": "Imperative Mood",
            "ru-imperative-exp": "<b>Structure:</b> Verb stem + imperative ending. Used for commands, requests, and advice.",
            "ru-reflexive-verbs-ru-title": "Reflexive Verbs",
            "ru-reflexive-verbs-ru-exp": "<b>Structure:</b> Verb + -ся/-сь. Used when the subject and object of the action are the same.",
            "ru-learning-tips-title": "Russian Learning Tips",
            "ru-5-strategies-title": "5 Strategies for Success in Learning Russian",
            "ru-tip-1": "<b>The Cyrillic Alphabet:</b> Focus on the alphabet in the first week. Practice writing and reading each letter. Start with simple words like \"Привет.\"",
            "ru-tip-2": "<b>Stress System:</b> Pay attention to where the stress falls. Incorrect stress can make a word unintelligible.",
            "ru-tip-3": "<b>Noun Cases:</b> Learn the 6 case system with everyday examples. Practice the declensions of one noun in different cases each day.",
            "ru-tip-4": "<b>Verb Aspect:</b> Understand the distinction between imperfective (process) and perfective (result). This is one of the most important features of Russian.",
            "ru-tip-5": "<b>Russian Culture:</b> Follow Russian movies, music, and news. Cartoons often use simpler language.",
            "ru-tip-6": "<b>💬 Conversation Practice:</b> Use Lingoano's Russian chat feature to practice the Cyrillic alphabet and stress system. Real conversation improves your Russian pronunciation and comprehension skills.",
            "ru-learning-strategies-title": "Russian Learning Strategies",
            "ru-tactic-1": "<b>Cyrillic Alphabet and Basic Sounds:</b> Focus on the alphabet in the first week. Practice these words in real conversation in Lingoano's Russian chat feature.",
            "ru-tactic-2": "<b>Stress System and Pronunciation:</b> Pay attention to where the stress falls. Improve your pronunciation with Lingoano's voice chat feature and practice with native Russian speakers.",
            "ru-tactic-3": "<b>Learning Noun Cases (Падежи):</b> Learn the 6 case system with everyday examples. Test these structures in real conversation on Lingoano.",
            "ru-tactic-4": "<b>Verb Aspect (Вид) and Tense Systems:</b> Understand the distinction between imperfective (process) and perfective (result). Apply this distinction in Lingoano's Russian chat rooms.",
            "ru-tactic-5": "<b>Russian Culture and Authentic Materials:</b> Follow Russian movies, music, and news. Learn the language in its natural context by discussing these cultural topics in Lingoano's Russian chat feature."
        },
        de: {
            // Allgemein
            "learning-tactics-title": "Lerntaktiken",
            "culture-note-title": "💡 Sprach- und Kulturnotiz",
    
            // Englischer Abschnitt
            "en-intro-title": "Einführung in Englisch: Eine Weltsprache",
            "en-intro-p": "Als Mitglied des germanischen Zweigs der indogermanischen Sprachfamilie ist Englisch heute die Lingua Franca der globalen Kommunikation, von Wissenschaft und Technologie bis hin zu Handel und Diplomatie. Seine analytische Struktur, bei der die Funktion von Wörtern durch die Wortstellung und Hilfswörter (Präpositionen, Hilfsverben) anstelle von Endungen bestimmt wird, unterscheidet es von vielen anderen Sprachen. Auf dieser Reise werden Sie die flexible und logische Struktur des Englischen entdecken und Teil einer globalen Gemeinschaft werden.",
            "en-grammar-analysis-title": "Analyse der englischen Grammatik",
            "en-articles-title": "Artikel (a/an, the)",
            "en-articles-exp": "<b>a/an:</b> Wird für ein allgemeines Objekt verwendet. <b>the:</b> Wird für ein bestimmtes, bereits erwähntes Objekt verwendet.",
            "en-present-simple-title": "Present Simple (Einfache Gegenwart)",
            "en-present-simple-exp": "<b>Verwendung:</b> Allgemeine Wahrheiten, Gewohnheiten. Das Verb erhält bei He/She/It ein \"-s\".",
            "en-past-simple-title": "Past Simple (Einfache Vergangenheit)",
            "en-past-simple-exp": "<b>Verwendung:</b> Abgeschlossene Handlungen in der Vergangenheit. Regelmäßige Verben erhalten \"-ed\"; unregelmäßige ändern sich (V2).",
            "en-past-simple-attn": "<b>Achtung:</b> In verneinten Sätzen und Fragen mit `did` kehrt das Verb in seine Grundform zurück.",
            "en-present-perfect-title": "Present Perfect (Perfekt)",
            "en-present-perfect-exp": "<b>Verwendung:</b> Handlungen, die in der Vergangenheit begonnen haben und noch Auswirkungen haben, oder Handlungen zu einem unbestimmten Zeitpunkt. Struktur: have/has + V3.",
            "en-modal-verbs-title": "Modalverben",
            "en-modal-verbs-exp": "<b>Funktion:</b> Sie fügen dem Satz Bedeutungen wie Fähigkeit (can), Möglichkeit (may), Notwendigkeit (must) und Ratschlag (should) hinzu.",
            "en-gerunds-infinitives-title": "Gerundien & Infinitive",
            "en-gerunds-infinitives-exp": "<b>Gerund (V-ing):</b> Wird nach bestimmten Verben als Nomen verwendet (Enjoy, mind, suggest + V-ing).<br><b>Infinitive (to V):</b> Wird verwendet, um einen Zweck nach bestimmten Verben auszudrücken (Want, need, decide + to V).",
            "en-conditionals-title": "Bedingungssätze",
            "en-conditionals-exp": "<b>Zero Conditional:</b> Allgemeine Wahrheiten (If + Present, Present).<br><b>First Conditional:</b> Mögliche Zukunft (If + Present, will + V).<br><b>Second Conditional:</b> Imaginäre Situationen (If + Past, would + V).",
            "en-passive-voice-title": "Passiv",
            "en-passive-voice-exp": "<b>Struktur:</b> be + V3. Wird verwendet, wenn der Handelnde unbekannt oder unwichtig ist.",
            "en-reported-speech-title": "Indirekte Rede",
            "en-reported-speech-exp": "<b>Regel:</b> Bei der Wiedergabe von Aussagen anderer verschiebt sich die Zeitform nach hinten. Present → Past, Past → Past Perfect.",
            "en-relative-clauses-title": "Relativsätze",
            "en-relative-clauses-exp": "<b>Bestimmend (Defining):</b> Gibt wesentliche Informationen, ohne Kommas.<br><b>Nicht-bestimmend (Non-defining):</b> Gibt zusätzliche Informationen, durch Kommas getrennt.",
            "en-learning-tips-title": "Lerntipps für Englisch",
            "en-5-golden-rules-title": "5 goldene Regeln für erfolgreiches Englischlernen",
            "en-tip-1": "<b>Tägliche Übung:</b> Beschäftigen Sie sich jeden Tag mindestens 30 Minuten mit Englisch. Beständigkeit ist effektiver als intensives Lernen.",
            "en-tip-2": "<b>Vielfältige Quellen:</b> Konzentrieren Sie sich nicht nur auf Lehrbücher, sondern auch auf authentische Materialien wie Filme, Musik, Podcasts und Nachrichten.",
            "en-tip-3": "<b>Keine Angst vor Fehlern:</b> Fehler sind ein natürlicher Teil des Lernens. Versuchen Sie zu sprechen, nicht perfekt zu sein.",
            "en-tip-4": "<b>Im Kontext lernen:</b> Lernen Sie Wörter in Sätzen, nicht nur in Listen. Dies festigt sowohl Bedeutung als auch Anwendung.",
            "en-tip-5": "<b>Kultureller Kontext:</b> Lernen Sie Englisch nicht nur als Sprache, sondern als Teil einer Kultur. Das macht die Sprache bedeutungsvoller.",
            "en-tip-6": "<b>💬 Konversationsübung:</b> Nutzen Sie die Englisch-Chat-Funktion von Lingoano, um in Echtzeit zu sprechen. Dies hilft Ihnen, die gelernten Grammatikregeln und Vokabeln natürlich anzuwenden.",
            "en-learning-strategies-title": "Englisch-Lernstrategien",
            "en-tactic-1": "<b>Wortschatzstrategie:</b> Lernen Sie Wörter im Kontext. Anstatt Wortlisten auswendig zu lernen, lernen Sie Wörter, die in Sätzen verwendet werden. Üben Sie Ihren neu gelernten Wortschatz in Echtzeitgesprächen mit der Englisch-Chat-Funktion von Lingoano.",
            "en-tactic-2": "<b>Grammatikansatz:</b> Lernen Sie Grammatikregeln mit praktischen Sätzen, nicht nur theoretisch. Bilden Sie für jede neue Regel mindestens 5 verschiedene Sätze. Testen Sie diese Sätze in einer echten Gesprächsumgebung mit Lingoano.",
            "en-tactic-3": "<b>Hörverstehen und Aussprache:</b> Hören Sie sich verschiedene Akzente an (britisch, amerikanisch, australisch). Sehen Sie sich Podcasts, YouTube-Videos und Filme an. Verbessern Sie Ihre Aussprache mit der Voice-Chat-Funktion von Lingoano und üben Sie mit englischen Muttersprachlern.",
            "en-tactic-4": "<b>Sprechpraxis:</b> Üben Sie aktiv das Sprechen anstelle des passiven Lernens. Sprechen Sie über alltägliche Themen, stellen Sie Fragen und geben Sie Antworten in den Englisch-Chaträumen von Lingoano.",
            "en-tactic-5": "<b>Kultureller Kontext:</b> Lernen Sie Englisch als Teil seiner Kultur. Verfolgen Sie englische Nachrichten, Blogs und Social-Media-Inhalte. Erweitern Sie Ihr kulturelles Bewusstsein, indem Sie über diese Themen auf Lingoano chatten.",
            "en-did-you-know": "Es gibt Tausende von \"phrasal verbs\" (z. B. look up, give up, get along) im Englischen, die die Grundlage der täglichen Konversation bilden. Das Erlernen dieser idiomatischen Verben spielt eine Schlüsselrolle, um Muttersprachler zu verstehen und einen natürlicheren Ausdruck zu erlangen.",
    
            // Deutscher Abschnitt
            "de-intro-title": "Einführung in Deutsch: Die Sprache der Logik und Struktur",
            "de-intro-p": "Wie Englisch gehört auch Deutsch zur germanischen Sprachfamilie und zeichnet sich durch seine regelbasierte und logische Struktur aus. Merkmale wie die Fälle (Kasus) und die Stellung der Verben im Satz verleihen ihm eine ingenieurhafte Präzision. Auch wenn diese Struktur anfangs komplex erscheint, werden Sie schnell erkennen, wie vorhersagbar und konsistent die Sprache ist, sobald Sie die Grundprinzipien verstanden haben. Deutsch zu lernen öffnet nicht nur eine neue Tür zur Kommunikation, sondern fördert auch Ihr analytisches Denkvermögen.",
            "de-grammar-analysis-title": "Analyse der deutschen Grammatik",
            "de-artikel-title": "Artikel und Geschlecht",
            "de-artikel-exp": "<b>Regel:</b> Jedes Nomen hat ein Geschlecht: <b>der</b> (maskulin), <b>die</b> (feminin), <b>das</b> (neutral). Es muss mit dem Wort gelernt werden.",
            "de-artikel-attn": "<b>Achtung:</b> Dass \"das Mädchen\" sächlich ist, unterstreicht die Bedeutung des grammatikalischen Geschlechts.",
            "de-kasus-title": "Die Fälle (Kasus)",
            "de-kasus-exp": "Zeigt die Funktion eines Nomens im Satz an und verändert seinen Artikel.<br><b>Nominativ:</b> Subjekt - <b>Der Hund</b> ist klein.<br><b>Akkusativ:</b> Direktes Objekt - Ich sehe <b>den Hund</b>.<br><b>Dativ:</b> Indirektes Objekt - Ich gebe <b>dem Hund</b> Wasser.",
            "de-satzbau-title": "Satzbau",
            "de-satzbau-exp": "<b>Grundregel (V2):</b> In Hauptsätzen steht das konjugierte Verb <b>immer an zweiter Position.</b>",
            "de-perfekt-title": "Perfekt",
            "de-perfekt-exp": "<b>Verwendung:</b> Die gebräuchlichste Vergangenheitsform in der gesprochenen Sprache. Struktur: haben/sein + Partizip II.",
            "de-trennbare-verben-title": "Trennbare Verben",
            "de-trennbare-verben-exp": "<b>Struktur:</b> Die Vorsilbe von Verben wie \"anrufen\" (an-) wandert im Hauptsatz ans Satzende.",
            "de-praepositionen-title": "Präpositionen",
            "de-praepositionen-exp": "Im Deutschen bestimmen Präpositionen den Fall (Akkusativ oder Dativ) des folgenden Nomens. Dies muss auswendig gelernt werden.<br><b>Akkusativ:</b> für, durch, gegen...<br><b>Dativ:</b> mit, nach, von, zu...",
            "de-konjunktiv-title": "Konjunktiv II",
            "de-konjunktiv-exp": "<b>Verwendung:</b> Wird für irreale Wünsche, höfliche Bitten und hypothetische Situationen verwendet.",
            "de-relativsaetze-title": "Relativsätze",
            "de-relativsaetze-exp": "<b>Struktur:</b> Nebensätze, die ein Nomen näher beschreiben. Es werden Relativpronomen (der, die, das, denen) verwendet.",
            "de-passiv-title": "Passiv",
            "de-passiv-exp": "<b>Struktur:</b> werden + Partizip II. Wird verwendet, wenn der Handelnde unwichtig ist.",
            "de-infinitiv-zu-title": "Infinitiv mit zu",
            "de-infinitiv-zu-exp": "<b>Verwendung:</b> Wird nach bestimmten Verben verwendet, um einen Zweck oder eine Absicht auszudrücken. \"zu\" + Infinitiv.",
            "de-learning-tips-title": "Lerntipps für Deutsch",
            "de-5-strategies-title": "5 Strategien für erfolgreiches Deutschlernen",
            "de-tip-1": "<b>Artikel lernen:</b> Lernen Sie jedes neue Nomen mit seinem Artikel. Visualisieren Sie die Geschlechter mit farbigen Karteikarten.",
            "de-tip-2": "<b>Das Kasussystem:</b> Üben Sie die Fälle mit alltäglichen Beispielen. Bilden Sie einfache Sätze wie \"Ich gebe dem Hund Wasser\".",
            "de-tip-3": "<b>Verbkonjugationen:</b> Wiederholen Sie rhythmisch die regelmäßigen Verben (-e, -st, -t, -en, -t, -en). Dies wird automatisch.",
            "de-tip-4": "<b>Zusammengesetzte Wörter:</b> Zerlegen Sie lange Wörter in ihre Bestandteile. \"Handschuh\" = Hand + Schuh.",
            "de-tip-5": "<b>Deutsche Kultur:</b> Verfolgen Sie deutsche Filme, Musik und Nachrichten. Dies hilft, die Sprache im natürlichen Kontext zu lernen.",
            "de-tip-6": "<b>💬 Konversationsübung:</b> Nutzen Sie die Deutsch-Chat-Funktion von Lingoano, um die gelernten Grammatikregeln zu üben. Echtzeitgespräche beschleunigen Ihre Sprachkenntnisse.",
            "de-learning-strategies-title": "Deutsch-Lernstrategien",
            "de-tactic-1": "<b>Artikel- und Genus-System:</b> Lernen Sie jedes neue Wort mit seinem Artikel. Verwenden Sie farbige Karteikarten, um die Genera zu visualisieren. Üben Sie diese Wörter im Deutsch-Chat von Lingoano, um die Artikel natürlich zu lernen.",
            "de-tactic-2": "<b>Lernen der Fälle (Kasus):</b> Üben Sie die Fälle mit Alltagsbeispielen. Bilden Sie einfache Sätze wie „Ich gebe dem Hund Wasser“. Testen Sie diese Strukturen im realen Gespräch auf Lingoano und korrigieren Sie Ihre Fehler.",
            "de-tactic-3": "<b>Verbkonjugation und Satzbau:</b> Wiederholen Sie regelmäßig die Konjugationen. Üben Sie die V2-Regel (finites Verb an zweiter Position) mit täglichen Sätzen. Automatisieren Sie diese Regeln in den Deutsch-Chaträumen von Lingoano.",
            "de-tactic-4": "<b>Zusammengesetzte Wörter und Wortstruktur:</b> Zerlegen Sie lange Wörter in ihre Bestandteile: „Handschuh“ = Hand + Schuh. Festigen Sie deren Bedeutung, indem Sie diese Wörter auf Lingoano verwenden.",
            "de-tactic-5": "<b>Deutsche Kultur und authentische Materialien:</b> Sehen Sie deutsche Filme, hören Sie deutsche Musik und lesen Sie deutsche Nachrichten. Sprechen Sie über diese kulturellen Themen im Deutsch-Chat von Lingoano, um die Sprache im natürlichen Kontext zu lernen.",
            "de-did-you-know": "Die Fähigkeit des Deutschen, zusammengesetzte Wörter (Komposita) zu bilden, ist berühmt. Von einfachen Beispielen wie \"Handschuh\" bis hin zu sehr langen Wörtern in Rechtstexten zeigt diese Eigenschaft, wie modular und kreativ die Sprache sein kann.",
    
            // Spanischer Abschnitt
            "es-intro-title": "Einführung in Spanisch: Die Sprache der Melodie und Emotion",
            "es-intro-p": "Als Mitglied des romanischen Zweigs der indogermanischen Familie ist Spanisch die am zweithäufigsten gesprochene Muttersprache der Welt. Seine phonetische Natur (im Allgemeinen wird es so gelesen, wie es geschrieben wird) und seine melodische Intonation machen das Lernen zu einer Freude. Die Sprache integriert eine philosophische Unterscheidung zwischen Zustand und Wesen in ihre Grammatik mit zwei verschiedenen Verben für „sein“ (ser und estar), was ihren Reichtum und ihre Feinheit zeigt. Spanisch zu lernen öffnet nicht nur die Türen zu einer riesigen Geografie von Lateinamerika bis Spanien, sondern auch zum Herzen einer warmen und leidenschaftlichen Kultur.",
            "es-grammar-analysis-title": "Analyse der spanischen Grammatik",
            "es-ser-estar-title": "Der Unterschied zwischen Ser & Estar",
            "es-ser-estar-exp": "<b>Ser:</b> Dauerhafte, unveränderliche Eigenschaften (Identität, Beruf). \"Yo <b>soy</b> profesor.\"<br><b>Estar:</b> Vorübergehende Zustände und Orte (Emotion, Ort). \"Yo <b>estoy</b> cansado.\"",
            "es-ser-estar-attn": "<b>Achtung:</b> Diese Unterscheidung ist grundlegend für das Spanische.",
            "es-gender-agreement-title": "Geschlecht und Übereinstimmung",
            "es-gender-agreement-exp": "<b>Regel:</b> Substantive sind entweder männlich (enden oft auf -o) oder weiblich (-a). Adjektive und Artikel müssen in Geschlecht und Zahl mit dem Substantiv übereinstimmen.",
            "es-preterito-imperfecto-title": "Pretérito vs. Imperfecto",
            "es-preterito-imperfecto-exp": "Es gibt zwei Hauptvergangenheitsformen.<br><b>Pretérito:</b> Für einmalige, abgeschlossene Handlungen in der Vergangenheit. \"Ayer <b>comí</b> paella.\" (Gestern habe ich Paella gegessen).<br><b>Imperfecto:</b> Für Gewohnheiten, wiederholte Handlungen oder Hintergrundbeschreibungen in der Vergangenheit. \"Cuando era niño, <b>jugaba</b> al fútbol.\" (Als ich ein Kind war, spielte ich Fußball).",
            "es-por-para-title": "Der Unterschied zwischen Por & Para",
            "es-por-para-exp": "Beide können „für“ bedeuten, aber ihre Verwendung unterscheidet sich.<br><b>Por:</b> Grund, Ursache, Mittel. \"Lo hice <b>por</b> ti.\" (Ich tat es deinetwegen).<br><b>Para:</b> Zweck, Ziel, Empfänger. \"Este regalo es <b>para</b> ti.\" (Dieses Geschenk ist für dich).",
            "es-subjuntivo-title": "Subjuntivo (Konjunktiv)",
            "es-subjuntivo-exp": "<b>Funktion:</b> Ein spezieller Verb-Modus, der verwendet wird, um subjektive Gefühle, Wünsche, Zweifel und Möglichkeiten anstelle von Fakten auszudrücken.",
            "es-punctuation-title": "Umgekehrte Frage-/Ausrufezeichen",
            "es-punctuation-exp": "<b>Funktion:</b> Frage- (¿) und Ausrufezeichen (¡) werden sowohl am Anfang (umgekehrt) als auch am Ende eines Satzes platziert. Dies informiert den Leser von Anfang an über den Ton des Satzes.",
            "es-reflexive-verbs-title": "Reflexivverben",
            "es-reflexive-verbs-exp": "<b>Struktur:</b> Verb + se. Wird verwendet, wenn Subjekt und Objekt der Handlung dieselbe Person sind.",
            "es-object-pronouns-title": "Direkte/Indirekte Objekte",
            "es-object-pronouns-exp": "<b>Direktes Objekt:</b> Das direkt von der Handlung betroffene Objekt (lo, la, los, las).<br><b>Indirektes Objekt:</b> Das indirekt von der Handlung betroffene Objekt (le, les).",
            "es-future-tense-title": "Futur",
            "es-future-tense-exp": "<b>Struktur:</b> Infinitiv + Endung (-é, -ás, -á, -emos, -éis, -án). Wird für zukünftige Handlungen verwendet.",
            "es-conditional-tense-title": "Konditional",
            "es-conditional-tense-exp": "<b>Struktur:</b> Infinitiv + Konditional-Endung (-ía, -ías, -ía, -íamos, -íais, -ían). Für höfliche Bitten und hypothetische Situationen.",
            "es-learning-tips-title": "Lerntipps für Spanisch",
            "es-5-strategies-title": "5 Strategien für erfolgreiches Spanischlernen",
            "es-tip-1": "<b>Ser vs. Estar:</b> Üben Sie diese beiden Verben mit Alltagsbeispielen. \"Soy estudiante\" (Ich bin Student) vs. \"Estoy cansado\" (Ich bin müde).",
            "es-tip-2": "<b>Aussprache üben:</b> Üben Sie regelmäßig die Laute \"rr\", \"ñ\" und \"j\". Wiederholen Sie das Wort \"perro\" (Hund).",
            "es-tip-3": "<b>Verbkonjugationen:</b> Lernen Sie die Präsenskonjugationen regelmäßiger Verben (-o, -as, -a, -amos, -áis, -an) auswendig.",
            "es-tip-4": "<b>Lateinamerikanische Kultur:</b> Verfolgen Sie die Musik, Filme und Nachrichten spanischsprachiger Länder.",
            "es-tip-5": "<b>Alltägliche Gespräche:</b> Verwenden Sie grundlegende Ausdrücke wie \"¿Cómo estás?\" und \"Mucho gusto\" im Alltag.",
            "es-tip-6": "<b>💬 Konversationsübung:</b> Nutzen Sie die Spanisch-Chat-Funktion von Lingoano, um komplexe Grammatikregeln wie \"Ser\" und \"Estar\" zu üben. Echte Gespräche erleichtern das Verständnis dieses Unterschieds.",
            "es-learning-strategies-title": "Spanisch-Lernstrategien",
            "es-tactic-1": "<b>Unterscheidung Ser vs. Estar:</b> Üben Sie diese beiden Verben mit Alltagsbeispielen. Testen Sie diesen Unterschied in echten Gesprächen in der Spanisch-Chat-Funktion von Lingoano.",
            "es-tactic-2": "<b>Aussprache und Lautsystem:</b> Üben Sie regelmäßig die Laute „rr“, „ñ“ und „j“. Verbessern Sie Ihre Aussprache mit der Voice-Chat-Funktion von Lingoano und üben Sie mit spanischen Muttersprachlern.",
            "es-tactic-3": "<b>Verbkonjugationen und Zeitensysteme:</b> Lernen Sie die Präsenskonjugationen regelmäßiger Verben auswendig. Verstehen Sie den Unterschied zwischen Pretérito und Imperfecto. Bilden Sie Sätze mit diesen Zeitformen auf Lingoano.",
            "es-tactic-4": "<b>Lateinamerikanische Kultur und authentische Materialien:</b> Verfolgen Sie die Musik, Filme und Nachrichten spanischsprachiger Länder. Lernen Sie die Sprache in ihrem natürlichen Kontext, indem Sie diese kulturellen Themen in den Spanisch-Chaträumen von Lingoano diskutieren.",
            "es-tactic-5": "<b>Alltägliche Konversation und Kommunikation:</b> Verwenden Sie grundlegende Ausdrücke wie „¿Cómo estás?“ und „Mucho gusto“ im Alltag. Festigen Sie diese Ausdrücke, indem Sie über alltägliche Themen auf Lingoano chatten.",
    
            // Französischer Abschnitt
            "fr-intro-title": "Einführung in Französisch: Die Sprache der Eleganz und Regeln",
            "fr-intro-p": "Wie Spanisch ist auch Französisch eine romanische Sprache, die als Sprache der Diplomatie, Mode und Kunst bekannt ist. Sie hat eine einzigartige Musikalität mit ihrem reichen Lautsystem, Nasalvokalen (en, on, un) und phonetischen Regeln wie der \"Liaison\". Die Grammatikregeln sind stark strukturiert, und die Verbkonjugationen (conjugaison) stehen im Mittelpunkt der Sprache. Französisch zu lernen bedeutet nicht nur, eine ästhetische Sprache zu lernen, sondern auch eine tiefe Reise in die Geschichte der Weltkultur und des Denkens zu unternehmen.",
            "fr-grammar-analysis-title": "Analyse der französischen Grammatik",
            "fr-etre-avoir-title": "Être & Avoir",
            "fr-etre-avoir-exp": "Diese beiden unregelmäßigen Verben sind die Grundlage des Französischen. \"Être\" (sein) und \"Avoir\" (haben) werden auch als Hilfsverben zur Bildung der Vergangenheitsform (passé composé) verwendet.",
            "fr-negation-title": "Verneinung: Ne... pas",
            "fr-negation-exp": "<b>Struktur:</b> Im Französischen wird die Verneinung gebildet, indem \"ne\" und \"pas\" das Verb umschließen.",
            "fr-negation-attn": "<b>Achtung:</b> In der gesprochenen Sprache wird \"ne\" oft weggelassen (\"Je parle pas\"), aber schriftlich ist es obligatorisch.",
            "fr-passe-compose-title": "Passé Composé",
            "fr-passe-compose-exp": "<b>Verwendung:</b> Die gebräuchlichste Vergangenheitsform in der gesprochenen Sprache. Struktur: avoir/être + Partizip Perfekt des Verbs.<br><b>Verwendung von Être:</b> Wird im Allgemeinen bei Verben der Bewegung und Zustandsänderung verwendet (aller, venir, partir...).",
            "fr-partitifs-title": "Teilungsartikel",
            "fr-partitifs-exp": "<b>Funktion:</b> Wird verwendet, um auf eine unbestimmte Menge eines unzählbaren Substantivs zu verweisen.<br><b>du</b> (maskulin), <b>de la</b> (feminin), <b>de l'</b> (Vokal), <b>des</b> (Plural).",
            "fr-y-en-pronouns-title": "Die Pronomen 'Y' und 'En'",
            "fr-y-en-pronouns-exp": "<b>Y:</b> Ersetzt im Allgemeinen \"à + ein Ort\" oder \"à + eine Sache.\" Es fügt die Bedeutung von „dort“ hinzu.<br><b>En:</b> Ersetzt im Allgemeinen \"de + eine Sache\" oder eine Menge. Es fügt die Bedeutung von „einige“ oder „davon“ hinzu.",
            "fr-liaison-title": "Liaison (Bindung)",
            "fr-liaison-exp": "<b>Regel:</b> Ein Wort, das auf einen stummen Konsonanten endet, wird ausgesprochen, indem es mit dem folgenden Wort verbunden wird, das mit einem Vokal beginnt. Dies verleiht der Sprache ihren flüssigen Klang.",
            "fr-subjonctif-title": "Subjonctif (Konjunktiv)",
            "fr-subjonctif-exp": "<b>Verwendung:</b> Wird verwendet, um subjektive Gefühle, Wünsche und Zweifel auszudrücken. Er erscheint oft in Nebensätzen, die mit \"que\" beginnen.",
            "fr-imparfait-title": "Imparfait (Imperfekt)",
            "fr-imparfait-exp": "<b>Verwendung:</b> Wird für vergangene Gewohnheiten, andauernde Situationen und Hintergrundbeschreibungen verwendet.",
            "fr-futur-simple-title": "Futur Simple (Einfaches Futur)",
            "fr-futur-simple-exp": "<b>Struktur:</b> Infinitiv + Futur-Endung (-ai, -as, -a, -ons, -ez, -ont). Wird für zukünftige Handlungen verwendet.",
            "fr-conditionnel-title": "Conditionnel Présent (Präsens Konditional)",
            "fr-conditionnel-exp": "<b>Struktur:</b> Futur-Stamm + Imparfait-Endung. Wird für höfliche Bitten und hypothetische Situationen verwendet.",
            "fr-learning-tips-title": "Lerntipps für Französisch",
            "fr-5-strategies-title": "5 Strategien für erfolgreiches Französischlernen",
            "fr-tip-1": "<b>Nasale Laute:</b> Üben Sie regelmäßig nasale Laute wie \"en\", \"on\", \"un.\" Sprechen Sie das Wort \"Bonjour\" korrekt aus.",
            "fr-tip-2": "<b>Liaison-Regeln:</b> Lernen und wenden Sie die Liaison-Regeln an. Z. B. \"Vous avez\" → \"vou-z-ave.\"",
            "fr-tip-3": "<b>Verbkonjugationen:</b> Lernen Sie die Konjugationen regelmäßiger \"-er\"-Verben (-e, -es, -e, -ons, -ez, -ent) auswendig.",
            "fr-tip-4": "<b>Französische Kultur:</b> Verfolgen Sie französische Filme, Musik und Nachrichten. Hören Sie Musik im Stil des \"Chanson.\"",
            "fr-tip-5": "<b>Alltägliche Ausdrücke:</b> Verwenden Sie grundlegende Ausdrücke wie \"Bonjour,\" \"Au revoir,\" und \"S'il vous plaît\" im Alltag.",
            "fr-tip-6": "<b>💬 Konversationsübung:</b> Nutzen Sie die Französisch-Chat-Funktion von Lingoano, um Nasallaute und Liaison-Regeln zu üben. Echte Gespräche perfektionieren Ihre französische Aussprache.",
            "fr-learning-strategies-title": "Französisch-Lernstrategien",
            "fr-tactic-1": "<b>Nasallaute und Aussprache:</b> Üben Sie regelmäßig Nasallaute wie „en“, „on“, „un“. Üben Sie diese Laute in echten Gesprächen in der Französisch-Chat-Funktion von Lingoano.",
            "fr-tactic-2": "<b>Liaison-Regeln und Sprachfluss:</b> Lernen und wenden Sie die Liaison-Regeln an. Z.B. „Vous avez“ → „vou-z-ave“. Wenden Sie diese Regeln in natürlicher Sprache mit der Voice-Chat-Funktion von Lingoano an.",
            "fr-tactic-3": "<b>Verbkonjugationen und Zeitensysteme:</b> Lernen Sie die Konjugationen regelmäßiger „-er“-Verben auswendig. Verstehen Sie den Unterschied zwischen Passé Composé und Imparfait. Bilden Sie Sätze mit diesen Zeitformen auf Lingoano.",
            "fr-tactic-4": "<b>Französische Kultur und authentische Materialien:</b> Verfolgen Sie französische Filme, Musik und Nachrichten. Lernen Sie die Sprache in ihrem natürlichen Kontext, indem Sie diese kulturellen Themen in den Französisch-Chaträumen von Lingoano diskutieren.",
            "fr-tactic-5": "<b>Tägliche Kommunikation und Praxis:</b> Verwenden Sie grundlegende Ausdrücke wie „Bonjour“ und „S'il vous plaît“ im Alltag. Festigen Sie diese Ausdrücke, indem Sie über alltägliche Themen auf Lingoano chatten.",
    
            // Türkischer Abschnitt
            "tr-intro-title": "Einführung in Türkisch: Eine agglutinierende und harmonische Sprache",
            "tr-intro-p": "Türkisch, das zum altaischen Zweig der ural-altaischen Sprachfamilie gehört, zeichnet sich durch seine agglutinierende Struktur aus. Das bedeutet, dass Suffixe, die Bedeutung und Funktion hinzufügen, an ein Wurzelwort aneinandergereiht werden. Diese Struktur ermöglicht es, komplexe Konzepte in einem einzigen Wort auszudrücken, wie \"gözlükçülük\" (das Geschäft eines Optikers). Phonetische Regeln wie die große und kleine Vokalharmonie verleihen der Sprache einen phonetischen Rhythmus und eine mathematische Ordnung. Türkisch zu lernen bedeutet, die Kunst zu entdecken, neue Bedeutungen zu schaffen, indem man Wörter wie Legosteine zusammensetzt.",
            "tr-grammar-analysis-title": "Analyse der türkischen Grammatik",
            "tr-vowel-harmony-title": "Vokalharmonie",
            "tr-vowel-harmony-exp": "<b>Funktion:</b> Dies ist die grundlegende Lautregel des Türkischen. Der Vokal eines Suffixes wird durch den letzten Vokal des Wortes bestimmt.<br><b>Große Vokalharmonie:</b> Auf hintere Vokale (a, ı, o, u) folgen hintere Vokale, und auf vordere Vokale (e, i, ö, ü) folgen vordere Vokale.",
            "tr-agglutination-title": "Agglutinierende Struktur",
            "tr-agglutination-exp": "<b>Regel:</b> Ableitungssuffixe (die die Bedeutung ändern) kommen zuerst, gefolgt von Beugungssuffixen (die die Funktion angeben). Jedes Suffix hat eine einzige Rolle.",
            "tr-sov-structure-title": "Satzstruktur (SOV)",
            "tr-sov-structure-exp": "<b>Struktur:</b> Die grundlegende Satzstellung im Türkischen ist <b>Subjekt-Objekt-Verb</b>. Das Verb steht normalerweise ganz am Ende des Satzes.",
            "tr-sov-structure-attn": "<b>Vergleich:</b> Im Englischen würde dieser Satz \"I read a book yesterday\" (SVO) lauten.",
            "tr-noun-compounds-title": "Substantivkomposita",
            "tr-noun-compounds-exp": "<b>Struktur:</b> Zwei Substantive bilden zusammen ein neues Konzept.<br><b>Bestimmt:</b> Sowohl der Besitzer (-in) als auch das Besessene (-i) erhalten Suffixe. (kapı<b>nın</b> kol<b>u</b> - der Griff der Tür)<br><b>Unbestimmt:</b> Nur das Besessene (-i) erhält ein Suffix. (okul kapı<b>sı</b> - Schultür)",
            "tr-verbals-title": "Verbalnomen (Fiilimsiler)",
            "tr-verbals-exp": "<b>Funktion:</b> Wörter, die von Verbstämmen abgeleitet sind und im Satz als Substantive, Adjektive oder Adverbien fungieren. Sie werden verwendet, um Sätze zu kombinieren und zu verkürzen.<br><b>Verbalnomen:</b> -ma, -ış, -mak<br><b>Partizip:</b> -an, -ası, -mez, -ar, -dik, -ecek, -miş<br><b>Gerundium/Adverbial:</b> -ken, -alı, -ip...",
            "tr-var-yok-title": "\"Var\" und \"Yok\"",
            "tr-var-yok-exp": "<b>Verwendung:</b> Wird verwendet, um Besitz auszudrücken, anstelle von \"haben\" im Deutschen. Es zeigt das Vorhandensein oder Fehlen von etwas an.",
            "tr-tense-suffixes-title": "Zeit-Suffixe",
            "tr-tense-suffixes-exp": "<b>Präsens:</b> Wird mit dem -iyor-Suffix gebildet. \"Ben okuyorum, sen okuyorsun...\"<br><b>Vergangenheit:</b> Wird mit dem -di/-dı-Suffix gebildet. \"Ben okudum, sen okudun...\"<br><b>Zukunft:</b> Wird mit dem -ecek/-acak-Suffix gebildet. \"Ben okuyacağım, sen okuyacaksın...\"",
            "tr-plural-suffix-title": "Plural-Suffix",
            "tr-plural-suffix-exp": "<b>Regel:</b> Substantive werden durch Hinzufügen des -ler/-lar-Suffixes pluralisiert. Je nach Vokalharmonie wird entweder -ler (vorne) oder -lar (hinten) verwendet.",
            "tr-case-suffixes-title": "Kasus-Suffixe",
            "tr-case-suffixes-exp": "<b>Dativ (-e/-a):</b> \"Eve gidiyorum\" (zum Haus)<br><b>Lokativ (-de/-da):</b> \"Evde oturuyorum\" (im Haus)<br><b>Ablativ (-den/-dan):</b> \"Evden çıkıyorum\" (aus dem Haus)<br><b>Akkusativ (-i/-ı):</b> \"Kitabı okuyorum\" (das Buch)",
            "tr-adjectives-title": "Adjektive",
            "tr-adjectives-exp": "<b>Struktur:</b> Im Türkischen werden Adjektive nicht dekliniert. Wenn sie mit Substantiven verwendet werden, erhält das Substantiv die Flexionssuffixe.<br><b>Vergleich:</b> Wird mit -daha (mehr), -en (am meisten) gebildet.",
            "tr-learning-tips-title": "Lerntipps für Türkisch",
            "tr-5-strategies-title": "5 Strategien für erfolgreiches Türkischlernen",
            "tr-tip-1": "<b>Das Suffix-System:</b> Verstehen Sie die agglutinierende Natur des Türkischen. Jedes Suffix hat eine einzige Funktion, und Sie können neue Bedeutungen schaffen, indem Sie sie kombinieren.",
            "tr-tip-2": "<b>Vokalharmonie:</b> Lernen Sie diese Regel gut. Auf hintere Vokale folgen hintere Vokale, auf vordere Vokale folgen vordere Vokale.",
            "tr-tip-3": "<b>Satzstruktur:</b> Das Verb steht im Türkischen am Ende des Satzes. Machen Sie diese Struktur zur Gewohnheit.",
            "tr-tip-4": "<b>Alltägliche Gespräche:</b> Verwenden Sie häufig grundlegende Ausdrücke wie \"Merhaba,\" \"Nasılsın?,\" und \"Teşekkür ederim\".",
            "tr-tip-5": "<b>Türkische Kultur:</b> Verfolgen Sie türkische Filme, Musik und Nachrichten. Dies hilft Ihnen, die Sprache in ihrem natürlichen Kontext zu lernen.",
            "tr-tip-6": "<b>💬 Konversationsübung:</b> Nutzen Sie die Türkisch-Chat-Funktion von Lingoano, um das Suffix-System und die Vokalharmonie zu üben. Echte Gespräche beschleunigen Ihr Verständnis der türkischen Logik.",
            "tr-learning-strategies-title": "Türkisch-Lernstrategien",
            "tr-tactic-1": "<b>Suffix-System und Wortstruktur:</b> Verstehen Sie die agglutinierende Natur des Türkischen. Üben Sie diese Suffixe in echten Gesprächen in der Türkisch-Chat-Funktion von Lingoano.",
            "tr-tactic-2": "<b>Vokalharmonie und Lautregeln:</b> Lernen Sie diese Regel gut. Wenden Sie diese Regel an, wenn Sie neue Wörter auf Lingoano bilden.",
            "tr-tactic-3": "<b>Syntax und Satzstruktur:</b> Das Verb steht im Türkischen am Ende des Satzes. Wenden Sie diese Struktur in natürlicher Sprache in den Türkisch-Chaträumen von Lingoano an.",
            "tr-tactic-4": "<b>Tägliche Konversation und Kommunikation:</b> Verwenden Sie häufig grundlegende Ausdrücke wie „Merhaba“ und „Nasılsın?“. Festigen Sie diese Ausdrücke, indem Sie über alltägliche Themen auf Lingoano chatten.",
            "tr-tactic-5": "<b>Türkische Kultur und authentische Materialien:</b> Verfolgen Sie türkische Filme, Musik und Nachrichten. Lernen Sie die Sprache in ihrem natürlichen Kontext, indem Sie über diese Themen auf Lingoano diskutieren.",
    
            // Russischer Abschnitt
            "ru-intro-title": "Einführung in Russisch: Eine reiche und ausdrucksstarke Sprache",
            "ru-intro-p": "Russisch, das zum slawischen Zweig der indogermanischen Familie gehört, hat mit seinem kyrillischen Alphabet und seinem reichen phonetischen System einen einzigartigen Charakter. Wie Deutsch hat es eine komplexe Grammatik, die auf Substantivfällen (6 Padeschi) basiert. Diese Struktur ermöglicht eine sehr flexible Wortstellung, bei der Betonung und Intonation eine wichtige Rolle für die Bedeutung spielen. Die Aspektunterscheidung bei Verben (Wid) fügt eine unglaubliche Feinheit hinzu, indem sie anzeigt, ob eine Handlung abgeschlossen oder andauernd ist. Russisch zu lernen ist eine Gelegenheit, die Werke von Dostojewski und Tolstoi in ihrer Originalsprache zu berühren und ein tiefes kulturelles Erbe zu erkunden.",
            "ru-grammar-analysis-title": "Analyse der russischen Grammatik",
            "ru-cyrillic-title": "Das kyrillische Alphabet",
            "ru-cyrillic-exp": "<b>Struktur:</b> Es besteht aus 33 Buchstaben. Einige Buchstaben sehen aus wie lateinische (А, К, М, О, Т), einige sehen ähnlich aus, klingen aber anders (В 'w', Н 'n', Р 'r'), und einige sind völlig neu (Ж 'sch', Ц 'ts', Я 'ja').",
            "ru-cases-title": "Substantivfälle (Падежи)",
            "ru-cases-exp": "<b>Funktion:</b> Russisch hat 6 Fälle, die die Rolle eines Wortes in einem Satz durch Ändern seiner Endung bestimmen.<br><b>Beispiel:</b> \"книга\" (Buch) -> \"Я читаю <b>книгу</b>\" (Akkusativ).",
            "ru-verb-aspect-title": "Verbalaspekt (Вид)",
            "ru-verb-aspect-exp": "<b>Regel:</b> Die meisten Verben gibt es in zwei Formen:<br><b>Imperfektiv (Несовершенный):</b> Zeigt den Prozess oder die Wiederholung einer Handlung an. (читать - lesen/am Lesen sein)<br><b>Perfektiv (Совершенный):</b> Zeigt den Abschluss einer Handlung an. (прочитать - fertig lesen)",
            "ru-gender-system-title": "Genus-System",
            "ru-gender-system-exp": "<b>Regel:</b> Es gibt 3 Genera: Maskulin (endet auf einen Konsonanten/-й), Feminin (-а/-я) und Neutrum (-о/-е). Adjektive und Verben in der Vergangenheitsform ändern sich je nach Genus des Substantivs.",
            "ru-motion-verbs-title": "Verben der Bewegung",
            "ru-motion-verbs-exp": "<b>Regel:</b> Im Russischen werden Bewegungsverben in zwei Typen unterteilt: unidirektional (идти - zu Fuß gehen) und multidirektional/gewohnheitsmäßig (ходить - zu Fuß gehen, umhergehen).",
            "ru-genitive-negation-title": "Genitiv bei Verneinung",
            "ru-genitive-negation-exp": "<b>Regel:</b> Um auszudrücken, dass man etwas nicht hat oder dass etwas nicht vorhanden ist, wird das Wort \"нет\" (nein/nicht) verwendet, gefolgt vom Substantiv im Genitiv.",
            "ru-stress-system-title": "Betonungssystem",
            "ru-stress-system-exp": "<b>Wichtigkeit:</b> Die Betonung ist im Russischen sehr wichtig. Dasselbe Wort kann mit unterschiedlichen Betonungsmustern unterschiedliche Bedeutungen haben, was durch ein Akzentzeichen (´) angezeigt wird.",
            "ru-stress-system-attn": "<b>Achtung:</b> Wenn die Betonung an der falschen Stelle liegt, kann das Wort unverständlich werden.",
            "ru-adjective-declension-title": "Adjektivdeklination",
            "ru-adjective-declension-exp": "<b>Regel:</b> Adjektive ändern sich je nach Geschlecht, Zahl und Fall des Substantivs, das sie modifizieren. Sie haben maskuline, feminine, neutrale und plurale Formen.",
            "ru-future-tense-ru-title": "Futur",
            "ru-future-tense-ru-exp": "<b>Struktur:</b> быть (sein) + Infinitiv. Wird für zukünftige Handlungen verwendet. Das Verb быть wird konjugiert.",
            "ru-imperative-title": "Imperativ (Befehlsform)",
            "ru-imperative-exp": "<b>Struktur:</b> Verbstamm + Imperativendung. Wird für Befehle, Bitten und Ratschläge verwendet.",
            "ru-reflexive-verbs-ru-title": "Reflexivverben",
            "ru-reflexive-verbs-ru-exp": "<b>Struktur:</b> Verb + -ся/-сь. Wird verwendet, wenn Subjekt und Objekt der Handlung identisch sind.",
            "ru-learning-tips-title": "Lerntipps für Russisch",
            "ru-5-strategies-title": "5 Strategien für erfolgreiches Russischlernen",
            "ru-tip-1": "<b>Das kyrillische Alphabet:</b> Konzentrieren Sie sich in der ersten Woche auf das Alphabet. Üben Sie das Schreiben und Lesen jedes Buchstabens. Beginnen Sie mit einfachen Wörtern wie \"Привет.\"",
            "ru-tip-2": "<b>Betonungssystem:</b> Achten Sie darauf, wo die Betonung liegt. Falsche Betonung kann ein Wort unverständlich machen.",
            "ru-tip-3": "<b>Substantivfälle:</b> Lernen Sie das 6-Fälle-System mit alltäglichen Beispielen. Üben Sie jeden Tag die Deklinationen eines Substantivs in verschiedenen Fällen.",
            "ru-tip-4": "<b>Verbalaspekt:</b> Verstehen Sie den Unterschied zwischen imperfektiv (Prozess) und perfektiv (Ergebnis). Dies ist eines der wichtigsten Merkmale des Russischen.",
            "ru-tip-5": "<b>Russische Kultur:</b> Verfolgen Sie russische Filme, Musik und Nachrichten. Zeichentrickfilme verwenden oft eine einfachere Sprache.",
            "ru-tip-6": "<b>💬 Konversationsübung:</b> Nutzen Sie die Russisch-Chat-Funktion von Lingoano, um das kyrillische Alphabet und das Betonungssystem zu üben. Echte Gespräche verbessern Ihre russische Aussprache und Ihr Hörverständnis.",
            "ru-learning-strategies-title": "Russisch-Lernstrategien",
            "ru-tactic-1": "<b>Kyrillisches Alphabet und Grundlaute:</b> Konzentrieren Sie sich in der ersten Woche auf das Alphabet. Üben Sie diese Wörter in echten Gesprächen in der Russisch-Chat-Funktion von Lingoano.",
            "ru-tactic-2": "<b>Betonungssystem und Aussprache:</b> Achten Sie darauf, wo die Betonung liegt. Verbessern Sie Ihre Aussprache mit der Voice-Chat-Funktion von Lingoano und üben Sie mit russischen Muttersprachlern.",
            "ru-tactic-3": "<b>Lernen der Substantivfälle (Падежи):</b> Lernen Sie das 6-Fälle-System mit alltäglichen Beispielen. Testen Sie diese Strukturen in echten Gesprächen auf Lingoano.",
            "ru-tactic-4": "<b>Verbalaspekt (Вид) und Zeitensysteme:</b> Verstehen Sie den Unterschied zwischen imperfektiv (Prozess) und perfektiv (Ergebnis). Wenden Sie diese Unterscheidung in den Russisch-Chaträumen von Lingoano an.",
            "ru-tactic-5": "<b>Russische Kultur und authentische Materialien:</b> Verfolgen Sie russische Filme, Musik und Nachrichten. Lernen Sie die Sprache in ihrem natürlichen Kontext, indem Sie über diese kulturellen Themen in der Russisch-Chat-Funktion von Lingoano diskutieren."
        },
            es: {
                // General
                "learning-tactics-title": "Tácticas de Aprendizaje",
                "culture-note-title": "💡 Nota sobre Lengua y Cultura",
        
                // Guía de Inglés (en Español)
                "en-intro-title": "Introducción al Inglés: Un Idioma Mundial",
                "en-intro-p": "Perteneciente a la rama germánica de la familia de lenguas indoeuropeas, el inglés es la lengua franca de la comunicación global. Su estructura analítica, donde la función de las palabras se determina por el orden y las palabras auxiliares en lugar de los sufijos, lo distingue de muchos otros idiomas. En este viaje, descubrirás la estructura flexible y lógica del inglés.",
                "en-grammar-analysis-title": "Análisis de la Gramática Inglesa",
                "en-articles-title": "Artículos (a/an, the)",
                "en-articles-exp": "<b>a/an:</b> Se usa para un objeto general. <b>the:</b> Se usa para un objeto específico ya mencionado.",
                "en-present-simple-title": "Present Simple",
                "en-present-simple-exp": "<b>Uso:</b> Verdades generales, hábitos. El verbo lleva \"-s\" con He/She/It.",
                "en-past-simple-title": "Past Simple",
                "en-past-simple-exp": "<b>Uso:</b> Acciones completadas en el pasado. Los verbos regulares llevan \"-ed\"; los irregulares cambian (V2).",
                "en-past-simple-attn": "<b>Nota:</b> En negaciones y preguntas con `did`, el verbo vuelve a su forma base.",
                "en-present-perfect-title": "Present Perfect",
                "en-present-perfect-exp": "<b>Uso:</b> Acciones que comenzaron en el pasado y aún tienen efecto, o que ocurrieron en un tiempo no especificado. Estructura: have/has + V3.",
                "en-modal-verbs-title": "Verbos Modales",
                "en-modal-verbs-exp": "<b>Función:</b> Añaden significados como habilidad (can), posibilidad (may), necesidad (must) y consejo (should).",
                "en-gerunds-infinitives-title": "Gerundios e Infinitivos",
                "en-gerunds-infinitives-exp": "<b>Gerundio (V-ing):</b> Usado como sustantivo después de ciertos verbos.<br><b>Infinitivo (to V):</b> Usado para expresar un propósito después de ciertos verbos.",
                "en-conditionals-title": "Oraciones Condicionales",
                "en-conditionals-exp": "<b>Zero Conditional:</b> Verdades generales (If + Present, Present).<br><b>First Conditional:</b> Futuro posible (If + Present, will + V).<br><b>Second Conditional:</b> Situaciones imaginarias (If + Past, would + V).",
                "en-passive-voice-title": "Voz Pasiva",
                "en-passive-voice-exp": "<b>Estructura:</b> be + V3. Se usa cuando el agente es desconocido o no es importante.",
                "en-reported-speech-title": "Estilo Indirecto",
                "en-reported-speech-exp": "<b>Regla:</b> Al reportar las palabras de alguien, el tiempo verbal retrocede. Present → Past, Past → Past Perfect.",
                "en-relative-clauses-title": "Cláusulas Relativas",
                "en-relative-clauses-exp": "<b>Definitorias (Defining):</b> Proporcionan información esencial, sin comas.<br><b>Explicativas (Non-defining):</b> Proporcionan información extra, separadas por comas.",
                "en-learning-tips-title": "Consejos para Aprender Inglés",
                "en-5-golden-rules-title": "5 Reglas de Oro para Aprender Inglés con Éxito",
                "en-tip-1": "<b>Práctica Diaria:</b> Dedica al menos 30 minutos al inglés todos los días. La constancia es más efectiva que el estudio intensivo.",
                "en-tip-2": "<b>Fuentes Múltiples:</b> No te centres solo en libros de texto, sino también en materiales auténticos como películas, música y noticias.",
                "en-tip-3": "<b>No Temas Equivocarte:</b> Los errores son parte natural del aprendizaje. Intenta hablar, no ser perfecto.",
                "en-tip-4": "<b>Aprende en Contexto:</b> Aprende palabras en frases, no en listas. Esto refuerza tanto el significado como el uso.",
                "en-tip-5": "<b>Contexto Cultural:</b> Aprende el inglés no solo como idioma, sino como parte de una cultura.",
                "en-tip-6": "<b>💬 Práctica de Conversación:</b> Utiliza el chat de inglés de Lingoano para practicar en tiempo real.",
                "en-learning-strategies-title": "Estrategias de Aprendizaje de Inglés",
                "en-tactic-1": "<b>Estrategia de Vocabulario:</b> Aprende palabras en contexto. Practica tu nuevo vocabulario en conversaciones reales usando el chat de inglés de Lingoano.",
                "en-tactic-2": "<b>Enfoque Gramatical:</b> Aprende las reglas gramaticales con frases prácticas, no solo teoría. Por cada nueva regla, crea al menos 5 frases diferentes.",
                "en-tactic-3": "<b>Comprensión Auditiva y Pronunciación:</b> Escucha diferentes acentos. Mejora tu pronunciación con la función de chat de voz de Lingoano.",
                "en-tactic-4": "<b>Práctica Oral:</b> Participa en prácticas activas de conversación. Habla sobre temas diarios, haz preguntas y da respuestas en las salas de chat de Lingoano.",
                "en-tactic-5": "<b>Contexto Cultural:</b> Sigue noticias, blogs y redes sociales en inglés. Aumenta tu conciencia cultural chateando sobre estos temas en Lingoano.",
                "en-did-you-know": "Hay miles de \"phrasal verbs\" en inglés que forman la base de la conversación diaria. Aprenderlos es clave para entender a los hablantes nativos.",
        
                // Guía de Alemán (en Español)
                "de-intro-title": "Introducción al Alemán: El Idioma de la Lógica y la Estructura",
                "de-intro-p": "Al igual que el inglés, el alemán pertenece a la familia de las lenguas germánicas y destaca por su estructura lógica y basada en reglas. Características como los casos de los sustantivos (Kasus) y la posición de los verbos le confieren una precisión de ingeniería. Aprender alemán no solo abre una nueva puerta a la comunicación, sino que también mejora tu pensamiento analítico.",
                "de-grammar-analysis-title": "Análisis de la Gramática Alemana",
                "de-artikel-title": "Artículos y Género",
                "de-artikel-exp": "<b>Regla:</b> Cada sustantivo tiene un género: <b>der</b> (masculino), <b>die</b> (femenino), <b>das</b> (neutro). Debe memorizarse con la palabra.",
                "de-artikel-attn": "<b>Nota:</b> Que \"das Mädchen\" (la niña) sea neutro resalta la importancia del género gramatical.",
                "de-kasus-title": "Casos (Kasus)",
                "de-kasus-exp": "Indica la función de un sustantivo y cambia su artículo.<br><b>Nominativo:</b> Sujeto - <b>Der Hund</b> ist klein.<br><b>Acusativo:</b> Objeto directo - Ich sehe <b>den Hund</b>.<br><b>Dativo:</b> Objeto indirecto - Ich gebe <b>dem Hund</b> Wasser.",
                "de-satzbau-title": "Estructura de la Oración (Satzbau)",
                "de-satzbau-exp": "<b>Regla Básica (V2):</b> En las cláusulas principales, el verbo conjugado está <b>siempre en segunda posición.</b>",
                "de-perfekt-title": "Tiempo Perfecto (Perfekt)",
                "de-perfekt-exp": "<b>Uso:</b> El tiempo pasado más común en el lenguaje hablado. Estructura: haben/sein + Partizip II.",
                "de-trennbare-verben-title": "Verbos Separables",
                "de-trennbare-verben-exp": "<b>Estructura:</b> El prefijo de verbos como \"anrufen\" (llamar) va al final de la cláusula principal.",
                "de-praepositionen-title": "Preposiciones",
                "de-praepositionen-exp": "En alemán, las preposiciones determinan el caso (Acusativo o Dativo) del sustantivo que sigue.<br><b>Acusativo:</b> für, durch, gegen...<br><b>Dativo:</b> mit, nach, von, zu...",
                "de-konjunktiv-title": "Subjuntivo II (Konjunktiv II)",
                "de-konjunktiv-exp": "<b>Uso:</b> Para situaciones hipotéticas, peticiones corteses y eventos pasados que no ocurrieron.",
                "de-relativsaetze-title": "Cláusulas Relativas",
                "de-relativsaetze-exp": "<b>Estructura:</b> Cláusulas subordinadas que describen sustantivos. Se usan pronombres relativos (der, die, das, denen).",
                "de-passiv-title": "Voz Pasiva",
                "de-passiv-exp": "<b>Estructura:</b> werden + Partizip II. Se usa cuando el agente es irrelevante.",
                "de-infinitiv-zu-title": "Infinitivo con 'zu'",
                "de-infinitiv-zu-exp": "<b>Uso:</b> Se usa después de ciertos verbos para indicar un propósito. \"zu\" + infinitivo.",
                "de-learning-tips-title": "Consejos para Aprender Alemán",
                "de-5-strategies-title": "5 Estrategias para el Éxito en el Aprendizaje de Alemán",
                "de-tip-1": "<b>Memorizar Artículos:</b> Aprende cada sustantivo con su artículo. Usa tarjetas de colores para visualizar los géneros.",
                "de-tip-2": "<b>El Sistema de Casos:</b> Practica los casos con ejemplos de la vida real. Forma frases simples.",
                "de-tip-3": "<b>Conjugaciones Verbales:</b> Repite rítmicamente los verbos regulares. Se volverá automático.",
                "de-tip-4": "<b>Palabras Compuestas:</b> Descompón las palabras largas en sus componentes. \"Handschuh\" = Hand + Schuh.",
                "de-tip-5": "<b>Cultura Alemana:</b> Sigue películas, música y noticias alemanas para aprender en contexto.",
                "de-tip-6": "<b>💬 Práctica de Conversación:</b> Usa el chat de alemán de Lingoano para practicar las reglas gramaticales.",
                "de-learning-strategies-title": "Estrategias de Aprendizaje de Alemán",
                "de-tactic-1": "<b>Sistema de Artículos y Género:</b> Aprende cada palabra nueva con su artículo. Aprende los artículos de forma natural usándolos en el chat de alemán de Lingoano.",
                "de-tactic-2": "<b>Aprendizaje de Casos:</b> Practica los casos con ejemplos cotidianos. Prueba estas estructuras en conversaciones reales en Lingoano.",
                "de-tactic-3": "<b>Conjugación y Sintaxis:</b> Repite las conjugaciones regulares. Practica la regla V2 con frases diarias. Automatiza estas reglas en las salas de chat de Lingoano.",
                "de-tactic-4": "<b>Palabras Compuestas:</b> Descompón palabras largas. Refuerza sus significados usándolas en Lingoano.",
                "de-tactic-5": "<b>Cultura y Materiales Auténticos:</b> Sigue películas y música alemanas. Aprende en contexto discutiendo temas culturales en el chat de Lingoano.",
                "de-did-you-know": "La capacidad del alemán para formar palabras compuestas (Komposita) es famosa. Desde \"Handschuh\" (guante) hasta palabras muy largas en textos legales, muestra cuán modular puede ser el idioma.",
                
                // Guía de Español (en Español)
                "es-intro-title": "Introducción al Español: El Idioma de la Melodía y la Emoción",
                "es-intro-p": "Miembro de la rama romance de la familia indoeuropea, el español es la segunda lengua nativa más hablada del mundo. Su naturaleza fonética y su entonación melódica hacen que sea un placer aprenderlo. El idioma incorpora una distinción filosófica entre estado y esencia en su gramática con dos verbos diferentes para \"ser\" (ser y estar), mostrando su riqueza y sutileza. Aprender español abre las puertas no solo a una vasta geografía desde América Latina hasta España, sino también al corazón de una cultura cálida y apasionada.",
                "es-grammar-analysis-title": "Análisis de la Gramática Española",
                "es-ser-estar-title": "Diferencia entre Ser y Estar",
                "es-ser-estar-exp": "<b>Ser:</b> Características permanentes e inmutables (identidad, profesión). \"Yo <b>soy</b> profesor.\"<br><b>Estar:</b> Estados y ubicaciones temporales (emoción, lugar). \"Yo <b>estoy</b> cansado.\"",
                "es-ser-estar-attn": "<b>Nota:</b> Esta distinción es fundamental para el español.",
                "es-gender-agreement-title": "Género y Concordancia",
                "es-gender-agreement-exp": "<b>Regla:</b> Los sustantivos son masculinos (a menudo terminan en -o) o femeninos (-a). Los adjetivos y artículos deben concordar con el género y número del sustantivo.",
                "es-preterito-imperfecto-title": "Pretérito vs. Imperfecto",
                "es-preterito-imperfecto-exp": "Hay dos tiempos pasados principales.<br><b>Pretérito:</b> Para acciones que ocurrieron una vez y se completaron en el pasado. \"Ayer <b>comí</b> paella.\"<br><b>Imperfecto:</b> Para hábitos pasados, acciones repetidas o descripciones de fondo. \"Cuando era niño, <b>jugaba</b> al fútbol.\"",
                "es-por-para-title": "Diferencia entre Por y Para",
                "es-por-para-exp": "Ambos pueden significar \"for\", pero sus usos difieren.<br><b>Por:</b> Razón, causa, medio. \"Lo hice <b>por</b> ti.\"<br><b>Para:</b> Propósito, destino, destinatario. \"Este regalo es <b>para</b> ti.\"",
                "es-subjuntivo-title": "Modo Subjuntivo",
                "es-subjuntivo-exp": "<b>Función:</b> Un modo verbal especial utilizado para expresar sentimientos subjetivos, deseos, dudas y posibilidades en lugar de hechos.",
                "es-punctuation-title": "Signos de Interrogación/Exclamación Invertidos",
                "es-punctuation-exp": "<b>Función:</b> Los signos de interrogación (¿) y exclamación (¡) se colocan tanto al principio (invertidos) como al final de una oración.",
                "es-reflexive-verbs-title": "Verbos Reflexivos",
                "es-reflexive-verbs-exp": "<b>Estructura:</b> Verbo + se. Se usa cuando el sujeto y el objeto de la acción son la misma persona.",
                "es-object-pronouns-title": "Objetos Directos/Indirectos",
                "es-object-pronouns-exp": "<b>Objeto Directo:</b> El objeto directamente afectado por la acción (lo, la, los, las).<br><b>Objeto Indirecto:</b> El objeto indirectamente afectado por la acción (le, les).",
                "es-future-tense-title": "Tiempo Futuro",
                "es-future-tense-exp": "<b>Estructura:</b> Infinitivo + terminación (-é, -ás, -á, -emos, -éis, -án). Se usa para acciones futuras.",
                "es-conditional-tense-title": "Tiempo Condicional",
                "es-conditional-tense-exp": "<b>Estructura:</b> Infinitivo + terminación condicional (-ía, -ías, -ía, -íamos, -íais, -ían). Para peticiones amables y situaciones hipotéticas.",
                "es-learning-tips-title": "Consejos para Aprender Español",
                "es-5-strategies-title": "5 Estrategias para el Éxito en el Aprendizaje de Español",
                "es-tip-1": "<b>Ser vs Estar:</b> Practica estos dos verbos con ejemplos cotidianos. \"Soy estudiante\" vs. \"Estoy cansado\".",
                "es-tip-2": "<b>Práctica de Pronunciación:</b> Practica regularmente los sonidos \"rr\", \"ñ\" y \"j\". Repite la palabra \"perro\".",
                "es-tip-3": "<b>Conjugaciones Verbales:</b> Memoriza las conjugaciones en presente de los verbos regulares (-o, -as, -a, -amos, -áis, -an).",
                "es-tip-4": "<b>Cultura Latina:</b> Sigue la música, las películas y las noticias de los países de habla hispana.",
                "es-tip-5": "<b>Conversación Diaria:</b> Usa frases básicas como \"¿Cómo estás?\" y \"Mucho gusto\" en la vida diaria.",
                "es-tip-6": "<b>💬 Práctica de Conversación:</b> Usa la función de chat en español de Lingoano para practicar reglas gramaticales complejas como \"Ser\" y \"Estar\".",
                "es-learning-strategies-title": "Estrategias de Aprendizaje de Español",
                "es-tactic-1": "<b>Distinción Ser vs. Estar:</b> Practica estos dos verbos con ejemplos cotidianos. Prueba esta distinción en conversaciones reales en el chat de español de Lingoano.",
                "es-tactic-2": "<b>Pronunciación y Sistema de Sonidos:</b> Practica regularmente los sonidos \"rr\", \"ñ\" y \"j\". Mejora tu pronunciación con la función de chat de voz de Lingoano y practica con hablantes nativos de español.",
                "es-tactic-3": "<b>Conjugaciones Verbales y Tiempos:</b> Memoriza las conjugaciones en presente de los verbos regulares. Entiende la diferencia entre Pretérito e Imperfecto. Forma oraciones usando estos tiempos en Lingoano.",
                "es-tactic-4": "<b>Cultura Latina y Materiales Auténticos:</b> Sigue la música, películas y noticias de países de habla hispana. Aprende el idioma en su contexto natural discutiendo estos temas culturales en las salas de chat de español de Lingoano.",
                "es-tactic-5": "<b>Conversación y Comunicación Diaria:</b> Usa frases básicas como \"¿Cómo estás?\" y \"Mucho gusto\" en la vida diaria. Refuerza estas expresiones chateando sobre temas cotidianos en Lingoano.",
                "es-did-you-know": "La distinción entre \"ser\" y \"estar\", ambos traducidos como \"to be\" en inglés, es una característica central del español que permite un nivel de precisión descriptiva sobre la naturaleza de las cosas (permanente vs. temporal) que muchos otros idiomas no tienen.",
                
                // Recursos Académicos
                "academic-sources-title": "Recursos Académicos",
                "cefr-guidelines-title": "Directrices CEFR",
                "cefr-guidelines-desc": "Marco Común Europeo de Referencia para las Lenguas (CEFR)",
                "second-language-acquisition-title": "Adquisición de Segunda Lengua",
                "second-language-acquisition-desc": "Libros de texto Cambridge SLA",
                "corpora-title": "Corpus Lingüísticos",
                "corpora-desc": "Fuentes de corpus como COCA/BNC",
                "peer-reviewed-title": "Estudios Revisados por Pares",
                "peer-reviewed-desc": "Búsqueda de literatura en Google Scholar",
        
                // Guía de Francés (en Español)
                "fr-intro-title": "Introducción al Francés: El Idioma de la Elegancia y las Reglas",
                "fr-intro-p": "El francés es una lengua romance conocida como el idioma de la diplomacia, la moda y el arte. Tiene una musicalidad única con sus vocales nasales y reglas fonéticas como la \"liaison\". Las reglas gramaticales están muy estructuradas y las conjugaciones verbales son fundamentales. Aprender francés es un viaje a la historia de la cultura mundial.",
                "fr-grammar-analysis-title": "Análisis de la Gramática Francesa",
                "fr-etre-avoir-title": "Être & Avoir",
                "fr-etre-avoir-exp": "Estos dos verbos irregulares son la base del francés. \"Être\" (ser/estar) y \"Avoir\" (haber/tener) también se usan como auxiliares para formar el passé composé.",
                "fr-negation-title": "Negación: Ne... pas",
                "fr-negation-exp": "<b>Estructura:</b> En francés, la negación se forma colocando \"ne\" y \"pas\" alrededor del verbo.",
                "fr-negation-attn": "<b>Nota:</b> En el lenguaje hablado, \"ne\" a menudo se omite, pero es obligatorio por escrito.",
                "fr-passe-compose-title": "Passé Composé",
                "fr-passe-compose-exp": "<b>Uso:</b> El tiempo pasado más común en el lenguaje hablado. Estructura: avoir/être + el participio pasado del verbo.<br><b>Uso de Être:</b> Generalmente con verbos de movimiento y cambio de estado.",
                "fr-partitifs-title": "Artículos Partitivos",
                "fr-partitifs-exp": "<b>Función:</b> Se usan para referirse a una cantidad no especificada de un sustantivo no contable.<br><b>du</b> (masculino), <b>de la</b> (femenino), <b>de l'</b> (vocal), <b>des</b> (plural).",
                "fr-y-en-pronouns-title": "Los Pronombres 'Y' y 'En'",
                "fr-y-en-pronouns-exp": "<b>Y:</b> Generalmente reemplaza \"à + un lugar\" o \"à + una cosa\".<br><b>En:</b> Generalmente reemplaza \"de + una cosa\" o una cantidad.",
                "fr-liaison-title": "Liaison",
                "fr-liaison-exp": "<b>Regla:</b> Una palabra que termina en una consonante muda se pronuncia uniéndola a la siguiente palabra que comienza con una vocal. Esto le da fluidez al idioma.",
                "fr-subjonctif-title": "Subjuntivo (Subjonctif)",
                "fr-subjonctif-exp": "<b>Uso:</b> Para expresar sentimientos subjetivos, deseos y dudas. A menudo aparece en cláusulas que comienzan con \"que\".",
                "fr-imparfait-title": "Imperfecto (Imparfait)",
                "fr-imparfait-exp": "<b>Uso:</b> Para hábitos pasados, situaciones en curso y descripciones de fondo.",
                "fr-futur-simple-title": "Futuro Simple (Futur Simple)",
                "fr-futur-simple-exp": "<b>Estructura:</b> Infinitivo + terminación de futuro (-ai, -as, -a, -ons, -ez, -ont).",
                "fr-conditionnel-title": "Condicional Presente (Conditionnel Présent)",
                "fr-conditionnel-exp": "<b>Estructura:</b> Raíz del futuro simple + terminación del imperfecto. Para peticiones corteses y situaciones hipotéticas.",
                "fr-learning-tips-title": "Consejos para Aprender Francés",
                "fr-5-strategies-title": "5 Estrategias para el Éxito en el Aprendizaje de Francés",
                "fr-tip-1": "<b>Sonidos Nasales:</b> Practica regularmente los sonidos nasales como \"en\", \"on\", \"un\".",
                "fr-tip-2": "<b>Reglas de Liaison:</b> Aprende y aplica las reglas de liaison. Ej: \"Vous avez\" → \"vu-z-avé\".",
                "fr-tip-3": "<b>Conjugaciones Verbales:</b> Memoriza las conjugaciones de los verbos regulares en \"-er\".",
                "fr-tip-4": "<b>Cultura Francesa:</b> Sigue películas, música y noticias francesas. Escucha música estilo \"Chanson\".",
                "fr-tip-5": "<b>Expresiones Diarias:</b> Usa expresiones básicas como \"Bonjour\", \"Au revoir\" y \"S'il vous plaît\".",
                "fr-tip-6": "<b>💬 Práctica de Conversación:</b> Usa el chat de francés de Lingoano para practicar los sonidos nasales y las reglas de liaison.",
                "fr-learning-strategies-title": "Estrategias de Aprendizaje de Francés",
                "fr-tactic-1": "<b>Sonidos Nasales y Pronunciación:</b> Practica regularmente los sonidos nasales. Practícalos en conversaciones reales en el chat de francés de Lingoano.",
                "fr-tactic-2": "<b>Reglas de Liaison y Fluidez:</b> Aprende y aplica las reglas de liaison. Aplica estas reglas en el habla natural con la función de chat de voz de Lingoano.",
                "fr-tactic-3": "<b>Conjugaciones y Tiempos:</b> Memoriza las conjugaciones de los verbos en \"-er\". Entiende la diferencia entre Passé Composé e Imparfait.",
                "fr-tactic-4": "<b>Cultura y Materiales Auténticos:</b> Sigue películas y música francesas. Aprende el idioma discutiendo temas culturales en las salas de chat de Lingoano.",
                "fr-tactic-5": "<b>Comunicación Diaria:</b> Usa expresiones básicas como \"Bonjour\" y \"S'il vous plaît\". Refuerza estas expresiones chateando en Lingoano.",
                "fr-did-you-know": "El francés hablado en Quebec (Canadá) tiene diferencias notables en pronunciación, vocabulario y expresiones idiomáticas en comparación con el francés de Francia, lo que lo convierte en un dialecto vibrante y único.",
        
                // Guía de Turco (en Español)
                "tr-intro-title": "Introducción al Turco: Un Idioma Aglutinante y Armonioso",
                "tr-intro-p": "Perteneciente a la rama altaica, el turco es notable por su estructura aglutinante. Esto significa que los sufijos se añaden uno tras otro a una palabra raíz. Reglas como la armonía vocálica le dan un ritmo fonético. Aprender turco es descubrir el arte de construir nuevos significados combinando palabras como legos.",
                "tr-grammar-analysis-title": "Análisis de la Gramática Turca",
                "tr-vowel-harmony-title": "Armonía Vocálica",
                "tr-vowel-harmony-exp": "<b>Función:</b> Es la regla de sonido fundamental del turco. La vocal de un sufijo se determina por la última vocal de la palabra.",
                "tr-agglutination-title": "Estructura Aglutinante",
                "tr-agglutination-exp": "<b>Regla:</b> Los sufijos derivativos (cambian el significado) van primero, seguidos de los sufijos flexivos (indican función).",
                "tr-sov-structure-title": "Estructura de la Oración (SOV)",
                "tr-sov-structure-exp": "<b>Estructura:</b> El orden básico de la oración en turco es <b>Sujeto-Objeto-Verbo</b>. El verbo suele estar al final.",
                "tr-sov-structure-attn": "<b>Comparación:</b> En inglés, esta oración sería \"I read a book yesterday\" (SVO).",
                "tr-noun-compounds-title": "Compuestos Nominales",
                "tr-noun-compounds-exp": "<b>Estructura:</b> Dos sustantivos se unen para formar un nuevo concepto.<br><b>Definido:</b> Tanto el poseedor (-in) como lo poseído (-i) llevan sufijos.<br><b>Indefinido:</b> Solo lo poseído (-i) lleva un sufijo.",
                "tr-verbals-title": "Verbales (Fiilimsiler)",
                "tr-verbals-exp": "<b>Función:</b> Palabras derivadas de raíces verbales que funcionan como sustantivos, adjetivos o adverbios.",
                "tr-var-yok-title": "\"Var\" y \"Yok\"",
                "tr-var-yok-exp": "<b>Uso:</b> Se usan para expresar posesión en lugar de \"tener\". Indican la existencia o ausencia de algo.",
                "tr-tense-suffixes-title": "Sufijos de Tiempo",
                "tr-tense-suffixes-exp": "<b>Presente Continuo:</b> Formado con el sufijo -iyor.<br><b>Pasado:</b> Formado con el sufijo -di/-dı.<br><b>Futuro:</b> Formado con el sufijo -ecek/-acak.",
                "tr-plural-suffix-title": "Sufijo Plural",
                "tr-plural-suffix-exp": "<b>Regla:</b> Los sustantivos se pluralizan añadiendo el sufijo -ler/-lar, según la armonía vocálica.",
                "tr-case-suffixes-title": "Sufijos de Caso",
                "tr-case-suffixes-exp": "<b>Dativo (-e/-a):</b> \"Eve gidiyorum\" (a la casa)<br><b>Locativo (-de/-da):</b> \"Evde oturuyorum\" (en la casa)<br><b>Ablativo (-den/-dan):</b> \"Evden çıkıyorum\" (de la casa)<br><b>Acusativo (-i/-ı):</b> \"Kitabı okuyorum\" (el libro)",
                "tr-adjectives-title": "Adjetivos",
                "tr-adjectives-exp": "<b>Estructura:</b> En turco, los adjetivos no se flexionan.<br><b>Comparación:</b> Se forma con -daha (más), -en (el más).",
                "tr-learning-tips-title": "Consejos para Aprender Turco",
                "tr-5-strategies-title": "5 Estrategias para el Éxito en el Aprendizaje de Turco",
                "tr-tip-1": "<b>El Sistema de Sufijos:</b> Comprende la naturaleza aglutinante del turco.",
                "tr-tip-2": "<b>Armonía Vocálica:</b> Aprende bien esta regla. Es fundamental.",
                "tr-tip-3": "<b>Estructura de la Oración:</b> El verbo va al final. Acostúmbrate a esta estructura.",
                "tr-tip-4": "<b>Conversación Diaria:</b> Usa frases básicas como \"Merhaba\" y \"Nasılsın?\" frecuentemente.",
                "tr-tip-5": "<b>Cultura Turca:</b> Sigue películas y música turcas para aprender en contexto.",
                "tr-tip-6": "<b>💬 Práctica de Conversación:</b> Usa el chat de turco de Lingoano para practicar el sistema de sufijos y la armonía vocálica.",
                "tr-learning-strategies-title": "Estrategias de Aprendizaje de Turco",
                "tr-tactic-1": "<b>Sistema de Sufijos y Estructura de Palabras:</b> Comprende la naturaleza aglutinante del turco. Practica estos sufijos en conversaciones reales en el chat de turco de Lingoano.",
                "tr-tactic-2": "<b>Armonía Vocálica y Reglas de Sonido:</b> Aprende bien esta regla. Aplícala al formar nuevas palabras en Lingoano.",
                "tr-tactic-3": "<b>Sintaxis y Estructura de la Oración:</b> El verbo va al final. Aplica esta estructura en el habla natural en las salas de chat de turco de Lingoano.",
                "tr-tactic-4": "<b>Conversación y Comunicación Diaria:</b> Usa frases básicas como \"Merhaba\" y \"Nasılsın?\" frecuentemente.",
                "tr-tactic-5": "<b>Cultura y Materiales Auténticos:</b> Sigue películas y música turcas. Aprende discutiendo temas culturales en Lingoano.",
                "tr-did-you-know": "Gracias a su estructura aglutinante, el turco puede formar oraciones completas en una sola palabra, como \"Çekoslovakyalılaştıramadıklarımızdan mısınız?\", que significa \"¿Es usted una de esas personas a las que no pudimos hacer checoslovacas?\"",
        
                // Guía de Ruso (en Español)
                "ru-intro-title": "Introducción al Ruso: Un Idioma Rico y Expresivo",
                "ru-intro-p": "Perteneciente a la rama eslava, el ruso tiene un carácter único con su alfabeto cirílico. Al igual que el alemán, tiene una gramática compleja basada en casos de sustantivos (6 падежи). Esta estructura permite un orden de palabras muy flexible, donde el acento y la entonación juegan un papel importante. La distinción de aspecto en los verbos añade una sutileza increíble. Aprender ruso es una oportunidad para tocar las obras de Dostoievski y Tolstoi en su idioma original.",
                "ru-grammar-analysis-title": "Análisis de la Gramática Rusa",
                "ru-cyrillic-title": "El Alfabeto Cirílico",
                "ru-cyrillic-exp": "<b>Estructura:</b> Consta de 33 letras. Algunas letras se parecen a las latinas (А, К, М, О, Т), otras se ven similares pero suenan diferente (В 'v', Н 'n', Р 'r'), y algunas son completamente nuevas (Ж 'zh', Ц 'ts', Я 'ya').",
                "ru-cases-title": "Casos de Sustantivos (Падежи)",
                "ru-cases-exp": "<b>Función:</b> El ruso tiene 6 casos que determinan el papel de una palabra cambiando su terminación.<br><b>Ejemplo:</b> \"книга\" (libro) -> \"Я читаю <b>книгу</b>\" (caso acusativo).",
                "ru-verb-aspect-title": "Aspecto Verbal (Вид)",
                "ru-verb-aspect-exp": "<b>Regla:</b> La mayoría de los verbos vienen en dos formas:<br><b>Imperfectivo (Несовершенный):</b> Indica el proceso o la repetición de una acción.<br><b>Perfectivo (Совершенный):</b> Indica la finalización de una acción.",
                "ru-gender-system-title": "Sistema de Género",
                "ru-gender-system-exp": "<b>Regla:</b> Hay 3 géneros: Masculino (termina en consonante/-й), Femenino (-а/-я) y Neutro (-о/-е). Los adjetivos y los verbos en pasado cambian según el género del sustantivo.",
                "ru-motion-verbs-title": "Verbos de Movimiento",
                "ru-motion-verbs-exp": "<b>Regla:</b> Se dividen en dos tipos: Unidireccionales (идти - ir a pie) y Multidireccionales/habituales (ходить - andar a pie).",
                "ru-genitive-negation-title": "Caso Genitivo para la Negación",
                "ru-genitive-negation-exp": "<b>Regla:</b> Para expresar la ausencia de algo, se usa la palabra \"нет\" seguida del sustantivo en caso genitivo.",
                "ru-stress-system-title": "Sistema de Acento",
                "ru-stress-system-exp": "<b>Importancia:</b> El acento es muy importante en ruso. La misma palabra puede tener diferentes significados con diferentes acentos.",
                "ru-stress-system-attn": "<b>Nota:</b> Si el acento está en el lugar equivocado, la palabra puede ser incomprensible.",
                "ru-adjective-declension-title": "Declinación de Adjetivos",
                "ru-adjective-declension-exp": "<b>Regla:</b> Los adjetivos cambian según el género, número y caso del sustantivo que modifican.",
                "ru-future-tense-ru-title": "Tiempo Futuro",
                "ru-future-tense-ru-exp": "<b>Estructura:</b> быть (ser/estar) + infinitivo. El verbo быть se conjuga.",
                "ru-imperative-title": "Modo Imperativo",
                "ru-imperative-exp": "<b>Estructura:</b> Raíz del verbo + terminación imperativa. Se usa para órdenes, peticiones y consejos.",
                "ru-reflexive-verbs-ru-title": "Verbos Reflexivos",
                "ru-reflexive-verbs-ru-exp": "<b>Estructura:</b> Verbo + -ся/-сь. Se usa cuando el sujeto y el objeto de la acción son los mismos.",
                "ru-learning-tips-title": "Consejos para Aprender Ruso",
                "ru-5-strategies-title": "5 Estrategias para el Éxito en el Aprendizaje de Ruso",
                "ru-tip-1": "<b>El Alfabeto Cirílico:</b> Concéntrate en el alfabeto la primera semana. Empieza con palabras simples como \"Привет\".",
                "ru-tip-2": "<b>Sistema de Acento:</b> Presta atención a dónde cae el acento. Un acento incorrecto puede hacer que una palabra sea ininteligible.",
                "ru-tip-3": "<b>Casos de Sustantivos:</b> Aprende el sistema de 6 casos con ejemplos cotidianos.",
                "ru-tip-4": "<b>Aspecto Verbal:</b> Entiende la distinción entre imperfectivo (proceso) y perfectivo (resultado).",
                "ru-tip-5": "<b>Cultura Rusa:</b> Sigue películas, música y noticias rusas. Los dibujos animados a menudo usan un lenguaje más simple.",
                "ru-tip-6": "<b>💬 Práctica de Conversación:</b> Usa el chat de ruso de Lingoano para practicar el alfabeto cirílico y el sistema de acento.",
                "ru-learning-strategies-title": "Estrategias de Aprendizaje de Ruso",
                "ru-tactic-1": "<b>Alfabeto Cirílico y Sonidos Básicos:</b> Concéntrate en el alfabeto la primera semana. Practica estas palabras en conversaciones reales en el chat de ruso de Lingoano.",
                "ru-tactic-2": "<b>Sistema de Acento y Pronunciación:</b> Presta atención a dónde cae el acento. Mejora tu pronunciación con la función de chat de voz de Lingoano.",
                "ru-tactic-3": "<b>Aprendizaje de Casos (Падежи):</b> Aprende el sistema de 6 casos con ejemplos cotidianos. Prueba estas estructuras en conversaciones reales en Lingoano.",
                "ru-tactic-4": "<b>Aspecto Verbal (Вид) y Tiempos:</b> Entiende la distinción entre imperfectivo y perfectivo. Aplica esta distinción en las salas de chat de ruso de Lingoano.",
                "ru-tactic-5": "<b>Cultura y Materiales Auténticos:</b> Sigue películas y música rusas. Aprende el idioma discutiendo temas culturales en el chat de Lingoano.",
                "ru-did-you-know": "El ruso es uno de los pocos idiomas del mundo que tiene consonantes \"duras\" y \"blandas\". La diferencia, a menudo indicada por los signos duro (ъ) y blando (ь), puede cambiar completamente el significado de una palabra, lo que lo convierte en un aspecto crucial de la pronunciación."
            },
            fr: {
                // Général
                "learning-tactics-title": "Tactiques d'apprentissage",
                "culture-note-title": "💡 Note sur la langue et la culture",
        
                // Guide Anglais (en Français)
                "en-intro-title": "Introduction à l'anglais : Une langue mondiale",
                "en-intro-p": "Appartenant à la branche germanique de la famille des langues indo-européennes, l'anglais est la lingua franca de la communication mondiale. Sa structure analytique, où la fonction des mots est déterminée par l'ordre des mots et les mots outils plutôt que par les suffixes, le distingue de nombreuses autres langues. Au cours de ce voyage, vous découvrirez la structure flexible et logique de l'anglais.",
                "en-grammar-analysis-title": "Analyse de la grammaire anglaise",
                "en-articles-title": "Articles (a/an, the)",
                "en-articles-exp": "<b>a/an :</b> Utilisé pour un objet général. <b>the :</b> Utilisé pour un objet spécifique déjà mentionné.",
                "en-present-simple-title": "Présent Simple",
                "en-present-simple-exp": "<b>Usage :</b> Vérités générales, habitudes. Le verbe prend un \"-s\" avec He/She/It.",
                "en-past-simple-title": "Passé Simple (Past Simple)",
                "en-past-simple-exp": "<b>Usage :</b> Actions terminées dans le passé. Les verbes réguliers prennent \"-ed\" ; les irréguliers changent (V2).",
                "en-past-simple-attn": "<b>Note :</b> Dans les négations et les questions avec `did`, le verbe retourne à sa forme de base.",
                "en-present-perfect-title": "Present Perfect",
                "en-present-perfect-exp": "<b>Usage :</b> Actions commencées dans le passé et ayant toujours un effet, ou survenues à un moment non spécifié. Structure : have/has + V3.",
                "en-modal-verbs-title": "Verbes modaux",
                "en-modal-verbs-exp": "<b>Fonction :</b> Ils ajoutent des significations comme la capacité (can), la possibilité (may), la nécessité (must) et le conseil (should).",
                "en-gerunds-infinitives-title": "Gérondifs et Infinitifs",
                "en-gerunds-infinitives-exp": "<b>Gérondif (V-ing) :</b> Utilisé comme un nom après certains verbes.<br><b>Infinitif (to V) :</b> Utilisé pour exprimer un but après certains verbes.",
                "en-conditionals-title": "Phrases conditionnelles",
                "en-conditionals-exp": "<b>Zéro conditionnel :</b> Vérités générales (If + Présent, Présent).<br><b>Premier conditionnel :</b> Futur possible (If + Présent, will + V).<br><b>Deuxième conditionnel :</b> Situations imaginaires (If + Passé, would + V).",
                "en-passive-voice-title": "Voix passive",
                "en-passive-voice-exp": "<b>Structure :</b> be + V3. Utilisée lorsque l'agent est inconnu ou sans importance.",
                "en-reported-speech-title": "Discours indirect",
                "en-reported-speech-exp": "<b>Règle :</b> En rapportant les paroles de quelqu'un, le temps verbal recule. Présent → Passé, Passé → Plus-que-parfait.",
                "en-relative-clauses-title": "Propositions relatives",
                "en-relative-clauses-exp": "<b>Définissantes (Defining) :</b> Fournissent des informations essentielles, sans virgules.<br><b>Explicatives (Non-defining) :</b> Fournissent des informations supplémentaires, séparées par des virgules.",
                "en-learning-tips-title": "Conseils pour apprendre l'anglais",
                "en-5-golden-rules-title": "5 règles d'or pour un apprentissage réussi de l'anglais",
                "en-tip-1": "<b>Pratique quotidienne :</b> Consacrez au moins 30 minutes à l'anglais chaque jour. La régularité est plus efficace que l'étude intensive.",
                "en-tip-2": "<b>Sources multiples :</b> Ne vous concentrez pas uniquement sur les manuels, mais aussi sur des matériaux authentiques comme les films et la musique.",
                "en-tip-3": "<b>N'ayez pas peur de faire des erreurs :</b> Les erreurs font partie de l'apprentissage. Essayez de parler, pas d'être parfait.",
                "en-tip-4": "<b>Apprenez en contexte :</b> Apprenez les mots dans des phrases, pas dans des listes. Cela renforce le sens et l'usage.",
                "en-tip-5": "<b>Contexte culturel :</b> Apprenez l'anglais non seulement comme une langue, mais comme une partie d'une culture.",
                "en-tip-6": "<b>💬 Pratique de la conversation :</b> Utilisez le chat en anglais de Lingoano pour pratiquer en temps réel.",
                "en-learning-strategies-title": "Stratégies d'apprentissage de l'anglais",
                "en-tactic-1": "<b>Stratégie de vocabulaire :</b> Apprenez les mots en contexte. Pratiquez votre nouveau vocabulaire dans des conversations réelles en utilisant le chat anglais de Lingoano.",
                "en-tactic-2": "<b>Approche grammaticale :</b> Apprenez les règles de grammaire avec des phrases pratiques. Pour chaque nouvelle règle, créez au moins 5 phrases différentes.",
                "en-tactic-3": "<b>Compréhension orale et prononciation :</b> Écoutez différents accents. Améliorez votre prononciation avec la fonction de chat vocal de Lingoano.",
                "en-tactic-4": "<b>Pratique de l'oral :</b> Engagez-vous dans une pratique active de l'oral. Parlez de sujets quotidiens, posez des questions et donnez des réponses dans les salons de discussion de Lingoano.",
                "en-tactic-5": "<b>Contexte culturel :</b> Suivez les actualités, les blogs et les médias sociaux en anglais. Améliorez votre conscience culturelle en discutant de ces sujets sur Lingoano.",
                "en-did-you-know": "Il existe des milliers de \"phrasal verbs\" en anglais qui constituent la base de la conversation quotidienne. Les apprendre est essentiel pour comprendre les locuteurs natifs.",
        
                // Guide Allemand (en Français)
                "de-intro-title": "Introduction à l'allemand : La langue de la logique et de la structure",
                "de-intro-p": "Comme l'anglais, l'allemand appartient à la famille des langues germaniques et se distingue par sa structure logique et basée sur des règles. Des caractéristiques telles que les cas des noms (Kasus) et la position des verbes lui confèrent une précision d'ingénierie. Apprendre l'allemand n'ouvre pas seulement une nouvelle porte à la communication, mais améliore également votre pensée analytique.",
                "de-grammar-analysis-title": "Analyse de la grammaire allemande",
                "de-artikel-title": "Articles et genre",
                "de-artikel-exp": "<b>Règle :</b> Chaque nom a un genre : <b>der</b> (masculin), <b>die</b> (féminin), <b>das</b> (neutre). Il doit être mémorisé avec le mot.",
                "de-artikel-attn": "<b>Note :</b> Le fait que \"das Mädchen\" (la fille) soit neutre souligne l'importance du genre grammatical.",
                "de-kasus-title": "Les cas (Kasus)",
                "de-kasus-exp": "Indique la fonction d'un nom et modifie son article.<br><b>Nominatif :</b> Sujet - <b>Der Hund</b> ist klein.<br><b>Accusatif :</b> Objet direct - Ich sehe <b>den Hund</b>.<br><b>Datif :</b> Objet indirect - Ich gebe <b>dem Hund</b> Wasser.",
                "de-satzbau-title": "Structure de la phrase (Satzbau)",
                "de-satzbau-exp": "<b>Règle de base (V2) :</b> Dans les propositions principales, le verbe conjugué est <b>toujours en deuxième position.</b>",
                "de-perfekt-title": "Temps parfait (Perfekt)",
                "de-perfekt-exp": "<b>Usage :</b> Le temps du passé le plus courant à l'oral. Structure : haben/sein + Partizip II.",
                "de-trennbare-verben-title": "Verbes séparables",
                "de-trennbare-verben-exp": "<b>Structure :</b> Le préfixe des verbes comme \"anrufen\" (appeler) va à la fin de la proposition principale.",
                "de-praepositionen-title": "Prépositions",
                "de-praepositionen-exp": "En allemand, les prépositions déterminent le cas (Accusatif ou Datif) du nom qui suit.<br><b>Accusatif :</b> für, durch, gegen...<br><b>Datif :</b> mit, nach, von, zu...",
                "de-konjunktiv-title": "Subjonctif II (Konjunktiv II)",
                "de-konjunktiv-exp": "<b>Usage :</b> Pour les situations hypothétiques, les demandes polies et les événements passés qui ne se sont pas produits.",
                "de-relativsaetze-title": "Propositions relatives",
                "de-relativsaetze-exp": "<b>Structure :</b> Propositions subordonnées qui décrivent des noms. On utilise des pronoms relatifs (der, die, das, denen).",
                "de-passiv-title": "Voix passive",
                "de-passiv-exp": "<b>Structure :</b> werden + Partizip II. Utilisée lorsque l'agent est sans importance.",
                "de-infinitiv-zu-title": "Infinitif avec 'zu'",
                "de-infinitiv-zu-exp": "<b>Usage :</b> Utilisé après certains verbes pour indiquer un but. \"zu\" + infinitif.",
                "de-learning-tips-title": "Conseils pour apprendre l'allemand",
                "de-5-strategies-title": "5 stratégies pour réussir à apprendre l'allemand",
                "de-tip-1": "<b>Mémoriser les articles :</b> Apprenez chaque nom avec son article. Utilisez des fiches de couleur pour visualiser les genres.",
                "de-tip-2": "<b>Le système des cas :</b> Pratiquez les cas avec des exemples de la vie réelle.",
                "de-tip-3": "<b>Conjugaisons verbales :</b> Répétez rythmiquement les verbes réguliers. Cela deviendra automatique.",
                "de-tip-4": "<b>Mots composés :</b> Décomposez les mots longs. \"Handschuh\" = Hand + Schuh.",
                "de-tip-5": "<b>Culture allemande :</b> Suivez des films et de la musique allemands pour apprendre en contexte.",
                "de-tip-6": "<b>💬 Pratique de la conversation :</b> Utilisez le chat en allemand de Lingoano pour pratiquer les règles de grammaire.",
                "de-learning-strategies-title": "Stratégies d'apprentissage de l'allemand",
                "de-tactic-1": "<b>Système d'articles et de genre :</b> Apprenez chaque nouveau mot avec son article. Apprenez les articles naturellement en les utilisant dans le chat allemand de Lingoano.",
                "de-tactic-2": "<b>Apprentissage des cas :</b> Pratiquez les cas avec des exemples quotidiens. Testez ces structures dans des conversations réelles sur Lingoano.",
                "de-tactic-3": "<b>Conjugaison et syntaxe :</b> Répétez les conjugaisons régulières. Pratiquez la règle V2 avec des phrases quotidiennes. Automatisez ces règles dans les salons de discussion de Lingoano.",
                "de-tactic-4": "<b>Mots composés :</b> Décomposez les mots longs. Renforcez leur signification en les utilisant sur Lingoano.",
                "de-tactic-5": "<b>Culture et matériaux authentiques :</b> Suivez des films et de la musique allemands. Apprenez en discutant de sujets culturels sur le chat de Lingoano.",
                "de-did-you-know": "La capacité de l'allemand à former des mots composés (Komposita) est célèbre. De \"Handschuh\" (gant) à des mots très longs dans les textes juridiques, cela montre à quel point la langue peut être modulaire.",
                
                // Guide Espagnol (en Français)
                "es-intro-title": "Introduction à l'espagnol : La langue de la mélodie et de l'émotion",
                "es-intro-p": "Membre de la branche romane de la famille indo-européenne, l'espagnol est la deuxième langue maternelle la plus parlée au monde. Sa nature phonétique et son intonation mélodique en font un plaisir à apprendre. La langue intègre une distinction philosophique entre l'état et l'essence avec deux verbes différents pour \"être\" (ser et estar), montrant sa richesse. Apprendre l'espagnol ouvre les portes non seulement à une vaste géographie, mais aussi au cœur d'une culture chaleureuse.",
                "es-grammar-analysis-title": "Analyse de la grammaire espagnole",
                "es-ser-estar-title": "Différence entre Ser et Estar",
                "es-ser-estar-exp": "<b>Ser :</b> Caractéristiques permanentes et immuables. \"Yo <b>soy</b> profesor.\"<br><b>Estar :</b> États et lieux temporaires. \"Yo <b>estoy</b> cansado.\"",
                "es-ser-estar-attn": "<b>Note :</b> Cette distinction est fondamentale en espagnol.",
                "es-gender-agreement-title": "Genre et accord",
                "es-gender-agreement-exp": "<b>Règle :</b> Les noms sont masculins (-o) ou féminins (-a). Les adjectifs et articles doivent s'accorder en genre et en nombre.",
                "es-preterito-imperfecto-title": "Prétérit vs. Imparfait",
                "es-preterito-imperfecto-exp": "Il y a deux temps du passé principaux.<br><b>Prétérit :</b> Pour les actions uniques et terminées. \"Ayer <b>comí</b> paella.\"<br><b>Imparfait :</b> Pour les habitudes passées ou les descriptions. \"Cuando era niño, <b>jugaba</b> al fútbol.\"",
                "es-por-para-title": "Différence entre Por et Para",
                "es-por-para-exp": "Les deux peuvent signifier \"pour\", mais leurs usages diffèrent.<br><b>Por :</b> Raison, cause, moyen.<br><b>Para :</b> But, destination, destinataire.",
                "es-subjuntivo-title": "Mode Subjonctif",
                "es-subjuntivo-exp": "<b>Fonction :</b> Un mode verbal spécial pour exprimer des sentiments subjectifs, des souhaits, des doutes.",
                "es-punctuation-title": "Points d'interrogation/d'exclamation inversés",
                "es-punctuation-exp": "<b>Fonction :</b> Les signes (¿) et (¡) sont placés au début et à la fin d'une phrase.",
                "es-reflexive-verbs-title": "Verbes réfléchis",
                "es-reflexive-verbs-exp": "<b>Structure :</b> Verbe + se. Utilisé lorsque le sujet et l'objet sont la même personne.",
                "es-object-pronouns-title": "Objets directs/indirects",
                "es-object-pronouns-exp": "<b>Objet direct :</b> L'objet directement affecté (lo, la, los, las).<br><b>Objet indirect :</b> L'objet indirectement affecté (le, les).",
                "es-future-tense-title": "Temps futur",
                "es-future-tense-exp": "<b>Structure :</b> Infinitif + terminaison. Utilisé pour les actions futures.",
                "es-conditional-tense-title": "Temps conditionnel",
                "es-conditional-tense-exp": "<b>Structure :</b> Infinitif + terminaison conditionnelle. Pour les demandes polies et les situations hypothétiques.",
                "es-learning-tips-title": "Conseils pour apprendre l'espagnol",
                "es-5-strategies-title": "5 stratégies pour réussir à apprendre l'espagnol",
                "es-tip-1": "<b>Ser vs Estar :</b> Pratiquez ces deux verbes avec des exemples quotidiens.",
                "es-tip-2": "<b>Pratique de la prononciation :</b> Pratiquez régulièrement les sons \"rr\", \"ñ\" et \"j\".",
                "es-tip-3": "<b>Conjugaisons verbales :</b> Mémorisez les conjugaisons au présent des verbes réguliers.",
                "es-tip-4": "<b>Culture latine :</b> Suivez la musique et les films des pays hispanophones.",
                "es-tip-5": "<b>Conversation quotidienne :</b> Utilisez des phrases de base comme \"¿Cómo estás?\" et \"Mucho gusto\".",
                "es-tip-6": "<b>💬 Pratique de la conversation :</b> Utilisez le chat en espagnol de Lingoano pour pratiquer des règles comme \"Ser\" et \"Estar\".",
                "es-learning-strategies-title": "Stratégies d'apprentissage de l'espagnol",
                "es-tactic-1": "<b>Distinction Ser vs. Estar :</b> Pratiquez ces verbes avec des exemples quotidiens. Testez cette distinction dans des conversations réelles sur le chat espagnol de Lingoano.",
                "es-tactic-2": "<b>Prononciation et système sonore :</b> Pratiquez régulièrement les sons « rr », « ñ » et « j ». Améliorez votre prononciation avec la fonction de chat vocal de Lingoano.",
                "es-tactic-3": "<b>Conjugaisons et temps :</b> Mémorisez les conjugaisons au présent. Comprenez la différence entre le Prétérit et l'Imparfait. Formez des phrases en utilisant ces temps sur Lingoano.",
                "es-tactic-4": "<b>Culture et matériaux authentiques :</b> Suivez la musique et les films hispanophones. Apprenez la langue en discutant de ces sujets culturels dans les salons de discussion de Lingoano.",
                "es-tactic-5": "<b>Communication quotidienne :</b> Utilisez des phrases de base comme « ¿Cómo estás ? ». Renforcez ces expressions en discutant sur Lingoano.",
                "es-did-you-know": "La distinction entre \"ser\" et \"estar\", tous deux traduits par \"to be\" en anglais, est une caractéristique centrale de l'espagnol qui permet une précision descriptive sur la nature des choses (permanente vs temporaire) que beaucoup d'autres langues n'ont pas.",
        
                // Guide Français (en Français)
                "fr-intro-title": "Introduction au Français : La Langue de l'Élégance et des Règles",
                "fr-intro-p": "Comme l'espagnol, le français est une langue romane connue comme la langue de la diplomatie, de la mode et de l'art. Elle possède une musicalité unique avec son système sonore riche, ses voyelles nasales (en, on, un) et ses règles phonétiques comme la \"liaison\". Les règles de grammaire sont très structurées et les conjugaisons verbales sont au cœur de la langue. Apprendre le français, ce n'est pas seulement apprendre une langue esthétique, c'est aussi faire un voyage profond dans l'histoire de la culture et de la pensée mondiales.",
                "fr-grammar-analysis-title": "Analyse de la Grammaire Française",
                "fr-etre-avoir-title": "Être & Avoir",
                "fr-etre-avoir-exp": "Ces deux verbes irréguliers sont la base du français. \"Être\" et \"Avoir\" sont également utilisés comme verbes auxiliaires pour former le passé composé.",
                "fr-negation-title": "La Négation : Ne... pas",
                "fr-negation-exp": "<b>Structure :</b> En français, la négation se forme en plaçant \"ne\" et \"pas\" autour du verbe.",
                "fr-negation-attn": "<b>Note :</b> À l'oral, le \"ne\" est souvent omis (\"Je parle pas\"), mais il est obligatoire à l'écrit.",
                "fr-passe-compose-title": "Passé Composé",
                "fr-passe-compose-exp": "<b>Usage :</b> Le temps du passé le plus courant à l'oral. Structure : avoir/être + le participe passé du verbe.<br><b>Usage de Être :</b> Généralement utilisé avec les verbes de mouvement et de changement d'état (aller, venir, partir...).",
                "fr-partitifs-title": "Articles Partitifs",
                "fr-partitifs-exp": "<b>Fonction :</b> Utilisés pour désigner une quantité non spécifiée d'un nom indénombrable.<br><b>du</b> (masculin), <b>de la</b> (féminin), <b>de l'</b> (voyelle), <b>des</b> (pluriel).",
                "fr-y-en-pronouns-title": "Les Pronoms 'Y' et 'En'",
                "fr-y-en-pronouns-exp": "<b>Y :</b> Remplace généralement \"à + un lieu\" ou \"à + une chose\". Il ajoute le sens de \"là-bas\".<br><b>En :</b> Remplace généralement \"de + une chose\" ou une quantité. Il ajoute le sens de \"quelques-uns\" ou \"de cela\".",
                "fr-liaison-title": "La Liaison",
                "fr-liaison-exp": "<b>Règle :</b> Un mot se terminant par une consonne muette est prononcé en le liant au mot suivant qui commence par une voyelle. Cela donne sa fluidité à la langue.",
                "fr-subjonctif-title": "Subjonctif",
                "fr-subjonctif-exp": "<b>Usage :</b> Utilisé pour exprimer des sentiments subjectifs, des souhaits et des doutes. Il apparaît souvent dans les propositions subordonnées commençant par \"que\".",
                "fr-imparfait-title": "Imparfait",
                "fr-imparfait-exp": "<b>Usage :</b> Utilisé pour les habitudes passées, les situations en cours et les descriptions de fond.",
                "fr-futur-simple-title": "Futur Simple",
                "fr-futur-simple-exp": "<b>Structure :</b> Infinitif + terminaison du futur (-ai, -as, -a, -ons, -ez, -ont). Utilisé pour les actions futures.",
                "fr-conditionnel-title": "Conditionnel Présent",
                "fr-conditionnel-exp": "<b>Structure :</b> Racine du futur simple + terminaison de l'imparfait. Utilisé pour les demandes polies et les situations hypothétiques.",
                "fr-learning-tips-title": "Conseils pour Apprendre le Français",
                "fr-5-strategies-title": "5 Stratégies pour Réussir à Apprendre le Français",
                "fr-tip-1": "<b>Sons Nasaux :</b> Pratiquez régulièrement les sons nasaux comme \"en\", \"on\", \"un\". Prononcez correctement le mot \"Bonjour\".",
                "fr-tip-2": "<b>Règles de Liaison :</b> Apprenez et appliquez les règles de liaison. Ex : \"Vous avez\" → \"vou-z-ave.\"",
                "fr-tip-3": "<b>Conjugaisons Verbales :</b> Mémorisez les conjugaisons des verbes réguliers en \"-er\" (-e, -es, -e, -ons, -ez, -ent).",
                "fr-tip-4": "<b>Culture Française :</b> Suivez les films, la musique et les actualités françaises. Écoutez de la musique de style \"Chanson\".",
                "fr-tip-5": "<b>Expressions Quotidiennes :</b> Utilisez des expressions de base comme \"Bonjour\", \"Au revoir\" et \"S'il vous plaît\" dans la vie de tous les jours.",
                "fr-tip-6": "<b>💬 Pratique de la Conversation :</b> Utilisez la fonction de chat en français de Lingoano pour pratiquer les sons nasaux et les règles de liaison. La conversation réelle perfectionne votre prononciation française.",
                "fr-learning-strategies-title": "Stratégies d'Apprentissage du Français",
                "fr-tactic-1": "<b>Sons nasaux et prononciation :</b> Pratiquez régulièrement les sons nasaux. Pratiquez ces sons en conversation réelle dans la fonction de chat en français de Lingoano.",
                "fr-tactic-2": "<b>Règles de liaison et fluidité :</b> Apprenez et appliquez les règles de liaison. Appliquez ces règles dans un discours naturel avec la fonction de chat vocal de Lingoano.",
                "fr-tactic-3": "<b>Conjugaisons verbales et temps :</b> Mémorisez les conjugaisons des verbes réguliers en « -er ». Comprenez la différence entre le Passé Composé et l'Imparfait. Formez des phrases en utilisant ces temps sur Lingoano.",
                "fr-tactic-4": "<b>Culture française et matériaux authentiques :</b> Suivez les films, la musique et les actualités françaises. Apprenez la langue dans son contexte naturel en discutant de ces sujets culturels dans les salons de discussion en français de Lingoano.",
                "fr-tactic-5": "<b>Communication et pratique quotidiennes :</b> Utilisez des expressions de base comme « Bonjour » et « S'il vous plaît » dans la vie de tous les jours. Renforcez ces expressions en discutant de sujets quotidiens sur Lingoano.",
                "fr-did-you-know": "Le français parlé au Québec (Canada) présente des différences notables de prononciation, de vocabulaire et d'expressions idiomatiques par rapport au français de France, ce qui en fait un dialecte vibrant et unique.",
                
                // Ressources Académiques
                "academic-sources-title": "Ressources Académiques",
                "cefr-guidelines-title": "Directives CEFR",
                "cefr-guidelines-desc": "Cadre Européen Commun de Référence pour les Langues (CEFR)",
                "second-language-acquisition-title": "Acquisition de Langue Seconde",
                "second-language-acquisition-desc": "Manuels Cambridge SLA",
                "corpora-title": "Corpus Linguistiques",
                "corpora-desc": "Sources de corpus comme COCA/BNC",
                "peer-reviewed-title": "Études Évaluées par les Pairs",
                "peer-reviewed-desc": "Recherche de littérature Google Scholar",
        
                // Guide Turc (en Français)
                "tr-intro-title": "Introduction au turc : Une langue agglutinante et harmonieuse",
                "tr-intro-p": "Appartenant à la branche altaïque, le turc est remarquable pour sa structure agglutinante. Cela signifie que des suffixes sont ajoutés les uns après les autres à un mot racine. Des règles comme l'harmonie vocalique lui confèrent un rythme phonétique. Apprendre le turc, c'est découvrir l'art de construire de nouvelles significations en combinant des mots comme des legos.",
                "tr-grammar-analysis-title": "Analyse de la grammaire turque",
                "tr-vowel-harmony-title": "Harmonie vocalique",
                "tr-vowel-harmony-exp": "<b>Fonction :</b> C'est la règle sonore fondamentale du turc. La voyelle d'un suffixe est déterminée par la dernière voyelle du mot.",
                "tr-agglutination-title": "Structure agglutinante",
                "tr-agglutination-exp": "<b>Règle :</b> Les suffixes dérivationnels (qui changent le sens) viennent en premier, suivis des suffixes flexionnels (qui indiquent la fonction).",
                "tr-sov-structure-title": "Structure de la phrase (SOV)",
                "tr-sov-structure-exp": "<b>Structure :</b> L'ordre de base de la phrase en turc est <b>Sujet-Objet-Verbe</b>. Le verbe est généralement à la fin.",
                "tr-sov-structure-attn": "<b>Comparaison :</b> En anglais, cette phrase serait \"I read a book yesterday\" (SVO).",
                "tr-noun-compounds-title": "Composés nominaux",
                "tr-noun-compounds-exp": "<b>Structure :</b> Deux noms s'unissent pour former un nouveau concept.<br><b>Défini :</b> Le possesseur (-in) et le possédé (-i) prennent des suffixes.<br><b>Indéfini :</b> Seul le possédé (-i) prend un suffixe.",
                "tr-verbals-title": "Formes verbales non finies (Fiilimsiler)",
                "tr-verbals-exp": "<b>Fonction :</b> Mots dérivés de racines verbales qui fonctionnent comme des noms, des adjectifs ou des adverbes.",
                "tr-var-yok-title": "\"Var\" et \"Yok\"",
                "tr-var-yok-exp": "<b>Usage :</b> Utilisés pour exprimer la possession au lieu de \"avoir\". Ils indiquent l'existence ou l'absence de quelque chose.",
                "tr-tense-suffixes-title": "Suffixes de temps",
                "tr-tense-suffixes-exp": "<b>Présent continu :</b> Formé avec le suffixe -iyor.<br><b>Passé :</b> Formé avec le suffixe -di/-dı.<br><b>Futur :</b> Formé avec le suffixe -ecek/-acak.",
                "tr-plural-suffix-title": "Suffixe pluriel",
                "tr-plural-suffix-exp": "<b>Règle :</b> Les noms sont mis au pluriel en ajoutant le suffixe -ler/-lar, selon l'harmonie vocalique.",
                "tr-case-suffixes-title": "Suffixes de cas",
                "tr-case-suffixes-exp": "<b>Datif (-e/-a) :</b> \"Eve gidiyorum\" (à la maison)<br><b>Locatif (-de/-da) :</b> \"Evde oturuyorum\" (à la maison)<br><b>Ablatif (-den/-dan) :</b> \"Evden çıkıyorum\" (de la maison)<br><b>Accusatif (-i/-ı) :</b> \"Kitabı okuyorum\" (le livre)",
                "tr-adjectives-title": "Adjectifs",
                "tr-adjectives-exp": "<b>Structure :</b> En turc, les adjectifs ne sont pas fléchis.<br><b>Comparaison :</b> Formée avec -daha (plus), -en (le plus).",
                "tr-learning-tips-title": "Conseils pour apprendre le turc",
                "tr-5-strategies-title": "5 stratégies pour réussir à apprendre le turc",
                "tr-tip-1": "<b>Le système de suffixes :</b> Comprenez la nature agglutinante du turc.",
                "tr-tip-2": "<b>Harmonie vocalique :</b> Apprenez bien cette règle. Elle est fondamentale.",
                "tr-tip-3": "<b>Structure de la phrase :</b> Le verbe est à la fin. Habituez-vous à cette structure.",
                "tr-tip-4": "<b>Conversation quotidienne :</b> Utilisez fréquemment des phrases de base comme \"Merhaba\" et \"Nasılsın?\".",
                "tr-tip-5": "<b>Culture turque :</b> Suivez des films et de la musique turcs pour apprendre en contexte.",
                "tr-tip-6": "<b>💬 Pratique de la conversation :</b> Utilisez le chat en turc de Lingoano pour pratiquer le système de suffixes et l'harmonie vocalique.",
                "tr-learning-strategies-title": "Stratégies d'apprentissage du turc",
                "tr-tactic-1": "<b>Système de suffixes et structure des mots :</b> Comprenez la nature agglutinante du turc. Pratiquez ces suffixes dans des conversations réelles sur le chat turc de Lingoano.",
                "tr-tactic-2": "<b>Harmonie vocalique et règles sonores :</b> Apprenez bien cette règle. Appliquez-la en formant de nouveaux mots sur Lingoano.",
                "tr-tactic-3": "<b>Syntaxe et structure de la phrase :</b> Le verbe est à la fin. Appliquez cette structure dans un discours naturel dans les salons de discussion turcs de Lingoano.",
                "tr-tactic-4": "<b>Communication quotidienne :</b> Utilisez fréquemment des phrases de base comme « Merhaba ». Renforcez ces expressions en discutant sur Lingoano.",
                "tr-tactic-5": "<b>Culture et matériaux authentiques :</b> Suivez des films et de la musique turcs. Apprenez en discutant de sujets culturels sur Lingoano.",
                "tr-did-you-know": "Grâce à sa structure agglutinante, le turc peut former des phrases complètes en un seul mot, comme \"Çekoslovakyalılaştıramadıklarımızdan mısınız?\", qui signifie \"Êtes-vous l'un de ceux que nous n'avons pas pu rendre tchécoslovaques ?\"",
                
                // Ressources Académiques
                "academic-sources-title": "Akademik Kaynaklar",
                "cefr-guidelines-title": "CEFR Rehberleri",
                "cefr-guidelines-desc": "Avrupa Dilleri Ortak Başvuru Metni (CEFR)",
                "second-language-acquisition-title": "İkinci Dil Edinimi",
                "second-language-acquisition-desc": "Cambridge SLA ders kitapları",
                "corpora-title": "Dil Derlemleri",
                "corpora-desc": "COCA/BNC gibi derlem kaynakları",
                "peer-reviewed-title": "Hakemli Çalışmalar",
                "peer-reviewed-desc": "Google Scholar literatür taraması",
        
                // Guide Russe (en Français)
                "ru-intro-title": "Introduction au russe : Une langue riche et expressive",
                "ru-intro-p": "Appartenant à la branche slave, le russe a un caractère unique avec son alphabet cyrillique. Comme l'allemand, il a une grammaire complexe basée sur les cas des noms (6 падежи). Cette structure permet un ordre des mots très flexible, où l'accent et l'intonation jouent un rôle majeur. La distinction d'aspect dans les verbes ajoute une subtilité incroyable. Apprendre le russe est l'occasion de toucher aux œuvres de Dostoïevski et de Tolstoï dans leur langue originale.",
                "ru-grammar-analysis-title": "Analyse de la grammaire russe",
                "ru-cyrillic-title": "L'alphabet cyrillique",
                "ru-cyrillic-exp": "<b>Structure :</b> Il se compose de 33 lettres. Certaines lettres ressemblent aux lettres latines (А, К, М, О, Т), d'autres se ressemblent mais se prononcent différemment (В 'v', Н 'n', Р 'r'), et certaines sont entièrement nouvelles (Ж 'j', Ц 'ts', Я 'ya').",
                "ru-cases-title": "Cas des noms (Падежи)",
                "ru-cases-exp": "<b>Fonction :</b> Le russe a 6 cas qui déterminent le rôle d'un mot en changeant sa terminaison.<br><b>Exemple :</b> \"книга\" (livre) -> \"Я читаю <b>книгу</b>\" (cas accusatif).",
                "ru-verb-aspect-title": "Aspect verbal (Вид)",
                "ru-verb-aspect-exp": "<b>Règle :</b> La plupart des verbes existent sous deux formes :<br><b>Imperfectif (Несовершенный) :</b> Indique le processus ou la répétition d'une action.<br><b>Perfectif (Совершенный) :</b> Indique l'achèvement d'une action.",
                "ru-gender-system-title": "Système de genre",
                "ru-gender-system-exp": "<b>Règle :</b> Il y a 3 genres : Masculin (se termine par une consonne/-й), Féminin (-а/-я), et Neutre (-о/-е). Les adjectifs et les verbes au passé changent en fonction du genre du nom.",
                "ru-motion-verbs-title": "Verbes de mouvement",
                "ru-motion-verbs-exp": "<b>Règle :</b> Ils sont divisés en deux types : Unidirectionnels (идти - aller à pied) et Multidirectionnels/habituels (ходить - marcher à pied).",
                "ru-genitive-negation-title": "Cas génitif pour la négation",
                "ru-genitive-negation-exp": "<b>Règle :</b> Pour exprimer l'absence de quelque chose, on utilise le mot \"нет\" suivi du nom au cas génitif.",
                "ru-stress-system-title": "Système d'accentuation",
                "ru-stress-system-exp": "<b>Importance :</b> L'accent est très important en russe. Le même mot peut avoir des significations différentes avec des accents différents.",
                "ru-stress-system-attn": "<b>Note :</b> Si l'accent est mal placé, le mot peut devenir incompréhensible.",
                "ru-adjective-declension-title": "Déclinaison des adjectifs",
                "ru-adjective-declension-exp": "<b>Règle :</b> Les adjectifs changent en fonction du genre, du nombre et du cas du nom qu'ils modifient.",
                "ru-future-tense-ru-title": "Temps futur",
                "ru-future-tense-ru-exp": "<b>Structure :</b> быть (être) + infinitif. Le verbe быть est conjugué.",
                "ru-imperative-title": "Mode impératif",
                "ru-imperative-exp": "<b>Structure :</b> Racine du verbe + terminaison impérative. Utilisé pour les ordres, les demandes et les conseils.",
                "ru-reflexive-verbs-ru-title": "Verbes réfléchis",
                "ru-reflexive-verbs-ru-exp": "<b>Structure :</b> Verbe + -ся/-сь. Utilisé lorsque le sujet et l'objet de l'action sont les mêmes.",
                "ru-learning-tips-title": "Conseils pour apprendre le russe",
                "ru-5-strategies-title": "5 stratégies pour réussir à apprendre le russe",
                "ru-tip-1": "<b>L'alphabet cyrillique :</b> Concentrez-vous sur l'alphabet la première semaine. Commencez avec des mots simples comme \"Привет\".",
                "ru-tip-2": "<b>Système d'accentuation :</b> Faites attention à l'endroit où tombe l'accent. Un accent incorrect peut rendre un mot inintelligible.",
                "ru-tip-3": "<b>Cas des noms :</b> Apprenez le système des 6 cas avec des exemples quotidiens.",
                "ru-tip-4": "<b>Aspect verbal :</b> Comprenez la distinction entre l'imperfectif (processus) et le perfectif (résultat).",
                "ru-tip-5": "<b>Culture russe :</b> Suivez des films et de la musique russes. Les dessins animés utilisent souvent un langage plus simple.",
                "ru-tip-6": "<b>💬 Pratique de la conversation :</b> Utilisez le chat en russe de Lingoano pour pratiquer l'alphabet cyrillique et le système d'accentuation.",
                "ru-learning-strategies-title": "Stratégies d'apprentissage du russe",
                "ru-tactic-1": "<b>Alphabet cyrillique et sons de base :</b> Concentrez-vous sur l'alphabet la première semaine. Pratiquez ces mots dans des conversations réelles sur le chat russe de Lingoano.",
                "ru-tactic-2": "<b>Système d'accentuation et prononciation :</b> Faites attention à l'endroit où tombe l'accent. Améliorez votre prononciation avec la fonction de chat vocal de Lingoano.",
                "ru-tactic-3": "<b>Apprentissage des cas (Падежи) :</b> Apprenez le système des 6 cas avec des exemples quotidiens. Testez ces structures dans des conversations réelles sur Lingoano.",
                "ru-tactic-4": "<b>Aspect verbal (Вид) et temps :</b> Comprenez la distinction entre l'imperfectif et le perfectif. Appliquez cette distinction dans les salons de discussion russes de Lingoano.",
                "ru-tactic-5": "<b>Culture et matériaux authentiques :</b> Suivez des films et de la musique russes. Apprenez la langue en discutant de sujets culturels sur le chat de Lingoano.",
                "ru-did-you-know": "Le russe est l'une des rares langues au monde à avoir des consonnes \"dures\" et \"douces\". La différence, souvent indiquée par les signes dur (ъ) et doux (ь), peut changer complètement le sens d'un mot, ce qui en fait un aspect crucial de la prononciation."
            },
            ru: {
                // Общее
                "learning-tactics-title": "Тактики обучения",
                "culture-note-title": "💡 Язык и культура: заметка",
        
                // Руководство по английскому (на русском)
                "en-intro-title": "Введение в английский: мировой язык",
                "en-intro-p": "Принадлежащий к германской ветви индоевропейской языковой семьи, английский является лингва-франка глобального общения. Его аналитическая структура, где функция слов определяется порядком слов и вспомогательными словами, а не суффиксами, отличает его от многих других языков. В этом путешествии вы откроете для себя гибкую и логичную структуру английского.",
                "en-grammar-analysis-title": "Анализ английской грамматики",
                "en-articles-title": "Артикли (a/an, the)",
                "en-articles-exp": "<b>a/an:</b> Используется для общего объекта. <b>the:</b> Используется для конкретного, уже упомянутого объекта.",
                "en-present-simple-title": "Present Simple (Простое настоящее)",
                "en-present-simple-exp": "<b>Использование:</b> Общие истины, привычки. Глагол принимает окончание \"-s\" с He/She/It.",
                "en-past-simple-title": "Past Simple (Простое прошедшее)",
                "en-past-simple-exp": "<b>Использование:</b> Завершенные действия в прошлом. Правильные глаголы принимают \"-ed\"; неправильные изменяются (V2).",
                "en-past-simple-attn": "<b>Примечание:</b> В отрицаниях и вопросах с `did` глагол возвращается в базовую форму.",
                "en-present-perfect-title": "Present Perfect (Настоящее совершенное)",
                "en-present-perfect-exp": "<b>Использование:</b> Действия, начавшиеся в прошлом и имеющие эффект сейчас, или произошедшие в неопределенное время. Структура: have/has + V3.",
                "en-modal-verbs-title": "Модальные глаголы",
                "en-modal-verbs-exp": "<b>Функция:</b> Добавляют значения способности (can), возможности (may), необходимости (must) и совета (should).",
                "en-gerunds-infinitives-title": "Герундий и инфинитив",
                "en-gerunds-infinitives-exp": "<b>Герундий (V-ing):</b> Используется как существительное после определенных глаголов.<br><b>Инфинитив (to V):</b> Используется для выражения цели после определенных глаголов.",
                "en-conditionals-title": "Условные предложения",
                "en-conditionals-exp": "<b>Zero Conditional:</b> Общие истины (If + Present, Present).<br><b>First Conditional:</b> Возможное будущее (If + Present, will + V).<br><b>Second Conditional:</b> Воображаемые ситуации (If + Past, would + V).",
                "en-passive-voice-title": "Страдательный залог",
                "en-passive-voice-exp": "<b>Структура:</b> be + V3. Используется, когда исполнитель действия неизвестен или неважен.",
                "en-reported-speech-title": "Косвенная речь",
                "en-reported-speech-exp": "<b>Правило:</b> При передаче чужих слов время глагола сдвигается назад. Present → Past, Past → Past Perfect.",
                "en-relative-clauses-title": "Относительные придаточные предложения",
                "en-relative-clauses-exp": "<b>Определительные:</b> Дают важную информацию, без запятых.<br><b>Распространительные:</b> Дают дополнительную информацию, выделяются запятыми.",
                "en-learning-tips-title": "Советы по изучению английского",
                "en-5-golden-rules-title": "5 золотых правил успешного изучения английского",
                "en-tip-1": "<b>Ежедневная практика:</b> Занимайтесь английским не менее 30 минут каждый день. Постоянство эффективнее интенсивных занятий.",
                "en-tip-2": "<b>Разнообразные источники:</b> Используйте не только учебники, но и аутентичные материалы, такие как фильмы и музыка.",
                "en-tip-3": "<b>Не бойтесь ошибок:</b> Ошибки — естественная часть обучения. Старайтесь говорить, а не быть идеальным.",
                "en-tip-4": "<b>Учите в контексте:</b> Учите слова в предложениях, а не списками. Это укрепляет и значение, и употребление.",
                "en-tip-5": "<b>Культурный контекст:</b> Изучайте английский не просто как язык, а как часть культуры.",
                "en-tip-6": "<b>💬 Практика разговора:</b> Используйте английский чат Lingoano для практики в реальном времени.",
                "en-learning-strategies-title": "Стратегии изучения английского",
                "en-tactic-1": "<b>Стратегия словарного запаса:</b> Учите слова в контексте. Практикуйте новую лексику в реальных разговорах в английском чате Lingoano.",
                "en-tactic-2": "<b>Грамматический подход:</b> Изучайте правила с практическими предложениями. Для каждого нового правила составляйте не менее 5 предложений.",
                "en-tactic-3": "<b>Аудирование и произношение:</b> Слушайте разные акценты. Улучшайте произношение с помощью функции голосового чата Lingoano.",
                "en-tactic-4": "<b>Разговорная практика:</b> Активно практикуйте речь. Обсуждайте ежедневные темы, задавайте вопросы и отвечайте в чатах Lingoano.",
                "en-tactic-5": "<b>Культурный контекст:</b> Следите за новостями, блогами и соцсетями на английском. Повышайте свою культурную осведомленность, общаясь на эти темы в Lingoano.",
                "en-did-you-know": "В английском языке существуют тысячи фразовых глаголов, которые составляют основу повседневного общения. Их изучение — ключ к пониманию носителей языка.",
        
                // Руководство по немецкому (на русском)
                "de-intro-title": "Введение в немецкий: язык логики и структуры",
                "de-intro-p": "Как и английский, немецкий принадлежит к германской языковой семье и выделяется своей логичной и основанной на правилах структурой. Такие особенности, как падежи существительных (Kasus) и положение глаголов, придают ему инженерную точность. Изучение немецкого не только открывает новые возможности для общения, но и развивает аналитическое мышление.",
                "de-grammar-analysis-title": "Анализ немецкой грамматики",
                "de-artikel-title": "Артикли и род",
                "de-artikel-exp": "<b>Правило:</b> Каждое существительное имеет род: <b>der</b> (мужской), <b>die</b> (женский), <b>das</b> (средний). Его нужно запоминать вместе со словом.",
                "de-artikel-attn": "<b>Примечание:</b> То, что \"das Mädchen\" (девочка) среднего рода, подчеркивает важность грамматического рода.",
                "de-kasus-title": "Падежи (Kasus)",
                "de-kasus-exp": "Указывает на функцию существительного и изменяет его артикль.<br><b>Nominativ:</b> Подлежащее - <b>Der Hund</b> ist klein.<br><b>Akkusativ:</b> Прямое дополнение - Ich sehe <b>den Hund</b>.<br><b>Dativ:</b> Косвенное дополнение - Ich gebe <b>dem Hund</b> Wasser.",
                "de-satzbau-title": "Структура предложения (Satzbau)",
                "de-satzbau-exp": "<b>Основное правило (V2):</b> В главных предложениях спрягаемый глагол <b>всегда стоит на втором месте.</b>",
                "de-perfekt-title": "Прошедшее время (Perfekt)",
                "de-perfekt-exp": "<b>Использование:</b> Самое распространенное прошедшее время в разговорной речи. Структура: haben/sein + Partizip II.",
                "de-trennbare-verben-title": "Отделяемые глаголы",
                "de-trennbare-verben-exp": "<b>Структура:</b> Приставка глаголов типа \"anrufen\" (звонить) ставится в конец главного предложения.",
                "de-praepositionen-title": "Предлоги",
                "de-praepositionen-exp": "В немецком языке предлоги определяют падеж (Akkusativ или Dativ) следующего за ним существительного.<br><b>Akkusativ:</b> für, durch, gegen...<br><b>Dativ:</b> mit, nach, von, zu...",
                "de-konjunktiv-title": "Сослагательное наклонение II (Konjunktiv II)",
                "de-konjunktiv-exp": "<b>Использование:</b> Для гипотетических ситуаций, вежливых просьб и не произошедших в прошлом событий.",
                "de-relativsaetze-title": "Относительные придаточные предложения",
                "de-relativsaetze-exp": "<b>Структура:</b> Придаточные предложения, описывающие существительные. Используются относительные местоимения (der, die, das, denen).",
                "de-passiv-title": "Страдательный залог",
                "de-passiv-exp": "<b>Структура:</b> werden + Partizip II. Используется, когда исполнитель действия неважен.",
                "de-infinitiv-zu-title": "Инфинитив с 'zu'",
                "de-infinitiv-zu-exp": "<b>Использование:</b> Используется после определенных глаголов для указания цели. \"zu\" + инфинитив.",
                "de-learning-tips-title": "Советы по изучению немецкого",
                "de-5-strategies-title": "5 стратегий для успешного изучения немецкого",
                "de-tip-1": "<b>Запоминание артиклей:</b> Учите каждое существительное с его артиклем. Используйте цветные карточки для визуализации родов.",
                "de-tip-2": "<b>Падежная система:</b> Практикуйте падежи на примерах из реальной жизни.",
                "de-tip-3": "<b>Спряжение глаголов:</b> Ритмично повторяйте правильные глаголы. Это станет автоматическим.",
                "de-tip-4": "<b>Сложные слова:</b> Разбирайте длинные слова на компоненты. \"Handschuh\" = Hand + Schuh.",
                "de-tip-5": "<b>Немецкая культура:</b> Смотрите немецкие фильмы и слушайте музыку для изучения в контексте.",
                "de-tip-6": "<b>💬 Практика разговора:</b> Используйте немецкий чат Lingoano для практики грамматических правил.",
                "de-learning-strategies-title": "Стратегии изучения немецкого",
                "de-tactic-1": "<b>Система артиклей и рода:</b> Учите каждое новое слово с его артиклем. Естественно учите артикли, используя их в немецком чате Lingoano.",
                "de-tactic-2": "<b>Изучение падежей:</b> Практикуйте падежи на повседневных примерах. Проверяйте эти конструкции в реальных разговорах на Lingoano.",
                "de-tactic-3": "<b>Спряжение и синтаксис:</b> Повторяйте правильные спряжения. Практикуйте правило V2 с ежедневными предложениями. Автоматизируйте эти правила в чатах Lingoano.",
                "de-tactic-4": "<b>Сложные слова:</b> Разбирайте длинные слова. Закрепляйте их значения, используя их на Lingoano.",
                "de-tactic-5": "<b>Культура и аутентичные материалы:</b> Смотрите немецкие фильмы. Учитесь, обсуждая культурные темы в немецком чате Lingoano.",
                "de-did-you-know": "Способность немецкого языка образовывать сложные слова (Komposita) знаменита. От \"Handschuh\" (перчатка) до очень длинных слов в юридических текстах, это показывает, насколько модульным может быть язык.",
        
                // Руководство по испанскому (на русском)
                "es-intro-title": "Введение в испанский: язык мелодии и эмоций",
                "es-intro-p": "Являясь членом романской ветви индоевропейской семьи, испанский — второй по распространенности родной язык в мире. Его фонетическая природа и мелодичная интонация делают его изучение приятным. Язык включает философское различие между состоянием и сущностью с двумя разными глаголами «быть» (ser и estar), демонстрируя свое богатство. Изучение испанского открывает двери не только в обширную географию, но и в сердце теплой культуры.",
                "es-grammar-analysis-title": "Анализ испанской грамматики",
                "es-ser-estar-title": "Разница между Ser и Estar",
                "es-ser-estar-exp": "<b>Ser:</b> Постоянные, неизменные качества. \"Yo <b>soy</b> profesor.\"<br><b>Estar:</b> Временные состояния и местоположения. \"Yo <b>estoy</b> cansado.\"",
                "es-ser-estar-attn": "<b>Примечание:</b> Это различие является основополагающим в испанском.",
                "es-gender-agreement-title": "Род и согласование",
                "es-gender-agreement-exp": "<b>Правило:</b> Существительные бывают мужского (-o) или женского (-a) рода. Прилагательные и артикли должны согласовываться в роде и числе.",
                "es-preterito-imperfecto-title": "Pretérito против Imperfecto",
                "es-preterito-imperfecto-exp": "Есть два основных прошедших времени.<br><b>Pretérito:</b> Для однократных, завершенных действий. \"Ayer <b>comí</b> paella.\"<br><b>Imperfecto:</b> Для прошлых привычек или описаний. \"Cuando era niño, <b>jugaba</b> al fútbol.\"",
                "es-por-para-title": "Разница между Por и Para",
                "es-por-para-exp": "Оба могут означать «для», но используются по-разному.<br><b>Por:</b> Причина, повод, средство.<br><b>Para:</b> Цель, предназначение, получатель.",
                "es-subjuntivo-title": "Сослагательное наклонение (Subjuntivo)",
                "es-subjuntivo-exp": "<b>Функция:</b> Специальное наклонение глагола для выражения субъективных чувств, желаний, сомнений.",
                "es-punctuation-title": "Перевернутые вопросительные/восклицательные знаки",
                "es-punctuation-exp": "<b>Функция:</b> Знаки (¿) и (¡) ставятся как в начале, так и в конце предложения.",
                "es-reflexive-verbs-title": "Возвратные глаголы",
                "es-reflexive-verbs-exp": "<b>Структура:</b> Глагол + se. Используется, когда субъект и объект действия — одно и то же лицо.",
                "es-object-pronouns-title": "Прямые/косвенные дополнения",
                "es-object-pronouns-exp": "<b>Прямое дополнение:</b> Объект, на который направлено действие (lo, la, los, las).<br><b>Косвенное дополнение:</b> Объект, косвенно затронутый действием (le, les).",
                "es-future-tense-title": "Будущее время",
                "es-future-tense-exp": "<b>Структура:</b> Инфинитив + окончание. Используется для будущих действий.",
                "es-conditional-tense-title": "Условное наклонение",
                "es-conditional-tense-exp": "<b>Структура:</b> Инфинитив + условное окончание. Для вежливых просьб и гипотетических ситуаций.",
                "es-learning-tips-title": "Советы по изучению испанского",
                "es-5-strategies-title": "5 стратегий для успешного изучения испанского",
                "es-tip-1": "<b>Ser против Estar:</b> Практикуйте эти два глагола на повседневных примерах.",
                "es-tip-2": "<b>Практика произношения:</b> Регулярно практикуйте звуки \"rr\", \"ñ\" и \"j\".",
                "es-tip-3": "<b>Спряжение глаголов:</b> Запомните спряжения правильных глаголов в настоящем времени.",
                "es-tip-4": "<b>Латинская культура:</b> Следите за музыкой и фильмами испаноязычных стран.",
                "es-tip-5": "<b>Ежедневное общение:</b> Используйте базовые фразы, такие как \"¿Cómo estás?\" и \"Mucho gusto\".",
                "es-tip-6": "<b>💬 Практика разговора:</b> Используйте испанский чат Lingoano для практики сложных правил, таких как \"Ser\" и \"Estar\".",
                "es-learning-strategies-title": "Стратегии изучения испанского",
                "es-tactic-1": "<b>Различие Ser vs. Estar:</b> Практикуйте эти глаголы на повседневных примерах. Проверьте это различие в реальных разговорах в испанском чате Lingoano.",
                "es-tactic-2": "<b>Произношение и звуковая система:</b> Регулярно практикуйте звуки «rr», «ñ» и «j». Улучшайте произношение с помощью функции голосового чата Lingoano.",
                "es-tactic-3": "<b>Спряжения и времена:</b> Запомните спряжения в настоящем времени. Поймите разницу между Pretérito и Imperfecto. Составляйте предложения, используя эти времена на Lingoano.",
                "es-tactic-4": "<b>Культура и аутентичные материалы:</b> Следите за музыкой и фильмами испаноязычных стран. Изучайте язык, обсуждая культурные темы в чатах Lingoano.",
                "es-tactic-5": "<b>Ежедневное общение:</b> Используйте базовые фразы, такие как «¿Cómo estás?». Закрепляйте их, общаясь на Lingoano.",
                "es-did-you-know": "Различие между \"ser\" и \"estar\", оба переводятся как \"to be\" на английском, является центральной чертой испанского языка, которая позволяет достичь уровня описательной точности о природе вещей (постоянной против временной), которого нет во многих других языках.",
        
                // Руководство по французскому (на русском)
                "fr-intro-title": "Введение во французский: язык элегантности и правил",
                "fr-intro-p": "Французский — это романский язык, известный как язык дипломатии, моды и искусства. Он обладает уникальной музыкальностью благодаря носовым гласным и фонетическим правилам, таким как \"liaison\". Грамматические правила строго структурированы, а спряжения глаголов занимают центральное место. Изучение французского — это путешествие в историю мировой культуры.",
                "fr-grammar-analysis-title": "Анализ французской грамматики",
                "fr-etre-avoir-title": "Être и Avoir",
                "fr-etre-avoir-exp": "Эти два неправильных глагола — основа французского. \"Être\" (быть) и \"Avoir\" (иметь) также используются как вспомогательные для образования passé composé.",
                "fr-negation-title": "Отрицание: Ne... pas",
                "fr-negation-exp": "<b>Структура:</b> Во французском отрицание образуется путем постановки \"ne\" и \"pas\" вокруг глагола.",
                "fr-negation-attn": "<b>Примечание:</b> В разговорной речи \"ne\" часто опускается, но в письменной обязательно.",
                "fr-passe-compose-title": "Passé Composé",
                "fr-passe-compose-exp": "<b>Использование:</b> Самое распространенное прошедшее время в разговорной речи. Структура: avoir/être + причастие прошедшего времени.<br><b>Использование Être:</b> Обычно с глаголами движения и изменения состояния.",
                "fr-partitifs-title": "Частичные артикли",
                "fr-partitifs-exp": "<b>Функция:</b> Используются для обозначения неопределенного количества неисчисляемого существительного.<br><b>du</b> (мужской), <b>de la</b> (женский), <b>de l'</b> (гласный), <b>des</b> (множественное число).",
                "fr-y-en-pronouns-title": "Местоимения 'Y' и 'En'",
                "fr-y-en-pronouns-exp": "<b>Y:</b> Обычно заменяет \"à + место\" или \"à + вещь\".<br><b>En:</b> Обычно заменяет \"de + вещь\" или количество.",
                "fr-liaison-title": "Связывание (Liaison)",
                "fr-liaison-exp": "<b>Правило:</b> Слово, оканчивающееся на непроизносимый согласный, произносится путем связывания его со следующим словом, начинающимся с гласного. Это придает языку плавность.",
                "fr-subjonctif-title": "Сослагательное наклонение (Subjonctif)",
                "fr-subjonctif-exp": "<b>Использование:</b> Для выражения субъективных чувств, желаний и сомнений. Часто встречается в придаточных, начинающихся с \"que\".",
                "fr-imparfait-title": "Imparfait (Незавершенное)",
                "fr-imparfait-exp": "<b>Использование:</b> Для прошлых привычек, длительных ситуаций и фоновых описаний.",
                "fr-futur-simple-title": "Futur Simple (Простое будущее)",
                "fr-futur-simple-exp": "<b>Структура:</b> Инфинитив + будущее окончание (-ai, -as, -a, -ons, -ez, -ont).",
                "fr-conditionnel-title": "Conditionnel Présent (Настоящее условное)",
                "fr-conditionnel-exp": "<b>Структура:</b> Основа будущего времени + окончание imparfait. Для вежливых просьб и гипотетических ситуаций.",
                "fr-learning-tips-title": "Советы по изучению французского",
                "fr-5-strategies-title": "5 стратегий для успешного изучения французского",
                "fr-tip-1": "<b>Носовые звуки:</b> Регулярно практикуйте носовые звуки, такие как \"en\", \"on\", \"un\".",
                "fr-tip-2": "<b>Правила связывания:</b> Изучайте и применяйте правила связывания. Например, \"Vous avez\" → \"ву-з-аве\".",
                "fr-tip-3": "<b>Спряжение глаголов:</b> Запомните спряжения правильных глаголов на \"-er\".",
                "fr-tip-4": "<b>Французская культура:</b> Смотрите французские фильмы и слушайте музыку. Слушайте музыку в стиле \"шансон\".",
                "fr-tip-5": "<b>Ежедневные выражения:</b> Используйте базовые выражения, такие как \"Bonjour\", \"Au revoir\" и \"S'il vous plaît\".",
                "fr-tip-6": "<b>💬 Практика разговора:</b> Используйте французский чат Lingoano для практики носовых звуков и правил связывания.",
                "fr-learning-strategies-title": "Стратегии изучения французского",
                "fr-tactic-1": "<b>Носовые звуки и произношение:</b> Регулярно практикуйте носовые звуки. Практикуйте их в реальных разговорах во французском чате Lingoano.",
                "fr-tactic-2": "<b>Правила связывания и беглость:</b> Изучайте и применяйте правила связывания. Применяйте их в естественной речи с помощью функции голосового чата Lingoano.",
                "fr-tactic-3": "<b>Спряжения и времена:</b> Запомните спряжения глаголов на «-er». Поймите разницу между Passé Composé и Imparfait.",
                "fr-tactic-4": "<b>Культура и аутентичные материалы:</b> Смотрите французские фильмы. Изучайте язык, обсуждая культурные темы в чатах Lingoano.",
                "fr-tactic-5": "<b>Ежедневное общение:</b> Используйте базовые выражения, такие как «Bonjour». Закрепляйте их, общаясь на Lingoano.",
                "fr-did-you-know": "Французский язык, на котором говорят в Квебеке (Канада), имеет заметные различия в произношении, лексике и идиомах по сравнению с французским языком Франции, что делает его ярким и уникальным диалектом.",
        
                // Руководство по турецкому (на русском)
                "tr-intro-title": "Введение в турецкий: агглютинативный и гармоничный язык",
                "tr-intro-p": "Принадлежащий к алтайской ветви, турецкий отличается своей агглютинативной структурой. Это означает, что суффиксы последовательно добавляются к корню слова. Такие правила, как гармония гласных, придают ему фонетический ритм. Изучение турецкого — это открытие искусства создания новых значений путем комбинирования слов, как кубиков лего.",
                "tr-grammar-analysis-title": "Анализ турецкой грамматики",
                "tr-vowel-harmony-title": "Гармония гласных",
                "tr-vowel-harmony-exp": "<b>Функция:</b> Это основное звуковое правило турецкого языка. Гласный в суффиксе определяется последним гласным в слове.",
                "tr-agglutination-title": "Агглютинативная структура",
                "tr-agglutination-exp": "<b>Правило:</b> Словообразовательные суффиксы (изменяющие значение) идут первыми, за ними следуют словоизменительные (указывающие на функцию).",
                "tr-sov-structure-title": "Структура предложения (SOV)",
                "tr-sov-structure-exp": "<b>Структура:</b> Основной порядок слов в турецком — <b>Подлежащее-Дополнение-Сказуемое</b>. Глагол обычно стоит в конце.",
                "tr-sov-structure-attn": "<b>Сравнение:</b> В английском это предложение было бы \"I read a book yesterday\" (SVO).",
                "tr-noun-compounds-title": "Именные словосочетания",
                "tr-noun-compounds-exp": "<b>Структура:</b> Два существительных объединяются, образуя новое понятие.<br><b>Определенное:</b> И обладатель (-in), и обладаемое (-i) принимают суффиксы.<br><b>Неопределенное:</b> Только обладаемое (-i) принимает суффикс.",
                "tr-verbals-title": "Нефинитные формы глагола (Fiilimsiler)",
                "tr-verbals-exp": "<b>Функция:</b> Слова, производные от глагольных основ, которые функционируют как существительные, прилагательные или наречия.",
                "tr-var-yok-title": "\"Var\" и \"Yok\"",
                "tr-var-yok-exp": "<b>Использование:</b> Используются для выражения обладания вместо \"иметь\". Указывают на наличие или отсутствие чего-либо.",
                "tr-tense-suffixes-title": "Временные суффиксы",
                "tr-tense-suffixes-exp": "<b>Настоящее длительное:</b> Образуется с помощью суффикса -iyor.<br><b>Прошедшее:</b> Образуется с помощью суффикса -di/-dı.<br><b>Будущее:</b> Образуется с помощью суффикса -ecek/-acak.",
                "tr-plural-suffix-title": "Суффикс множественного числа",
                "tr-plural-suffix-exp": "<b>Правило:</b> Существительные ставятся во множественное число путем добавления суффикса -ler/-lar, в соответствии с гармонией гласных.",
                "tr-case-suffixes-title": "Падежные суффиксы",
                "tr-case-suffixes-exp": "<b>Дательный (-e/-a):</b> \"Eve gidiyorum\" (к дому)<br><b>Местный (-de/-da):</b> \"Evde oturuyorum\" (в доме)<br><b>Исходный (-den/-dan):</b> \"Evden çıkıyorum\" (из дома)<br><b>Винительный (-i/-ı):</b> \"Kitabı okuyorum\" (книгу)",
                "tr-adjectives-title": "Прилагательные",
                "tr-adjectives-exp": "<b>Структура:</b> В турецком прилагательные не склоняются.<br><b>Сравнение:</b> Образуется с помощью -daha (более), -en (самый).",
                "tr-learning-tips-title": "Советы по изучению турецкого",
                "tr-5-strategies-title": "5 стратегий для успешного изучения турецкого",
                "tr-tip-1": "<b>Система суффиксов:</b> Поймите агглютинативную природу турецкого.",
                "tr-tip-2": "<b>Гармония гласных:</b> Хорошо изучите это правило. Оно фундаментально.",
                "tr-tip-3": "<b>Структура предложения:</b> Глагол стоит в конце. Привыкните к этому.",
                "tr-tip-4": "<b>Ежедневное общение:</b> Часто используйте базовые фразы, такие как \"Merhaba\" и \"Nasılsın?\".",
                "tr-tip-5": "<b>Турецкая культура:</b> Смотрите турецкие фильмы и слушайте музыку для изучения в контексте.",
                "tr-tip-6": "<b>💬 Практика разговора:</b> Используйте турецкий чат Lingoano для практики системы суффиксов и гармонии гласных.",
                "tr-learning-strategies-title": "Стратегии изучения турецкого",
                "tr-tactic-1": "<b>Система суффиксов и структура слова:</b> Поймите агглютинативную природу турецкого. Практикуйте эти суффиксы в реальных разговорах в турецком чате Lingoano.",
                "tr-tactic-2": "<b>Гармония гласных и звуковые правила:</b> Хорошо изучите это правило. Применяйте его при образовании новых слов на Lingoano.",
                "tr-tactic-3": "<b>Синтаксис и структура предложения:</b> Глагол стоит в конце. Применяйте эту структуру в естественной речи в турецких чатах Lingoano.",
                "tr-tactic-4": "<b>Ежедневное общение:</b> Часто используйте базовые фразы, такие как «Merhaba». Закрепляйте их, общаясь на Lingoano.",
                "tr-tactic-5": "<b>Культура и аутентичные материалы:</b> Смотрите турецкие фильмы. Изучайте язык, обсуждая культурные темы на Lingoano.",
                "tr-did-you-know": "Благодаря своей агглютинативной структуре, турецкий язык может формировать целые предложения в одном слове, например, \"Çekoslovakyalılaştıramadıklarımızdan mısınız?\", что означает \"Вы один из тех, кого мы не смогли сделать чехословаками?\"",
                
                // Руководство по русскому (на русском)
                "ru-intro-title": "Введение в русский язык: Богатый и выразительный язык",
                "ru-intro-p": "Принадлежащий к славянской ветви индоевропейской семьи, русский язык обладает уникальным характером благодаря своему кириллическому алфавиту и богатой фонетической системе. Подобно немецкому, он имеет сложную грамматику, основанную на падежах существительных (6 падежей). Эта структура допускает очень гибкий порядок слов, где ударение и интонация играют важную роль в значении. Различие в видах глаголов (совершенный и несовершенный) добавляет невероятную тонкость, указывая, завершено ли действие или оно находится в процессе. Изучение русского языка — это возможность прикоснуться к произведениям Достоевского и Толстого на их родном языке и исследовать глубокое культурное наследие.",
                "ru-grammar-analysis-title": "Анализ русской грамматики",
                "ru-cyrillic-title": "Кириллический алфавит",
                "ru-cyrillic-exp": "<b>Структура:</b> Состоит из 33 букв. Некоторые буквы похожи на латинские (А, К, М, О, Т), некоторые выглядят похоже, но звучат иначе (В 'в', Н 'н', Р 'р'), а некоторые совершенно новые (Ж 'ж', Ц 'ц', Я 'я').",
                "ru-cases-title": "Падежи существительных",
                "ru-cases-exp": "<b>Функция:</b> В русском языке 6 падежей, которые определяют роль слова в предложении, изменяя его окончание.<br><b>Пример:</b> \"книга\" -> \"Я читаю <b>книгу</b>\" (винительный падеж).",
                "ru-verb-aspect-title": "Вид глагола",
                "ru-verb-aspect-exp": "<b>Правило:</b> Большинство глаголов имеют две формы:<br><b>Несовершенный вид:</b> Указывает на процесс или повторение действия. (читать - читать в процессе)<br><b>Совершенный вид:</b> Указывает на завершение действия. (прочитать - прочитать до конца)",
                "ru-gender-system-title": "Род",
                "ru-gender-system-exp": "<b>Правило:</b> Существует 3 рода: Мужской (оканчивается на согласный/-й), Женский (-а/-я) и Средний (-о/-е). Прилагательные и глаголы в прошедшем времени изменяются в соответствии с родом существительного.",
                "ru-motion-verbs-title": "Глаголы движения",
                "ru-motion-verbs-exp": "<b>Правило:</b> В русском языке глаголы движения делятся на два типа: однонаправленные (идти - идти пешком в одном направлении) и разнонаправленные/обычные (ходить - ходить пешком, гулять).",
                "ru-genitive-negation-title": "Родительный падеж при отрицании",
                "ru-genitive-negation-exp": "<b>Правило:</b> Для выражения отсутствия чего-либо используется слово \"нет\", за которым следует существительное в родительном падеже.",
                "ru-stress-system-title": "Система ударения",
                "ru-stress-system-exp": "<b>Важность:</b> Ударение в русском языке очень важно. Одно и то же слово может иметь разные значения с разным ударением, которое обозначается знаком (´).",
                "ru-stress-system-attn": "<b>Примечание:</b> Если ударение стоит не на том слоге, слово может стать непонятным.",
                "ru-adjective-declension-title": "Склонение прилагательных",
                "ru-adjective-declension-exp": "<b>Правило:</b> Прилагательные изменяются в соответствии с родом, числом и падежом существительного, которое они определяют. У них есть мужская, женская, средняя и множественная формы.",
                "ru-future-tense-ru-title": "Будущее время",
                "ru-future-tense-ru-exp": "<b>Структура:</b> быть + инфинитив. Используется для действий в будущем. Глагол быть спрягается.",
                "ru-imperative-title": "Повелительное наклонение",
                "ru-imperative-exp": "<b>Структура:</b> Основа глагола + повелительное окончание. Используется для команд, просьб и советов.",
                "ru-reflexive-verbs-ru-title": "Возвратные глаголы",
                "ru-reflexive-verbs-ru-exp": "<b>Структура:</b> Глагол + -ся/-сь. Используется, когда субъект и объект действия совпадают.",
                "ru-learning-tips-title": "Советы по изучению русского языка",
                "ru-5-strategies-title": "5 стратегий для успешного изучения русского языка",
                "ru-tip-1": "<b>Кириллический алфавит:</b> В первую неделю сосредоточьтесь на алфавите. Практикуйтесь в написании и чтении каждой буквы. Начните с простых слов, таких как \"Привет\".",
                "ru-tip-2": "<b>Система ударения:</b> Обращайте внимание на то, куда падает ударение. Неправильное ударение может сделать слово непонятным.",
                "ru-tip-3": "<b>Падежи существительных:</b> Изучайте систему 6 падежей на повседневных примерах. Каждый день практикуйте склонение одного существительного в разных падежах.",
                "ru-tip-4": "<b>Вид глагола:</b> Поймите различие между несовершенным (процесс) и совершенным (результат). Это одна из важнейших особенностей русского языка.",
                "ru-tip-5": "<b>Русская культура:</b> Смотрите русские фильмы, слушайте музыку и следите за новостями. В мультфильмах часто используется более простой язык.",
                "ru-tip-6": "<b>💬 Практика разговора:</b> Используйте функцию русского чата в Lingoano для практики кириллического алфавита и системы ударения. Реальный разговор улучшает ваше русское произношение и навыки понимания.",
                "ru-learning-strategies-title": "Стратегии изучения русского языка",
                "ru-tactic-1": "<b>Кириллический алфавит и основные звуки:</b> В первую неделю сосредоточьтесь на алфавите. Практикуйте эти слова в реальном разговоре в русском чате Lingoano.",
                "ru-tactic-2": "<b>Система ударения и произношение:</b> Обращайте внимание на то, куда падает ударение. Улучшайте свое произношение с помощью функции голосового чата Lingoano и практикуйтесь с носителями русского языка.",
                "ru-tactic-3": "<b>Изучение падежей существительных:</b> Изучайте систему 6 падежей на повседневных примерах. Проверяйте эти конструкции в реальном разговоре на Lingoano.",
                "ru-tactic-4": "<b>Вид глагола и система времен:</b> Поймите различие между несовершенным (процесс) и совершенным (результат) видом. Применяйте это различие в русских чат-комнатах Lingoano.",
                "ru-tactic-5": "<b>Русская культура и аутентичные материалы:</b> Смотрите русские фильмы, слушайте музыку и следите за новостями. Изучайте язык в его естественном контексте, обсуждая эти культурные темы в русском чате Lingoano.",
                "ru-did-you-know": "Русский — один из немногих языков в мире, в котором есть «твёрдые» и «мягкие» согласные. Разница, часто обозначаемая твёрдым (ъ) и мягким (ь) знаками, может полностью изменить значение слова, что делает это важным аспектом произношения.",
                
                // Академические ресурсы
                "academic-sources-title": "Академические ресурсы",
                "cefr-guidelines-title": "Руководства CEFR",
                "cefr-guidelines-desc": "Общеевропейские компетенции владения иностранным языком (CEFR)",
                "second-language-acquisition-title": "Приобретение второго языка",
                "second-language-acquisition-desc": "Учебники Cambridge SLA",
                "corpora-title": "Языковые корпуса",
                "corpora-desc": "Источники корпусов, такие как COCA/BNC",
                "peer-reviewed-title": "Рецензируемые исследования",
                "peer-reviewed-desc": "Поиск литературы в Google Scholar"
            }
        
};

class RehberLanguageManager {
    constructor(globalTranslations = {}) {
        this.currentLanguage = localStorage.getItem('Lingoano-site-language') || null;
        this.globalTranslations = globalTranslations;
        this.allTranslations = {};
        this.init();
    }
    
    init() {
        // Merge global translations with page-specific translations
        this.mergeTranslations();
        
        if (this.currentLanguage) {
            // User has already selected a language, use it
            this.setLanguage(this.currentLanguage);
        } else {
            // No language selected, detect from IP
            this.detectLanguageFromIP();
        }
        this.bindEvents();
    }
    
    mergeTranslations() {
        // Start with global translations
        this.allTranslations = { ...this.globalTranslations };
        
        // Merge page-specific translations, overriding global ones if needed
        Object.keys(rehberPageTranslations).forEach(lang => {
            if (!this.allTranslations[lang]) {
                this.allTranslations[lang] = {};
            }
            this.allTranslations[lang] = { ...this.allTranslations[lang], ...rehberPageTranslations[lang] };
        });
        
        console.log('Translations merged successfully');
    }
    
    async detectLanguageFromIP() {
        // Show loading indicator
        this.showLanguageLoading();
        
        // Try multiple IP detection services for better reliability
        const services = [
            'https://ipapi.co/json/',
            'https://ipinfo.io/json',
            'https://api.ipify.org?format=json'
        ];
        
        for (const service of services) {
            try {
                const controller = new AbortController();
                const timeoutId = setTimeout(() => controller.abort(), 5000);
                
                const response = await fetch(service, { 
                    method: 'GET',
                    headers: { 'Accept': 'application/json' },
                    signal: controller.signal
                });
                
                clearTimeout(timeoutId);
                
                if (!response.ok) continue;
                
                const data = await response.json();
                
                // Handle different response formats
                let countryCode = null;
                if (data.country_code) {
                    countryCode = data.country_code.toLowerCase();
                } else if (data.country) {
                    countryCode = data.country.toLowerCase();
                }
                
                if (countryCode) {
                    const detectedLanguage = this.getLanguageFromCountry(countryCode);
                    
                    if (detectedLanguage) {
                        const countryName = data.country_name || data.country || countryCode;
                        console.log(`Detected language from IP: ${detectedLanguage} (Country: ${countryName})`);
                        this.hideLanguageLoading();
                        this.setLanguage(detectedLanguage);
                        return;
                    }
                }
            } catch (error) {
                console.log(`IP detection service ${service} failed:`, error.message);
                continue;
            }
        }
        
        // If all IP services fail, try browser language detection
        console.log('All IP detection services failed, trying browser language...');
        this.detectLanguageFromBrowser();
    }
    
    showLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'flex';
        }
    }
    
    hideLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'none';
        }
    }
    
    getLanguageFromCountry(countryCode) {
        // Map countries to supported languages
        const countryToLanguage = {
            // Turkish speaking countries
            'tr': 'tr',
            'cy': 'tr', // Northern Cyprus
            
            // English speaking countries
            'us': 'en', 'gb': 'en', 'ca': 'en', 'au': 'en', 'nz': 'en', 'ie': 'en',
            'za': 'en', 'in': 'en', 'pk': 'en', 'ng': 'en', 'ke': 'en', 'ug': 'en',
            'tz': 'en', 'gh': 'en', 'zm': 'en', 'zw': 'en', 'mw': 'en', 'bw': 'en',
            'sz': 'en', 'ls': 'en', 'na': 'en', 'mu': 'en', 'sc': 'en', 'mv': 'en',
            'lk': 'en', 'bd': 'en', 'np': 'en', 'bt': 'en', 'mm': 'en', 'kh': 'en',
            'la': 'en', 'vn': 'en', 'my': 'en', 'sg': 'en', 'bn': 'en', 'ph': 'en',
            'fj': 'en', 'pg': 'en', 'sb': 'en', 'vu': 'en', 'nc': 'en', 'pf': 'en',
            'to': 'en', 'ws': 'en', 'ki': 'en', 'tv': 'en', 'nr': 'en', 'pw': 'en',
            'mh': 'en', 'fm': 'en', 'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en',
            'jm': 'en', 'bb': 'en', 'gd': 'en', 'lc': 'en', 'vc': 'en', 'ag': 'en',
            'dm': 'en', 'kn': 'en', 'ai': 'en', 'vg': 'en', 'tc': 'en', 'ms': 'en',
            'ky': 'en', 'bm': 'en', 'fk': 'en', 'gi': 'en', 'sh': 'en', 'io': 'en',
            'pn': 'en', 'ck': 'en', 'nu': 'en', 'tk': 'en', 'wf': 'en', 'as': 'en',
            'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en', 'jm': 'en', 'bb': 'en',
            
            // German speaking countries
            'de': 'de', 'at': 'de', 'ch': 'de', 'li': 'de', 'lu': 'de',
            
            // French speaking countries
            'fr': 'fr', 'be': 'fr', 'mc': 'fr', 'ca': 'fr',

            // Spanish speaking countries
            'es': 'es', 'mx': 'es', 'ar': 'es', 'cl': 'es', 'pe': 'es', 'co': 'es', 'ec': 'es',
            'uy': 'es', 'py': 'es', 'bo': 'es', 've': 'es', 'do': 'es', 'cr': 'es', 'gt': 'es',
            'hn': 'es', 'ni': 'es', 'sv': 'es', 'pa': 'es', 'cu': 'es',
            
            // Russian speaking countries
            'ru': 'ru', 'by': 'ru', 'kz': 'ru', 'kg': 'ru', 'tj': 'ru',
            'uz': 'ru', 'tm': 'ru', 'md': 'ru', 'ge': 'ru', 'am': 'ru',
            'az': 'ru', 'ua': 'ru', 'ee': 'ru', 'lv': 'ru', 'lt': 'ru'
        };
        
        return countryToLanguage[countryCode] || null;
    }
    
    detectLanguageFromBrowser() {
        // Get browser language
        const browserLang = navigator.language || navigator.userLanguage;
        const langCode = browserLang.split('-')[0].toLowerCase();
        
        // Map browser language to supported languages
        const browserToLanguage = {
            'tr': 'tr',
            'en': 'en',
            'de': 'de',
            'fr': 'fr',
            'es': 'es',
            'ru': 'ru'
        };
        
        const detectedLanguage = browserToLanguage[langCode];
        
        if (detectedLanguage) {
            console.log(`Detected language from browser: ${detectedLanguage}`);
            this.hideLanguageLoading();
            this.setLanguage(detectedLanguage);
        } else {
            // Default to Turkish if no match found
            console.log('No language detected, defaulting to Turkish');
            this.hideLanguageLoading();
            this.setLanguage('tr');
        }
    }
    
    setLanguage(lang, saveToStorage = false) {
        if (!this.allTranslations[lang]) {
            console.warn(`Language ${lang} not found, falling back to Turkish`);
            lang = 'tr';
        }
        
        this.currentLanguage = lang;
        
        // Only save to localStorage if user manually selected
        if (saveToStorage) {
            localStorage.setItem('Lingoano-site-language', lang);
        }
        
        // Update language selectors
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.value = lang;
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.value = lang;
        }
        
        // Update all translatable elements
        this.updatePageContent();
    }
    
    getText(key) {
        return this.allTranslations[this.currentLanguage]?.[key] || this.allTranslations['tr']?.[key] || key;
    }
    
    updatePageContent() {
        // Update elements with data-lang attribute
        const elements = document.querySelectorAll('[data-lang]');
        elements.forEach(element => {
            const key = element.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                if (element.tagName === 'INPUT' && element.hasAttribute('placeholder')) {
                    element.placeholder = translation;
                } else if (element.hasAttribute('title')) {
                    element.title = translation;
                } else if (element.hasAttribute('aria-label')) {
                    element.setAttribute('aria-label', translation);
                } else if (element.hasAttribute('alt')) {
                    element.alt = translation;
                } else {
                    element.innerHTML = translation;
                }
            }
        });
        
        // Update form options
        this.updateFormOptions();
        
        // Update dictionary widget if it exists
        if (window.dictionaryWidget) {
            window.dictionaryWidget.updateLanguage();
        }
    }
    
    updateFormOptions() {
        // Update language form options
        const languageSelect = document.getElementById('language');
        if (languageSelect) {
            const options = languageSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = option.value;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update level form options
        const levelSelect = document.getElementById('level');
        if (levelSelect) {
            const options = levelSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = `level-${option.value.toLowerCase()}`;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update meta description for current language
        const metaDesc = document.querySelector('meta[name="description"]');
        if (metaDesc) {
            const currentLang = this.currentLanguage;
            // This could be expanded to have page-specific descriptions per language
        }
        
        // Update document title if it has data-lang
        const titleElement = document.querySelector('title[data-lang]');
        if (titleElement) {
            const key = titleElement.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                titleElement.textContent = translation;
            }
        }
    }
    
    bindEvents() {
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
    }
}

// Initialize language manager when DOM is loaded
let rehberLanguageManager;
document.addEventListener('DOMContentLoaded', () => {
    // Wait for global translations to be available
    if (window.translations) {
        rehberLanguageManager = new RehberLanguageManager(window.translations);
        // Make it globally available after initialization
        window.rehberLanguageManager = rehberLanguageManager;
    } else {
        console.warn('Global translations not available, initializing with empty translations');
        rehberLanguageManager = new RehberLanguageManager({});
        window.rehberLanguageManager = rehberLanguageManager;
    }
});

// Remove AdSense-related translation keys across all languages at runtime
(function removeAdKeys() {
    try {
        const keysToRemove = [
            'google-adsense',
            'google-adsense-content',
            'google-adsense-terms',
            'google-adsense-terms-content',
            'adsense-cookies',
            'adsense-privacy',
            'adsense-opt-out',
            'adsense-compliance'
        ];
        Object.keys(rehberPageTranslations || {}).forEach(lang => {
            const dict = rehberPageTranslations[lang];
            if (!dict) return;
            keysToRemove.forEach(k => { try { delete dict[k]; } catch (_) {} });
        });
    } catch (_) {}
})();

