// Lingoano Multilingual Translations
const translations = {
    fr: {
        "wod-streak-msg-1": "💔 Tu nous as quittés une fois, Igo est encore triste.",
        "wod-streak-msg-2": "🎉 Félicitations ! Igo est fier de ta première série.",
        "wod-streak-msg-3": "🏆🔥 Igo est fier de ta série, bravo !",
        "wod-streak-msg-3-special": "🤗🎉 Igo te pardonne et te félicite !",
        "change-wod-language": "Changer de langue",
         "decentralized-structure": "<strong style='color: var(--accent-color);'>Structure Décentralisée :</strong> <span style='color: var(--text-secondary);'>Vos données sont transmises sur un réseau distribué et ne sont pas collectées en un seul emplacement central.</span>",
        "censorship-resistance": "<strong style='color: var(--accent-color);'>Résistance à la Censure :</strong> <span style='color: var(--text-secondary);'>Aucune autorité ne peut bloquer notre plateforme ; elle reste accessible à tout moment.</span>",
        "full-anonymity": "<strong style='color: var(--accent-color);'>Anonymat Total :</strong> <span style='color: var(--text-secondary);'>Nous ne demandons aucune information personnelle ; vous n'êtes pas tenu de partager votre vrai nom.</span>",
        "minimal-data": "<strong style='color: var(--accent-color);'>Données Minimales :</strong> <span style='color: var(--text-secondary);'>Seules les informations nécessaires sont stockées ; nous ne collectons pas de données inutiles.</span>",
        "zero-record": "<strong style='color: var(--accent-color);'>Zéro Enregistrement :</strong> <span style='color: var(--text-secondary);'>Vos discussions ne sont stockées nulle part ; elles sont totalement temporaires.</span>",
        "default-theme": "Thème par défaut",
        "blue-theme": "Thème bleu",
        "purple-theme": "Thème violet",
        "green-theme": "Thème vert",
        "theme-switcher-label": "Sélecteur de thème",
        "menu-toggle-label": "Basculer le menu",
        "type-message": "Écrivez votre message...",
        "guess-input-placeholder": "Écrivez votre proposition...",
        "logo-alt": "Logo Lingoano",
        "github-visit": "Visiter le profil GitHub",
        "home-title": "Lingoano Web",
        "contact": "11. Contact",
        "contactfooter": "Contact",
        "contact-us": "Nous Contacter",
        "contact-info": "Informations de contact",
        "contact-email": "Email : iletisim@liguana.com",
        "contact-description": "Pour toute question, suggestion ou commentaire, vous pouvez nous contacter.",
        "contact-response": "Délai de réponse : sous 24 à 48 heures",
        "faq-q-free": "Lingoano est‑il gratuit ?",
        "faq-a-free": "Oui. Lingoano est entièrement gratuit ; vous ne payez pas pour discuter ou apprendre.",
        "faq-q-login": "Faut‑il un compte ou une connexion ?",
        "faq-a-login": "Non. Lingoano ne nécessite ni inscription ni connexion ; vous pouvez l’utiliser de façon anonyme.",
        "faq-title": "Questions fréquentes",
        "faq-q-p2p": "Comment les messages sont‑ils transmis sans passer par un serveur ?",
        "faq-a-p2p-content": "Par défaut, des protocoles pair‑à‑pair comme IPFS/WebRTC sont privilégiés. Ils permettent une transmission directe des messages entre pairs sans passer par un serveur. En essence, un réseau privé se forme entre adresses IP et les messages circulent sur ce réseau.",
        "faq-q-udp-vpn": "Comment un VPN basé sur l’UDP améliore‑t‑il la connectivité ?",
        "faq-a-udp-vpn-content": "La traversée NAT est souvent limitée par les opérateurs. Les VPN basés sur l’UDP (WireGuard, OpenVPN‑UDP) peuvent augmenter le taux de réussite P2P/WebRTC et permettre des connexions entre pairs plus rapides et fiables.",
        "faq-q-privacy": "Comment savoir si mon chat utilise un protocole décentralisé comme IPFS ?",
        "faq-a-privacy-content": "En temps normal, l’app tente d’utiliser IPFS et WebRTC ; si cela échoue, elle bascule vers WebSocket. Dans ce cas, la discussion est relayée via le serveur, mais aucun journal n’est conservé.",
        "faq-q-vpn-how": "Pourquoi Lingoano ?",
        "faq-a-vpn-how-content": "Contrairement aux autres applications, Lingoano vous permet de parler avec des personnes qui apprennent la même langue que vous. Cela favorise un apprentissage efficace et maintient la motivation grâce à de vraies conversations.",
        "close": "Fermer",
        "todays-words": "Mots du jour",
        "todays-words-subtitle": "Apprenez de nouveaux mots chaque jour et améliorez vos compétences linguistiques",
        "loading-words": "Chargement des mots...",
        "learning-tips": "Conseils d'apprentissage de mots",
        "tip-daily": "Tenez un journal",
        "tip-daily-desc": "Écrivez les nouveaux mots que vous apprenez dans un carnet et révisez-les régulièrement.",
        "tip-sentences": "Construisez des phrases",
        "tip-sentences-desc": "Créez vos propres phrases avec chaque nouveau mot et entraînez-vous.",
        "tip-connect": "Faites des liens",
        "tip-connect-desc": "Reliez les nouveaux mots aux mots que vous connaissez déjà et renforcez votre mémoire.",
        "tip-audio": "Apprenez avec de l'audio",
        "tip-audio-desc": "Apprenez à prononcer le mot correctement et répétez-le à haute voix.",
        "footer": "Votre vie privée est notre priorité. Communiquez librement avec Lingoano",
        "privacy-features": "Nos fonctionnalités de confidentialité",
        "terminal1": " Aucune historique de message n'est stockée",
        "terminal2": "> Les discussions ne transitent pas par le serveur (dans le protocole par défaut)",
        "terminal3": "> Les informations utilisateur ne sont ni demandées ni stockées",
        "terminal4": "> Tout le monde peut consulter le code",
        "terminal5": "> Notre objectif : prendre l'apprentissage et la sécurité au sérieux",
        "terminal": "Nos fonctionnalités de sécurité",
        "benefits": "Les bienfaits de l'apprentissage des langues",
        "career-development": "Développement de carrière",
        "why": "Pourquoi vous devriez apprendre une langue",
        "privacy": "Confidentialité et sécurité",
        "privacy-principles": "Nos principes de confidentialité",
        "p2p-fallback-disclaimer": "Lorsque le P2P n'est pas possible, WebSocket est utilisé pour un relais serveur temporaire ; aucun journal persistant n'est conservé.",
        "udp-vpn-tip-inline": "L'utilisation d'un VPN basé sur l'UDP (WireGuard, OpenVPN‑UDP) peut améliorer les taux de réussite P2P.",
        "decentralized-structure-title": "Structure Décentralisée :",
        "decentralized-structure-desc": "Vos données sont transmises sur un réseau distribué et ne sont pas collectées en un seul emplacement central.",
        "censorship-resistance-title": "Résistance à la Censure :",
        "censorship-resistance-desc": "Aucune autorité ne peut bloquer notre plateforme ; elle reste accessible à tout moment.",
        "full-anonymity-title": "Anonymat Total :",
        "full-anonymity-desc": "Nous ne demandons aucune information personnelle ; vous n'êtes pas tenu de partager votre vrai nom.",
        "minimal-data-title": "Données Minimales :",
        "minimal-data-desc": "Seules les informations nécessaires sont stockées ; nous ne collectons pas de données inutiles.",
        "zero-record-title": "Zéro Enregistrement :",
        "zero-record-desc": "Vos discussions ne sont stockées nulle part ; elles sont totalement temporaires.",
        "how-it-works": "Comment ça marche",
        "how-it-works-content": "Le principe de fonctionnement de Lingoano est simple et efficace. La plateforme vous met en relation avec des personnes qui souhaitent apprendre la même langue et vous permet de vous entraîner à des conversations réelles.",
        "step-by-step-process": "Processus étape par étape",
        "step-1": "1. Sélectionnez la langue et le niveau",
        "step-1-content": "Choisissez la langue que vous souhaitez apprendre et votre niveau actuel. Tous les niveaux de A1 à B2+ sont pris en charge, vous serez donc mis en relation avec des personnes du même niveau que vous.",
        "step-2": "2. Mise en relation automatique",
        "step-2-content": "Le système vous met automatiquement en relation avec des utilisateurs qui souhaitent apprendre la même langue et ont un niveau similaire, assurant une expérience d'apprentissage confortable et efficace.",
        "step-3": "3. Chat sécurisé",
        "step-3-content": "Grâce à la technologie IPFS, vos discussions sont entièrement sécurisées et anonymes. Vos messages ne sont stockés sur aucun serveur et ne peuvent être surveillés par personne.",
        "step-4": "4. Apprentissage continu",
        "step-4-content": "Chaque conversation est une nouvelle opportunité d'améliorer vos compétences linguistiques. En parlant à différentes personnes, vous enrichissez votre vocabulaire et améliorez votre prononciation.",
        "technology-security": "Technologie et Sécurité",
        "technology-security-content": "Lingoano utilise les dernières technologies pour offrir une expérience d'apprentissage des langues sûre et efficace. Notre plateforme est conçue pour maximiser la confidentialité et la sécurité des utilisateurs.",
        "technologies-we-use": "Technologies que nous utilisons",
        "ipfs-title": "IPFS (InterPlanetary File System)",
        "ipfs-content": "En utilisant un système de fichiers décentralisé, il garantit que vos messages ne sont jamais stockés sur un serveur. Cette technologie crée un environnement de communication sécurisé et résistant à la censure.",
        "webrtc-title": "WebRTC",
        "webrtc-content": "La technologie WebRTC est utilisée pour la communication directe de pair à pair, garantissant que vos messages parviennent à l'autre partie sans passer par des serveurs tiers.",
        "open-source-title": "Code Open Source",
        "open-source-content": "Tout notre code est publié en open source, ce qui permet aux experts en sécurité et aux développeurs de revoir et de vérifier notre sécurité.",
        "user": "Expériences utilisateur :",
        "testimonials-emir": "\"Grâce à Lingoano, j'ai surmonté ma peur de parler anglais. Je peux désormais discuter à l'aise avec des amis étrangers.\"",
        "testimonials-privacy": "\"J'avais des inquiétudes concernant la confidentialité, mais grâce à IPFS je l'utilise en toute confiance.\"",
        "testimonials-effective": "\"Comme je suis mis en relation avec des personnes de mon niveau, mon apprentissage est beaucoup plus efficace.\"",
        "testimonials-dr-basak": "\"Placer la pratique orale réelle au centre de l'apprentissage des langues est une approche pédagogiquement solide.\"",
        "chat": "Chat",
        "about": "À propos de Lingoano",
        "word-of-day": "Mot du jour",
        "language-guides": "Guides linguistiques",
        "download": "Télécharger",
        "meet": "Lingoano Web",
        "learn": "Commencez à apprendre des langues dès aujourd'hui",
        "status-content": "La version web de Lingoano est conçue pour faciliter l'apprentissage des langues. Vous pouvez vous entraîner via votre navigateur sans avoir à télécharger d'application. Notre système de mise en relation rassemble des utilisateurs ayant des objectifs et des niveaux similaires.",
        "why-Lingoano": "Pourquoi Lingoano Web",
        "footer": "Commencez à apprendre des langues dès aujourd'hui avec Lingoano dans un environnement de pratique réel",
        "donate": "Soutenir Lingoano",
        "donate-content": "Si vous souhaitez soutenir le développement de cette application, vous pouvez le faire depuis la page \"Buy Me A Coffee\"",
        "select-language": "Langue que vous souhaitez parler :",
        "select-level": "Votre niveau dans cette langue :",
        "select-placeholder": "Sélectionner",
        "search-match": "Rechercher une correspondance",
        "english": "Anglais",
        "turkish": "Turc",
        "german": "Allemand",
        "french": "Français",
        "spanish": "Espagnol",
        "russian": "Russe",
        "level-a1": "A1 (Débutant)",
        "level-a2": "A2 (Élémentaire)",
        "level-b1": "B1 (Intermédiaire)",
        "level-b2": "B2+ (Avancé)",
        "feature-browser": "Accès par navigateur - vous pouvez l'utiliser depuis n'importe quel appareil",
        "feature-matching": "Mise en relation par niveau - vous parlez avec des personnes du même niveau que vous",
        "feature-anonymous": "Système de chat anonyme - vous pouvez vous entraîner confortablement tout en gardant votre identité cachée",
        "feature-multilingual": "Support multilingue - Anglais, turc, allemand, français, espagnol, russe",
        "feature-mobile": "Interface adaptée aux mobiles - vous pouvez l'utiliser confortablement depuis votre téléphone",
        "feature-free": "Accès gratuit - apprenez des langues sans payer de frais",
        "why-learn-title": "Pourquoi vous devriez apprendre des langues",
        "why-learn-subtitle": "Apprendre une langue ne se résume pas à apprendre de nouveaux mots, c'est découvrir un nouveau monde. Voici quelques raisons pour lesquelles vous devriez apprendre des langues :",
        "career-opportunities": "Opportunités de carrière",
        "career-description": "Connaître une deuxième langue offre de grands avantages dans le monde des affaires. Vous pouvez travailler dans des entreprises internationales, trouver des opportunités d'emploi à l'étranger et gagner des salaires plus élevés.",
        "cultural-richness": "Richesse culturelle",
        "cultural-description": "Chaque langue contient sa propre culture unique et sa manière de penser. Lorsque vous apprenez une nouvelle langue, vous pouvez comprendre les films, les livres et la musique de cette culture.",
        "travel-freedom": "Liberté de voyage",
        "travel-description": "Pouvoir parler la langue locale dans un pays étranger change complètement votre expérience de voyage. Vous pouvez découvrir non seulement les lieux touristiques, mais aussi de véritables expériences locales.",
        "brain-health": "Santé du cerveau",
        "brain-description": "L'apprentissage des langues maintient votre cerveau actif et renforce votre mémoire. La recherche montre que les personnes multilingues sont plus résistantes aux maladies comme la maladie d'Alzheimer.",
        "confidence": "Confiance et estime de soi",
        "confidence-description": "Apprendre une nouvelle langue augmente votre confiance en vous. Voir que vous avez atteint un objectif difficile vous rend plus courageux dans d'autres domaines de votre vie.",
        "social-connections": "Liens sociaux",
        "social-description": "La langue est l'un des outils les plus puissants qui relie les gens. Lorsque vous apprenez une nouvelle langue, vous pouvez communiquer avec des personnes de différentes parties du monde.",
        "dictionary": "Dictionnaire",
        "search-placeholder": "Rechercher des mots...",
        "popular-words": "Mots populaires",
        "word-not-found": "Mot non trouvé",
        "detecting-language": "Détection de la langue...",
        "send": "Envoyer",
        "ipfs-chat-started": "Connecté à IPFS. Chat démarré.",
        "ipfs-connection-failed": "Échec de la connexion à IPFS. Veuillez vérifier votre réseau.",
        "connection-error-placeholder": "Erreur de connexion",
        "websocket-connected": "Connecté à WebSocket. Vous pouvez maintenant envoyer des messages !",
        "demo-mode-type-message": "Mode démo - Écrivez votre message...",
        "websocket-demo-mode": "La connexion WebSocket a échoué. Mode démo activé.",
        "matching-search-started": "🔍 Recherche de correspondance démarrée ! Recherche d'un partenaire approprié pour vous...",
        "searching-match-button": "Recherche d'une correspondance...",
        "waiting-match-button": "En attente d'une correspondance...",
        "matching-waiting": "⏳ En attente d'une correspondance... Recherche d'un autre utilisateur.",
        "matched-redirecting-button": "Correspondance trouvée ! Redirection...",
        "matching-found-notification": "🎉 Correspondance trouvée ! Redirection vers la page de chat...",
        "matching-error": "❌ Erreur de mise en relation",
        "peer-disconnected-notification": "⚠️ L'utilisateur correspondant s'est déconnecté. Veuillez réessayer.",
        "server-connection-failed": "🔌 Impossible de se connecter au serveur. Veuillez vous assurer que le serveur est en cours d'exécution.",
        "select-language-level": "Veuillez sélectionner une langue et un niveau.",
        "todays-words": "Mots du jour",
        "todays-words-subtitle": "Apprenez de nouveaux mots chaque jour et améliorez vos compétences linguistiques",
        "loading-words": "Chargement des mots...",
        "learning-tips": "Conseils d'apprentissage de mots",
        "tip-daily": "Tenez un journal",
        "tip-daily-desc": "Écrivez les nouveaux mots que vous apprenez dans un carnet et révisez-les régulièrement.",
        "tip-sentences": "Faites des phrases",
        "tip-sentences-desc": "Créez vos propres phrases pour chaque nouveau mot et entraînez-vous.",
        "tip-connect": "Faites des liens",
        "tip-connect-desc": "Reliez les nouveaux mots aux mots que vous connaissez et renforcez votre mémoire.",
        "tip-audio": "Apprenez avec de l'audio",
        "tip-audio-desc": "Apprenez à prononcer les mots correctement et répétez-les à haute voix.",
        "download-title": "Télécharger Lingoano",
        "download-subtitle": "Téléchargez la plateforme d'apprentissage des langues pour tous vos appareils",
        "download-windows": "Télécharger pour Windows",
        "download-mac": "Télécharger pour Mac",
        "download-linux": "Télécharger pour Linux",
        "download-android": "Télécharger pour Android",
        "download-ios": "Télécharger pour iOS",
        "coming-soon": "Prochainement",
        "development-in-progress": "En développement",
        "stay-tuned": "Restez à l'écoute",
        "language-guides-title": "Guides linguistiques",
        "language-guides-subtitle": "Règles de grammaire, tactiques et guides d'apprentissage",
        "english-grammar": "Grammaire anglaise",
        "german-grammar": "Grammaire allemande",
        "spanish-grammar": "Grammaire espagnole",
        "russian-grammar": "Grammaire russe",
        "learning-tactics": "Tactiques d'apprentissage",
        "grammar-basics": "Bases de la grammaire",
        "about-title": "À propos de Lingoano",
        "about-subtitle": "Informations détaillées sur la plateforme d'apprentissage des langues",
        "what-is-Lingoano": "Qu'est-ce que Lingoano ?",
        "Lingoano-description": "Lingoano est une plateforme de chat moderne conçue pour ceux qui souhaitent apprendre des langues.",
        "our-mission": "Notre mission",
        "privacy-security": "Confidentialité et sécurité",
        "how-it-works": "Comment ça marche ?",
        "how-it-works-content": "Le principe de fonctionnement de Lingoano est très simple et efficace. La plateforme vous met en relation avec des personnes qui souhaitent apprendre la même langue et vous permet de vous entraîner à des conversations réelles.",
        "technology-security": "Technologie et Sécurité",
        "technology-security-content": "Lingoano utilise les dernières technologies pour offrir une expérience d'apprentissage des langues sûre et efficace. Notre plateforme est conçue pour protéger la confidentialité et la sécurité des utilisateurs au plus haut niveau.",
        "community-support": "Communauté et support",
        "community-support-content": "Lingoano n'est pas seulement une plateforme d'apprentissage des langues, mais aussi une communauté où les apprenants de langues se retrouvent. Les expériences et les commentaires de nos utilisateurs nous aident à améliorer continuellement la plateforme.",
        "privacy-policy-title": "Politique de confidentialité",
        "privacy-policy-subtitle": "Informations sur la manière dont vos données personnelles sont protégées",
        "data-collection": "Collecte de données",
        "data-usage": "Utilisation des données",
        "data-protection": "Protection des données",
        "your-rights": "Vos droits",
        "last-updated": "Dernière mise à jour : 26 août 2025",
        "contact-section": "13. Contact",
        "introduction": "1. Introduction",
        "introduction-content": "Chez Lingoano (\"Lingoano\", \"nous\" ou la \"société\"), nous nous engageons à protéger les données personnelles et votre vie privée. Cette politique de confidentialité explique quelles données sont traitées lorsque vous utilisez notre plateforme, les finalités et les bases légales du traitement, les périodes de conservation et vos droits.",
        "information-collected": "2. Informations que nous collectons",
        "personal-information": "2.1 Données personnelles",
        "personal-information-content": "En règle générale, Lingoano ne demande ni ne traite de données personnelles telles que le nom, le prénom, l'e-mail ou le numéro de téléphone.",
        "technical-information": "2.2 Identifiants techniques/en ligne",
        "technical-information-content": "Pour fournir le service, assurer la sécurité et améliorer les performances, les données techniques suivantes peuvent être traitées :",
        "browser-type": "Type et version du navigateur",
        "operating-system": "Système d'exploitation et informations sur l'appareil",
        "ip-address": "Adresse IP (masquage/anonymisation appliquée si possible)",
        "page-views": "Statistiques d'utilisation/d'interaction (agrégées et anonymes)",
        "use-of-information": "3. Utilisation des informations",
        "use-of-information-content": "Les données collectées/traitées sont utilisées dans le cadre d'intérêts légitimes et pour la fourniture du service aux fins suivantes :",
        "improve-platform": "Améliorer les performances de la plateforme",
        "resolve-issues": "Résoudre les problèmes techniques",
        "enhance-experience": "Améliorer l'expérience utilisateur",
        "ensure-security": "Assurer la sécurité",
        "information-sharing": "4. Partage d'informations",
        "information-sharing-content": "Lingoano ne vend ni ne partage les informations des utilisateurs à des fins de marketing. Les données peuvent être divulguées uniquement si cela est nécessaire pour se conformer aux obligations légales et pour répondre aux demandes dûment autorisées des autorités compétentes.",
        "cookies-tracking": "5. Cookies et suivi",
        "cookies-tracking-content": "Seuls des cookies essentiels et de préférence sont utilisés pour faire fonctionner le service. Aucun cookie publicitaire ou de suivi tiers n'est actif dans cette version.",
        "store-theme": "Stocke vos préférences de thème",
        "remember-language": "Se souvient de votre sélection de langue",
        "session-info": "Préserve vos informations de session",
        "google-adsense": "6. Publicités (désactivées)",
        "google-adsense-content": "Aucune régie publicitaire n'est active dans cette version. Aucune publicité personnalisée n'est diffusée.",
        "personalize-ads": "Personnalise l'expérience publicitaire à l'aide de cookies",
        "measure-performance": "Mesure les performances des annonces",
        "analyze-behavior": "Analyse le comportement de l'utilisateur",
        "google-privacy-policy": "",
        "data-security": "7. Sécurité des données",
        "data-security-content": "Lingoano met en œuvre des mesures techniques et organisationnelles raisonnables pour garantir la sécurité des données :",
        "use-ipfs": "La communication de pair à pair (par exemple, WebRTC, IPFS) est préférée si possible",
        "encrypted-communication": "Le cryptage est utilisé pendant la transmission",
        "no-data-storage": "Aucun stockage de contenu ; les journaux obligatoires sont minimaux",
        "regular-updates": "Les composants sont mis à jour régulièrement",
        "user-rights": "8. Droits de l'utilisateur",
        "user-rights-content": "Sous réserve de la loi applicable, les utilisateurs ont les droits suivants :",
        "access-data": "Accéder à vos données personnelles",
        "correct-data": "Rectifier vos données",
        "delete-data": "Supprimer vos données",
        "object-processing": "S'opposer au traitement",
        "children-privacy": "9. Confidentialité des enfants",
        "children-privacy-content": "Lingoano n'est pas destiné aux personnes de moins de 13 ans. Nous ne collectons pas sciemment de données auprès d'enfants de moins de 13 ans ; si elles sont collectées par inadvertance, elles seront supprimées dans un délai raisonnable.",
        "policy-changes": "10. Modifications de la politique",
        "policy-changes-content": "Cette politique de confidentialité peut être mise à jour de temps à autre. Pour les modifications substantielles, la date d'entrée en vigueur sera mise à jour et un préavis raisonnable sera fourni.",
        "contact": "11. Contact",
        "contact-content": "Pour toute question concernant cette politique de confidentialité, vous pouvez nous contacter via :",
        "privacy-email": "E-mail : privacy@lingoano.com",
        "acceptance": "1. Acceptation et consentement",
        "acceptance-content": "En accédant et en utilisant les services de Lingoano, vous acceptez les présentes conditions d'utilisation et toutes les politiques et avis incorporés par référence. Si vous n'êtes pas d'accord, vous ne devez pas utiliser le service.",
        "service-description": "2. Description du service",
        "service-description-content": "Lingoano est une plateforme qui met en relation des utilisateurs qui souhaitent pratiquer des langues et permet la communication. La communication de pair à pair (P2P) est préférée lorsque cela est faisable. Le service est fourni \"tel quel\" et \"selon la disponibilité\".",
        "general-rules": "3.1 Règles générales",
        "general-rules-content": "Pendant l'utilisation du service, vous devez vous conformer aux lois applicables, à l'ordre public et aux règles de la communauté :",
        "be-respectful": "Soyez respectueux et courtois",
        "follow-laws": "Conformez-vous aux lois",
        "respect-rights": "Respectez les droits des autres",
        "no-spam": "Ne partagez pas de spam ou de contenu nuisible",
        "no-threats": "Ne menacez pas la sécurité de la plateforme",
        "prohibited-content": "3.2 Contenu interdit",
        "prohibited-content-content": "Le contenu et les actes suivants sont interdits :",
        "hate-speech": "Discours de haine et discrimination",
        "violence": "Contenu violent",
        "obscene-material": "Matériel obscène ou pornographique",
        "illegal-activities": "Activités illégales",
        "personal-info": "Partage d'informations personnelles",
        "false-info": "Diffusion de fausses informations",
        "terms-privacy-security": "4. Confidentialité et sécurité",
        "terms-privacy-security-content": "Lingoano donne la priorité à la confidentialité et à la sécurité des utilisateurs. Cependant, l'utilisateur est le seul responsable du maintien de la sécurité en ligne :",
        "self-responsibility": "Vous êtes responsable de votre propre sécurité",
        "no-personal-info": "Ne partagez pas vos informations personnelles",
        "report-suspicious": "Signalez tout comportement suspect",
        "support-security": "Soutenez les mesures de sécurité de la plateforme",
        "intellectual-property": "5. Propriété intellectuelle",
        "intellectual-property-content": "Les marques de commerce, logos, l'interface, les logiciels, les textes et les visuels de Lingoano sont protégés par les lois applicables. Sans autorisation écrite, ils ne peuvent être copiés, reproduits, distribués ou utilisés pour créer des œuvres dérivées.",
        "service-changes": "6. Modifications du service",
        "service-changes-content": "Lingoano peut mettre à jour, suspendre ou interrompre la portée et les fonctions du service de temps à autre. Un préavis raisonnable sera fourni pour les modifications substantielles.",
        "liability-limitation": "7. Limitation de responsabilité",
        "liability-limitation-content": "Le service est fourni \"tel quel\" et \"selon la disponibilité\". Dans la mesure maximale permise par la loi, Lingoano ne sera pas responsable des dommages indirects, accessoires, spéciaux, punitifs ou consécutifs.",
        "account-suspension": "8. Suspension et résiliation",
        "account-suspension-content": "En cas de violation des conditions, l'accès peut être restreint et le(s) compte(s) peuvent être suspendus ou résiliés. Les enregistrements nécessaires à la résolution des litiges peuvent être conservés conformément aux lois applicables.",
        "advertisements": "9. Publicités",
        "advertisements-content": "Aucune régie publicitaire n'est active dans cette version. Aucune publicité personnalisée n'est diffusée.",
        "cover-costs": "Affichées pour couvrir les coûts de développement de la plateforme",
        "non-intrusive": "Placées de manière à ne pas avoir d'impact sur l'expérience utilisateur",
        "google-policies": "Affichées conformément aux politiques de publicité/confidentialité des fournisseurs",
        "applicable-law": "10. Droit applicable et juridiction",
        "applicable-law-content": "Les présentes conditions sont régies et interprétées conformément aux lois de la République de Turquie. Les tribunaux et bureaux d'exécution d'Istanbul (central) seront compétents pour les litiges.",
        "terms-email": "E-mail : terms@Lingoano.com",
        "terms-title": "Conditions d'utilisation",
        "terms-subtitle": "Règles et conditions d'utilisation de la plateforme",
        "usage-rules": "Règles d'utilisation",
        "user-responsibilities": "Responsabilités de l'utilisateur",
        "prohibited-content": "Contenu interdit",
        "account-termination": "Résiliation du compte",
        "chat-title": "Chat",
        "connecting": "Connexion...",
        "waiting-for-match": "En attente de correspondance...",
        "connected": "Connecté",
        "disconnected": "Déconnecté",
        "type-message": "Écrivez votre message...",
        "partner-left": "Votre partenaire de chat est parti",
        "new-match": "Nouvelle correspondance",
        "leave-chat": "Quitter le chat",
        "home": "Accueil",
        "menu": "Menu",
        "close-menu": "Fermer le menu",
        "loading": "Chargement...",
        "error": "Erreur",
        "success": "Succès",
        "warning": "Avertissement",
        "info": "Info",
        "continue": "Continuer",
        "cancel": "Annuler",
        "close": "Fermer",
        "save": "Sauvegarder",
        "delete": "Supprimer",
        "edit": "Modifier",
        "yes": "Oui",
        "no": "Non",
        "confirm-leave-chat": "Voulez-vous retourner à la page d'accueil ? Le chat prendra fin.",
        "select-option": "Sélectionner",
        "default-theme": "Thème par défaut",
        "blue-theme": "Thème bleu",
        "purple-theme": "Thème violet",
        "green-theme": "Thème vert",
        "platforms": "Plateformes de bureau",
        "mobile-platforms": "Plateformes mobiles",
        "windows": "Windows",
        "mac": "Mac",
        "linux": "Linux",
        "android": "Android",
        "ios": "iOS",
        "menu-toggle-label": "Ouvrir/fermer le menu",
        "theme-switcher-label": "Sélecteur de thème",
        "github-visit": "Visiter le profil GitHub",
        "privacy-policy": "Politique de confidentialité",
        "terms-of-service": "Conditions d'utilisation",
        "donate-button": "FAIRE UN DON",
        "buy-me-coffee": "Offrez-moi un café",
        "chat-title-page": "Lingoano Chat - Plateforme d'apprentissage des langues",
        "logo-alt": "Logo",
        "about-title-page": "À propos de Lingoano - Plateforme d'apprentissage des langues",
        "download-title-page": "Télécharger Lingoano - Application d'apprentissage des langues",
        "word-of-day-title-page": "Mot du jour - Lingoano",
        "language-guides-title-page": "Guides linguistiques - Lingoano",
        "language-learning-guides": "Guides d'apprentissage des langues",
        "guides-subtitle": "Règles de grammaire, tactiques et conseils d'apprentissage",
        "privacy-policy-title-page": "Politique de confidentialité - Lingoano",
        "terms-title-page": "Conditions d'utilisation - Lingoano",
        "language-guides": "Guides d'apprentissage des langues",
        "guides-subtitle": "Règles de grammaire, tactiques et conseils d'apprentissage",
        "english-tab": "🇺🇸 Anglais",
        "german-tab": "🇩🇪 Allemand",
        "spanish-tab": "🇪🇸 Espagnol",
        "turkish-tab": "🇹🇷 Turc",
        "russian-tab": "🇷🇺 Russe",
        "english": "Anglais",
        "german": "Allemand",
        "spanish": "Espagnol",
        "french": "Français",
        "turkish": "Turc",
        "russian": "Russe",
        "english-grammar-basics": "Bases de la grammaire anglaise",
        "present-simple-title": "Présent simple",
        "present-simple-explanation": "Utilisé pour des faits généraux, des habitudes et des actions régulières. La troisième personne du singulier prend la terminaison -s.",
        "present-continuous-title": "Présent continu",
        "present-continuous-explanation": "Utilisé pour des actions en cours en ce moment et des projets futurs. Structure Be + V-ing.",
        "past-simple-title": "Passé simple",
        "past-simple-explanation": "Utilisé pour des actions terminées dans le passé. Les verbes réguliers prennent -ed, les irréguliers changent.",
        "present-perfect-title": "Passé composé",
        "present-perfect-explanation": "Pour des actions qui ont commencé dans le passé et se poursuivent jusqu'à maintenant ou qui ont des effets en cours.",
        "future-tenses-title": "Temps futurs",
        "future-tenses-explanation": "Will (futur incertain), going to (futur planifié), Présent continu (futur proche).",
        "conditionals-title": "Conditionnels",
        "conditionals-explanation": "Clauses en if : 0 (faits généraux), 1 (futur possible), 2 (présent hypothétique), 3 (passé hypothétique).",
        "learning-resources-title": "Ressources d'apprentissage",
        "resources-mobile-apps-title": "Applications mobiles",
        "resources-mobile-apps-desc": "Utilisez des applications comme Duolingo, Memrise, Babbel.",
        "resources-video-content-title": "Contenu vidéo",
        "resources-video-content-desc": "Suivez des chaînes d'apprentissage des langues sur YouTube.",
        "resources-books-title": "Livres",
        "resources-books-desc": "Lisez des livres de grammaire et des livres d'histoires.",
        "resources-online-courses-title": "Cours en ligne",
        "resources-online-courses-desc": "Bénéficiez de plateformes comme Coursera, edX.",
        "descriptiona": "Lingoano est juste un bouton pour tous vos appareils",
        "description": "Lingoano est une plateforme de chat moderne conçue pour ceux qui souhaitent apprendre des langues. Elle vous permet de pratiquer une langue dans un environnement de conversation réel avec des personnes qui partagent le même objectif linguistique. La plateforme est conçue pour rendre l'apprentissage des langues facile et agréable.",
        "learn-content": "Contrairement aux méthodes traditionnelles d'apprentissage des langues, Lingoano se concentre sur la pratique de conversations réelles. Il offre un environnement linguistique naturel où vous pouvez apprendre à votre propre rythme, tout en interagissant avec des personnes du même niveau. Cela vous permet de vous entraîner de manière confortable et efficace.",
        "why-content": "Apprendre une nouvelle langue ne se résume pas à apprendre de nouveaux mots ; c'est découvrir un nouveau monde. Comprendre différentes cultures, rencontrer de nouvelles personnes et vivre de nouvelles opportunités font tous partie du voyage. Que vous soyez intéressé par une carrière, l'éducation ou la croissance personnelle, les compétences linguistiques deviennent de plus en plus importantes pour tout le monde. Lingoano offre un point de départ simple mais efficace pour votre parcours d'apprentissage des langues.",
        "career-development-content": "Connaître une deuxième langue offre de grands avantages dans le monde des affaires. Vous pouvez travailler dans des entreprises internationales, trouver des opportunités d'emploi à l'étranger et gagner des salaires plus élevés. L'anglais, en particulier, est presque essentiel dans l'économie mondiale d'aujourd'hui.",
        "cultural-richness-content": "Chaque langue contient sa propre culture unique et sa manière de penser. Lorsque vous apprenez une nouvelle langue, vous pouvez comprendre les films, les livres et la musique de cette culture. Cela vous permet d'apprécier différentes perspectives et d'élargir votre compréhension du monde.",
        "travel-freedom-content": "Pouvoir parler la langue locale dans un pays étranger change complètement votre expérience de voyage. Vous pouvez découvrir non seulement les lieux touristiques, mais aussi de véritables expériences locales. Cela vous permet de vous connecter avec les habitants et de vous faire de nouveaux amis en cours de route.",
        "brain-health-content": "L'apprentissage des langues maintient votre cerveau actif et renforce votre mémoire. Les recherches montrent que les personnes multilingues sont plus résistantes à des maladies comme la maladie d'Alzheimer."
    },
    tr: {
        "wod-streak-msg-1": "💔 Bizi bir kere terk ettin, İgo hâlâ kırgın.",
        "wod-streak-msg-2": "🎉 Tebrikler! İlk streakinle İgo gurur duyuyor.",
        "wod-streak-msg-3": "🏆🔥 İgo streakinle gurur duyuyor, tebrikler!",
        "wod-streak-msg-3-special": "🤗🎉 İgo seni affediyor ve kutluyor!",
        "change-wod-language": "Dili değiştir",
        // Navigation
        "chat": "Sohbet",
        "about": "Lingoano Hakkında",
        "word-of-day": "Günün Kelimesi",
        "language-guides": "Dil Rehberleri",
        "download": "İndir",
        "home": "Ana Sayfa",
        "support": "Destek",
        "learn-more": "Daha Fazla Bilgi",

        // Main page
        "meet": "Lingoano Web",
        "learn": "Bugün yeni bir dil öğrenmeye başlayın!",
        "status-content": "Lingoano web sürümü ile dil öğrenmeyi kolaylaştırıyoruz! Uygulama indirmenize gerek yok, tarayıcı üzerinden hemen pratik yapmaya başlayın. Akıllı eşleşme sistemimiz sizi benzer hedef ve seviyedeki kullanıcılarla buluşturuyor.",
        "why-Lingoano": "Neden Lingoano Web'i Seçmelisiniz?",
        "footer": "Gerçek pratik ortamında Lingoano ile dil öğrenmeye bugün başlayın",
        "donate": "Lingoano'yı Destekle",
        "donate-content": "Geliştirme aşamasındaki bu uygulamayı desteklemek isterseniz \"Buy Me A Coffee\" sayfasından destek olabilirsiniz",
        "buy-me-coffee": "Bana Bir Kahve Ismarla",
        "hero-title": "Dilleri <span class='text-accent'>güvenli ve özgürce</span> öğrenin",
        "hero-subtitle": "Lingoano size merkezi olmayan, anonim ve sansürsüz bir dil öğrenme deneyimi sunar.",
        "start-chatting": "Sohbete Başla",

        // Form labels
        "select-language": "Konuşmak istediğiniz dil:",
        "select-level": "Bu dildeki seviyeniz:",
        "select-placeholder": "Seçiniz",
        "search-match": "Eşleşme Ara",

        // Matching flow (buttons/notifications)
        "matching-search-started": "🔍 Eşleşme araması başlatıldı! Size uygun bir partner aranıyor...",
        "searching-match-button": "Eşleşme aranıyor...",
        "waiting-match-button": "Eşleşme bekleniyor...",
        "matched-redirecting-button": "Eşleşme bulundu! Yönlendiriliyor...",
        "matching-waiting": "⏳ Eşleşme bekleniyor... Başka bir kullanıcı aranıyor.",
        "matching-found-notification": "🎉 Eşleşme bulundu! Sohbet sayfasına yönlendiriliyorsunuz...",
        "matching-error": "❌ Eşleşme hatası",
        "peer-disconnected-notification": "⚠️ Eşleşen kullanıcı bağlantıyı kesti. Tekrar deneyin.",
        "server-connection-failed": "🔌 Sunucuya bağlanılamadı. Lütfen sunucunun çalıştığından emin olun.",
        "select-language-level": "Lütfen dil ve seviye seçiniz.",

        // Language options
        "english": "İngilizce",
        "turkish": "Türkçe",
        "german": "Almanca",
        "french": "Fransızca",
        "spanish": "İspanyolca",
        "russian": "Rusça",

        // Level options
        "level-a1": "A1 (Başlangıç)",
        "level-a2": "A2 (Temel)",
        "level-b1": "B1 (Orta)",
        "level-b2": "B2+ (İleri)",

        // Features list
        "feature-browser": "Tarayıcı üzerinden erişim - Herhangi bir cihazdan kullanabilirsiniz",
        "feature-matching": "Akıllı eşleşme sistemi - Sizinle aynı seviyedeki kişilerle konuşun",
        "feature-anonymous": "Güvenli anonim sohbet - Kimliğinizi gizli tutarak rahatça pratik yapın",
        "feature-multilingual": "6 dil desteği - İngilizce, Türkçe, Almanca, İspanyolca, Fransızca ve Rusça",
        "feature-mobile": "Mobil uyumlu tasarım - Telefonunuzdan da rahatça kullanın",
        "feature-free": "Tamamen ücretsiz - Hiçbir ücret ödemeden dil öğrenin",

        // Why learn section
        "why-learn-title": "Neden Dil Öğrenmelisin",
        "why-learn-subtitle": "Dil öğrenmek sadece yeni kelimeler öğrenmek değil, yeni bir dünya keşfetmektir. İşte neden dil öğrenmeniz gerektiğinin birkaç nedeni:",
        "career-opportunities": "Kariyer Fırsatları",
        "career-description": "İkinci bir dil bilmek iş dünyasında büyük avantaj sağlar. Uluslararası şirketlerde çalışma, yurtdışı iş fırsatları ve daha yüksek maaşlar elde edebilirsiniz.",
        "cultural-richness": "Kültürel Zenginlik",
        "cultural-description": "Her dil, kendine özgü bir kültürü ve düşünce tarzını barındırır. Yeni bir dil öğrendiğinizde, o kültürün filmlerini, kitaplarını ve müziğini anlayabilirsiniz.",
        "travel-freedom": "Seyahat Özgürlüğü",
        "travel-description": "Yabancı bir ülkede yerel dili konuşabilmek, seyahat deneyiminizi tamamen değiştirir. Sadece turistik yerleri değil, gerçek yerel deneyimleri yaşayabilirsiniz.",
        "brain-health": "Beyin Sağlığı",
        "brain-description": "Dil öğrenmek beyninizi aktif tutar ve hafızanızı güçlendirir. Araştırmalar, çok dilli insanların Alzheimer gibi hastalıklara karşı daha dirençli olduğunu gösteriyor.",
        "confidence": "Güven ve Özgüven",
        "confidence-description": "Yeni bir dil öğrenmek, kendinize olan güveninizi artırır. Zorlu bir hedefi başardığınızı görmek, hayatınızın diğer alanlarında da daha cesur olmanızı sağlar.",
        "social-connections": "Sosyal Bağlantılar",
        "social-description": "Dil, insanları birbirine bağlayan en güçlü araçlardan biridir. Yeni bir dil öğrendiğinizde, dünyanın farklı yerlerinden insanlarla iletişim kurabilirsiniz.",

        // Privacy Features
        "privacy-features": "Güvenlik Özelliklerimiz",
        "terminal1": "> Hiçbir mesaj geçmişi tutulmaz",
        "terminal2": "> Sohbetler sunucuya uğramaz(varsayılan protokolde)",
        "terminal3": "> Kullanıcı bilgileri istenmez, kaydedilmez",
        "terminal4": "> İsteyen herkes kodu inceleyebilir",
        "terminal5": "> Hedefimiz: hem öğrenmeyi hem de güvenliği ciddiye almak",
        "terminal": "Güvenlik Özelliklerimiz",

        // About Page
        "what-is-Lingoano": "Lingoano Nedir?",
        "what-is-Lingoano-title": "Lingoano Nedir?",
        "what-is-Lingoano-text1": "Lingoano, dünya çapında insanlarla dil pratiği yapmanızı sağlayan bir uygulamadır.",
        "what-is-Lingoano-text2": "<span class='text-accent'>Merkezi olmayan altyapısı</span> sayesinde konuşmalarınız <span class='text-accent'>anonim, güvenli</span> ve <span class='text-accent'>sansürsüzdür</span>.",
        "what-is-Lingoano-text3": "İster başlangıç ​​seviyesinde olun ister ileri düzeyde, sizinle aynı dili öğrenen insanlarla tanışabilir ve becerilerinizi gerçek zamanlı olarak geliştirebilirsiniz.",
        "what-is-Lingoano-feature1-title": "Gerçek Pratik",
        "what-is-Lingoano-feature1-text": "Anadili İngilizce olan kişilerle sohbet edin ve akıcılık kazanın.",
        "what-is-Lingoano-feature2-title": "Maksimum Güvenlik",
        "what-is-Lingoano-feature2-text": "Hiçbir kişisel veri istenmez veya saklanmaz.",
        "what-is-Lingoano-feature3-title": "Küresel Öğrenme",
        "what-is-Lingoano-feature3-text": "Uluslararası bir dil meraklıları topluluğuna katılın.",
        "benefits": "Dil Öğrenmenin Faydaları",
        "career-development": "Kariyer Gelişimi",
        "why": "Neden Dil Öğrenmelisiniz",
        "why-content": "Dil öğrenmek sadece yeni kelimeler öğrenmek değil, aynı zamanda yeni bir dünya görüşü kazanmaktır. Farklı kültürleri anlamak, yeni fırsatlar yaratmak ve kişisel gelişiminizi desteklemek için dil öğrenmek en etkili yoldur.",
        "privacy": "Gizlilik ve Güvenlik",
        "privacy-principles": "Gizlilik İlkelerimiz",
        "p2p-fallback-disclaimer": "P2P mümkün olmadığında WebSocket ile sunucu üzerinden geçici işleme yapılır; kalıcı kayıt tutulmaz.",
        "udp-vpn-tip-inline": "UDP destekli bir VPN (WireGuard, OpenVPN‑UDP) kullanmak P2P başarı oranını artırabilir.",

        // Privacy Principles
        "decentralized-structure-title": "Merkeziyetsiz Yapı:",
        "decentralized-structure-desc": "Verileriniz dağıtık ağda iletilir, tek bir merkezi noktada toplanmaz.",
        "censorship-resistance-title": "Sansür Direnci:",
        "censorship-resistance-desc": "Hiçbir otorite platformumuzu engelleyemez, her zaman erişilebilir kalır.",
        "full-anonymity-title": "Tam Anonimlik:",
        "full-anonymity-desc": "Kimlik bilgileriniz istenmez, gerçek adınızı paylaşmak zorunda değilsiniz.",
        "minimal-data-title": "Minimal Veri:",
        "minimal-data-desc": "Sadece gerekli bilgiler tutulur, gereksiz veri toplamayız.",
        "zero-record-title": "Sıfır Kayıt:",
        "zero-record-desc": "Sohbetleriniz hiçbir yerde saklanmaz, tamamen geçicidir.",

        // How It Works
        "how-it-works": "Nasıl Çalışır",
        "how-it-works-content": "Lingoano'nın çalışma prensibi oldukça basit ve etkilidir. Platform, sizinle aynı dili öğrenmek isteyen kişilerle sizi eşleştirir ve gerçek konuşma pratiği yapmanızı sağlar.",
        "step-by-step-process": "Adım Adım Süreç",
        "step-1": "1. Dil ve Seviye Seçimi",
        "step-1-content": "Öğrenmek istediğiniz dili ve mevcut seviyenizi seçin. A1'den B2+'ya kadar tüm seviyeler desteklenir. Bu sayede sizinle aynı seviyede olan kişilerle eşleşirsiniz.",
        "step-2": "2. Otomatik Eşleşme",
        "step-2-content": "Sistem, sizinle aynı dili öğrenmek isteyen ve benzer seviyede olan kullanıcılarla sizi otomatik olarak eşleştirir. Bu sayede rahat ve etkili bir öğrenme deneyimi yaşarsınız.",
        "step-3": "3. Güvenli Sohbet",
        "step-3-content": "IPFS teknolojisi sayesinde sohbetleriniz tamamen güvenli ve anonimdir. Mesajlarınız hiçbir sunucuda saklanmaz ve kimse tarafından izlenemez.",
        "step-4": "4. Sürekli Öğrenme",
        "step-4-content": "Her sohbet, dil becerilerinizi geliştirmeniz için yeni bir fırsattır. Farklı kişilerle konuşarak kelime dağarcığınızı genişletir ve telaffuzunuzu iyileştirirsiniz.",

        // Technology & Security
        "technology-security": "Teknoloji ve Güvenlik",
        "technology-security-content": "Lingoano, en son teknolojileri kullanarak güvenli ve etkili bir dil öğrenme deneyimi sunar. Platformumuz, kullanıcıların gizliliğini ve güvenliğini en üst düzeyde tutmak için tasarlanmıştır.",
        "technologies-we-use": "Kullandığımız Teknolojiler",
        "ipfs-title": "IPFS (InterPlanetary File System)",
        "ipfs-content": "Merkeziyetsiz dosya sistemi kullanarak, mesajlarınızın hiçbir sunucuda saklanmamasını sağlar. Bu teknoloji, sansüre karşı dayanıklı ve güvenli bir iletişim ortamı yaratır.",
        "webrtc-title": "WebRTC",
        "webrtc-content": "Doğrudan peer-to-peer iletişim için kullanılan WebRTC teknolojisi, mesajlarınızın üçüncü taraf sunuculara uğramadan doğrudan karşı tarafa ulaşmasını sağlar.",
        "open-source-title": "Açık Kaynak Kod",
        "open-source-content": "Tüm kodumuz açık kaynak olarak yayınlanmıştır. Bu sayede güvenlik uzmanları ve geliştiriciler platformumuzu inceleyebilir ve güvenliğimizi doğrulayabilir.",
        "user": "Kullanıcı Deneyimleri:",
        "testimonials-emir": "\"Lingoano sayesinde İngilizce konuşma korkumu yendim. Artık yabancı arkadaşlarımla rahatça sohbet edebiliyorum.\"",
        "testimonials-privacy": "\"Gizlilik konusunda endişelerim vardı ama IPFS teknolojisi sayesinde güvenle kullanabiliyorum.\"",
        "testimonials-effective": "\"Seviyeme uygun kişilerle eşleştiğim için öğrenme sürecim çok daha etkili oldu.\"",
        "testimonials-dr-basak": "\"Dil öğreniminde gerçek konuşma pratiğini merkeze alması, pedagojik açıdan güçlü bir yaklaşım.\"",

        // Support Page
        "support-title": "Yardıma mı ihtiyacınız var?",
        "support-subtitle": "Lingoano'dan en iyi şekilde yararlanmanıza yardımcı olmak için buradayız.",
        "faq-title": "Sıkça Sorulan Sorular",
        "faq-q-p2p": "Mesajlar sunucuya uğramadan nasıl iletilir?",
        "faq-q-free": "Lingoano ücretsiz mi?",
        "faq-a-free": "Evet. Lingoano tamamen ücretsizdir; sohbet etmek ve öğrenmek için ücret ödemezsiniz.",
        "faq-q-login": "Üyelik veya giriş gerekli mi?",
        "faq-a-login": "Hayır. Lingoano üyelik veya oturum açma gerektirmez; anonim olarak kullanabilirsiniz.",
        "faq-a-p2p-content": "Varsayılan olarak IPFS/WebRTC gibi P2P protokoller tercih edilir. Bu protokoller sayesinde mesajlar doğrudan eşler arasında iletilir ve sunucuya uğramadan iletilir. Protokollerin temelinde IP adresleri arasında özel bir ağ kurulur ve bu ağ üzerinden mesajlar iletilir.",
        "faq-q-udp-vpn": "UDP destekli bir VPN kullanmak bağlantıyı nasıl iyileştirir?",
        "faq-a-udp-vpn-content": "NAT geçişi çoğu zaman operatörler tarafından kısıtlanır. WireGuard veya OpenVPN‑UDP gibi UDP tabanlı VPN’ler P2P/WebRTC başarı oranını artırarak daha hızlı ve kararlı bağlantılar sağlar.",
        "faq-q-privacy": "Sohbetimin IPFS gibi merkeziyetsiz bir protokolde mi olduğunu nasıl anlarım?",
        "faq-a-privacy-content": "Normalde IPFS ve WebRTC kullanılmaya çalışılır; başarısız olursa WebSocket’e düşülür. Bu durumda sohbet sunucu üzerinden yönlendirilir ancak hiçbir koşulda sohbet kaydı tutulmaz.",
        "faq-q-vpn-how": "Neden Lingoano?",
        "faq-a-vpn-how-content": "Lingoano, aynı dili öğrenen kişilerle sizi konuşturur. Böylece hem etkili öğrenir hem de gerçek insanlarla sohbet ederek motivasyonunuzu yüksek tutarsınız.",
        "contact-us": "Bize Ulaşın",
        "contact-text": "Bir sorunuz mu var? Ekibimizle iletişime geçin, en kısa sürede size geri döneceğiz.",

        // Download Page
        "download-title": "Lingoano İndir",
        "download-subtitle": "Dil öğrenme platformunu tüm cihazlarınıza indirin",
        "download-windows": "Windows İçin İndir",
        "download-macos": "Mac İçin İndir",
        "download-web": "Web Sürümünü Kullan",
        "download-coming-soon": "Yakında",

        // Privacy Policy
        "privacy-policy": "Gizlilik Politikası",
        "privacy-policy-title-page": "Gizlilik Politikası - Lingoano",
        "last-updated": "Son güncelleme: 26 Ağustos 2025",
        "contact-section": "13. İletişim",
        "introduction": "1. Giriş",
        "introduction-content": "Lingoano (\"Lingoano\", \"biz\" veya \"Şirket\") olarak kişisel verilerin korunmasını ve gizliliğinizi gözetmeyi taahhüt ederiz. İşbu Gizlilik Politikası, platformumuzu kullandığınızda hangi verilerin işlendiğini, bu verilerin hangi amaçlarla ve hangi hukuki sebeplere dayanarak işlendiğini, saklama sürelerini ve haklarınızı açıklar.",
        "information-collected": "2. Topladığımız Bilgiler",
        "personal-information": "2.1 Kişisel Veriler",
        "personal-information-content": "Lingoano, kural olarak ad, soyad, e‑posta, telefon gibi kimliği belirli veya belirlenebilir gerçek kişiye ilişkin verileri talep etmez ve işlemez.",
        "technical-information": "2.2 Teknik/Çevrimiçi Tanımlayıcılar",
        "technical-information-content": "Hizmetin sunulması, güvenliğinin sağlanması ve performansın iyileştirilmesi amacıyla aşağıda sayılan teknik veriler işlenebilir:",
        "browser-type": "Tarayıcı türü ve sürümü",
        "operating-system": "İşletim sistemi ve cihaz bilgileri",
        "ip-address": "IP adresi (mümkün olduğunda maskeleme/anonimleştirme uygulanır)",
        "page-views": "Kullanım/etkileşim istatistikleri (toplu ve anonim)",
        "use-of-information": "3. Bilgilerin Kullanımı",
        "use-of-information-content": "Toplanan/işlenen bilgiler, meşru menfaatler ile hizmetin ifası kapsamında ve aşağıdaki amaçlarla kullanılır:",
        "improve-platform": "Platform performansını iyileştirmek",
        "resolve-issues": "Teknik sorunları çözmek",
        "enhance-experience": "Kullanıcı deneyimini geliştirmek",
        "ensure-security": "Güvenliği sağlamak",
        "information-sharing": "4. Bilgi Paylaşımı",
        "information-sharing-content": "Lingoano, kullanıcı bilgilerini üçüncü kişilere satmaz ve pazarlama amacıyla paylaşmaz. Yalnızca kanuni yükümlülüklerin yerine getirilmesi ve yetkili makamların usulüne uygun taleplerinin karşılanması kapsamında zorunlu hallerde veri aktarımı yapılabilir.",
        "cookies-tracking": "5. Çerezler ve İzleme",
        "cookies-tracking-content": "Hizmetin çalışması için yalnızca zorunlu ve tercih çerezleri kullanılır. Üçüncü taraf reklam ve izleme çerezleri devre dışıdır; kişiselleştirilmiş reklam sunulmaz.",
        "store-theme": "Tema tercihlerinizi saklar",
        "remember-language": "Dil seçiminizi hatırlar",
        "session-info": "Oturum bilgilerinizi korur",
        "user-rights": "8. Kullanıcı Hakları",
        "user-rights-content": "Uygulanabilir mevzuat kapsamında kullanıcılarımız aşağıdaki haklara sahiptir:",
        "access-data": "Kişisel verilerinize erişim",
        "correct-data": "Verilerinizin düzeltilmesi",
        "delete-data": "Verilerinizin silinmesi",
        "object-processing": "Veri işlemeye itiraz",
        "children-privacy": "9. Çocukların Gizliliği",
        "children-privacy-content": "Lingoano 13 yaş altına yönelik değildir. 13 yaş altından bilerek veri toplanmaz; yanlışlıkla toplandığının anlaşılması halinde makul süre içinde silinir.",
        "policy-changes": "10. Politika Değişiklikleri",
        "policy-changes-content": "İşbu Gizlilik Politikası zaman zaman güncellenebilir. Esaslı değişikliklerde yürürlük tarihi güncellenir ve makul yöntemlerle bilgilendirme yapılır.",
        "contact": "İletişim",
        "contact-section": "13. İletişim",
        "contactfooter": "İletişim",
        "contact-content": "Bu Gizlilik Politikası hakkında sorularınızı aşağıdaki kanallardan iletebilirsiniz:",
        "privacy-email": "E‑posta: privacy@Lingoano.com",

        // Terms of Service
        "terms-of-service": "Kullanım Şartları",
        "terms-title-page": "Kullanım Şartları - Lingoano",
        "terms-title": "Kullanım Şartları",
        "terms-subtitle": "Platform kullanım kuralları ve şartları",
        "acceptance": "1. Kabul ve Onay",
        "acceptance-content": "Lingoano hizmetlerine erişmek ve bunları kullanmakla, işbu Kullanım Şartları'nı ve atıf yoluyla dahil edilen tüm politika ve aydınlatmaları kabul etmiş sayılırsınız. Şartları kabul etmiyorsanız hizmeti kullanmamalısınız.",
        "service-description": "2. Hizmet Tanımı",
        "service-description-content": "Lingoano; dil pratiği yapmak isteyen kullanıcıları eşleştiren ve iletişim kurmalarını sağlayan bir platformdur. Mümkün olan durumlarda eşler arası (P2P) iletişim tercih edilir. Hizmet olduğu gibi ve mevcut haliyle sunulur.",
        "general-rules": "3.1 Genel Kurallar",
        "general-rules-content": "Hizmet kullanımı sırasında yürürlükteki mevzuata, kamu düzenine ve topluluk kurallarına riayet edilmelidir:",
        "be-respectful": "Saygılı ve kibar olun",
        "follow-laws": "Yasalara uygun davranın",
        "respect-rights": "Başkalarının haklarına saygı gösterin",
        "no-spam": "Spam veya zararlı içerik paylaşmayın",
        "no-threats": "Platform güvenliğini tehdit etmeyin",
        "prohibited-content": "3.2 Yasaklı İçerikler",
        "prohibited-content-content": "Aşağıdaki içerik ve fiiller yasaktır:",
        "hate-speech": "Nefret söylemi ve ayrımcılık",
        "violence": "Şiddet içeren içerik",
        "obscene-material": "Müstehcen veya pornografik materyal",
        "illegal-activities": "Yasadışı faaliyetler",
        "personal-info": "Kişisel bilgilerin paylaşımı",
        "false-info": "Sahte bilgi yayma",
        "terms-privacy-security": "4. Gizlilik ve Güvenlik",
        "terms-privacy-security-content": "Lingoano, kullanıcı gizliliğini ve güvenliğini önceler. Bununla birlikte çevrimiçi güvenliğin sağlanmasında nihai sorumluluk kullanıcıya aittir:",
        "self-responsibility": "Kendi güvenliğinizden siz sorumlusunuz",
        "no-personal-info": "Kişisel bilgilerinizi paylaşmayın",
        "report-suspicious": "Şüpheli davranışları bildirin",
        "support-security": "Platform güvenlik önlemlerini destekleyin",
        "intellectual-property": "5. Fikri Mülkiyet",
        "intellectual-property-content": "Lingoano'ya ait marka, logo, arayüz, yazılım, metin ve görseller ilgili mevzuatla korunur. Yazılı izin alınmadan kopyalanamaz, çoğaltılamaz, dağıtılamaz veya türev eser oluşturulamaz.",
        "service-changes": "6. Hizmette Değişiklik",
        "service-changes-content": "Lingoano, hizmet kapsamını ve işlevlerini zaman zaman güncelleyebilir, askıya alabilir veya durdurabilir. Esaslı değişikliklerde makul bilgilendirme yapılır.",
        "liability-limitation": "7. Sorumluluğun Sınırlandırılması",
        "liability-limitation-content": "Hizmet, olduğu gibi ve mevcut haliyle sunulur. Uygulanabilir mevzuatın izin verdiği azami ölçüde; dolaylı, arızi, özel, cezai veya netice kabilinden doğan zararlar bakımından Lingoano sorumlu tutulamaz.",
        "account-suspension": "8. Askıya Alma ve Sonlandırma",
        "account-suspension-content": "Şartların ihlali halinde erişim kısıtlanabilir, hesap(lar) askıya alınabilir veya sonlandırılabilir. Uyuşmazlıkların çözümü amacıyla gerekli görülen kayıtlar yürürlükteki mevzuata uygun şekilde saklanabilir.",
        "download-windows": "Windows İçin İndir",
        "download-mac": "Mac İçin İndir", 
        "download-linux": "Linux İçin İndir",
        "download-android": "Android İçin İndir",
        "download-ios": "iOS İçin İndir",
        "coming-soon": "Yakında",
        "development-in-progress": "Geliştirme Aşamasında",
        "stay-tuned": "Takipte Kalın",
        
        // Language guides page
        "language-guides-title": "Dil Rehberleri",
        "language-guides-subtitle": "Gramer kuralları, taktikler ve öğrenme rehberleri",
        "english-grammar": "İngilizce Gramer",
        "german-grammar": "Almanca Gramer",
        "spanish-grammar": "İspanyolca Gramer",
        "russian-grammar": "Rusça Gramer",
        "learning-tactics": "Öğrenme Taktikleri",
        "grammar-basics": "Gramer Temelleri",
        
        // About page
        "about-title": "Lingoano Hakkında",
        "about-subtitle": "Dil öğrenme platformu hakkında detaylı bilgi",
        "what-is-Lingoano": "Lingoano Nedir?",
        "Lingoano-description": "Lingoano, dil öğrenmek isteyenler için tasarlanmış modern bir sohbet platformudur.",
        "our-mission": "Misyonumuz",
        "privacy-security": "Gizlilik ve Güvenlik",
        "how-it-works": "Nasıl Çalışır",
        "how-it-works-content": "Lingoano'nın çalışma prensibi oldukça basit ve etkilidir. Platform, sizinle aynı dili öğrenmek isteyen kişilerle sizi eşleştirir ve gerçek konuşma pratiği yapmanızı sağlar.",
        "technology-security": "Teknoloji ve Güvenlik",
        "technology-security-content": "Lingoano, en son teknolojileri kullanarak güvenli ve etkili bir dil öğrenme deneyimi sunar. Platformumuz, kullanıcıların gizliliğini ve güvenliğini en üst düzeyde tutmak için tasarlanmıştır.",
        "community-support": "Topluluk ve Destek",
        "community-support-content": "Lingoano, sadece bir dil öğrenme platformu değil, aynı zamanda dünya çapında dil öğrenenlerin bir araya geldiği bir topluluktur. Kullanıcılarımızın deneyimleri ve geri bildirimleri, platformumuzu sürekli iyileştirmemizi sağlar.",
        
        // Privacy policy page
        "privacy-policy-title": "Gizlilik Politikası",
        "privacy-policy-subtitle": "Kişisel verilerinizin nasıl korunduğu hakkında bilgi",
        "data-collection": "Veri Toplama",
        "data-usage": "Veri Kullanımı",
        "data-protection": "Veri Korunması",
        "your-rights": "Haklarınız",
        // Privacy & Terms detailed keys
        "last-updated": "Son güncelleme: 16 Ağustos 2025",
        "introduction": "1. Giriş",
        "introduction-content": "Lingoano (\"Lingoano\", \"biz\" veya \"Şirket\") olarak kişisel verilerin korunmasını ve gizliliğinizi gözetmeyi taahhüt ederiz. İşbu Gizlilik Politikası, platformumuzu kullandığınızda hangi verilerin işlendiğini, bu verilerin hangi amaçlarla ve hangi hukuki sebeplere dayanarak işlendiğini, saklama sürelerini ve haklarınızı açıklar.",
        "information-collected": "2. Topladığımız Bilgiler",
        "personal-information": "2.1 Kişisel Veriler",
        "personal-information-content": "Lingoano, kural olarak ad, soyad, e‑posta, telefon gibi kimliği belirli veya belirlenebilir gerçek kişiye ilişkin verileri talep etmez ve işlemez.",
        "technical-information": "2.2 Teknik/Çevrimiçi Tanımlayıcılar",
        "technical-information-content": "Hizmetin sunulması, güvenliğinin sağlanması ve performansın iyileştirilmesi amacıyla aşağıda sayılan teknik veriler işlenebilir:",
        "browser-type": "Tarayıcı türü ve sürümü",
        "operating-system": "İşletim sistemi ve cihaz bilgileri",
        "ip-address": "IP adresi (mümkün olduğunda maskeleme/anonimleştirme uygulanır)",
        "page-views": "Kullanım/etkileşim istatistikleri (toplu ve anonim)",
        "use-of-information": "3. Bilgilerin Kullanımı",
        "use-of-information-content": "Toplanan/işlenen bilgiler, meşru menfaatler ile hizmetin ifası kapsamında ve aşağıdaki amaçlarla kullanılır:",
        "improve-platform": "Platform performansını iyileştirmek",
        "resolve-issues": "Teknik sorunları çözmek",
        "enhance-experience": "Kullanıcı deneyimini geliştirmek",
        "ensure-security": "Güvenliği sağlamak",
        "information-sharing": "4. Bilgi Paylaşımı",
        "information-sharing-content": "Lingoano, kullanıcı bilgilerini üçüncü kişilere satmaz ve pazarlama amacıyla paylaşmaz. Yalnızca kanuni yükümlülüklerin yerine getirilmesi ve yetkili makamların usulüne uygun taleplerinin karşılanması kapsamında zorunlu hallerde veri aktarımı yapılabilir.",
        "cookies-tracking": "5. Çerezler ve İzleme",
        "cookies-tracking-content": "Hizmetin çalışması için yalnızca zorunlu ve tercih çerezleri kullanılır. Üçüncü taraf reklam ve izleme çerezleri devre dışıdır.",
        "store-theme": "Tema tercihlerinizi saklar",
        "remember-language": "Dil seçiminizi hatırlar",
        "session-info": "Oturum bilgilerinizi korur",
        "user-rights": "8. Kullanıcı Hakları",
        "user-rights-content": "Uygulanabilir mevzuat kapsamında kullanıcılarımız aşağıdaki haklara sahiptir:",
        "access-data": "Kişisel verilerinize erişim",
        "correct-data": "Verilerinizin düzeltilmesi",
        "delete-data": "Verilerinizin silinmesi",
        "object-processing": "Veri işlemeye itiraz",
        "children-privacy": "9. Çocukların Gizliliği",
        "children-privacy-content": "Lingoano 13 yaş altına yönelik değildir. 13 yaş altından bilerek veri toplanmaz; yanlışlıkla toplandığının anlaşılması halinde makul süre içinde silinir.",
        "policy-changes": "10. Politika Değişiklikleri",
        "policy-changes-content": "İşbu Gizlilik Politikası zaman zaman güncellenebilir. Esaslı değişikliklerde yürürlük tarihi güncellenir ve makul yöntemlerle bilgilendirme yapılır.",
        "contact": "11. İletişim",
        "contact-content": "Bu Gizlilik Politikası hakkında sorularınızı aşağıdaki kanallardan iletebilirsiniz:",
        "privacy-email": "E‑posta: privacy@Lingoano.com",
        
        // Terms detailed keys
        "acceptance": "1. Kabul ve Onay",
        "acceptance-content": "Lingoano hizmetlerine erişmek ve bunları kullanmakla, işbu Kullanım Şartları'nı ve atıf yoluyla dahil edilen tüm politika ve aydınlatmaları kabul etmiş sayılırsınız. Şartları kabul etmiyorsanız hizmeti kullanmamalısınız.",
        "service-description": "2. Hizmet Tanımı",
        "service-description-content": "Lingoano; dil pratiği yapmak isteyen kullanıcıları eşleştiren ve iletişim kurmalarını sağlayan bir platformdur. Mümkün olan durumlarda eşler arası (P2P) iletişim tercih edilir. Hizmet olduğu gibi ve mevcut haliyle sunulur.",
        "general-rules": "3.1 Genel Kurallar",
        "general-rules-content": "Hizmet kullanımı sırasında yürürlükteki mevzuata, kamu düzenine ve topluluk kurallarına riayet edilmelidir:",
        "be-respectful": "Saygılı ve kibar olun",
        "follow-laws": "Yasalara uygun davranın",
        "respect-rights": "Başkalarının haklarına saygı gösterin",
        "no-spam": "Spam veya zararlı içerik paylaşmayın",
        "no-threats": "Platform güvenliğini tehdit etmeyin",
        "prohibited-content": "3.2 Yasaklı İçerikler",
        "prohibited-content-content": "Aşağıdaki içerik ve fiiller yasaktır:",
        "hate-speech": "Nefret söylemi ve ayrımcılık",
        "violence": "Şiddet içeren içerik",
        "obscene-material": "Müstehcen veya pornografik materyal",
        "illegal-activities": "Yasadışı faaliyetler",
        "personal-info": "Kişisel bilgilerin paylaşımı",
        "false-info": "Sahte bilgi yayma",
        "terms-privacy-security": "4. Gizlilik ve Güvenlik",
        "terms-privacy-security-content": "Lingoano, kullanıcı gizliliğini ve güvenliğini önceler. Bununla birlikte çevrimiçi güvenliğin sağlanmasında nihai sorumluluk kullanıcıya aittir:",
        "self-responsibility": "Kendi güvenliğinizden siz sorumlusunuz",
        "no-personal-info": "Kişisel bilgilerinizi paylaşmayın",
        "report-suspicious": "Şüpheli davranışları bildirin",
        "support-security": "Platform güvenlik önlemlerini destekleyin",
        "intellectual-property": "5. Fikri Mülkiyet",
        "intellectual-property-content": "Lingoano'ya ait marka, logo, arayüz, yazılım, metin ve görseller ilgili mevzuatla korunur. Yazılı izin alınmadan kopyalanamaz, çoğaltılamaz, dağıtılamaz veya türev eser oluşturulamaz.",
        "service-changes": "6. Hizmette Değişiklik",
        "service-changes-content": "Lingoano, hizmet kapsamını ve işlevlerini zaman zaman güncelleyebilir, askıya alabilir veya durdurabilir. Esaslı değişikliklerde makul bilgilendirme yapılır.",
        "liability-limitation": "7. Sorumluluğun Sınırlandırılması",
        "liability-limitation-content": "Hizmet, olduğu gibi ve mevcut haliyle sunulur. Uygulanabilir mevzuatın izin verdiği azami ölçüde; dolaylı, arızi, özel, cezai veya netice kabilinden doğan zararlar bakımından Lingoano sorumlu tutulamaz.",
        "account-suspension": "8. Askıya Alma ve Sonlandırma",
        "account-suspension-content": "Şartların ihlali halinde erişim kısıtlanabilir, hesap(lar) askıya alınabilir veya sonlandırılabilir. Uyuşmazlıkların çözümü amacıyla gerekli görülen kayıtlar yürürlükteki mevzuata uygun şekilde saklanabilir.",
        "applicable-law": "10. Uygulanacak Hukuk ve Yetki",
        "applicable-law-content": "İşbu Şartlar, Türkiye Cumhuriyeti hukuku uyarınca yorumlanır ve uygulanır. Uyuşmazlıklarda İstanbul (Merkez) mahkemeleri ve icra daireleri yetkilidir.",
        "terms-email": "E‑posta: terms@Lingoano.com",
        
        // Terms of service page
        "terms-title": "Kullanım Şartları",
        "terms-subtitle": "Platform kullanım kuralları ve şartları",
        "usage-rules": "Kullanım Kuralları",
        "user-responsibilities": "Kullanıcı Sorumlulukları",
        "prohibited-content": "Yasak İçerik",
        "account-termination": "Hesap Sonlandırma",
        
        // Chat page
        "chat-title": "Sohbet",
        "connecting": "Bağlanıyor...",
        "waiting-for-match": "Eşleşme bekleniyor...",
        "connected": "Bağlandı",
        "disconnected": "Bağlantı kesildi",
        "type-message": "Mesajınızı yazın...",
        "partner-left": "Konuşma partneriniz ayrıldı",
        "new-match": "Yeni Eşleşme",
        "leave-chat": "Sohbeti Terk Et",
        
        // Menu items
        "home": "Ana Sayfa",
        "menu": "Menü",
        "close-menu": "Menüyü Kapat",
        
        // Common terms
        "loading": "Yükleniyor...",
        "error": "Hata",
        "success": "Başarılı",
        "warning": "Uyarı",
        "info": "Bilgi",
        "continue": "Devam Et",
        "cancel": "İptal",
        "close": "Kapat",
        "save": "Kaydet",
        "delete": "Sil",
        "edit": "Düzenle",
        "yes": "Evet",
        "no": "Hayır",
        "confirm-leave-chat": "Ana sayfaya dönmek istiyor musunuz? Sohbet sonlanacak.",
        
        // Form options
        "select-option": "Seçiniz",
        
        // Theme options
        "default-theme": "Varsayılan Tema",
        "blue-theme": "Mavi Tema", 
        "purple-theme": "Mor Tema",
        "green-theme": "Yeşil Tema",
        
        // Pages specific
        "platforms": "Bilgisayarlar İçin Platformlar",
        "mobile-platforms": "Mobil Platformlar",
        "windows": "Windows",
        "mac": "Mac",
        "linux": "Linux",
        "android": "Android",
        "ios": "iOS",
        
        // UI Labels
        "menu-toggle-label": "Menüyü aç/kapat",
        "theme-switcher-label": "Tema değiştirici",
        "github-visit": "GitHub profilini ziyaret et",
        "privacy-policy": "Gizlilik Politikası", 
        "terms-of-service": "Kullanım Şartları",
        "donate-button": "BAĞIŞ YAP",
        "buy-me-coffee": "Bana Bir Kahve Al",
        "chat-title-page": "Lingoano Sohbet - Dil Öğrenme Platformu",
        "logo-alt": "Logo",
        "about-title-page": "Lingoano Hakkında - Dil Öğrenme Platformu",
        "download-title-page": "Lingoano İndir - Dil Öğrenme Uygulaması",
        "word-of-day-title-page": "Günün Kelimesi - Lingoano",
        "language-guides-title-page": "Dil Rehberleri - Lingoano",
        "language-learning-guides": "Dil Öğrenme Rehberleri",
        "guides-subtitle": "Gramer kuralları, taktikler ve öğrenme ipuçları",
        "privacy-policy-title-page": "Gizlilik Politikası - Lingoano",
        "terms-title-page": "Kullanım Şartları - Lingoano",
        
        // Language guides content
        "language-learning-guides": "Dil Öğrenme Rehberleri",
        "guides-subtitle": "Gramer kuralları, taktikler ve öğrenme ipuçları",
        "english-tab": "🇺🇸 İngilizce",
        "german-tab": "🇩🇪 Almanca", 
        "spanish-tab": "🇪🇸 İspanyolca",
        "turkish-tab": "🇹🇷 Türkçe",
        "russian-tab": "🇷🇺 Rusça",
        "english": "İngilizce",
        "german": "Almanca", 
        "spanish": "İspanyolca",
        "french": "Fransızca",
        "turkish": "Türkçe",
        "russian": "Rusça",
                
        // Resources Section
        "learning-resources-title": "Öğrenme Kaynakları",
        "resources-mobile-apps-title": "Mobil Uygulamalar",
        "resources-mobile-apps-desc": "Duolingo, Memrise, Babbel gibi uygulamaları kullanın.",
        "resources-video-content-title": "Video İçerikler",
        "resources-video-content-desc": "YouTube'da dil öğrenme kanallarını takip edin.",
        "resources-books-title": "Kitaplar",
        "resources-books-desc": "Gramer kitapları ve hikaye kitapları okuyun.",
        "resources-online-courses-title": "Online Kurslar",
        "resources-online-courses-desc": "Coursera, edX gibi platformlardan yararlanın.",
        
        "descriptiona": "Lingoano tüm cihazlar için bir tuş kadar uzağınızda",
        "description": "Lingoano, dil öğrenmeyi kolaylaştırmak için tasarlanmış yenilikçi bir platformdur. Sizinle aynı dili öğrenmek isteyen kişilerle anonim olarak eşleşmenizi sağlar ve gerçek konuşma pratiği yapmanıza olanak tanır.",
        "learn-content": "Geleneksel dil öğrenme yöntemlerinden farklı olarak, Lingoano gerçek konuşma pratiğine odaklanır. Karmaşık gramer kuralları ve ezberleme yerine, doğal sohbet ortamında dil öğrenmenizi sağlar. Sizinle aynı seviyede olan kişilerle eşleşerek, rahat ve etkili bir öğrenme deneyimi yaşarsınız.",
        "why-content": "Yeni bir dil öğrenmek, sadece yeni kelimeler öğrenmek değil, yeni bir dünya keşfetmektir. Farklı kültürleri anlamak, yeni insanlarla tanışmak ve yepyeni fırsatların kapısını aralamaktır. İster kariyer, ister eğitim, ister sadece kişisel gelişim için olsun, dil becerisi artık herkes için önemli. Lingoano, bu yolculukta size basit ama etkili bir başlangıç noktası sunar.",
        "career-development-content": "İkinci bir dil bilmek, iş dünyasında büyük avantaj sağlar. Uluslararası şirketlerde çalışma imkanı, yurtdışı iş fırsatları ve daha yüksek maaşlar elde edebilirsiniz. Özellikle İngilizce, günümüzde neredeyse her sektörde gerekli bir beceri haline geldi.",
        "cultural-richness-content": "Her dil, kendine özgü bir kültürü ve düşünce tarzını barındırır. Yeni bir dil öğrendiğinizde, o kültürün filmlerini, kitaplarını ve müziğini anlayabilir, farklı perspektiflerden dünyaya bakabilirsiniz.",
        "travel-freedom-content": "Yabancı bir ülkede yerel dili konuşabilmek, seyahat deneyiminizi tamamen değiştirir. Sadece turistik yerleri değil, gerçek yerel deneyimleri yaşayabilir, yeni arkadaşlar edinebilirsiniz.",
        "brain-health-content": "Dil öğrenmek beyninizi aktif tutar ve hafızanızı güçlendirir. Araştırmalar, çok dilli insanların Alzheimer gibi hastalıklara karşı daha dirençli olduğunu gösteriyor.",
        "confidence-content": "Yeni bir dil öğrenmek, kendinize olan güveninizi artırır. Zorlu bir hedefi başardığınızı görmek, hayatınızın diğer alanlarında da daha cesur olmanızı sağlar.",
        "privacy-content": "Lingoano'da gizliliğiniz bizim en önemli önceliğimizdir. Sohbetleriniz merkeziyetsiz IPFS ağı üzerinden gerçekleştirilir, yani mesajlarınız hiçbir sunucuda saklanmaz ve başka kimse tarafından izlenemez. Bu sayede hem sansüre karşı dayanıklı, hem de sizi koruyan bir yapı sunar. Ayrıca veritabanı yükü de olmadığı için sistem sade, hızlı ve güvenlidir.",
        
        // Privacy principles (HTML format for hakkında.html)
        "decentralized-structure": "<strong style='color: var(--accent-color);'>Merkeziyetsiz Yapı:</strong> <span style='color: var(--text-secondary);'>Verileriniz dağıtık ağda iletilir, tek bir merkezi noktada toplanmaz.</span>",
        "censorship-resistance": "<strong style='color: var(--accent-color);'>Sansür Direnci:</strong> <span style='color: var(--text-secondary);'>Hiçbir otorite platformumuzu engelleyemez, her zaman erişilebilir kalır.</span>",
        "full-anonymity": "<strong style='color: var(--accent-color);'>Tam Anonimlik:</strong> <span style='color: var(--text-secondary);'>Kişisel bilgileriniz istenmez, gerçek adınızı paylaşmak zorunda değilsiniz.</span>",
        "minimal-data": "<strong style='color: var(--accent-color);'>Minimal Veri:</strong> <span style='color: var(--text-secondary);'>Sadece gerekli bilgiler tutulur, gereksiz veri toplamayız.</span>",
        "zero-record": "<strong style='color: var(--accent-color);'>Sıfır Kayıt:</strong> <span style='color: var(--text-secondary);'>Sohbetleriniz hiçbir yerde saklanmaz, tamamen geçicidir.</span>",
        
        // Theme translations
        "default-theme": "Varsayılan Tema",
        "blue-theme": "Mavi Tema",
        "purple-theme": "Mor Tema",
        "green-theme": "Yeşil Tema",
        "theme-switcher-label": "Tema değiştirici",
        "menu-toggle-label": "Menüyü aç/kapat",
        
        // Placeholder translations
        "type-message": "Mesajınızı yazın...",
        "guess-input-placeholder": "Tahmininizi yazın...",
        
        // Alt text translations
        "logo-alt": "Lingoano Logo",
        "github-visit": "GitHub profilini ziyaret et",

        // Ana sayfa başlığı
        "home-title": "Lingoano Web",

        // İletişim popup çevirileri
        "contact": "11. İletişim",
        "contactfooter": "İletişim",
        "contact-us": "Bizimle İletişime Geçin",
        "contact-info": "İletişim Bilgileri",
        "contact-email": "E-posta: contact@lingoano.com",
        "contact-description": "Sorularınız, önerileriniz veya geri bildirimleriniz için bizimle iletişime geçebilirsiniz.",
        "contact-response": "Yanıt süresi: 24-48 saat içinde",
        "close": "Kapat",

        // Yeni eklenen çeviri anahtarları - Kullanım Şartları
        "terms-notice": "Bu Kullanım Şartları, Lingoano platformunu kullanırken uymanız gereken kuralları ve koşulları belirler. Platformu kullanarak bu şartları kabul etmiş sayılırsınız.",
        "anonymity-notice": "Lingoano, kullanıcı anonimliğini en üst düzeyde korumayı taahhüt eder. Platform, kişisel kimlik bilgileri talep etmez ve kullanıcıların gerçek kimliklerini paylaşmalarını gerektirmez.",
        "no-harassment": "Diğer kullanıcıları taciz etmeyin",
        "no-impersonation": "Başkalarının kimliğine bürünmeyin",
        "malware": "Zararlı yazılım veya bağlantı paylaşımı",
        "commercial-spam": "Ticari spam ve reklam içerikleri",
        "chat-privacy": "4.1 Sohbet Gizliliği",
        "chat-privacy-content": "Platform üzerinden gerçekleştirilen sohbetlerde gizlilik önceliğimizdir:",
        "no-chat-storage": "Sohbet geçmişi kalıcı olarak saklanmaz",
        "websocket-temporary": "WebSocket protokolü kullanılan sohbetlerde mesajlar geçici olarak işlenir ve kalıcı olarak kaydedilmez",
        "p2p-communication": "Mümkün olduğunda peer-to-peer iletişim tercih edilir",
        "encrypted-transmission": "Mesajlar şifrelenmiş olarak iletilir",
        "session-only": "Sohbet verileri yalnızca oturum süresince geçici olarak tutulur",
        "secure-connection": "Güvenli internet bağlantısı kullanın",
        "dispute-resolution": "12. Uyuşmazlık Çözümü",
        "dispute-resolution-content": "Platform ile ilgili uyuşmazlıklar öncelikle görüşme yoluyla çözülmeye çalışılır. Görüşme ile çözülemeyen uyuşmazlıklar için yasal yollara başvurulabilir. Kullanıcılar, haklarını korumak için gerekli belgeleri saklamalıdır.",
        "response-time": "Yanıt süresi: 48 saat içinde",
        "terms-acceptance-notice": "Platformu kullanmaya devam ederek, bu Kullanım Şartları'nın güncel versiyonunu kabul etmiş sayılırsınız. Şartlarda yapılacak değişiklikler, yayınlandığı tarihten itibaren geçerli olacaktır.",

        // Yeni eklenen çeviri anahtarları - Gizlilik Politikası
        "privacy-notice": "Bu Gizlilik Politikası, Lingoano platformunu kullanırken kişisel verilerinizin nasıl işlendiğini açıklar. Platformu kullanarak bu politikayı kabul etmiş sayılırsınız.",
        "anonymity-commitment": "Lingoano, kullanıcı anonimliğini en üst düzeyde korumayı taahhüt eder. Platform, kişisel kimlik bilgileri talep etmez ve kullanıcıların gerçek kimliklerini paylaşmalarını gerektirmez.",
        "chat-data": "2.3 Sohbet Verileri",
        "chat-data-content": "Platform üzerinden gerçekleştirilen sohbetlerde:",
        "no-permanent-storage": "Mesajlar kalıcı olarak saklanmaz",
        "websocket-temporary": "WebSocket protokolü kullanılan sohbetlerde mesajlar geçici olarak işlenir",
        "session-only-data": "Sohbet verileri yalnızca oturum süresince geçici olarak tutulur",
        "no-chat-logs": "Sohbet logları kalıcı olarak kaydedilmez",
        "p2p-preference": "Mümkün olduğunda peer-to-peer iletişim tercih edilir",
        "session-data": "Oturum verileri (geçici olarak)",
        "preferences": "Kullanıcı tercihleri (tema, dil seçimi)",
        "match-users": "Kullanıcı eşleştirme hizmetini sunmak",
        "analytics": "Platform kullanım analizi (anonim)",
        "essential-cookies": "Zorunlu çerezler hizmet işlevselliği için gereklidir",
        "preference-cookies": "Tercih çerezleri kullanıcı deneyimini iyileştirir",
        "third-party-services": "6 Üçüncü Taraf Hizmet Sağlayıcıları",
        "third-party-services-content": "Platformun şuanki sürümü 3. Taraf Hizmetleri kullanmamaktadır.",
        "access-controls": "Erişim kontrolleri uygulanır",
        "security-audits": "Güvenlik denetimleri yapılır",
        "chat-security": "7.1 Sohbet Güvenliği",
        "chat-security-content": "Sohbet güvenliği için alınan önlemler:",
        "end-to-end-encryption": "Mümkün olduğunda uçtan uca şifreleme",
        "temporary-messages": "Mesajlar geçici olarak işlenir",
        "no-server-storage": "Sunucuda kalıcı mesaj saklanmaz",
        "secure-protocols": "Güvenli protokoller kullanılır",
        "session-timeout": "Oturum zaman aşımı uygulanır",
        "data-retention": "8. Veri Saklama Süreleri",
        "data-retention-content": "Lingoano, minimal veri saklama prensibi ile çalışır:",
        "session-data-retention": "Oturum verileri: Oturum süresince",
        "chat-data-retention": "Sohbet verileri: Oturum süresince (kalıcı saklanmaz)",
        "analytics-retention": "Analitik veriler: 12 ay (anonim)",
        "preferences-retention": "Kullanıcı tercihleri: 2 yıl",
        "log-retention": "Güvenlik logları: 30 gün",
        "legal-retention": "Yasal zorunluluklar: Yasal gereklilik süresince",
        "data-portability": "Veri taşınabilirliği",
        "withdraw-consent": "Rıza geri çekme",
        "complaint-right": "Şikayet hakkı",
        "rights-exercise": "9.1 Hakların Kullanımı",
        "rights-exercise-content": "Haklarınızı kullanmak için:",
        "contact-privacy": "privacy@lingoano.com adresine e-posta gönderin",
        "response-time": "Yanıt süresi: 30 gün içinde",
        "free-service": "Hizmet ücretsizdir",
        "identity-verification": "Kimlik doğrulaması gerekebilir",
        "international-transfers": "11. Uluslararası Veri Aktarımları",
        "international-transfers-content": "Platform, küresel kullanıcılara hizmet vermektedir. Veri aktarımları, uygun güvenlik önlemleri ile gerçekleştirilir. Üçüncü taraf hizmet sağlayıcıları, yeterli koruma seviyesi sağlayan ülkelerde bulunur.",
        "data-protection-officer": "Veri Koruma Sorumlusu: privacy@lingoano.com",
        "privacy-commitment": "Lingoano, kullanıcı gizliliğini korumayı en önemli önceliği olarak görür. Bu politika, şeffaflık ve güven ilkeleri doğrultusunda hazırlanmıştır.",

        // İletişim popup çevirileri
        "contact": "İletişim",
        "contact-us": "Bizimle İletişime Geçin",
        "contact-info": "İletişim Bilgileri",
        "contact-email": "E-posta: contact@lingoano.com",
        "contact-description": "Sorularınız, önerileriniz veya geri bildirimleriniz için bizimle iletişime geçebilirsiniz.",
        "contact-response": "Yanıt süresi: 24-48 saat içinde",
        "close": "Kapat"
    },
    
    en: {
        "wod-streak-msg-1": "💔 You left us once, Igo is still upset.",
        "wod-streak-msg-2": "🎉 Congrats! Igo is proud of your first streak.",
        "wod-streak-msg-3": "🏆🔥 Igo is proud of your streak, well done!",
        "wod-streak-msg-3-special": "🤗🎉 Igo forgives and celebrates you!",
        "change-wod-language": "Change language",
        "decentralized-structure": "<strong style='color: var(--accent-color);'>Decentralized Structure:</strong> <span style='color: var(--text-secondary);'>Your data is transmitted over a distributed network and is not collected in a single central location.</span>",
        "censorship-resistance": "<strong style='color: var(--accent-color);'>Censorship Resistance:</strong> <span style='color: var(--text-secondary);'>No authority can block our platform; it remains accessible at all times.</span>",
        "full-anonymity": "<strong style='color: var(--accent-color);'>Full Anonymity:</strong> <span style='color: var(--text-secondary);'>We do not ask for personal information; you are not required to share your real name.</span>",
        "minimal-data": "<strong style='color: var(--accent-color);'>Minimal Data:</strong> <span style='color: var(--text-secondary);'>Only the necessary information is stored; we do not collect unnecessary data.</span>",
        "zero-record": "<strong style='color: var(--accent-color);'>Zero Record:</strong> <span style='color: var(--text-secondary);'>Your chats are not stored anywhere; they are completely temporary.</span>",
        "default-theme": "Default Theme",
        "blue-theme": "Blue Theme",
        "purple-theme": "Purple Theme",
        "green-theme": "Green Theme",
        "theme-switcher-label": "Theme switcher",
        "menu-toggle-label": "Toggle menu",
        "type-message": "Type your message...",
        "guess-input-placeholder": "Type your guess...",
        "logo-alt": "Lingoano Logo",
        "github-visit": "Visit GitHub profile",
        "home-title": "Lingoano Web",
        
        // İletişim popup çevirileri
        "contact": "Contact",
        "contact-section": "13. Contact",
        "contactfooter": "Contact",
        "contact-us": "Contact Us",
        "contact-info": "Contact Information",
        "contact-email": "Email: contact@lingoano.com",
        "contact-description": "For questions, suggestions or feedback, you can contact us.",
        "contact-response": "Response time: within 24-48 hours",
        "close": "Close",
        "faq-q-free": "Is Lingoano free?",
        "faq-a-free": "Yes. Lingoano is completely free; you don’t pay to chat or learn.",
        "faq-q-login": "Do I need an account or login?",
        "faq-a-login": "No. Lingoano does not require signup or login; you can use it anonymously.",
        "faq-title": "Frequently Asked Questions",
        "faq-q-p2p": "How are messages delivered without passing through a server?",
        "faq-a-p2p-content": "By default, peer‑to‑peer protocols such as IPFS/WebRTC are preferred. These allow messages to be transmitted directly between peers without touching a server. Essentially, a private network is formed between IP addresses and messages flow through that network.",
        "faq-q-udp-vpn": "How does a UDP‑based VPN improve connectivity?",
        "faq-a-udp-vpn-content": "NAT traversal is often restricted by carriers. UDP‑based VPNs like WireGuard or OpenVPN‑UDP can increase P2P/WebRTC success, enabling faster and more reliable peer connections.",
        "faq-q-privacy": "How can I tell if my chat uses a decentralized protocol like IPFS?",
        "faq-a-privacy-content": "Normally the app tries IPFS and WebRTC; if they fail it falls back to WebSocket. In that case the chat is relayed via the server, but no chat logs are stored under any circumstances.",
        "faq-q-vpn-how": "Why Lingoano?",
        "faq-a-vpn-how-content": "Unlike other apps, Lingoano lets you speak with people learning the same language as you. This helps you learn effectively and stay motivated by chatting with real people.",
        
        // Privacy Policy – static translations (complete)
        "last-updated": "Last updated: 26 August 2025",
        "introduction": "1. Introduction",
        "introduction-content": "Lingoano (\"Lingoano\", \"we\" or the \"Company\") is committed to protecting personal data and your privacy. This Privacy Policy explains what data is processed when you use our platform, the purposes and legal bases for processing, retention periods and your rights.",
        "information-collected": "2. Information We Collect",
        "personal-information": "2.1 Personal Data",
        "personal-information-content": "As a rule, Lingoano does not request or process personal data such as name, surname, e‑mail or phone number.",
        "technical-information": "2.2 Technical/Online Identifiers",
        "technical-information-content": "To provide the service, ensure security and improve performance, the following technical data may be processed:",
        "browser-type": "Browser type and version",
        "operating-system": "Operating system and device information",
        "ip-address": "IP address (masked/anonymized where possible)",
        "page-views": "Usage/interaction statistics (aggregated and anonymous)",
        "session-data": "Session data (temporarily)",
        "preferences": "User preferences (theme, language)",
        
        "use-of-information": "3. Use of Information",
        "use-of-information-content": "Collected/processed information is used under legitimate interests and for performance of the service for the following purposes:",
        "improve-platform": "Improve platform performance",
        "resolve-issues": "Resolve technical issues",
        "enhance-experience": "Enhance user experience",
        "ensure-security": "Ensure security",
        "match-users": "Provide user matching service",
        "analytics": "Platform usage analytics (anonymous)",
        
        "information-sharing": "4. Information Sharing",
        "information-sharing-content": "Lingoano does not sell user information to third parties for marketing purposes. Data may be transferred only where necessary to comply with legal obligations and respond to duly authorized requests from competent authorities.",
        
        "cookies-tracking": "5. Cookies and Tracking",
        "cookies-tracking-content": "Only essential and preference cookies are used for service operation. Advertising/tracking cookies are disabled in this release; no personalized ads.",
        "store-theme": "Stores your theme preferences",
        "remember-language": "Remembers your language selection",
        "session-info": "Preserves your session information",
        "essential-cookies": "Essential cookies are required for service functionality",
        "preference-cookies": "Preference cookies improve user experience",
        
        "third-party-services": "6.1 Third-Party Service Providers",
        "third-party-services-content": "The platform may use the following third-party services:",
        "google-analytics": "Google Analytics (anonymous usage analytics)",
        "cdn-services": "CDN services (content delivery)",
        "hosting-services": "Hosting services (platform hosting)",
        
        "chat-data": "2.3 Chat Data",
        "chat-data-content": "For chats conducted on the platform:",
        "no-permanent-storage": "Messages are not stored permanently",
        "session-only-data": "Chat data is retained only for the session temporarily",
        "p2p-preference": "Peer-to-peer communication is preferred where possible",
        
        "data-security": "7. Data Security",
        "data-security-content": "Lingoano implements reasonable technical and organizational measures to ensure data security:",
        "use-ipfs": "Where possible, end‑to‑end/peer‑to‑peer communication (e.g., WebRTC, IPFS) is preferred; otherwise, messages may be temporarily processed over WebSocket",
        "encrypted-communication": "Encryption is used in transit",
        "no-data-storage": "No content storage; mandatory logs are minimal",
        "regular-updates": "Components are regularly updated",
        "access-controls": "Access controls are applied",
        "security-audits": "Security audits are performed",
        
        "chat-security": "7.1 Chat Security",
        "chat-security-content": "Security measures for chat:",
        "end-to-end-encryption": "End-to-end encryption where possible",
        "temporary-messages": "Messages are processed temporarily",
        "no-server-storage": "No permanent message storage on the server",
        "secure-protocols": "Secure protocols are used",
        "session-timeout": "Session timeout is applied",
        
        "data-retention": "8. Data Retention Periods",
        "data-retention-content": "Lingoano follows a minimal data retention principle:",
        "session-data-retention": "Session data: For the duration of the session",
        "chat-data-retention": "Chat data: For the duration of the session (not stored permanently)",
        "analytics-retention": "Analytics data: 12 months (anonymous)",
        "preferences-retention": "User preferences: 2 years",
        "log-retention": "Security logs: 30 days",
        "legal-retention": "Legal obligations: For the legally required period",
        
        "user-rights": "9. User Rights",
        "user-rights-content": "Subject to applicable law, our users have the following rights:",
        "access-data": "Access your personal data",
        "correct-data": "Rectify your data",
        "delete-data": "Delete your data",
        "object-processing": "Object to processing",
        "data-portability": "Data portability",
        "withdraw-consent": "Withdraw consent",
        "complaint-right": "Right to lodge a complaint",
        "rights-exercise": "9.1 Exercising your rights",
        "rights-exercise-content": "To exercise your rights:",
        "contact-privacy": "Send an email to privacy@lingoano.com",
        "response-time": "Response time: within 30 days",
        "free-service": "The service is free of charge",
        "identity-verification": "Identity verification may be required",
        
        "children-privacy": "10. Children’s Privacy",
        "children-privacy-content": "Lingoano is not directed to children under 13. We do not knowingly collect data from children under 13; if inadvertently collected, it will be deleted within a reasonable time.",
        
        "international-transfers": "11. International Data Transfers",
        "international-transfers-content": "We serve global users. Data transfers are carried out with appropriate safeguards. Third-party providers are located in countries ensuring adequate protection.",
        
        "policy-changes": "12. Policy Changes",
        "policy-changes-content": "This Privacy Policy may be updated from time to time. For material changes, the effective date will be updated and reasonable notice provided.",
        
        "contact-content": "For questions regarding this Privacy Policy, you can reach us via:",
        "privacy-email": "E‑mail: privacy@Lingoano.com",
        "data-protection-officer": "Data Protection Officer: privacy@lingoano.com",
        
        // Additional missing translations
        "todays-words": "Today's Words",
        "todays-words-subtitle": "Learn new words every day and improve your language skills",
        "loading-words": "Loading words...",
        "learning-tips": "Word Learning Tips",
        "tip-daily": "Keep a Journal",
        "tip-daily-desc": "Write new words you learn in a notebook and review them regularly.",
        "tip-sentences": "Build Sentences",
        "tip-sentences-desc": "Create your own sentences with each new word and practice.",
        "tip-connect": "Make Connections",
        "tip-connect-desc": "Connect new words with words you already know and strengthen your memory.",
        "tip-audio": "Learn with Audio",
        "tip-audio-desc": "Learn to pronounce the word correctly and repeat it out loud.",
        
        "footer": "Your privacy is our priority. Communicate freely with Lingoano",

        "privacy-features": "Our Privacy Features",
        "terminal1": " No message history is stored",
        "terminal2": "> Chats do not pass through the server (in the default protocol)",
        "terminal3": "> User information is neither requested nor stored",
        "terminal4": "> Anyone can review the code",
        "terminal5": "> Our goal: to take both learning and security seriously",

        "terminal": "Our Security Features",
        "benefits": "Benefits of Language Learning",
        "career-development": "Career Development",
        "why": "Why You Should Learn a Language",
        "privacy": "Privacy and Security",
        "privacy-principles": "Our Privacy Principles",
        "p2p-fallback-disclaimer": "When P2P is not possible, WebSocket is used for temporary server relaying; no persistent logs are kept.",
        "udp-vpn-tip-inline": "Using a UDP‑based VPN (WireGuard, OpenVPN‑UDP) can improve P2P success rates.",

        "decentralized-structure-title": "Decentralized Structure:",
        "decentralized-structure-desc": "Your data is transmitted over a distributed network and is not collected in a single central location.",
        "censorship-resistance-title": "Censorship Resistance:",
        "censorship-resistance-desc": "No authority can block our platform; it remains accessible at all times.",
        "full-anonymity-title": "Full Anonymity:",
        "full-anonymity-desc": "We do not ask for your personal information; you are not required to share your real name.",
        "minimal-data-title": "Minimal Data:",
        "minimal-data-desc": "Only the necessary information is stored; we do not collect unnecessary data.",
        "zero-record-title": "Zero Record:",
        "zero-record-desc": "Your chats are not stored anywhere; they are completely temporary.",

        "how-it-works": "How It Works",
        "how-it-works-content": "Lingoano's operating principle is simple and effective. The platform matches you with people who want to learn the same language and lets you practice real conversations.",
        "step-by-step-process": "Step-by-Step Process",
        "step-1": "1. Select Language and Level",
        "step-1-content": "Choose the language you want to learn and your current level. All levels from A1 to B2+ are supported, so you will be matched with people at the same level as you.",
        "step-2": "2. Automatic Matching",
        "step-2-content": "The system automatically matches you with users who want to learn the same language and have a similar level, ensuring a comfortable and effective learning experience.",
        "step-3": "3. Secure Chat",
        "step-3-content": "Thanks to IPFS technology, your chats are completely secure and anonymous. Your messages are not stored on any server and cannot be monitored by anyone.",
        "step-4": "4. Continuous Learning",
        "step-4-content": "Each conversation is a new opportunity to improve your language skills. By talking to different people, you expand your vocabulary and improve your pronunciation.",
        "technology-security": "Technology and Security",
        "technology-security-content": "Lingoano uses the latest technologies to provide a secure and effective language learning experience. Our platform is designed to maximize user privacy and security.",
        "technologies-we-use": "Technologies We Use",
        "ipfs-title": "IPFS (InterPlanetary File System)",
        "ipfs-content": "By using a decentralized file system, it ensures your messages are never stored on any server. This technology creates a censorship-resistant and secure communication environment.",
        "webrtc-title": "WebRTC",
        "webrtc-content": "WebRTC technology is used for direct peer-to-peer communication, ensuring your messages reach the other party without passing through third-party servers.",
        "open-source-title": "Open Source Code",
        "open-source-content": "All our code is published as open source, allowing security experts and developers to review and verify our security.",
        "user": "User Experiences:",
        "testimonials-emir": "\"Thanks to Lingoano, I overcame my fear of speaking English. Now I can comfortably chat with my foreign friends.\"",
        "testimonials-privacy": "\"I had concerns about privacy, but thanks to IPFS I can use it with confidence.\"",
        "testimonials-effective": "\"Matching with people at my level made my learning process much more effective.\"",
        "testimonials-dr-basak": "\"Centering real speaking practice in language learning is a pedagogically strong approach.\"",


        // Navigation
        "chat": "Chat",
        "about": "About Lingoano",
        "word-of-day": "Word of Day",
        "language-guides": "Language Guides",
        "download": "Download",
        
        // Main page
        "meet": "Lingoano Web",
        "learn": "Start learning a new language today!",
        "status-content": "Lingoano web version makes language learning easier! No need to download an app, start practicing immediately through your browser. Our smart matching system connects you with users who have similar goals and levels.",
        "why-Lingoano": "Why Choose Lingoano Web?",
        "footer": "Start learning languages today with Lingoano in a real practice environment",
        "donate": "Support Lingoano",
        "donate-content": "If you want to support this application in development, you can support it from the \"Buy Me A Coffee\" page",
        
        // Form labels
        "select-language": "Language you want to speak:",
        "select-level": "Your level in this language:",
        "select-placeholder": "Select",
        "search-match": "Search Match",
        
        // Language options
        "english": "English",
        "turkish": "Turkish",
        "german": "German",
        "french": "French",
        "spanish": "Spanish",
        "russian": "Russian",
        
        // Level options
        "level-a1": "A1 (Beginner)",
        "level-a2": "A2 (Elementary)",
        "level-b1": "B1 (Intermediate)",
        "level-b2": "B2+ (Advanced)",
        
        // Features list
        "feature-browser": "Browser access - you can use it from any device",
        "feature-matching": "Level-based matching - you talk with people at the same level as you",
        "feature-anonymous": "Anonymous chat system - you can practice comfortably while keeping your identity hidden",
        "feature-multilingual": "Multi-language support - English, Turkish, German, French, Spanish, Russian",
        "feature-mobile": "Mobile-friendly interface - you can use it comfortably from your phone",
        "feature-free": "Completely free - Learn languages without paying any fee",
        
        // Why learn section
        "why-learn-title": "Why You Should Learn Languages",
        "why-learn-subtitle": "Learning a language is not just about learning new words, it's about discovering a new world. Here are a few reasons why you should learn languages:",
        "career-opportunities": "Career Opportunities",
        "career-description": "Knowing a second language provides great advantages in the business world. You can work in international companies, find job opportunities abroad, and earn higher salaries.",
        "cultural-richness": "Cultural Richness",
        "cultural-description": "Each language contains its own unique culture and way of thinking. When you learn a new language, you can understand the films, books, and music of that culture.",
        "travel-freedom": "Travel Freedom",
        "travel-description": "Being able to speak the local language in a foreign country completely changes your travel experience. You can experience not just tourist places, but real local experiences.",
        "brain-health": "Brain Health",
        "brain-description": "Learning languages keeps your brain active and strengthens your memory. Research shows that multilingual people are more resistant to diseases like Alzheimer's.",
        "confidence": "Confidence and Self-Esteem",
        "confidence-description": "Learning a new language increases your self-confidence. Seeing that you've achieved a challenging goal makes you more courageous in other areas of your life.",
        "social-connections": "Social Connections",
        "social-description": "Language is one of the most powerful tools that connects people. When you learn a new language, you can communicate with people from different parts of the world.",
        
        // Dictionary widget
        "dictionary": "Dictionary",
        "search-placeholder": "Search for words...",
        "popular-words": "Popular Words",
        "word-not-found": "Word not found",
        
        // Language detection
        "detecting-language": "Detecting language...",
        
        // Chat page
        "send": "Send",
        "ipfs-chat-started": "Connected to IPFS. Chat started.",
        "ipfs-connection-failed": "Failed to connect to IPFS. Please check your network.",
        "connection-error-placeholder": "Connection error",
        "websocket-connected": "Connected to WebSocket. You can now send messages!",
        "demo-mode-type-message": "Demo mode - Type your message...",
        "websocket-demo-mode": "WebSocket connection failed. Demo mode enabled.",
        "matching-search-started": "🔍 Match search started! Looking for a suitable partner for you...",
        "searching-match-button": "Searching for a match...",
        "waiting-match-button": "Waiting for a match...",
        "matching-waiting": "⏳ Waiting for a match... Looking for another user.",
        "matched-redirecting-button": "Match found! Redirecting...",
        "matching-found-notification": "🎉 Match found! Redirecting to chat page...",
        "matching-error": "❌ Matching error",
        "peer-disconnected-notification": "⚠️ The matched user disconnected. Please try again.",
        "server-connection-failed": "🔌 Could not connect to the server. Please make sure the server is running.",
        "select-language-level": "Please select a language and level.",
        
        // Word of day page
        "todays-words": "Today's Words",
        "todays-words-subtitle": "Learn new words every day and improve your language skills",
        "loading-words": "Loading words...",
        "learning-tips": "Word Learning Tips",
        "tip-daily": "Keep a Diary",
        "tip-daily-desc": "Write new words you learn in a notebook and review them regularly.",
        "tip-sentences": "Make Sentences",
        "tip-sentences-desc": "Create your own sentences for each new word and practice.",
        "tip-connect": "Make Connections",
        "tip-connect-desc": "Connect new words with words you know and strengthen your memory.",
        "tip-audio": "Learn with Audio",
        "tip-audio-desc": "Learn to pronounce words correctly and repeat them aloud.",
        
        // Download page
        "download-title": "Download Lingoano",
        "download-subtitle": "Download the language learning platform for all your devices",
        "download-windows": "Download for Windows",
        "download-mac": "Download for Mac",
        "download-linux": "Download for Linux",
        "download-android": "Download for Android",
        "download-ios": "Download for iOS",
        "coming-soon": "Coming Soon",
        "development-in-progress": "In Development",
        "stay-tuned": "Stay Tuned",
        
        // Language guides page
        "language-guides-title": "Language Guides",
        "language-guides-subtitle": "Grammar rules, tactics and learning guides",
        "english-grammar": "English Grammar",
        "german-grammar": "German Grammar",
        "spanish-grammar": "Spanish Grammar",
        "russian-grammar": "Russian Grammar",
        "learning-tactics": "Learning Tactics",
        "grammar-basics": "Grammar Basics",
        
        // About page
        "about-title": "About Lingoano",
        "about-subtitle": "Detailed information about the language learning platform",
        "what-is-Lingoano": "What is Lingoano?",
        "Lingoano-description": "Lingoano is a modern chat platform designed for those who want to learn languages.",
        "our-mission": "Our Mission",
        "privacy-security": "Privacy and Security",
        "how-it-works": "How It Works?",
        "how-it-works-content": "Lingoano's working principle is quite simple and effective. The platform matches you with people who want to learn the same language and allows you to practice real-world conversations.",
        "technology-security": "Technology and Security",
        "technology-security-content": "Lingoano uses the latest technologies to provide a secure and effective language learning experience. Our platform is designed to protect user privacy and security at the highest level.",
        "community-support": "Community and Support",
        "community-support-content": "Lingoano is not just a language learning platform, but also a community where language learners come together. Our users' experiences and feedback help us continuously improve the platform.",
        
        // Privacy policy page
        "privacy-policy-title": "Privacy Policy",
        "privacy-policy-subtitle": "Information about how your personal data is protected",
        "data-collection": "Data Collection",
        "data-usage": "Data Usage",
        "data-protection": "Data Protection",
        "your-rights": "Your Rights",
        
        // Privacy & Terms detailed keys
        "last-updated": "Last updated: August 16, 2025",
        "introduction": "1. Introduction",
        "introduction-content": "At Lingoano (\"Lingoano\", \"we\" or the \"Company\"), we are committed to protecting personal data and your privacy. This Privacy Policy explains what data is processed when you use our platform, the purposes and legal bases for processing, retention periods, and your rights.",
        "information-collected": "2. Information We Collect",
        "personal-information": "2.1 Personal Data",
        "personal-information-content": "As a rule, Lingoano does not request or process personal data such as name, surname, email, or phone number.",
        "technical-information": "2.2 Technical/Online Identifiers",
        "technical-information-content": "To provide the service, ensure security, and improve performance, the following technical data may be processed:",
        "browser-type": "Browser type and version",
        "operating-system": "Operating system and device information",
        "ip-address": "IP address (masking/anonymization applied where possible)",
        "page-views": "Usage/interaction statistics (aggregated and anonymous)",
        "use-of-information": "3. Use of Information",
        "use-of-information-content": "Data collected/processed is used under legitimate interests and for the performance of the service for the following purposes:",
        "improve-platform": "Improve platform performance",
        "resolve-issues": "Resolve technical issues",
        "enhance-experience": "Enhance the user experience",
        "ensure-security": "Ensure security",
        "information-sharing": "4. Information Sharing",
        "information-sharing-content": "Lingoano does not sell or share user information for marketing purposes. Data may be disclosed only where necessary to comply with legal obligations and to respond to duly authorized requests of competent authorities.",
        "cookies-tracking": "5. Cookies and Tracking",
        "cookies-tracking-content": "Essential and preference cookies may be used to operate the service. Advertising and measurement cookies may be enabled by third-party providers (e.g., Google AdSense) in compliance with applicable laws.",
        "store-theme": "Stores your theme preferences",
        "remember-language": "Remembers your language selection",
        "session-info": "Preserves your session information",
        "user-rights": "8. User Rights",
        "user-rights-content": "Subject to applicable law, users have the following rights:",
        "access-data": "Access your personal data",
        "correct-data": "Rectify your data",
        "delete-data": "Delete your data",
        "object-processing": "Object to processing",
        "children-privacy": "9. Children's Privacy",
        "children-privacy-content": "Lingoano is not directed to persons under 13. We do not knowingly collect data from children under 13; if collected inadvertently, it will be deleted within a reasonable time.",
        "policy-changes": "10. Policy Changes",
        "policy-changes-content": "This Privacy Policy may be updated from time to time. For material changes, the effective date will be updated and reasonable notice will be provided.",
        "contact": "11. Contact",
        "contact-content": "For questions about this Privacy Policy, you can contact us via:",
        "privacy-email": "Email: privacy@Lingoano.com",
        
        // Terms detailed keys
        "acceptance": "1. Acceptance and Consent",
        "acceptance-content": "By accessing and using Lingoano's services, you agree to these Terms of Service and all policies and notices incorporated by reference. If you do not agree, you should not use the service.",
        "service-description": "2. Service Description",
        "service-description-content": "Lingoano is a platform that matches users who want to practice languages and enables communication. Peer‑to‑peer (P2P) communication is preferred where feasible. The service is provided \"as is\" and \"as available\".",
        "general-rules": "3.1 General Rules",
        "general-rules-content": "During use of the service, you must comply with applicable laws, public order, and community rules:",
        "be-respectful": "Be respectful and courteous",
        "follow-laws": "Comply with laws",
        "respect-rights": "Respect the rights of others",
        "no-spam": "Do not share spam or harmful content",
        "no-threats": "Do not threaten platform security",
        "prohibited-content": "3.2 Prohibited Content",
        "prohibited-content-content": "The following content and acts are prohibited:",
        "hate-speech": "Hate speech and discrimination",
        "violence": "Violent content",
        "obscene-material": "Obscene or pornographic material",
        "illegal-activities": "Illegal activities",
        "personal-info": "Sharing personal information",
        "false-info": "Spreading false information",
        "terms-privacy-security": "4. Privacy and Security",
        "terms-privacy-security-content": "Lingoano prioritizes user privacy and security. However, the user bears ultimate responsibility for maintaining online safety:",
        "self-responsibility": "You are responsible for your own safety",
        "no-personal-info": "Do not share your personal information",
        "report-suspicious": "Report suspicious behavior",
        "support-security": "Support platform security measures",
        "intellectual-property": "5. Intellectual Property",
        "intellectual-property-content": "Lingoano's trademarks, logos, interface, software, texts, and visuals are protected by applicable laws. Without written permission, they may not be copied, reproduced, distributed, or used to create derivative works.",
        "service-changes": "6. Changes to the Service",
        "service-changes-content": "Lingoano may update, suspend, or discontinue the scope and functions of the service from time to time. Reasonable notice will be provided for material changes.",
        "liability-limitation": "7. Limitation of Liability",
        "liability-limitation-content": "The service is provided on an \"as is\" and \"as available\" basis. To the maximum extent permitted by law, Lingoano shall not be liable for indirect, incidental, special, punitive, or consequential damages.",
        "account-suspension": "8. Suspension and Termination",
        "account-suspension-content": "In case of violation of the Terms, access may be restricted, and account(s) may be suspended or terminated. Records necessary for dispute resolution may be retained in compliance with applicable laws.",
        "applicable-law": "10. Governing Law and Jurisdiction",
        "applicable-law-content": "These Terms are governed by and construed in accordance with the laws of the Republic of Turkey. Courts and enforcement offices of Istanbul (Central) shall have jurisdiction over disputes.",
        "terms-email": "Email: terms@Lingoano.com",
        
        // Terms of service page
        "terms-title": "Terms of Service",
        "terms-subtitle": "Platform usage rules and conditions",
        "usage-rules": "Usage Rules",
        "user-responsibilities": "User Responsibilities",
        "prohibited-content": "Prohibited Content",
        "account-termination": "Account Termination",
        // Chat page
        "chat-title": "Chat",
        "connecting": "Connecting...",
        "waiting-for-match": "Waiting for match...",
        "connected": "Connected",
        "disconnected": "Disconnected",
        "type-message": "Type your message...",
        "partner-left": "Your chat partner left",
        "new-match": "New Match",
        "leave-chat": "Leave Chat",
        
        // Menu items
        "home": "Home",
        "menu": "Menu",
        "close-menu": "Close Menu",
        
        // Common terms
        "loading": "Loading...",
        "error": "Error",
        "success": "Success",
        "warning": "Warning",
        "info": "Info",
        "continue": "Continue",
        "cancel": "Cancel",
        "close": "Close",
        "save": "Save",
        "delete": "Delete",
        "edit": "Edit",
        "yes": "Yes",
        "no": "No",
        "confirm-leave-chat": "Do you want to return to the home page? The chat will end.",
        
        // Form options
        "select-option": "Select",
        
        // Theme options
        "default-theme": "Default Theme",
        "blue-theme": "Blue Theme",
        "purple-theme": "Purple Theme", 
        "green-theme": "Green Theme",
        
        // Pages specific
        "platforms": "Desktop Platforms",
        "mobile-platforms": "Mobile Platforms",
        "windows": "Windows",
        "mac": "Mac",
        "linux": "Linux",
        "android": "Android",
        "ios": "iOS",
        
        // UI Labels
        "menu-toggle-label": "Open/close menu",
        "theme-switcher-label": "Theme switcher",
        "github-visit": "Visit GitHub profile",
        "privacy-policy": "Privacy Policy", 
        "terms-of-service": "Terms of Service",
        "donate-button": "DONATE",
        "buy-me-coffee": "Buy Me a Coffee",
        "chat-title-page": "Lingoano Chat - Language Learning Platform",
        "logo-alt": "Logo",
        "about-title-page": "About Lingoano - Language Learning Platform",
        "download-title-page": "Download Lingoano - Language Learning App",
        "word-of-day-title-page": "Word of the Day - Lingoano",
        "language-guides-title-page": "Language Guides - Lingoano",
        "language-learning-guides": "Language Learning Guides",
        "guides-subtitle": "Grammar rules, tactics and learning tips",
        "privacy-policy-title-page": "Privacy Policy - Lingoano",
        "terms-title-page": "Terms of Service - Lingoano",
        
        // Language guides content  
        "language-learning-guides": "Language Learning Guides",
        "guides-subtitle": "Grammar rules, tactics and learning tips",
        "english-tab": "🇺🇸 English",
        "german-tab": "🇩🇪 German",
        "spanish-tab": "🇪🇸 Spanish",
        "turkish-tab": "🇹🇷 Turkish", 
        "russian-tab": "🇷🇺 Russian",
        "english": "English",
        "german": "German", 
        "spanish": "Spanish",
        "french": "French",
        "turkish": "Turkish",
        "russian": "Russian",
        
        // English grammar section
        "english-grammar-basics": "English Grammar Basics",
        "present-simple-title": "Present Simple",
        "present-simple-explanation": "Used for general facts, habits and regular actions. Third person singular takes -s ending.",
        "present-continuous-title": "Present Continuous",
        "present-continuous-explanation": "Used for ongoing actions now and future plans. Be + V-ing structure.",
        "past-simple-title": "Past Simple", 
        "past-simple-explanation": "Used for completed actions in the past. Regular verbs take -ed, irregulars change.",
        "present-perfect-title": "Present Perfect",
        "present-perfect-explanation": "For actions that started in the past and continue to now or have ongoing effects.",
        "future-tenses-title": "Future Tenses",
        "future-tenses-explanation": "Will (uncertain future), going to (planned future), Present Continuous (near future).",
        "conditionals-title": "Conditionals",
        "conditionals-explanation": "If clauses: 0 (general facts), 1 (possible future), 2 (hypothetical present), 3 (hypothetical past).",
        
        // Resources Section
        "learning-resources-title": "Learning Resources",
        "resources-mobile-apps-title": "Mobile Apps",
        "resources-mobile-apps-desc": "Use apps like Duolingo, Memrise, Babbel.",
        "resources-video-content-title": "Video Content",
        "resources-video-content-desc": "Follow language learning channels on YouTube.",
        "resources-books-title": "Books",
        "resources-books-desc": "Read grammar books and story books.",
        "resources-online-courses-title": "Online Courses",
        "resources-online-courses-desc": "Benefit from platforms like Coursera, edX.",

        "descriptiona": "Lingoano is just a button aay for all your devices",
        "description": "Lingoano is a modern chat platform designed for those who want to learn languages. It allows you to practice language in a real-world conversational environment with people who share the same language goal. The platform is designed to make language learning easy and enjoyable.",
        "learn-content": "Unlike traditional language learning methods, Lingoano focuses on real-world conversational practice. It provides a natural language environment where you can learn at your own pace, while interacting with people at the same level. This allows you to practice in a comfortable and effective way.",
        "why-content": "Learning a new language is not just about learning new words; it's about discovering a new world. Understanding different cultures, meeting new people, and experiencing new opportunities are all part of the journey. Whether you're interested in a career, education, or personal growth, language skills are becoming increasingly important for everyone. Lingoano offers a simple yet effective starting point for your language learning journey.",
        "career-development-content": "Knowing a second language provides great advantages in the business world. You can work in international companies, find job opportunities abroad, and earn higher salaries. English, in particular, is almost essential in today's global economy.",
        "cultural-richness-content": "Each language contains its own unique culture and way of thinking. When you learn a new language, you can understand the films, books, and music of that culture. This allows you to appreciate different perspectives and broaden your understanding of the world.",
        "travel-freedom-content": "Being able to speak the local language in a foreign country completely changes your travel experience. You can experience not just tourist places, but real local experiences. This allows you to connect with locals and make new friends along the way.",
        "brain-health-content": "Learning languages keeps your brain active and strengthens your memory. Research shows that multilingual people are more resistant to diseases like Alzheimer's.",
        "confidence-content": "Learning a new language increases your self-confidence. Seeing that you've achieved a challenging goal makes you more courageous in other areas of your life.",
        "privacy-content": "Your privacy is our top priority. Messages are stored on a decentralized IPFS network, meaning they are not stored on any server and cannot be monitored by anyone else. This makes the platform both censorship-resistant and secure.",

        // New translation keys - Terms of Service
        "terms-notice": "These Terms of Service define the rules and conditions you must follow when using the Lingoano platform. By using the platform, you are deemed to have accepted these terms.",
        "anonymity-notice": "Lingoano is committed to protecting user anonymity at the highest level. The platform does not request personal identification information and does not require users to share their real identities.",
        "no-harassment": "Do not harass other users",
        "no-impersonation": "Do not impersonate others",
        "malware": "Sharing malicious software or links",
        "commercial-spam": "Commercial spam and advertising content",
        "chat-privacy": "4.1 Chat Privacy",
        "chat-privacy-content": "Privacy is our priority in chats conducted through the platform:",
        "no-chat-storage": "Chat history is not permanently stored",
        "websocket-temporary": "In chats using WebSocket protocol, messages are processed temporarily and not permanently recorded",
        "p2p-communication": "Peer-to-peer communication is preferred when possible",
        "encrypted-transmission": "Messages are transmitted encrypted",
        "session-only": "Chat data is only temporarily held during the session",
        "secure-connection": "Use secure internet connection",
        "dispute-resolution": "12. Dispute Resolution",
        "dispute-resolution-content": "Disputes related to the platform are primarily resolved through negotiation. For disputes that cannot be resolved through negotiation, legal remedies may be pursued. Users should keep necessary documents to protect their rights.",
        "response-time": "Response time: within 48 hours",
        "terms-acceptance-notice": "By continuing to use the platform, you are deemed to have accepted the current version of these Terms of Service. Changes to the terms will be effective from the date of publication.",

        // New translation keys - Privacy Policy
        "privacy-notice": "This Privacy Policy explains how your personal data is processed when using the Lingoano platform. By using the platform, you are deemed to have accepted this policy.",
        "anonymity-commitment": "Lingoano is committed to protecting user anonymity at the highest level. The platform does not request personal identification information and does not require users to share their real identities.",
        "chat-data": "2.3 Chat Data",
        "chat-data-content": "In chats conducted through the platform:",
        "no-permanent-storage": "Messages are not permanently stored",
        "websocket-temporary": "In chats using WebSocket protocol, messages are processed temporarily",
        "session-only-data": "Chat data is only temporarily held during the session",
        "no-chat-logs": "Chat logs are not permanently recorded",
        "p2p-preference": "Peer-to-peer communication is preferred when possible",
        "session-data": "Session data (temporarily)",
        "preferences": "User preferences (theme, language selection)",
        "match-users": "Provide user matching service",
        "analytics": "Platform usage analysis (anonymous)",
        "essential-cookies": "Essential cookies are required for service functionality",
        "preference-cookies": "Preference cookies improve user experience",
        "third-party-services": "6.1 Third-Party Service Providers",
        "third-party-services-content": "The platform may use the following third-party services:",
        "google-analytics": "Google Analytics (anonymous usage analysis)",
        "cdn-services": "CDN services (content distribution)",
        "hosting-services": "Hosting services (platform hosting)",
        "access-controls": "Access controls are implemented",
        "security-audits": "Security audits are conducted",
        "chat-security": "7.1 Chat Security",
        "chat-security-content": "Security measures taken for chat security:",
        "end-to-end-encryption": "End-to-end encryption when possible",
        "temporary-messages": "Messages are processed temporarily",
        "no-server-storage": "Messages are not permanently stored on the server",
        "secure-protocols": "Secure protocols are used",
        "session-timeout": "Session timeout is applied",
        "data-retention": "8. Data Retention Periods",
        "data-retention-content": "Lingoano operates on the principle of minimal data retention:",
        "session-data-retention": "Session data: During session",
        "chat-data-retention": "Chat data: During session (not permanently stored)",
        "analytics-retention": "Analytics data: 12 months (anonymous)",
        "preferences-retention": "User preferences: 2 years",
        "log-retention": "Security logs: 30 days",
        "legal-retention": "Legal obligations: For the duration of legal requirement",
        "data-portability": "Data portability",
        "withdraw-consent": "Withdraw consent",
        "complaint-right": "Right to complain",
        "rights-exercise": "9.1 Exercising Rights",
        "rights-exercise-content": "To exercise your rights:",
        "contact-privacy": "Send email to privacy@lingoano.com",
        "response-time": "Response time: within 30 days",
        "free-service": "Service is free",
        "identity-verification": "Identity verification may be required",
        "international-transfers": "11. International Data Transfers",
        "international-transfers-content": "The platform serves global users. Data transfers are carried out with appropriate security measures. Third-party service providers are located in countries that provide adequate protection levels.",
        "data-protection-officer": "Data Protection Officer: privacy@lingoano.com",
        "privacy-commitment": "Lingoano considers protecting user privacy as its most important priority. This policy is prepared in accordance with transparency and trust principles.",

        // Contact popup translations
        "contact": "Contact",
        "contact-us": "Contact Us",
        "contact-info": "Contact Information",
        "contact-email": "Email: contact@lingoano.com",
        "contact-description": "You can contact us for your questions, suggestions or feedback.",
        "contact-response": "Response time: within 24-48 hours",
        "close": "Close"
    },
    
    de: {
        "wod-streak-msg-1": "💔 Du hast uns einmal verlassen, Igo ist noch traurig.",
        "wod-streak-msg-2": "🎉 Glückwunsch! Igo ist stolz auf deinen ersten Streak.",
        "wod-streak-msg-3": "🏆🔥 Igo ist stolz auf deinen Streak, gut gemacht!",
        "wod-streak-msg-3-special": "🤗🎉 Igo verzeiht dir und feiert dich!",
        "change-wod-language": "Sprache ändern",
        "decentralized-structure": "<strong style='color: var(--accent-color);'>Dezentrale Struktur:</strong> <span style='color: var(--text-secondary);'>Ihre Daten werden über ein verteiltes Netzwerk übertragen und nicht an einem einzigen zentralen Ort gesammelt.</span>",
        "censorship-resistance": "<strong style='color: var(--accent-color);'>Zensurresistenz:</strong> <span style='color: var(--text-secondary);'>Keine Behörde kann unsere Plattform blockieren; sie bleibt jederzeit zugänglich.</span>",
        "full-anonymity": "<strong style='color: var(--accent-color);'>Volle Anonymität:</strong> <span style='color: var(--text-secondary);'>Wir fragen nicht nach persönlichen Daten; Sie müssen nicht Ihren echten Namen angeben.</span>",
        "minimal-data": "<strong style='color: var(--accent-color);'>Minimale Daten:</strong> <span style='color: var(--text-secondary);'>Es werden nur die notwendigen Informationen gespeichert; wir sammeln keine unnötigen Daten.</span>",
        "zero-record": "<strong style='color: var(--accent-color);'>Keine Aufzeichnung:</strong> <span style='color: var(--text-secondary);'>Ihre Chats werden nirgendwo gespeichert; sie sind vollständig temporär.</span>",
        "default-theme": "Standard-Theme",
        "blue-theme": "Blaues Theme",
        "purple-theme": "Lila Theme",
        "green-theme": "Grünes Theme",
        "theme-switcher-label": "Theme-Wechsler",
        "menu-toggle-label": "Menü umschalten",
        "type-message": "Geben Sie Ihre Nachricht ein...",
        "guess-input-placeholder": "Geben Sie Ihre Vermutung ein...",
        "logo-alt": "Lingoano Logo",
        "github-visit": "GitHub-Profil besuchen",
        "home-title": "Lingoano Web",
        "contact": "11. Kontakt",
        "contactfooter": "Kontakt",
        "contact-us": "Kontaktieren Sie uns",
        "contact-info": "Kontaktinformationen",
        "contact-email": "Email: iletisim@liguana.com",
        "contact-description": "Für Fragen, Vorschläge oder Feedback können Sie uns kontaktieren.",
        "contact-response": "Antwortzeit: innerhalb von 24-48 Stunden",
        "close": "Schließen",
        "faq-q-free": "Ist Lingoano kostenlos?",
        "faq-a-free": "Ja. Lingoano ist komplett kostenlos; Sie zahlen nichts fürs Chatten oder Lernen.",
        "faq-q-login": "Benötige ich ein Konto oder einen Login?",
        "faq-a-login": "Nein. Lingoano erfordert keine Registrierung oder Anmeldung; Sie können es anonym nutzen.",
        "faq-title": "Häufig gestellte Fragen",
        "faq-q-p2p": "Wie werden Nachrichten ohne Serverübertragung zugestellt?",
        "faq-a-p2p-content": "Standardmäßig werden Peer‑to‑Peer‑Protokolle wie IPFS/WebRTC bevorzugt. Sie ermöglichen die direkte Übertragung von Nachrichten zwischen Peers, ohne einen Server zu berühren. Im Kern entsteht ein privates Netzwerk zwischen IP‑Adressen, über das die Nachrichten fließen.",
        "faq-q-udp-vpn": "Wie verbessert ein UDP‑basiertes VPN die Konnektivität?",
        "faq-a-udp-vpn-content": "NAT‑Traversal wird häufig von Netzbetreibern eingeschränkt. UDP‑basierte VPNs wie WireGuard oder OpenVPN‑UDP können die Erfolgsquote von P2P/WebRTC erhöhen und schnellere, stabilere Peer‑Verbindungen ermöglichen.",
        "faq-q-privacy": "Woran erkenne ich, ob mein Chat ein dezentrales Protokoll wie IPFS nutzt?",
        "faq-a-privacy-content": "Normalerweise versucht die App IPFS und WebRTC; schlagen sie fehl, erfolgt ein Fallback auf WebSocket. Dann wird der Chat über den Server weitergeleitet, aber es werden keine Chat‑Protokolle gespeichert.",
        "faq-q-vpn-how": "Warum Lingoano?",
        "faq-a-vpn-how-content": "Im Unterschied zu anderen Apps ermöglicht Lingoano Gespräche mit Menschen, die dieselbe Sprache lernen. Das unterstützt effektives Lernen und hält die Motivation durch echte Gespräche hoch.",
        "todays-words": "Wörter des Tages",
        "todays-words-subtitle": "Lernen Sie jeden Tag neue Wörter und verbessern Sie Ihre Sprachkenntnisse",
        "loading-words": "Wörter werden geladen...",
        "learning-tips": "Tipps zum Vokabellernen",
        "tip-daily": "Führen Sie ein Tagebuch",
        "tip-daily-desc": "Schreiben Sie neue Wörter, die Sie lernen, in ein Notizbuch und wiederholen Sie sie regelmäßig.",
        "tip-sentences": "Sätze bilden",
        "tip-sentences-desc": "Erstellen Sie Ihre eigenen Sätze mit jedem neuen Wort und üben Sie.",
        "tip-connect": "Verbindungen herstellen",
        "tip-connect-desc": "Verbinden Sie neue Wörter mit Wörtern, die Sie bereits kennen, und stärken Sie Ihr Gedächtnis.",
        "tip-audio": "Mit Audio lernen",
        "tip-audio-desc": "Lernen Sie, das Wort richtig auszusprechen und wiederholen Sie es laut.",
        "footer": "Ihre Privatsphäre ist unsere Priorität. Kommunizieren Sie frei mit Lingoano",
        "privacy-features": "Unsere Datenschutzfunktionen",
        "terminal1": " Es wird keine Nachrichten-Historie gespeichert",
        "terminal2": "> Chats laufen nicht über den Server (im Standardprotokoll)",
        "terminal3": "> Benutzerinformationen werden weder angefordert noch gespeichert",
        "terminal4": "> Jeder kann den Code überprüfen",
        "terminal5": "> Unser Ziel: Sowohl Lernen als auch Sicherheit ernst nehmen",
        "terminal": "Unsere Sicherheitsfunktionen",
        "benefits": "Vorteile des Sprachenlernens",
        "career-development": "Karriereentwicklung",
        "why": "Warum Sie eine Sprache lernen sollten",
        "privacy": "Privatsphäre und Sicherheit",
        "privacy-principles": "Unsere Datenschutzprinzipien",
        "p2p-fallback-disclaimer": "Wenn P2P nicht möglich ist, wird WebSocket zur temporären Serverweiterleitung verwendet; es werden keine dauerhaften Protokolle geführt.",
        "udp-vpn-tip-inline": "Die Verwendung eines UDP‑basierten VPN (WireGuard, OpenVPN‑UDP) kann die P2P‑Erfolgsquote verbessern.",
        "decentralized-structure-title": "Dezentrale Struktur:",
        "decentralized-structure-desc": "Ihre Daten werden über ein verteiltes Netzwerk übertragen und nicht an einem einzigen zentralen Ort gesammelt.",
        "censorship-resistance-title": "Zensurresistenz:",
        "censorship-resistance-desc": "Keine Behörde kann unsere Plattform blockieren; sie bleibt jederzeit zugänglich.",
        "full-anonymity-title": "Volle Anonymität:",
        "full-anonymity-desc": "Wir fragen nicht nach Ihren persönlichen Daten; Sie müssen nicht Ihren echten Namen angeben.",
        "minimal-data-title": "Minimale Daten:",
        "minimal-data-desc": "Es werden nur die notwendigen Informationen gespeichert; wir sammeln keine unnötigen Daten.",
        "zero-record-title": "Keine Aufzeichnung:",
        "zero-record-desc": "Ihre Chats werden nirgendwo gespeichert; sie sind vollständig temporär.",
        "how-it-works": "Wie es funktioniert",
        "how-it-works-content": "Das Funktionsprinzip von Lingoano ist einfach und effektiv. Die Plattform bringt Sie mit Leuten zusammen, die dieselbe Sprache lernen möchten, und ermöglicht Ihnen, reale Konversationen zu üben.",
        "step-by-step-process": "Schritt-für-Schritt-Anleitung",
        "step-1": "1. Sprache und Niveau auswählen",
        "step-1-content": "Wählen Sie die Sprache, die Sie lernen möchten, und Ihr aktuelles Niveau. Alle Niveaus von A1 bis B2+ werden unterstützt, sodass Sie mit Personen auf demselben Niveau wie Sie zusammengebracht werden.",
        "step-2": "2. Automatische Übereinstimmung",
        "step-2-content": "Das System bringt Sie automatisch mit Benutzern zusammen, die dieselbe Sprache lernen möchten und ein ähnliches Niveau haben, was ein komfortables und effektives Lernerlebnis gewährleistet.",
        "step-3": "3. Sicherer Chat",
        "step-3-content": "Dank der IPFS-Technologie sind Ihre Chats vollständig sicher und anonym. Ihre Nachrichten werden auf keinem Server gespeichert und können von niemandem überwacht werden.",
        "step-4": "4. Kontinuierliches Lernen",
        "step-4-content": "Jede Konversation ist eine neue Gelegenheit, Ihre Sprachkenntnisse zu verbessern. Durch das Sprechen mit verschiedenen Personen erweitern Sie Ihren Wortschatz und verbessern Ihre Aussprache.",
        "technology-security": "Technologie und Sicherheit",
        "technology-security-content": "Lingoano verwendet die neuesten Technologien, um ein sicheres und effektives Spracherlebnis zu bieten. Unsere Plattform wurde entwickelt, um die Privatsphäre und Sicherheit der Benutzer zu maximieren.",
        "technologies-we-use": "Technologien, die wir verwenden",
        "ipfs-title": "IPFS (InterPlanetary File System)",
        "ipfs-content": "Durch die Verwendung eines dezentralen Dateisystems wird sichergestellt, dass Ihre Nachrichten niemals auf einem Server gespeichert werden. Diese Technologie schafft eine zensurresistente und sichere Kommunikationsumgebung.",
        "webrtc-title": "WebRTC",
        "webrtc-content": "Die WebRTC-Technologie wird für die direkte Peer-to-Peer-Kommunikation verwendet, um sicherzustellen, dass Ihre Nachrichten die andere Partei erreichen, ohne über Drittanbieter-Server zu laufen.",
        "open-source-title": "Open-Source-Code",
        "open-source-content": "Unser gesamter Code ist Open Source, was Sicherheitsexperten und Entwicklern ermöglicht, unsere Sicherheit zu überprüfen und zu verifizieren.",
        "user": "Benutzererfahrungen:",
        "testimonials-emir": "\"Dank Lingoano habe ich meine Angst, Englisch zu sprechen, überwunden. Jetzt kann ich problemlos mit ausländischen Freunden chatten.\"",
        "testimonials-privacy": "\"Ich hatte Bedenken hinsichtlich der Privatsphäre, aber dank IPFS kann ich es sicher verwenden.\"",
        "testimonials-effective": "\"Da ich mit Personen meines Niveaus zusammengebracht werde, ist mein Lernprozess viel effektiver geworden.\"",
        "testimonials-dr-basak": "\"Die Fokussierung auf echte Sprechpraxis im Sprachenlernen ist pädagogisch eine starke Herangehensweise.\"",
        "chat": "Chat",
        "about": "Über Lingoano",
        "word-of-day": "Wort des Tages",
        "language-guides": "Sprachführer",
        "download": "Herunterladen",
        "meet": "Lingoano Web",
        "learn": "Beginnen Sie heute mit dem Sprachenlernen",
        "status-content": "Die Web-Version von Lingoano wurde entwickelt, um das Sprachenlernen einfacher zu machen. Sie können über Ihren Browser üben, ohne eine App herunterladen zu müssen. Unser Matching-System bringt Benutzer mit ähnlichen Zielen und Niveaus zusammen.",
        "why-Lingoano": "Warum Lingoano Web",
        "footer": "Beginnen Sie heute mit Lingoano in einer realen Übungsumgebung mit dem Sprachenlernen",
        "donate": "Lingoano unterstützen",
        "donate-content": "Wenn Sie diese in Entwicklung befindliche Anwendung unterstützen möchten, können Sie dies auf der Seite \"Buy Me A Coffee\" tun.",
        "select-language": "Sprache, die Sie sprechen möchten:",
        "select-level": "Ihr Niveau in dieser Sprache:",
        "select-placeholder": "Auswählen",
        "search-match": "Nach Übereinstimmung suchen",
        "english": "Englisch",
        "turkish": "Türkisch",
        "german": "Deutsch",
        "french": "Französisch",
        "spanish": "Spanisch",
        "russian": "Russisch",
        "level-a1": "A1 (Anfänger)",
        "level-a2": "A2 (Grundkenntnisse)",
        "level-b1": "B1 (Mittelstufe)",
        "level-b2": "B2+ (Fortgeschritten)",
        "feature-browser": "Browser-Zugang - Sie können es von jedem Gerät aus nutzen",
        "feature-matching": "Niveau-basiertes Matching - Sie sprechen mit Leuten auf demselben Niveau wie Sie",
        "feature-anonymous": "Anonymes Chat-System - Sie können bequem üben, während Ihre Identität verborgen bleibt",
        "feature-multilingual": "Mehrsprachige Unterstützung - Englisch, Türkisch, Deutsch, Französisch, Spanisch, Russisch",
        "feature-mobile": "Mobile-freundliche Oberfläche - Sie können es bequem von Ihrem Handy aus nutzen",
        "feature-free": "Kostenloser Zugang - lernen Sie Sprachen, ohne Gebühren zu zahlen",
        "why-learn-title": "Warum Sie Sprachen lernen sollten",
        "why-learn-subtitle": "Eine Sprache zu lernen, bedeutet nicht nur, neue Wörter zu lernen, sondern eine neue Welt zu entdecken. Hier sind einige Gründe, warum Sie Sprachen lernen sollten:",
        "career-opportunities": "Karrierechancen",
        "career-description": "Das Wissen einer zweiten Sprache bietet große Vorteile in der Geschäftswelt. Sie können in internationalen Unternehmen arbeiten, Arbeitsmöglichkeiten im Ausland finden und höhere Gehälter verdienen.",
        "cultural-richness": "Kultureller Reichtum",
        "cultural-description": "Jede Sprache enthält ihre eigene einzigartige Kultur und Denkweise. Wenn Sie eine neue Sprache lernen, können Sie die Filme, Bücher und Musik dieser Kultur verstehen.",
        "travel-freedom": "Reisefreiheit",
        "travel-description": "In der Lage zu sein, die Landessprache in einem fremden Land zu sprechen, verändert Ihr Reiseerlebnis vollständig. Sie können nicht nur touristische Orte, sondern auch echte lokale Erfahrungen machen.",
        "brain-health": "Gehirngesundheit",
        "brain-description": "Das Lernen von Sprachen hält Ihr Gehirn aktiv und stärkt Ihr Gedächtnis. Untersuchungen zeigen, dass mehrsprachige Menschen widerstandsfähiger gegen Krankheiten wie Alzheimer sind.",
        "confidence": "Selbstvertrauen und Selbstwertgefühl",
        "confidence-description": "Das Erlernen einer neuen Sprache erhöht Ihr Selbstvertrauen. Zu sehen, dass Sie ein herausforderndes Ziel erreicht haben, macht Sie in anderen Bereichen Ihres Lebens mutiger.",
        "social-connections": "Soziale Verbindungen",
        "social-description": "Sprache ist eines der mächtigsten Werkzeuge, das Menschen verbindet. Wenn Sie eine neue Sprache lernen, können Sie mit Menschen aus verschiedenen Teilen der Welt kommunizieren.",
        "dictionary": "Wörterbuch",
        "search-placeholder": "Wörter suchen...",
        "popular-words": "Beliebte Wörter",
        "word-not-found": "Wort nicht gefunden",
        "detecting-language": "Sprache wird erkannt...",
        "send": "Senden",
        "ipfs-chat-started": "Mit IPFS verbunden. Chat gestartet.",
        "ipfs-connection-failed": "Verbindung zu IPFS fehlgeschlagen. Bitte überprüfen Sie Ihr Netzwerk.",
        "connection-error-placeholder": "Verbindungsfehler",
        "websocket-connected": "Mit WebSocket verbunden. Sie können jetzt Nachrichten senden!",
        "demo-mode-type-message": "Demo-Modus - Geben Sie Ihre Nachricht ein...",
        "websocket-demo-mode": "WebSocket-Verbindung fehlgeschlagen. Demo-Modus aktiviert.",
        "matching-search-started": "🔍 Suche nach Übereinstimmung gestartet! Wir suchen einen passenden Partner für Sie...",
        "searching-match-button": "Suche nach einer Übereinstimmung...",
        "waiting-match-button": "Warte auf eine Übereinstimmung...",
        "matching-waiting": "⏳ Warte auf eine Übereinstimmung... Suche nach einem anderen Benutzer.",
        "matched-redirecting-button": "Übereinstimmung gefunden! Weiterleitung...",
        "matching-found-notification": "🎉 Übereinstimmung gefunden! Weiterleitung zur Chat-Seite...",
        "matching-error": "❌ Matching-Fehler",
        "peer-disconnected-notification": "⚠️ Der passende Benutzer hat die Verbindung getrennt. Bitte versuchen Sie es erneut.",
        "server-connection-failed": "🔌 Verbindung zum Server konnte nicht hergestellt werden. Bitte stellen Sie sicher, dass der Server läuft.",
        "select-language-level": "Bitte wählen Sie eine Sprache und ein Niveau aus.",
        "todays-words": "Wörter des Tages",
        "todays-words-subtitle": "Lernen Sie jeden Tag neue Wörter und verbessern Sie Ihre Sprachkenntnisse",
        "loading-words": "Wörter werden geladen...",
        "learning-tips": "Tipps zum Vokabellernen",
        "tip-daily": "Führen Sie ein Tagebuch",
        "tip-daily-desc": "Schreiben Sie neue Wörter, die Sie lernen, in ein Notizbuch und wiederholen Sie sie regelmäßig.",
        "tip-sentences": "Sätze bilden",
        "tip-sentences-desc": "Erstellen Sie Ihre eigenen Sätze für jedes neue Wort und üben Sie.",
        "tip-connect": "Verbindungen herstellen",
        "tip-connect-desc": "Verbinden Sie neue Wörter mit Wörtern, die Sie kennen, und stärken Sie Ihr Gedächtnis.",
        "tip-audio": "Mit Audio lernen",
        "tip-audio-desc": "Lernen Sie, Wörter richtig auszusprechen und wiederholen Sie sie laut.",
        "download-title": "Lingoano herunterladen",
        "download-subtitle": "Laden Sie die Sprachlernplattform für alle Ihre Geräte herunter",
        "download-windows": "Für Windows herunterladen",
        "download-mac": "Für Mac herunterladen",
        "download-linux": "Für Linux herunterladen",
        "download-android": "Für Android herunterladen",
        "download-ios": "Für iOS herunterladen",
        "coming-soon": "Bald verfügbar",
        "development-in-progress": "In Entwicklung",
        "stay-tuned": "Bleiben Sie dran",
        "language-guides-title": "Sprachführer",
        "language-guides-subtitle": "Grammatikregeln, Taktiken und Lernführer",
        "english-grammar": "Englische Grammatik",
        "german-grammar": "Deutsche Grammatik",
        "spanish-grammar": "Spanische Grammatik",
        "russian-grammar": "Russische Grammatik",
        "learning-tactics": "Lerntaktiken",
        "grammar-basics": "Grammatik-Grundlagen",
        "about-title": "Über Lingoano",
        "about-subtitle": "Detaillierte Informationen über die Sprachlernplattform",
        "what-is-Lingoano": "Was ist Lingoano?",
        "Lingoano-description": "Lingoano ist eine moderne Chat-Plattform, die für diejenigen entwickelt wurde, die Sprachen lernen möchten.",
        "our-mission": "Unsere Mission",
        "privacy-security": "Privatsphäre und Sicherheit",
        "how-it-works": "Wie funktioniert es?",
        "how-it-works-content": "Das Funktionsprinzip von Lingoano ist ziemlich einfach und effektiv. Die Plattform bringt Sie mit Leuten zusammen, die dieselbe Sprache lernen möchten, und ermöglicht Ihnen, reale Konversationen zu üben.",
        "technology-security": "Technologie und Sicherheit",
        "technology-security-content": "Lingoano verwendet die neuesten Technologien, um ein sicheres und effektives Spracherlebnis zu bieten. Unsere Plattform wurde entwickelt, um die Privatsphäre und Sicherheit der Benutzer auf höchstem Niveau zu schützen.",
        "community-support": "Gemeinschaft und Unterstützung",
        "community-support-content": "Lingoano ist nicht nur eine Sprachlernplattform, sondern auch eine Gemeinschaft, in der Sprachlerner zusammenkommen. Die Erfahrungen und das Feedback unserer Benutzer helfen uns, die Plattform kontinuierlich zu verbessern.",
        "privacy-policy-title": "Datenschutzrichtlinie",
        "privacy-policy-subtitle": "Informationen darüber, wie Ihre persönlichen Daten geschützt werden",
        "data-collection": "Datenerfassung",
        "data-usage": "Datennutzung",
        "data-protection": "Datenschutz",
        "your-rights": "Ihre Rechte",
        "last-updated": "Letzte Aktualisierung: 16. August 2025",
        "introduction": "1. Einleitung",
        "introduction-content": "Bei Lingoano (\"Lingoano\", \"wir\" oder die \"Gesellschaft\") verpflichten wir uns, personenbezogene Daten und Ihre Privatsphäre zu schützen. Diese Datenschutzrichtlinie erklärt, welche Daten bei der Nutzung unserer Plattform verarbeitet werden, die Zwecke und rechtlichen Grundlagen der Verarbeitung, Aufbewahrungsfristen und Ihre Rechte.",
        "information-collected": "2. Von uns gesammelte Informationen",
        "personal-information": "2.1 Personenbezogene Daten",
        "personal-information-content": "In der Regel fordert Lingoano keine personenbezogenen Daten wie Name, Nachname, E-Mail oder Telefonnummer an oder verarbeitet sie nicht.",
        "technical-information": "2.2 Technische/Online-Identifikatoren",
        "technical-information-content": "Um den Service bereitzustellen, die Sicherheit zu gewährleisten und die Leistung zu verbessern, können die folgenden technischen Daten verarbeitet werden:",
        "browser-type": "Browsertyp und -version",
        "operating-system": "Betriebssystem und Geräteinformationen",
        "ip-address": "IP-Adresse (Maskierung/Anonymisierung, falls möglich)",
        "page-views": "Nutzungs-/Interaktionsstatistiken (aggregiert und anonym)",
        "use-of-information": "3. Verwendung der Informationen",
        "use-of-information-content": "Die gesammelten/verarbeiteten Daten werden im Rahmen legitimer Interessen und für die Erbringung des Dienstes für die folgenden Zwecke verwendet:",
        "improve-platform": "Verbesserung der Plattformleistung",
        "resolve-issues": "Behebung technischer Probleme",
        "enhance-experience": "Verbesserung des Benutzererlebnisses",
        "ensure-security": "Sicherstellung der Sicherheit",
        "information-sharing": "4. Informationsaustausch",
        "information-sharing-content": "Lingoano verkauft oder teilt keine Benutzerinformationen zu Marketingzwecken. Daten dürfen nur offengelegt werden, wenn dies zur Einhaltung gesetzlicher Verpflichtungen und zur Beantwortung ordnungsgemäß autorisierter Anfragen von zuständigen Behörden erforderlich ist.",
        "cookies-tracking": "5. Cookies und Tracking",
        "cookies-tracking-content": "Essenzielle und Präferenz-Cookies können zur Betreibung des Dienstes verwendet werden. Werbe- und Mess-Cookies können von Drittanbietern (z. B. Google AdSense) in Übereinstimmung mit den geltenden Gesetzen aktiviert werden.",
        "store-theme": "Speichert Ihre Theme-Präferenzen",
        "remember-language": "Erinnert sich an Ihre Sprachauswahl",
        "session-info": "Behält Ihre Sitzungsinformationen bei",
        "user-rights": "8. Benutzerrechte",
        "user-rights-content": "Vorbehaltlich der geltenden Gesetze haben Benutzer die folgenden Rechte:",
        "access-data": "Zugriff auf Ihre personenbezogenen Daten",
        "correct-data": "Berichtigung Ihrer Daten",
        "delete-data": "Löschung Ihrer Daten",
        "object-processing": "Widerspruch gegen die Verarbeitung",
        "children-privacy": "9. Datenschutz für Kinder",
        "children-privacy-content": "Lingoano richtet sich nicht an Personen unter 13 Jahren. Wir sammeln wissentlich keine Daten von Kindern unter 13 Jahren; falls versehentlich gesammelt, werden sie innerhalb einer angemessenen Frist gelöscht.",
        "policy-changes": "10. Änderungen der Richtlinie",
        "policy-changes-content": "Diese Datenschutzrichtlinie kann von Zeit zu Zeit aktualisiert werden. Bei wesentlichen Änderungen wird das Datum des Inkrafttretens aktualisiert und eine angemessene Benachrichtigung bereitgestellt.",
        "contact": "11. Kontakt",
        "contact-content": "Für Fragen zu dieser Datenschutzrichtlinie können Sie uns kontaktieren über:",
        "privacy-email": "E-Mail: privacy@Lingoano.com",
        "acceptance": "1. Annahme und Zustimmung",
        "acceptance-content": "Durch den Zugriff auf und die Nutzung der Dienste von Lingoano stimmen Sie diesen Nutzungsbedingungen und allen durch Verweis einbezogenen Richtlinien und Hinweisen zu. Wenn Sie nicht zustimmen, sollten Sie den Dienst nicht nutzen.",
        "service-description": "2. Servicebeschreibung",
        "service-description-content": "Lingoano ist eine Plattform, die Benutzer, die Sprachen üben möchten, zusammenbringt und die Kommunikation ermöglicht. Peer-to-Peer (P2P)-Kommunikation wird, wo immer möglich, bevorzugt. Der Service wird \"wie besehen\" und \"wie verfügbar\" bereitgestellt.",
        "general-rules": "3.1 Allgemeine Regeln",
        "general-rules-content": "Während der Nutzung des Dienstes müssen Sie die geltenden Gesetze, die öffentliche Ordnung und die Gemeinschaftsregeln einhalten:",
        "be-respectful": "Seien Sie respektvoll und höflich",
        "follow-laws": "Halten Sie die Gesetze ein",
        "respect-rights": "Respektieren Sie die Rechte anderer",
        "no-spam": "Teilen Sie keinen Spam oder schädlichen Inhalt",
        "no-threats": "Bedrohen Sie nicht die Sicherheit der Plattform",
        "prohibited-content": "3.2 Verbotener Inhalt",
        "prohibited-content-content": "Die folgenden Inhalte und Handlungen sind verboten:",
        "hate-speech": "Hassrede und Diskriminierung",
        "violence": "Gewalttätiger Inhalt",
        "obscene-material": "Obszönes oder pornografisches Material",
        "illegal-activities": "Illegale Aktivitäten",
        "personal-info": "Teilen persönlicher Informationen",
        "false-info": "Verbreitung falscher Informationen",
        "terms-privacy-security": "4. Privatsphäre und Sicherheit",
        "terms-privacy-security-content": "Lingoano priorisiert die Privatsphäre und Sicherheit der Benutzer. Der Benutzer trägt jedoch die letztendliche Verantwortung für die Aufrechterhaltung der Online-Sicherheit:",
        "self-responsibility": "Sie sind für Ihre eigene Sicherheit verantwortlich",
        "no-personal-info": "Teilen Sie Ihre persönlichen Informationen nicht",
        "report-suspicious": "Melden Sie verdächtiges Verhalten",
        "support-security": "Unterstützen Sie die Sicherheitsmaßnahmen der Plattform",
        "intellectual-property": "5. Geistiges Eigentum",
        "intellectual-property-content": "Die Marken, Logos, Benutzeroberfläche, Software, Texte und Bilder von Lingoano sind durch geltende Gesetze geschützt. Ohne schriftliche Genehmigung dürfen sie nicht kopiert, reproduziert, verteilt oder zur Erstellung abgeleiteter Werke verwendet werden.",
        "service-changes": "6. Änderungen am Service",
        "service-changes-content": "Lingoano kann den Umfang und die Funktionen des Dienstes von Zeit zu Zeit aktualisieren, aussetzen oder einstellen. Bei wesentlichen Änderungen wird eine angemessene Benachrichtigung bereitgestellt.",
        "liability-limitation": "7. Haftungsbeschränkung",
        "liability-limitation-content": "Der Dienst wird auf einer \"wie besehen\" und \"wie verfügbar\" Basis bereitgestellt. Im größtmöglichen gesetzlich zulässigen Umfang haftet Lingoano nicht für indirekte, zufällige, spezielle, strafbare oder Folgeschäden.",
        "account-suspension": "8. Sperrung und Kündigung",
        "account-suspension-content": "Bei Verstoß gegen die Bedingungen kann der Zugriff eingeschränkt und das/die Konto(s) gesperrt oder gekündigt werden. Aufzeichnungen, die für die Streitbeilegung erforderlich sind, können in Übereinstimmung mit den geltenden Gesetzen aufbewahrt werden.",
        "applicable-law": "10. Anwendbares Recht und Gerichtsbarkeit",
        "applicable-law-content": "Diese Bedingungen unterliegen den Gesetzen der Republik Türkei und werden in Übereinstimmung mit ihnen ausgelegt. Die Gerichte und Vollstreckungsbüros von Istanbul (Zentral) sind für Streitigkeiten zuständig.",
        "terms-email": "E-Mail: terms@Lingoano.com",
        "terms-title": "Nutzungsbedingungen",
        "terms-subtitle": "Regeln und Bedingungen zur Nutzung der Plattform",
        "usage-rules": "Nutzungsregeln",
        "user-responsibilities": "Benutzerverantwortlichkeiten",
        "prohibited-content": "Verbotener Inhalt",
        "account-termination": "Kontokündigung",
        "chat-title": "Chat",
        "connecting": "Verbinden...",
        "waiting-for-match": "Warte auf Übereinstimmung...",
        "connected": "Verbunden",
        "disconnected": "Getrennt",
        "type-message": "Geben Sie Ihre Nachricht ein...",
        "partner-left": "Ihr Chat-Partner hat den Chat verlassen",
        "new-match": "Neue Übereinstimmung",
        "leave-chat": "Chat verlassen",
        "home": "Startseite",
        "menu": "Menü",
        "close-menu": "Menü schließen",
        "loading": "Wird geladen...",
        "error": "Fehler",
        "success": "Erfolg",
        "warning": "Warnung",
        "info": "Info",
        "continue": "Weiter",
        "cancel": "Abbrechen",
        "close": "Schließen",
        "save": "Speichern",
        "delete": "Löschen",
        "edit": "Bearbeiten",
        "yes": "Ja",
        "no": "Nein",
        "confirm-leave-chat": "Möchten Sie zur Startseite zurückkehren? Der Chat wird beendet.",
        "select-option": "Auswählen",
        "default-theme": "Standard-Theme",
        "blue-theme": "Blaues Theme",
        "purple-theme": "Lila Theme",
        "green-theme": "Grünes Theme",
        "platforms": "Desktop-Plattformen",
        "mobile-platforms": "Mobile Plattformen",
        "windows": "Windows",
        "mac": "Mac",
        "linux": "Linux",
        "android": "Android",
        "ios": "iOS",
        "menu-toggle-label": "Menü öffnen/schließen",
        "theme-switcher-label": "Theme-Wechsler",
        "github-visit": "GitHub-Profil besuchen",
        "privacy-policy": "Datenschutzrichtlinie",
        "terms-of-service": "Nutzungsbedingungen",
        "donate-button": "SPENDEN",
        "buy-me-coffee": "Kauf mir einen Kaffee",
        "chat-title-page": "Lingoano Chat - Sprachlernplattform",
        "logo-alt": "Logo",
        "about-title-page": "Über Lingoano - Sprachlernplattform",
        "download-title-page": "Lingoano herunterladen - Sprachlern-App",
        "word-of-day-title-page": "Wort des Tages - Lingoano",
        "language-guides-title-page": "Sprachführer - Lingoano",
        "language-learning-guides": "Sprachlernführer",
        "guides-subtitle": "Grammatikregeln, Taktiken und Lerntipps",
        "privacy-policy-title-page": "Datenschutzrichtlinie - Lingoano",
        "terms-title-page": "Nutzungsbedingungen - Lingoano",
        "language-learning-guides": "Sprachlernführer",
        "guides-subtitle": "Grammatikregeln, Taktiken und Lerntipps",
        "english-tab": "🇺🇸 Englisch",
        "german-tab": "🇩🇪 Deutsch",
        "spanish-tab": "🇪🇸 Spanisch",
        "turkish-tab": "🇹🇷 Türkisch",
        "russian-tab": "🇷🇺 Russisch",
        "english": "Englisch",
        "german": "Deutsch",
        "spanish": "Spanisch",
        "french": "Französisch",
        "turkish": "Türkisch",
        "russian": "Russisch",
        "english-grammar-basics": "Grundlagen der englischen Grammatik",
        "present-simple-title": "Present Simple",
        "present-simple-explanation": "Wird für allgemeine Fakten, Gewohnheiten und regelmäßige Handlungen verwendet. Die dritte Person Singular nimmt die Endung -s.",
        "present-continuous-title": "Present Continuous",
        "present-continuous-explanation": "Wird für laufende Handlungen im Moment und zukünftige Pläne verwendet. Struktur: Be + V-ing.",
        "past-simple-title": "Past Simple",
        "past-simple-explanation": "Wird für abgeschlossene Handlungen in der Vergangenheit verwendet. Regelmäßige Verben nehmen -ed, unregelmäßige ändern sich.",
        "present-perfect-title": "Present Perfect",
        "present-perfect-explanation": "Für Handlungen, die in der Vergangenheit begonnen haben und bis jetzt andauern oder andauernde Auswirkungen haben.",
        "future-tenses-title": "Zukunftsformen",
        "future-tenses-explanation": "Will (ungewisse Zukunft), going to (geplante Zukunft), Present Continuous (nahe Zukunft).",
        "conditionals-title": "Bedingungssätze (If-Clauses)",
        "conditionals-explanation": "0 (allgemeine Fakten), 1 (mögliche Zukunft), 2 (hypothetische Gegenwart), 3 (hypothetische Vergangenheit).",
        "learning-resources-title": "Lernressourcen",
        "resources-mobile-apps-title": "Mobile Apps",
        "resources-mobile-apps-desc": "Nutzen Sie Apps wie Duolingo, Memrise, Babbel.",
        "resources-video-content-title": "Videoinhalte",
        "resources-video-content-desc": "Folgen Sie Sprachlernkanälen auf YouTube.",
        "resources-books-title": "Bücher",
        "resources-books-desc": "Lesen Sie Grammatikbücher und Geschichtenbücher.",
        "resources-online-courses-title": "Online-Kurse",
        "resources-online-courses-desc": "Nutzen Sie Plattformen wie Coursera, edX.",
        "descriptiona": "Lingoano ist nur einen Klick entfernt für alle Ihre Geräte",
        "description": "Lingoano ist eine moderne Chat-Plattform, die für diejenigen entwickelt wurde, die Sprachen lernen möchten. Sie ermöglicht es Ihnen, in einer realen Gesprächsumgebung mit Personen zu üben, die das gleiche Sprachziel haben. Die Plattform wurde entwickelt, um das Sprachenlernen einfach und unterhaltsam zu gestalten.",
        "learn-content": "Im Gegensatz zu traditionellen Sprachlernmethoden konzentriert sich Lingoano auf die Übung von realen Gesprächen. Es bietet eine natürliche Sprachumgebung, in der Sie in Ihrem eigenen Tempo lernen können, während Sie mit Personen auf demselben Niveau interagieren. Dies ermöglicht es Ihnen, bequem und effektiv zu üben.",
        "why-content": "Eine neue Sprache zu lernen, bedeutet nicht nur, neue Wörter zu lernen; es bedeutet, eine neue Welt zu entdecken. Das Verstehen anderer Kulturen, das Kennenlernen neuer Menschen und das Erleben neuer Möglichkeiten sind alle Teil der Reise. Egal, ob Sie sich für eine Karriere, Bildung oder persönliches Wachstum interessieren, Sprachkenntnisse werden für jeden immer wichtiger. Lingoano bietet einen einfachen, aber effektiven Ausgangspunkt für Ihre Sprachlernreise.",
        "career-development-content": "Das Wissen einer zweiten Sprache bietet große Vorteile in der Geschäftswelt. Sie können in internationalen Unternehmen arbeiten, Arbeitsmöglichkeiten im Ausland finden und höhere Gehälter verdienen. Insbesondere Englisch ist in der heutigen globalen Wirtschaft fast unerlässlich.",
        "cultural-richness-content": "Jede Sprache enthält ihre eigene einzigartige Kultur und Denkweise. Wenn Sie eine neue Sprache lernen, können Sie die Filme, Bücher und Musik dieser Kultur verstehen. Dies ermöglicht es Ihnen, verschiedene Perspektiven zu schätzen und Ihr Verständnis der Welt zu erweitern.",
        "travel-freedom-content": "In der Lage zu sein, die Landessprache in einem fremden Land zu sprechen, verändert Ihr Reiseerlebnis vollständig. Sie können nicht nur touristische Orte, sondern auch echte lokale Erfahrungen machen. Dies ermöglicht es Ihnen, sich mit Einheimischen zu verbinden und unterwegs neue Freunde zu finden.",
        "brain-health-content": "Das Lernen von Sprachen hält Ihr Gehirn aktiv und stärkt Ihr Gedächtnis. Untersuchungen zeigen, dass mehrsprachige Menschen widerstandsfähiger gegen Krankheiten wie Alzheimer sind."
    },
    
    ru: {
        "wod-streak-msg-1": "💔 Ты однажды нас покинул, Иго всё ещё расстроен.",
        "wod-streak-msg-2": "🎉 Поздравляем! Иго гордится твоей первой серией.",
        "wod-streak-msg-3": "🏆🔥 Иго гордится твоей серией, молодец!",
        "wod-streak-msg-3-special": "🤗🎉 Иго прощает тебя и поздравляет!",
        "change-wod-language": "Сменить язык",
    "decentralized-structure": "<strong style='color: var(--accent-color);'>Децентрализованная структура:</strong> <span style='color: var(--text-secondary);'>Ваши данные передаются по распределенной сети и не собираются в одном центральном месте.</span>",
    "censorship-resistance": "<strong style='color: var(--accent-color);'>Устойчивость к цензуре:</strong> <span style='color: var(--text-secondary);'>Никакие власти не могут заблокировать нашу платформу; она остается доступной в любое время.</span>",
    "full-anonymity": "<strong style='color: var(--accent-color);'>Полная анонимность:</strong> <span style='color: var(--text-secondary);'>Мы не запрашиваем личную информацию; вам не требуется сообщать свое настоящее имя.</span>",
    "minimal-data": "<strong style='color: var(--accent-color);'>Минимум данных:</strong> <span style='color: var(--text-secondary);'>Хранится только необходимая информация; мы не собираем лишние данные.</span>",
    "zero-record": "<strong style='color: var(--accent-color);'>Нулевой след:</strong> <span style='color: var(--text-secondary);'>Ваши чаты нигде не хранятся; они полностью временные.</span>",
    "default-theme": "Тема по умолчанию",
    "blue-theme": "Синяя тема",
    "purple-theme": "Фиолетовая тема",
    "green-theme": "Зеленая тема",
    "theme-switcher-label": "Переключатель тем",
    "menu-toggle-label": "Переключить меню",
    "type-message": "Введите ваше сообщение...",
    "guess-input-placeholder": "Введите ваш вариант...",
    "logo-alt": "Логотип Lingoano",
    "github-visit": "Посетить профиль на GitHub",
    "home-title": "Lingoano Web",
    
    // Переводы для всплывающего окна контактов
    "contact": "11. Контакт",
    "contactfooter": "Контакты",
    "contact-us": "Свяжитесь с нами",
    "contact-info": "Контактная информация",
    "contact-email": "Электронная почта: contact@lingoano.com",
    "contact-description": "По вопросам, предложениям или отзывам вы можете связаться с нами.",
    "contact-response": "Время ответа: в течение 24-48 часов",
    "faq-q-free": "Lingoano бесплатен?",
    "faq-a-free": "Да. Lingoano полностью бесплатен; вы не платите за чат или обучение.",
    "faq-q-login": "Нужна ли учетная запись или вход?",
    "faq-a-login": "Нет. В Lingoano не требуется регистрация или вход; можно использовать анонимно.",
    "faq-title": "Часто задаваемые вопросы",
    "faq-q-p2p": "Как сообщения доставляются без прохождения через сервер?",
    "faq-a-p2p-content": "По умолчанию используются одноранговые протоколы, такие как IPFS/WebRTC. Они позволяют передавать сообщения напрямую между участниками без участия сервера. По сути формируется приватная сеть между IP‑адресами, по которой и передаются сообщения.",
    "faq-q-udp-vpn": "Как VPN на основе UDP улучшает подключение?",
    "faq-a-udp-vpn-content": "Преодоление NAT часто ограничивается операторами. VPN на основе UDP, такие как WireGuard или OpenVPN‑UDP, могут повысить успешность P2P/WebRTC и обеспечить более быстрые и стабильные соединения между участниками.",
    "faq-q-privacy": "Как понять, что мой чат использует децентрализованный протокол, например IPFS?",
    "faq-a-privacy-content": "Обычно приложение пытается использовать IPFS и WebRTC; если это не удаётся, используется WebSocket. В этом случае чат ретранслируется через сервер, однако журналы чатов ни при каких условиях не сохраняются.",
    "faq-q-vpn-how": "Почему Lingoano?",
    "faq-a-vpn-how-content": "В отличие от других приложений для изучения языков, Lingoano позволяет общаться с людьми, изучающими тот же язык, что и вы. Это помогает учиться эффективно и поддерживает мотивацию благодаря общению с реальными людьми.",
    "close": "Закрыть",
    
    // Дополнительные недостающие переводы
    "todays-words": "Слова дня",
    "todays-words-subtitle": "Учите новые слова каждый день и улучшайте свои языковые навыки",
    "loading-words": "Загрузка слов...",
    "learning-tips": "Советы по изучению слов",
    "tip-daily": "Ведите дневник",
    "tip-daily-desc": "Записывайте новые слова в тетрадь и регулярно их повторяйте.",
    "tip-sentences": "Составляйте предложения",
    "tip-sentences-desc": "Составляйте свои предложения с каждым новым словом и практикуйтесь.",
    "tip-connect": "Создавайте связи",
    "tip-connect-desc": "Связывайте новые слова с уже известными и укрепляйте свою память.",
    "tip-audio": "Учите с аудио",
    "tip-audio-desc": "Учитесь правильно произносить слово и повторяйте его вслух.",
    
    "footer": "Ваша конфиденциальность - наш приоритет. Общайтесь свободно с Lingoano",

    "privacy-features": "Наши функции конфиденциальности",
    "terminal1": " История сообщений не сохраняется",
    "terminal2": "> Чаты не проходят через сервер (в стандартном протоколе)",
    "terminal3": "> Информация о пользователе не запрашивается и не хранится",
    "terminal4": "> Любой может проверить код",
    "terminal5": "> Наша цель: серьезно относиться как к обучению, так и к безопасности",

    "terminal": "Наши функции безопасности",
    "benefits": "Преимущества изучения языков",
    "career-development": "Карьерный рост",
    "why": "Почему стоит учить язык",
    "privacy": "Конфиденциальность и безопасность",
    "privacy-principles": "Наши принципы конфиденциальности",
    "p2p-fallback-disclaimer": "Когда P2P невозможен, используется WebSocket для временной передачи через сервер; постоянные журналы не ведутся.",
    "udp-vpn-tip-inline": "Использование VPN на основе UDP (WireGuard, OpenVPN‑UDP) может повысить успешность P2P.",

    "decentralized-structure-title": "Децентрализованная структура:",
    "decentralized-structure-desc": "Ваши данные передаются по распределенной сети и не собираются в одном центральном месте.",
    "censorship-resistance-title": "Устойчивость к цензуре:",
    "censorship-resistance-desc": "Никакие власти не могут заблокировать нашу платформу; она остается доступной в любое время.",
    "full-anonymity-title": "Полная анонимность:",
    "full-anonymity-desc": "Мы не запрашиваем вашу личную информацию; вам не требуется сообщать свое настоящее имя.",
    "minimal-data-title": "Минимум данных:",
    "minimal-data-desc": "Хранится только необходимая информация; мы не собираем лишние данные.",
    "zero-record-title": "Нулевой след:",
    "zero-record-desc": "Ваши чаты нигде не хранятся; они полностью временные.",
    "how-it-works": "Как это работает",
    "how-it-works-content": "Принцип работы Lingoano прост и эффективен. Платформа подбирает вам людей, которые хотят изучать тот же язык, и позволяет практиковаться в реальных разговорах.",
    "step-by-step-process": "Пошаговый процесс",
    "step-1": "1. Выберите язык и уровень",
    "step-1-content": "Выберите язык, который вы хотите изучать, и ваш текущий уровень. Поддерживаются все уровни от A1 до B2+, так что вы будете соединены с людьми вашего уровня.",
    "step-2": "2. Автоматический подбор",
    "step-2-content": "Система автоматически подбирает вам пользователей, которые хотят изучать тот же язык и имеют схожий уровень, обеспечивая комфортный и эффективный процесс обучения.",
    "step-3": "3. Безопасный чат",
    "step-3-content": "Благодаря технологии IPFS ваши чаты полностью безопасны и анонимны. Ваши сообщения не хранятся ни на одном сервере и не могут быть отслежены кем-либо.",
    "step-4": "4. Непрерывное обучение",
    "step-4-content": "Каждый разговор — это новая возможность улучшить ваши языковые навыки. Общаясь с разными людьми, вы расширяете свой словарный запас и улучшаете произношение.",
    "technology-security": "Технологии и безопасность",
    "technology-security-content": "Lingoano использует новейшие технологии для обеспечения безопасного и эффективного изучения языков. Наша платформа разработана для максимальной защиты конфиденциальности и безопасности пользователей.",
    "technologies-we-use": "Технологии, которые мы используем",
    "ipfs-title": "IPFS (InterPlanetary File System)",
    "ipfs-content": "Использование децентрализованной файловой системы гарантирует, что ваши сообщения никогда не будут храниться на сервере. Эта технология создает устойчивую к цензуре и безопасную среду для общения.",
    "webrtc-title": "WebRTC",
    "webrtc-content": "Технология WebRTC используется для прямой P2P-связи, гарантируя, что ваши сообщения достигают собеседника, не проходя через сторонние серверы.",
    "open-source-title": "Открытый исходный код",
    "open-source-content": "Весь наш код опубликован с открытым исходным кодом, что позволяет экспертам по безопасности и разработчикам проверять и подтверждать нашу безопасность.",
    "user": "Отзывы пользователей:",
    "testimonials-emir": "\"Благодаря Lingoano я преодолел страх говорить по‑английски. Теперь я могу свободно общаться с иностранными друзьями.\"",
    "testimonials-privacy": "\"У меня были опасения по поводу конфиденциальности, но благодаря IPFS я использую платформу с уверенностью.\"",
    "testimonials-effective": "\"Поскольку меня подбирают с людьми моего уровня, процесс обучения стал гораздо эффективнее.\"",
    "testimonials-dr-basak": "\"Ставить в центр обучения реальную разговорную практику — педагогически сильный подход.\"",
    
    // Навигация
    "chat": "Чат",
    "about": "О Lingoano",
    "word-of-day": "Слово дня",
    "language-guides": "Языковые руководства",
    "download": "Скачать",
    
    // Главная страница
    "meet": "Lingoano Web",
    "learn": "Начните изучать языки сегодня",
    "status-content": "Веб-версия Lingoano создана для облегчения изучения языков. Вы можете практиковаться через браузер без необходимости скачивать приложение. Наша система подбора соединяет пользователей с похожими целями и уровнями.",
    "why-Lingoano": "Почему Lingoano Web",
    "donate": "Поддержать Lingoano",
    "donate-content": "Если вы хотите поддержать это приложение в разработке, вы можете сделать это на странице \"Buy Me A Coffee\".",
    
    // Метки форм
    "select-language": "Язык, на котором вы хотите говорить:",
    "select-level": "Ваш уровень в этом языке:",
    "select-placeholder": "Выберите",
    "search-match": "Найти собеседника",
    
    // Языковые опции
    "english": "Английский",
    "turkish": "Турецкий",
    "german": "Немецкий",
    "french": "Французский",
    "spanish": "Испанский",
    "russian": "Русский",
    
    // Уровни
    "level-a1": "A1 (Начинающий)",
    "level-a2": "A2 (Элементарный)",
    "level-b1": "B1 (Средний)",
    "level-b2": "B2+ (Продвинутый)",
    
    // Список функций
    "feature-browser": "Доступ через браузер - вы можете использовать его с любого устройства",
    "feature-matching": "Подбор по уровню - вы общаетесь с людьми вашего уровня",
    "feature-anonymous": "Анонимная система чата - вы можете комфортно практиковаться, сохраняя анонимность",
    "feature-multilingual": "Поддержка нескольких языков - английский, турецкий, немецкий, французский, испанский, русский",
    "feature-mobile": "Мобильный интерфейс - вы можете удобно использовать его с телефона",
    "feature-free": "Бесплатный доступ - изучайте языки без какой-либо платы",
    
    // Секция "Почему стоит учить"
    "why-learn-title": "Почему стоит изучать языки",
    "why-learn-subtitle": "Изучение языка - это не просто изучение новых слов, это открытие нового мира. Вот несколько причин, почему стоит изучать языки:",
    "career-opportunities": "Карьерные возможности",
    "career-description": "Знание второго языка дает большие преимущества в деловом мире. Вы можете работать в международных компаниях, находить возможности для работы за границей и получать более высокую зарплату.",
    "cultural-richness": "Культурное обогащение",
    "cultural-description": "Каждый язык несет в себе свою уникальную культуру и образ мышления. Изучая новый язык, вы сможете понимать фильмы, книги и музыку этой культуры.",
    "travel-freedom": "Свобода путешествий",
    "travel-description": "Возможность говорить на местном языке в чужой стране полностью меняет ваш опыт путешествий. Вы можете познакомиться не только с туристическими местами, но и с настоящей местной жизнью.",
    "brain-health": "Здоровье мозга",
    "brain-description": "Изучение языков поддерживает ваш мозг в тонусе и укрепляет память. Исследования показывают, что многоязычные люди более устойчивы к таким заболеваниям, как болезнь Альцгеймера.",
    "confidence": "Уверенность и самооценка",
    "confidence-description": "Изучение нового языка повышает вашу уверенность в себе. Достижение сложной цели делает вас смелее в других сферах жизни.",
    "social-connections": "Социальные связи",
    "social-description": "Язык - один из самых мощных инструментов, который соединяет людей. Изучая новый язык, вы можете общаться с людьми из разных уголков мира.",
    
    // Виджет словаря
    "dictionary": "Словарь",
    "search-placeholder": "Искать слова...",
    "popular-words": "Популярные слова",
    "word-not-found": "Слово не найдено",
    
    // Определение языка
    "detecting-language": "Определение языка...",
    
    // Страница чата
    "send": "Отправить",
    "ipfs-chat-started": "Подключено к IPFS. Чат начат.",
    "ipfs-connection-failed": "Не удалось подключиться к IPFS. Пожалуйста, проверьте ваше сетевое подключение.",
    "connection-error-placeholder": "Ошибка подключения",
    "websocket-connected": "Подключено к WebSocket. Теперь вы можете отправлять сообщения!",
    "demo-mode-type-message": "Демо-режим - Введите ваше сообщение...",
    "websocket-demo-mode": "Не удалось подключиться к WebSocket. Включен демо-режим.",
    "matching-search-started": "🔍 Поиск собеседника начат! Ищем подходящего партнера для вас...",
    "searching-match-button": "Поиск собеседника...",
    "waiting-match-button": "Ожидание собеседника...",
    "matching-waiting": "⏳ Ожидание собеседника... Ищем другого пользователя.",
    "matched-redirecting-button": "Собеседник найден! Перенаправление...",
    "matching-found-notification": "🎉 Собеседник найден! Перенаправление на страницу чата...",
    "matching-error": "❌ Ошибка подбора",
    "peer-disconnected-notification": "⚠️ Пользователь отключился. Пожалуйста, попробуйте снова.",
    "server-connection-failed": "🔌 Не удалось подключиться к серверу. Убедитесь, что сервер работает.",
    "select-language-level": "Пожалуйста, выберите язык и уровень.",
    
    // Страница "Слово дня"
    "learning-tips": "Советы по изучению слов",
    "tip-daily": "Ведите дневник",
    "tip-daily-desc": "Записывайте новые слова в тетрадь и регулярно их повторяйте.",
    "tip-sentences": "Составляйте предложения",
    "tip-sentences-desc": "Составляйте свои предложения с каждым новым словом и практикуйтесь.",
    "tip-connect": "Создавайте связи",
    "tip-connect-desc": "Связывайте новые слова с уже известными и укрепляйте свою память.",
    "tip-audio": "Учите с аудио",
    "tip-audio-desc": "Учитесь правильно произносить слова и повторяйте их вслух.",
    
    // Страница загрузки
    "download-title": "Скачать Lingoano",
    "download-subtitle": "Скачайте платформу для изучения языков для всех ваших устройств",
    "download-windows": "Скачать для Windows",
    "download-mac": "Скачать для Mac",
    "download-linux": "Скачать для Linux",
    "download-android": "Скачать для Android",
    "download-ios": "Скачать для iOS",
    "coming-soon": "Скоро",
    "development-in-progress": "В разработке",
    "stay-tuned": "Следите за новостями",
    
    // Страница языковых руководств
    "language-guides-title": "Языковые руководства",
    "language-guides-subtitle": "Правила грамматики, тактики и руководства по обучению",
    "english-grammar": "Английская грамматика",
    "german-grammar": "Немецкая грамматика",
    "spanish-grammar": "Испанская грамматика",
    "russian-grammar": "Русская грамматика",
    "learning-tactics": "Тактики обучения",
    "grammar-basics": "Основы грамматики",
    
    // Страница "О нас"
    "about-title": "О Lingoano",
    "about-subtitle": "Подробная информация о платформе для изучения языков",
    "what-is-Lingoano": "Что такое Lingoano?",
    "Lingoano-description": "Lingoano - это современная чат-платформа, созданная для тех, кто хочет изучать языки.",
    "our-mission": "Наша миссия",
    "privacy-security": "Конфиденциальность и безопасность",
    "community-support": "Сообщество и поддержка",
    "community-support-content": "Lingoano - это не просто платформа для изучения языков, но и сообщество, где собираются изучающие языки. Опыт и отзывы наших пользователей помогают нам постоянно улучшать платформу.",
    
    // Страница политики конфиденциальности
    "privacy-policy-title": "Политика конфиденциальности",
    "privacy-policy-subtitle": "Информация о том, как защищены ваши личные данные",
    "data-collection": "Сбор данных",
    "data-usage": "Использование данных",
    "data-protection": "Защита данных",
    "your-rights": "Ваши права",
    
    // Ключи для политики конфиденциальности и условий
    "last-updated": "Последнее обновление: 16 августа 2025 г.",
    "introduction": "1. Введение",
    "introduction-content": "В Lingoano («Lingoano», «мы» или «Компания») мы обязуемся защищать личные данные и вашу конфиденциальность. Эта Политика конфиденциальности объясняет, какие данные обрабатываются при использовании нашей платформы, цели и правовые основания для обработки, сроки хранения и ваши права.",
    "information-collected": "2. Информация, которую мы собираем",
    "personal-information": "2.1 Личные данные",
    "personal-information-content": "Как правило, Lingoano не запрашивает и не обрабатывает личные данные, такие как имя, фамилия, адрес электронной почты или номер телефона.",
    "technical-information": "2.2 Технические/Онлайн идентификаторы",
    "technical-information-content": "Для предоставления услуг, обеспечения безопасности и повышения производительности могут обрабатываться следующие технические данные:",
    "browser-type": "Тип и версия браузера",
    "operating-system": "Операционная система и информация об устройстве",
    "ip-address": "IP-адрес (применяется маскирование/анонимизация, где это возможно)",
    "page-views": "Статистика использования/взаимодействия (агрегированная и анонимная)",
    "use-of-information": "3. Использование информации",
    "use-of-information-content": "Собранные/обработанные данные используются в рамках законных интересов и для предоставления услуг в следующих целях:",
    "improve-platform": "Улучшение производительности платформы",
    "resolve-issues": "Решение технических проблем",
    "enhance-experience": "Улучшение пользовательского опыта",
    "ensure-security": "Обеспечение безопасности",
    "information-sharing": "4. Обмен информацией",
    "information-sharing-content": "Lingoano не продает и не передает информацию о пользователях в маркетинговых целях. Данные могут быть раскрыты только в случае необходимости для выполнения юридических обязательств и в ответ на должным образом уполномоченные запросы компетентных органов.",
    "cookies-tracking": "5. Файлы cookie и отслеживание",
    "cookies-tracking-content": "Для работы сервиса могут использоваться основные и предпочтительные файлы cookie. Рекламные и измерительные cookie могут быть включены сторонними поставщиками (например, Google AdSense) в соответствии с действующим законодательством.",
    "store-theme": "Сохраняет ваши предпочтения по теме",
    "remember-language": "Запоминает ваш выбор языка",
    "session-info": "Сохраняет информацию о вашей сессии",
    "user-rights": "8. Права пользователя",
    "user-rights-content": "В соответствии с действующим законодательством, пользователи имеют следующие права:",
    "access-data": "Доступ к вашим личным данным",
    "correct-data": "Исправление ваших данных",
    "delete-data": "Удаление ваших данных",
    "object-processing": "Возражение против обработки",
    "children-privacy": "9. Конфиденциальность детей",
    "children-privacy-content": "Lingoano не предназначен для лиц младше 13 лет. Мы сознательно не собираем данные детей младше 13 лет; если они будут собраны случайно, они будут удалены в разумные сроки.",
    "policy-changes": "10. Изменения в политике",
    "policy-changes-content": "Эта Политика конфиденциальности может время от времени обновляться. В случае существенных изменений дата вступления в силу будет обновлена, и будет предоставлено разумное уведомление.",
    "contact": "11. Контакты",
    "contact-content": "По вопросам, касающимся этой Политики конфиденциальности, вы можете связаться с нами через:",
    "privacy-email": "Электронная почта: privacy@Lingoano.com",
    
    // Ключи для условий использования
    "acceptance": "1. Принятие и согласие",
    "acceptance-content": "Получая доступ и используя услуги Lingoano, вы соглашаетесь с настоящими Условиями обслуживания и всеми политиками и уведомлениями, включенными посредством ссылки. Если вы не согласны, вы не должны использовать сервис.",
    "service-description": "2. Описание сервиса",
    "service-description-content": "Lingoano - это платформа, которая подбирает пользователей, желающих практиковать языки, и обеспечивает общение. Предпочтение отдается P2P-коммуникации, где это возможно. Услуга предоставляется «как есть» и «по мере доступности».",
    "general-rules": "3.1 Общие правила",
    "general-rules-content": "При использовании сервиса вы должны соблюдать действующее законодательство, общественный порядок и правила сообщества:",
    "be-respectful": "Будьте уважительны и вежливы",
    "follow-laws": "Соблюдайте законы",
    "respect-rights": "Уважайте права других",
    "no-spam": "Не делитесь спамом или вредоносным контентом",
    "no-threats": "Не угрожайте безопасности платформы",
    "prohibited-content": "3.2 Запрещенный контент",
    "prohibited-content-content": "Следующий контент и действия запрещены:",
    "hate-speech": "Разжигание ненависти и дискриминация",
    "violence": "Контент с насилием",
    "obscene-material": "Непристойные или порнографические материалы",
    "illegal-activities": "Незаконная деятельность",
    "personal-info": "Распространение личной информации",
    "false-info": "Распространение ложной информации",
    "terms-privacy-security": "4. Конфиденциальность и безопасность",
    "terms-privacy-security-content": "Lingoano уделяет приоритетное внимание конфиденциальности и безопасности пользователей. Однако пользователь несет конечную ответственность за поддержание безопасности в Интернете:",
    "self-responsibility": "Вы несете ответственность за свою собственную безопасность",
    "no-personal-info": "Не делитесь своей личной информацией",
    "report-suspicious": "Сообщайте о подозрительном поведении",
    "support-security": "Поддерживайте меры безопасности платформы",
    "intellectual-property": "5. Интеллектуальная собственность",
    "intellectual-property-content": "Торговые марки, логотипы, интерфейс, программное обеспечение, тексты и визуальные материалы Lingoano защищены действующим законодательством. Без письменного разрешения их нельзя копировать, воспроизводить, распространять или использовать для создания производных работ.",
    "service-changes": "6. Изменения в сервисе",
    "service-changes-content": "Lingoano может время от времени обновлять, приостанавливать или прекращать действие объема и функций сервиса. О существенных изменениях будет предоставлено разумное уведомление.",
    "liability-limitation": "7. Ограничение ответственности",
    "liability-limitation-content": "Услуга предоставляется на условиях «как есть» и «по мере доступности». В максимальной степени, разрешенной законом, Lingoano не несет ответственности за косвенные, случайные, особые, штрафные или косвенные убытки.",
    "account-suspension": "8. Приостановка и прекращение действия",
    "account-suspension-content": "В случае нарушения Условий доступ может быть ограничен, а учетная(ые) запись(и) может быть приостановлена или прекращена. Записи, необходимые для разрешения споров, могут храниться в соответствии с действующим законодательством.",
    "applicable-law": "10. Применимое право и юрисдикция",
    "applicable-law-content": "Настоящие Условия регулируются и толкуются в соответствии с законодательством Турецкой Республики. Суды и исполнительные органы Стамбула (Центральный) обладают юрисдикцией в отношении споров.",
    "terms-email": "Электронная почта: terms@Lingoano.com",
    
    // Страница Условий обслуживания
    "terms-title": "Условия обслуживания",
    "terms-subtitle": "Правила и условия использования платформы",
    "usage-rules": "Правила использования",
    "user-responsibilities": "Обязанности пользователя",
    "account-termination": "Прекращение действия учетной записи",
    
    // Страница чата
    "chat-title": "Чат",
    "connecting": "Подключение...",
    "waiting-for-match": "Ожидание собеседника...",
    "connected": "Подключено",
    "disconnected": "Отключено",
    "partner-left": "Ваш собеседник покинул чат",
    "new-match": "Новый собеседник",
    "leave-chat": "Покинуть чат",
    
    // Элементы меню
    "home": "Главная",
    "menu": "Меню",
    "close-menu": "Закрыть меню",
    
    // Общие термины
    "loading": "Загрузка...",
    "error": "Ошибка",
    "success": "Успешно",
    "warning": "Предупреждение",
    "info": "Информация",
    "continue": "Продолжить",
    "cancel": "Отмена",
    "save": "Сохранить",
    "delete": "Удалить",
    "edit": "Редактировать",
    "yes": "Да",
    "no": "Нет",
    "confirm-leave-chat": "Вы хотите вернуться на главную страницу? Чат будет завершен.",
    
    // Опции формы
    "select-option": "Выберите",
    
    // Опции темы
    "default-theme": "Тема по умолчанию",
    "blue-theme": "Синяя тема",
    "purple-theme": "Фиолетовая тема", 
    "green-theme": "Зеленая тема",
    
    // Специфично для страниц
    "platforms": "Платформы для настольных компьютеров",
    "mobile-platforms": "Мобильные платформы",
    "windows": "Windows",
    "mac": "Mac",
    "linux": "Linux",
    "android": "Android",
    "ios": "iOS",
    
    // Метки UI
    "menu-toggle-label": "Открыть/закрыть меню",
    "theme-switcher-label": "Переключатель тем",
    "github-visit": "Посетить профиль на GitHub",
    "privacy-policy": "Политика конфиденциальности", 
    "terms-of-service": "Условия обслуживания",
    "donate-button": "ПОЖЕРТВОВАТЬ",
    "buy-me-coffee": "Buy Me a Coffee",
    "chat-title-page": "Lingoano Чат - Платформа для изучения языков",
    "logo-alt": "Логотип",
    "about-title-page": "О Lingoano - Платформа для изучения языков",
    "download-title-page": "Скачать Lingoano - Приложение для изучения языков",
    "word-of-day-title-page": "Слово дня - Lingoano",
    "language-guides-title-page": "Языковые руководства - Lingoano",
    "language-learning-guides": "Руководства по изучению языков",
    "guides-subtitle": "Правила грамматики, тактики и советы по обучению",
    "privacy-policy-title-page": "Политика конфиденциальности - Lingoano",
    "terms-title-page": "Условия обслуживания - Lingoano",
    
    // Содержимое языковых руководств
    "english-tab": "🇺🇸 Английский",
    "german-tab": "🇩🇪 Немецкий",
    "spanish-tab": "🇪🇸 Испанский",
    "turkish-tab": "🇹🇷 Турецкий", 
    "russian-tab": "🇷🇺 Русский",
    // Раздел английской грамматики
    "english-grammar-basics": "Основы английской грамматики",
    "present-simple-title": "Present Simple",
    "present-simple-explanation": "Используется для общих фактов, привычек и регулярных действий. В третьем лице единственного числа добавляется окончание -s.",
    "present-continuous-title": "Present Continuous",
    "present-continuous-explanation": "Используется для действий, происходящих в данный момент, и планов на будущее. Структура Be + V-ing.",
    "past-simple-title": "Past Simple", 
    "past-simple-explanation": "Используется для завершенных действий в прошлом. Правильные глаголы получают окончание -ed, неправильные меняются.",
    "present-perfect-title": "Present Perfect",
    "present-perfect-explanation": "Для действий, которые начались в прошлом и продолжаются до сих пор или имеют последствия в настоящем.",
    "future-tenses-title": "Будущие времена",
    "future-tenses-explanation": "Will (неопределенное будущее), going to (запланированное будущее), Present Continuous (ближайшее будущее).",
    "conditionals-title": "Условные предложения",
    "conditionals-explanation": "Условные предложения с if: 0 (общие факты), 1 (возможное будущее), 2 (гипотетическое настоящее), 3 (гипотетическое прошлое).",
    
    // Раздел ресурсов
    "learning-resources-title": "Учебные ресурсы",
    "resources-mobile-apps-title": "Мобильные приложения",
    "resources-mobile-apps-desc": "Используйте приложения, такие как Duolingo, Memrise, Babbel.",
    "resources-video-content-title": "Видеоконтент",
    "resources-video-content-desc": "Следите за каналами по изучению языков на YouTube.",
    "resources-books-title": "Книги",
    "resources-books-desc": "Читайте грамматические справочники и книги с историями.",
    "resources-online-courses-title": "Онлайн-курсы",
    "resources-online-courses-desc": "Воспользуйтесь платформами, такими как Coursera, edX.",

    "descriptiona": "Lingoano всего в одном клике на всех ваших устройствах",
    "description": "Lingoano - это современная чат-платформа, созданная для тех, кто хочет изучать языки. Она позволяет вам практиковать язык в реальной разговорной среде с людьми, которые разделяют ту же языковую цель. Платформа создана, чтобы сделать изучение языка легким и приятным.",
    "learn-content": "В отличие от традиционных методов изучения языка, Lingoano фокусируется на реальной разговорной практике. Он предоставляет естественную языковую среду, где вы можете учиться в своем собственном темпе, взаимодействуя с людьми на том же уровне. Это позволяет вам практиковаться комфортно и эффективно.",
    "why-content": "Изучение нового языка - это не просто изучение новых слов; это открытие нового мира. Понимание разных культур, знакомство с новыми людьми и получение новых возможностей - все это часть пути. Независимо от того, интересуетесь ли вы карьерой, образованием или личностным ростом, языковые навыки становятся все более важными для всех. Lingoano предлагает простую, но эффективную отправную точку для вашего путешествия в изучении языка.",
    "career-development-content": "Знание второго языка дает большие преимущества в деловом мире. Вы можете работать в международных компаниях, находить возможности для работы за границей и получать более высокую зарплату. Английский, в частности, практически необходим в современной глобальной экономике.",
    "cultural-richness-content": "Каждый язык несет в себе свою уникальную культуру и образ мышления. Изучая новый язык, вы сможете понимать фильмы, книги и музыку этой культуры. Это позволяет вам ценить разные точки зрения и расширять свое понимание мира.",
    "travel-freedom-content": "Возможность говорить на местном языке в чужой стране полностью меняет ваш опыт путешествий. Вы можете познакомиться не только с туристическими местами, но и с настоящей местной жизнью. Это позволяет вам общаться с местными жителями и заводить новых друзей.",
    "brain-health-content": "Изучение языков поддерживает ваш мозг в тонусе и укрепляет память. Исследования показывают, что многоязычные люди более устойчивы к таким заболеваниям, как болезнь Альцгеймера.",
    "confidence-content": "Изучение нового языка повышает вашу уверенность в себе. Достижение сложной цели делает вас смелее в других сферах жизни.",
    "privacy-content": "Ваша конфиденциальность - наш главный приоритет. Сообщения хранятся в децентрализованной сети IPFS, что означает, что они не хранятся ни на одном сервере и не могут быть отслежены кем-либо еще. Это делает платформу устойчивой к цензуре и безопасной.",

    // Новые ключи перевода - Условия обслуживания
    "terms-notice": "Эти Условия обслуживания определяют правила и условия, которым вы должны следовать при использовании платформы Lingoano. Используя платформу, вы считаетесь принявшими эти условия.",
    "anonymity-notice": "Lingoano стремится защищать анонимность пользователей на самом высоком уровне. Платформа не запрашивает личную идентификационную информацию и не требует от пользователей раскрытия их настоящих личностей.",
    "no-harassment": "Не преследуйте других пользователей",
    "no-impersonation": "Не выдавайте себя за других",
    "malware": "Распространение вредоносного ПО или ссылок",
    "commercial-spam": "Коммерческий спам и рекламный контент",
    "chat-privacy": "4.1 Конфиденциальность чата",
    "chat-privacy-content": "Конфиденциальность является нашим приоритетом в чатах, проводимых через платформу:",
    "no-chat-storage": "История чатов не хранится постоянно",
    "websocket-temporary": "В чатах, использующих протокол WebSocket, сообщения обрабатываются временно и не записываются постоянно",
    "p2p-communication": "Предпочтение отдается P2P-коммуникации, когда это возможно",
    "encrypted-transmission": "Сообщения передаются в зашифрованном виде",
    "session-only": "Данные чата хранятся временно только во время сессии",
    "secure-connection": "Используйте безопасное интернет-соединение",
    "dispute-resolution": "12. Разрешение споров",
    "dispute-resolution-content": "Споры, связанные с платформой, в первую очередь решаются путем переговоров. В случае споров, которые не могут быть разрешены путем переговоров, могут быть использованы правовые средства защиты. Пользователи должны хранить необходимые документы для защиты своих прав.",
    "response-time": "Время ответа: в течение 48 часов",
    "terms-acceptance-notice": "Продолжая использовать платформу, вы считаетесь принявшими текущую версию настоящих Условий обслуживания. Изменения в условиях вступают в силу с даты их публикации.",

    // Новые ключи перевода - Политика конфиденциальности
    "privacy-notice": "Эта Политика конфиденциальности объясняет, как обрабатываются ваши личные данные при использовании платформы Lingoano. Используя платформу, вы считаетесь принявшими эту политику.",
    "anonymity-commitment": "Lingoano стремится защищать анонимность пользователей на самом высоком уровне. Платформа не запрашивает личную идентификационную информацию и не требует от пользователей раскрытия их настоящих личностей.",
    "chat-data": "2.3 Данные чата",
    "chat-data-content": "В чатах, проводимых через платформу:",
    "no-permanent-storage": "Сообщения не хранятся постоянно",
    "websocket-temporary": "В чатах, использующих протокол WebSocket, сообщения обрабатываются временно",
    "session-only-data": "Данные чата хранятся временно только во время сессии",
    "no-chat-logs": "Логи чатов не записываются постоянно",
    "p2p-preference": "Предпочтение отдается P2P-коммуникации, когда это возможно",
    "session-data": "Данные сессии (временно)",
    "preferences": "Предпочтения пользователя (тема, выбор языка)",
    "match-users": "Предоставление услуги подбора пользователей",
    "analytics": "Анализ использования платформы (анонимно)",
    "essential-cookies": "Основные файлы cookie необходимы для функционирования сервиса",
    "preference-cookies": "Файлы cookie предпочтений улучшают пользовательский опыт",
    "third-party-services": "6.1 Сторонние поставщики услуг",
    "third-party-services-content": "Платформа может использовать следующие сторонние сервисы:",
    "google-analytics": "Google Analytics (анонимный анализ использования)",
    "cdn-services": "CDN-сервисы (распространение контента)",
    "hosting-services": "Хостинговые услуги (хостинг платформы)",
    "access-controls": "Реализован контроль доступа",
    "security-audits": "Проводятся аудиты безопасности",
    "chat-security": "7.1 Безопасность чата",
    "chat-security-content": "Меры безопасности, принятые для обеспечения безопасности чата:",
    "end-to-end-encryption": "Сквозное шифрование, где это возможно",
    "temporary-messages": "Сообщения обрабатываются временно",
    "no-server-storage": "Сообщения не хранятся постоянно на сервере",
    "secure-protocols": "Используются безопасные протоколы",
    "session-timeout": "Применяется тайм-аут сессии",
    "data-retention": "8. Сроки хранения данных",
    "data-retention-content": "Lingoano работает по принципу минимального хранения данных:",
    "session-data-retention": "Данные сессии: во время сессии",
    "chat-data-retention": "Данные чата: во время сессии (не хранятся постоянно)",
    "analytics-retention": "Аналитические данные: 12 месяцев (анонимно)",
    "preferences-retention": "Предпочтения пользователя: 2 года",
    "log-retention": "Логи безопасности: 30 дней",
    "legal-retention": "Юридические обязательства: на срок, установленный законом",
    "data-portability": "Переносимость данных",
    "withdraw-consent": "Отозвать согласие",
    "complaint-right": "Право на подачу жалобы",
    "rights-exercise-content": "Чтобы воспользоваться своими правами:",
    "contact-privacy": "Отправьте электронное письмо по адресу privacy@lingoano.com",
    "response-time": "Время ответа: в течение 30 дней",
    "free-service": "Услуга бесплатна",
    "identity-verification": "Может потребоваться проверка личности",
    "international-transfers": "11. Международная передача данных",
    "international-transfers-content": "Платформа обслуживает пользователей по всему миру. Передача данных осуществляется с применением соответствующих мер безопасности. Сторонние поставщики услуг находятся в странах, обеспечивающих адекватный уровень защиты.",
    "data-protection-officer": "Сотрудник по защите данных: privacy@lingoano.com",
    "privacy-commitment": "Lingoano считает защиту конфиденциальности пользователей своим главным приоритетом. Эта политика подготовлена в соответствии с принципами прозрачности и доверия."
    },

    es: {
        "wod-streak-msg-1": "💔 Nos dejaste una vez, Igo todavía está triste.",
        "wod-streak-msg-2": "🎉 ¡Felicidades! Igo está orgulloso de tu primera racha.",
        "wod-streak-msg-3": "🏆🔥 Igo está orgulloso de tu racha, ¡bien hecho!",
        "wod-streak-msg-3-special": "🤗🎉 ¡Igo te perdona y te celebra!",
        "change-wod-language": "Cambiar idioma",
    "decentralized-structure": "<strong style='color: var(--accent-color);'>Estructura Descentralizada:</strong> <span style='color: var(--text-secondary);'>Tus datos se transmiten a través de una red distribuida y no se recopilan en una única ubicación central.</span>",
    "censorship-resistance": "<strong style='color: var(--accent-color);'>Resistencia a la Censura:</strong> <span style='color: var(--text-secondary);'>Ninguna autoridad puede bloquear nuestra plataforma; permanece accesible en todo momento.</span>",
    "full-anonymity": "<strong style='color: var(--accent-color);'>Anonimato Total:</strong> <span style='color: var(--text-secondary);'>No solicitamos información personal; no estás obligado a compartir tu nombre real.</span>",
    "minimal-data": "<strong style='color: var(--accent-color);'>Datos Mínimos:</strong> <span style='color: var(--text-secondary);'>Solo se almacena la información necesaria; no recopilamos datos innecesarios.</span>",
    "zero-record": "<strong style='color: var(--accent-color);'>Cero Registros:</strong> <span style='color: var(--text-secondary);'>Tus chats no se guardan en ningún lugar; son completamente temporales.</span>",
    "default-theme": "Tema Predeterminado",
    "blue-theme": "Tema Azul",
    "purple-theme": "Tema Morado",
    "green-theme": "Tema Verde",
    "theme-switcher-label": "Cambiador de tema",
    "menu-toggle-label": "Alternar menú",
    "type-message": "Escribe tu mensaje...",
    "guess-input-placeholder": "Escribe tu suposición...",
    "logo-alt": "Logo de Lingoano",
    "github-visit": "Visitar perfil de GitHub",
    "home-title": "Lingoano Web",
    
    // Traducciones del popup de contacto
    "contact": "1. Contacto",
    "contactfooter": "Contacto",
    "contact-us": "Contáctanos",
    "contact-info": "Información de Contacto",
    "contact-email": "Correo electrónico: contact@lingoano.com",
    "contact-description": "Para preguntas, sugerencias o comentarios, puedes contactarnos.",
    "contact-response": "Tiempo de respuesta: entre 24 y 48 horas",
    "faq-q-free": "¿Es Lingoano gratis?",
    "faq-a-free": "Sí. Lingoano es completamente gratis; no pagas por chatear ni aprender.",
    "faq-q-login": "¿Necesito cuenta o inicio de sesión?",
    "faq-a-login": "No. Lingoano no requiere registro ni inicio de sesión; puedes usarlo de forma anónima.",
    "faq-q-p2p": "¿Cómo se entregan los mensajes sin pasar por un servidor?",
    "faq-a-p2p-content": "Por defecto, se prefieren protocolos peer‑to‑peer como IPFS/WebRTC. Permiten transmitir mensajes directamente entre pares sin tocar un servidor. En esencia, se forma una red privada entre direcciones IP por la que circulan los mensajes.",
    "faq-q-udp-vpn": "¿Cómo mejora la conexión una VPN basada en UDP?",
    "faq-a-udp-vpn-content": "El cruce NAT suele estar restringido por los operadores. Las VPN basadas en UDP como WireGuard u OpenVPN‑UDP pueden aumentar el éxito de P2P/WebRTC y habilitar conexiones entre pares más rápidas y estables.",
    "faq-q-privacy": "¿Cómo sé si mi chat usa un protocolo descentralizado como IPFS?",
    "faq-a-privacy-content": "Normalmente la app intenta usar IPFS y WebRTC; si fallan, recurre a WebSocket. En ese caso, el chat se retransmite a través del servidor, pero no se almacena ningún registro de chat bajo ninguna circunstancia.",
    "faq-q-vpn-how": "¿Por qué Lingoano?",
    "faq-a-vpn-how-content": "A diferencia de otras aplicaciones, Lingoano te permite hablar con personas que están aprendiendo el mismo idioma que tú. Esto ayuda a aprender de forma eficaz y a mantener la motivación conversando con personas reales.",
    "close": "Cerrar",
    "faq-title": "Preguntas frecuentes",
    
    // Traducciones adicionales faltantes
    "todays-words": "Palabras del Día",
    "todays-words-subtitle": "Aprende nuevas palabras cada día y mejora tus habilidades lingüísticas",
    "loading-words": "Cargando palabras...",
    "learning-tips": "Consejos para Aprender Palabras",
    "tip-daily": "Lleva un Diario",
    "tip-daily-desc": "Escribe las nuevas palabras que aprendas en un cuaderno y repásalas regularmente.",
    "tip-sentences": "Construye Oraciones",
    "tip-sentences-desc": "Crea tus propias oraciones con cada nueva palabra y practica.",
    "tip-connect": "Haz Conexiones",
    "tip-connect-desc": "Conecta nuevas palabras con las que ya conoces y fortalece tu memoria.",
    "tip-audio": "Aprende con Audio",
    "tip-audio-desc": "Aprende a pronunciar la palabra correctamente y repítela en voz alta.",
    
    "footer": "Tu privacidad es nuestra prioridad. Comunícate libremente con Lingoano",

    "privacy-features": "Nuestras Características de Privacidad",
    "terminal1": " No se guarda el historial de mensajes",
    "terminal2": "> Los chats no pasan por el servidor (en el protocolo predeterminado)",
    "terminal3": "> No se solicita ni se almacena información del usuario",
    "terminal4": "> Cualquiera puede revisar el código",
    "terminal5": "> Nuestro objetivo: tomar en serio tanto el aprendizaje como la seguridad",

    "terminal": "Nuestras Características de Seguridad",
    "benefits": "Beneficios de Aprender Idiomas",
    "career-development": "Desarrollo Profesional",
    "why": "Por qué Deberías Aprender un Idioma",
    "privacy": "Privacidad y Seguridad",
    "privacy-principles": "Nuestros Principios de Privacidad",
    "p2p-fallback-disclaimer": "Cuando P2P no es posible, se utiliza WebSocket para el enrutamiento temporal del servidor; no se guardan registros persistentes.",
    "udp-vpn-tip-inline": "Usar una VPN basada en UDP (WireGuard, OpenVPN‑UDP) puede mejorar la tasa de éxito de P2P.",

    "decentralized-structure-title": "Estructura Descentralizada:",
    "decentralized-structure-desc": "Tus datos se transmiten a través de una red distribuida y no se recopilan en una única ubicación central.",
    "censorship-resistance-title": "Resistencia a la Censura:",
    "censorship-resistance-desc": "Ninguna autoridad puede bloquear nuestra plataforma; permanece accesible en todo momento.",
    "full-anonymity-title": "Anonimato Total:",
    "full-anonymity-desc": "No solicitamos tu información personal; no estás obligado a compartir tu nombre real.",
    "minimal-data-title": "Datos Mínimos:",
    "minimal-data-desc": "Solo se almacena la información necesaria; no recopilamos datos innecesarios.",
    "zero-record-title": "Cero Registros:",
    "zero-record-desc": "Tus chats no se guardan en ningún lugar; son completamente temporales.",

    "how-it-works": "Cómo Funciona",
    "how-it-works-content": "El principio de funcionamiento de Lingoano es simple y efectivo. La plataforma te empareja con personas que quieren aprender el mismo idioma y te permite practicar conversaciones reales.",
    "step-by-step-process": "Proceso Paso a Paso",
    "step-1": "1. Selecciona Idioma y Nivel",
    "step-1-content": "Elige el idioma que quieres aprender y tu nivel actual. Se admiten todos los niveles desde A1 hasta B2+, por lo que serás emparejado con personas de tu mismo nivel.",
    "step-2": "2. Emparejamiento Automático",
    "step-2-content": "El sistema te empareja automáticamente con usuarios que quieren aprender el mismo idioma y tienen un nivel similar, asegurando una experiencia de aprendizaje cómoda y efectiva.",
    "step-3": "3. Chat Seguro",
    "step-3-content": "Gracias a la tecnología IPFS, tus chats son completamente seguros y anónimos. Tus mensajes no se almacenan en ningún servidor y no pueden ser monitoreados por nadie.",
    "step-4": "4. Aprendizaje Continuo",
    "step-4-content": "Cada conversación es una nueva oportunidad para mejorar tus habilidades lingüísticas. Al hablar con diferentes personas, expandes tu vocabulario y mejoras tu pronunciación.",
    "technology-security": "Tecnología y Seguridad",
    "technology-security-content": "Lingoano utiliza las últimas tecnologías para proporcionar una experiencia de aprendizaje de idiomas segura y efectiva. Nuestra plataforma está diseñada para maximizar la privacidad y seguridad del usuario.",
    "technologies-we-use": "Tecnologías que Usamos",
    "ipfs-title": "IPFS (InterPlanetary File System)",
    "ipfs-content": "Al usar un sistema de archivos descentralizado, garantiza que tus mensajes nunca se almacenen en ningún servidor. Esta tecnología crea un entorno de comunicación seguro y resistente a la censura.",
    "webrtc-title": "WebRTC",
    "webrtc-content": "La tecnología WebRTC se utiliza para la comunicación directa de igual a igual (peer-to-peer), asegurando que tus mensajes lleguen a la otra parte sin pasar por servidores de terceros.",
    "open-source-title": "Código Fuente Abierto",
    "open-source-content": "Todo nuestro código se publica como código fuente abierto, lo que permite a expertos en seguridad y desarrolladores revisar y verificar nuestra seguridad.",
    "user": "Experiencias de Usuario:",
    "testimonials-emir": "\"Gracias a Lingoano superé mi miedo a hablar inglés. Ahora puedo charlar cómodamente con mis amigos extranjeros.\"",
    "testimonials-privacy": "\"Tenía preocupaciones sobre la privacidad, pero gracias a IPFS puedo usarlo con confianza.\"",
    "testimonials-effective": "\"Al emparejarme con personas de mi nivel, mi proceso de aprendizaje fue mucho más eficaz.\"",
    "testimonials-dr-basak": "\"Centrar la práctica real del habla en el aprendizaje de idiomas es un enfoque pedagógicamente sólido.\"",
    
    // Navegación
    "chat": "Chat",
    "about": "Acerca de Lingoano",
    "word-of-day": "Palabra del Día",
    "language-guides": "Guías de Idiomas",
    "download": "Descargar",
    
    // Página principal
    "meet": "Lingoano Web",
    "learn": "Comienza a aprender idiomas hoy",
    "status-content": "La versión web de Lingoano está diseñada para facilitar el aprendizaje de idiomas. Puedes practicar a través de tu navegador sin necesidad de descargar una aplicación. Nuestro sistema de emparejamiento reúne a usuarios con objetivos y niveles similares.",
    "why-Lingoano": "Por qué Lingoano Web",
    "donate": "Apoya a Lingoano",
    "donate-content": "Si quieres apoyar esta aplicación en desarrollo, puedes hacerlo desde la página \"Buy Me A Coffee\".",
    
    // Etiquetas de formulario
    "select-language": "Idioma que quieres hablar:",
    "select-level": "Tu nivel en este idioma:",
    "select-placeholder": "Seleccionar",
    "search-match": "Buscar Pareja",
    
    // Opciones de idioma
    "english": "Inglés",
    "turkish": "Turco",
    "german": "Alemán",
    "french": "Francés",
    "spanish": "Español",
    "russian": "Ruso",
    
    // Opciones de nivel
    "level-a1": "A1 (Principiante)",
    "level-a2": "A2 (Elemental)",
    "level-b1": "B1 (Intermedio)",
    "level-b2": "B2+ (Avanzado)",
    
    // Lista de características
    "feature-browser": "Acceso desde el navegador: puedes usarlo desde cualquier dispositivo",
    "feature-matching": "Emparejamiento por nivel: hablas con personas de tu mismo nivel",
    "feature-anonymous": "Sistema de chat anónimo: puedes practicar cómodamente manteniendo tu identidad oculta",
    "feature-multilingual": "Soporte multilingüe: inglés, turco, alemán, francés, español, ruso",
    "feature-mobile": "Interfaz amigable para móviles: puedes usarlo cómodamente desde tu teléfono",
    "feature-free": "Acceso gratuito: aprende idiomas sin pagar ninguna tarifa",
    
    // Sección "Por qué aprender"
    "why-learn-title": "Por qué Deberías Aprender Idiomas",
    "why-learn-subtitle": "Aprender un idioma no es solo aprender nuevas palabras, es descubrir un nuevo mundo. Aquí tienes algunas razones por las que deberías aprender idiomas:",
    "career-opportunities": "Oportunidades Profesionales",
    "career-description": "Saber un segundo idioma ofrece grandes ventajas en el mundo de los negocios. Puedes trabajar en empresas internacionales, encontrar oportunidades de trabajo en el extranjero y ganar salarios más altos.",
    "cultural-richness": "Riqueza Cultural",
    "cultural-description": "Cada idioma contiene su propia cultura y forma de pensar únicas. Cuando aprendes un nuevo idioma, puedes entender las películas, los libros y la música de esa cultura.",
    "travel-freedom": "Libertad para Viajar",
    "travel-description": "Ser capaz de hablar el idioma local en un país extranjero cambia por completo tu experiencia de viaje. Puedes vivir no solo lugares turísticos, sino experiencias locales reales.",
    "brain-health": "Salud Cerebral",
    "brain-description": "Aprender idiomas mantiene tu cerebro activo y fortalece tu memoria. Las investigaciones demuestran que las personas multilingües son más resistentes a enfermedades como el Alzheimer.",
    "confidence": "Confianza y Autoestima",
    "confidence-description": "Aprender un nuevo idioma aumenta tu confianza en ti mismo. Ver que has logrado un objetivo desafiante te hace más valiente en otras áreas de tu vida.",
    "social-connections": "Conexiones Sociales",
    "social-description": "El idioma es una de las herramientas más poderosas que conecta a las personas. Cuando aprendes un nuevo idioma, puedes comunicarte con personas de diferentes partes del mundo.",
    
    // Widget de diccionario
    "dictionary": "Diccionario",
    "search-placeholder": "Buscar palabras...",
    "popular-words": "Palabras Populares",
    "word-not-found": "Palabra no encontrada",
    
    // Detección de idioma
    "detecting-language": "Detectando idioma...",
    
    // Página de chat
    "send": "Enviar",
    "ipfs-chat-started": "Conectado a IPFS. Chat iniciado.",
    "ipfs-connection-failed": "Fallo al conectar con IPFS. Por favor, comprueba tu red.",
    "connection-error-placeholder": "Error de conexión",
    "websocket-connected": "Conectado a WebSocket. ¡Ya puedes enviar mensajes!",
    "demo-mode-type-message": "Modo de demostración - Escribe tu mensaje...",
    "websocket-demo-mode": "Fallo en la conexión WebSocket. Modo de demostración activado.",
    "matching-search-started": "🔍 ¡Búsqueda de pareja iniciada! Buscando un compañero adecuado para ti...",
    "searching-match-button": "Buscando pareja...",
    "waiting-match-button": "Esperando pareja...",
    "matching-waiting": "⏳ Esperando pareja... Buscando otro usuario.",
    "matched-redirecting-button": "¡Pareja encontrada! Redirigiendo...",
    "matching-found-notification": "🎉 ¡Pareja encontrada! Redirigiendo a la página de chat...",
    "matching-error": "❌ Error de emparejamiento",
    "peer-disconnected-notification": "⚠️ El usuario emparejado se desconectó. Por favor, inténtalo de nuevo.",
    "server-connection-failed": "🔌 No se pudo conectar al servidor. Por favor, asegúrate de que el servidor está en funcionamiento.",
    "select-language-level": "Por favor, selecciona un idioma y un nivel.",
    
    // Página de "Palabra del día"
    "learning-tips": "Consejos para Aprender Palabras",
    "tip-daily": "Lleva un Diario",
    "tip-daily-desc": "Escribe las nuevas palabras que aprendas en un cuaderno y repásalas regularmente.",
    "tip-sentences": "Crea Oraciones",
    "tip-sentences-desc": "Crea tus propias oraciones para cada nueva palabra y practica.",
    "tip-connect": "Haz Conexiones",
    "tip-connect-desc": "Conecta nuevas palabras con las que ya conoces y fortalece tu memoria.",
    "tip-audio": "Aprende con Audio",
    "tip-audio-desc": "Aprende a pronunciar las palabras correctamente y repítelas en voz alta.",
    
    // Página de descargas
    "download-title": "Descargar Lingoano",
    "download-subtitle": "Descarga la plataforma de aprendizaje de idiomas para todos tus dispositivos",
    "download-windows": "Descargar para Windows",
    "download-mac": "Descargar para Mac",
    "download-linux": "Descargar para Linux",
    "download-android": "Descargar para Android",
    "download-ios": "Descargar para iOS",
    "coming-soon": "Próximamente",
    "development-in-progress": "En Desarrollo",
    "stay-tuned": "Mantente Atento",
    
    // Página de guías de idiomas
    "language-guides-title": "Guías de Idiomas",
    "language-guides-subtitle": "Reglas gramaticales, tácticas y guías de aprendizaje",
    "english-grammar": "Gramática Inglesa",
    "german-grammar": "Gramática Alemana",
    "spanish-grammar": "Gramática Española",
    "russian-grammar": "Gramática Rusa",
    "learning-tactics": "Tácticas de Aprendizaje",
    "grammar-basics": "Conceptos Básicos de Gramática",
    
    // Página "Acerca de"
    "about-title": "Acerca de Lingoano",
    "about-subtitle": "Información detallada sobre la plataforma de aprendizaje de idiomas",
    "what-is-Lingoano": "¿Qué es Lingoano?",
    "Lingoano-description": "Lingoano es una moderna plataforma de chat diseñada para quienes quieren aprender idiomas.",
    "our-mission": "Nuestra Misión",
    "privacy-security": "Privacidad y Seguridad",
    "community-support": "Comunidad y Soporte",
    "community-support-content": "Lingoano no es solo una plataforma de aprendizaje de idiomas, sino también una comunidad donde se reúnen los estudiantes de idiomas. Las experiencias y comentarios de nuestros usuarios nos ayudan a mejorar continuamente la plataforma.",
    // Página de política de privacidad
    "privacy-policy-title": "Política de Privacidad",
    "privacy-policy-subtitle": "Información sobre cómo se protegen tus datos personales",
    "data-collection": "Recopilación de Datos",
    "data-usage": "Uso de Datos",
    "data-protection": "Protección de Datos",
    "your-rights": "Tus Derechos",
    
    // Claves detalladas de Privacidad y Términos
    "last-updated": "Última actualización: 16 de agosto de 2025",
    "introduction": "1. Introducción",
    "introduction-content": "En Lingoano (\"Lingoano\", \"nosotros\" o la \"Compañía\"), estamos comprometidos con la protección de los datos personales y tu privacidad. Esta Política de Privacidad explica qué datos se procesan cuando utilizas nuestra plataforma, los propósitos y bases legales para el procesamiento, los períodos de retención y tus derechos.",
    "information-collected": "2. Información que Recopilamos",
    "personal-information": "2.1 Datos Personales",
    "personal-information-content": "Como regla general, Lingoano no solicita ni procesa datos personales como nombre, apellido, correo electrónico o número de teléfono.",
    "technical-information": "2.2 Identificadores Técnicos/En Línea",
    "technical-information-content": "Para proporcionar el servicio, garantizar la seguridad y mejorar el rendimiento, se pueden procesar los siguientes datos técnicos:",
    "browser-type": "Tipo y versión del navegador",
    "operating-system": "Sistema operativo e información del dispositivo",
    "ip-address": "Dirección IP (se aplica enmascaramiento/anonimización cuando es posible)",
    "page-views": "Estadísticas de uso/interacción (agregadas y anónimas)",
    "use-of-information": "3. Uso de la Información",
    "use-of-information-content": "Los datos recopilados/procesados se utilizan bajo intereses legítimos y para la prestación del servicio con los siguientes fines:",
    "improve-platform": "Mejorar el rendimiento de la plataforma",
    "resolve-issues": "Resolver problemas técnicos",
    "enhance-experience": "Mejorar la experiencia del usuario",
    "ensure-security": "Garantizar la seguridad",
    "information-sharing": "4. Intercambio de Información",
    "information-sharing-content": "Lingoano no vende ni comparte información de usuarios con fines de marketing. Los datos pueden divulgarse solo cuando sea necesario para cumplir con obligaciones legales y para responder a solicitudes debidamente autorizadas de las autoridades competentes.",
    "cookies-tracking": "5. Cookies y Seguimiento",
    "cookies-tracking-content": "Se pueden utilizar cookies esenciales y de preferencia para operar el servicio. Las cookies de publicidad y medición pueden ser habilitadas por proveedores de terceros (por ejemplo, Google AdSense) en cumplimiento de las leyes aplicables.",
    "store-theme": "Almacena tus preferencias de tema",
    "remember-language": "Recuerda tu selección de idioma",
    "session-info": "Conserva la información de tu sesión",
    "user-rights": "8. Derechos del Usuario",
    "user-rights-content": "Sujeto a la ley aplicable, los usuarios tienen los siguientes derechos:",
    "access-data": "Acceder a tus datos personales",
    "correct-data": "Rectificar tus datos",
    "delete-data": "Eliminar tus datos",
    "object-processing": "Oponerse al procesamiento",
    "children-privacy": "9. Privacidad de los Niños",
    "children-privacy-content": "Lingoano no está dirigido a personas menores de 13 años. No recopilamos conscientemente datos de niños menores de 13 años; si se recopilan inadvertidamente, se eliminarán en un tiempo razonable.",
    "policy-changes": "10. Cambios en la Política",
    "policy-changes-content": "Esta Política de Privacidad puede actualizarse de vez en cuando. Para cambios materiales, se actualizará la fecha de vigencia y se proporcionará un aviso razonable.",
    "contact": "11. Contacto",
    "contact-content": "Para preguntas sobre esta Política de Privacidad, puedes contactarnos a través de:",
    "privacy-email": "Correo electrónico: privacy@Lingoano.com",
    
    // Claves detalladas de los Términos
    "acceptance": "1. Aceptación y Consentimiento",
    "acceptance-content": "Al acceder y utilizar los servicios de Lingoano, aceptas estos Términos de Servicio y todas las políticas y avisos incorporados por referencia. Si no estás de acuerdo, no debes utilizar el servicio.",
    "service-description": "2. Descripción del Servicio",
    "service-description-content": "Lingoano es una plataforma que empareja a usuarios que quieren practicar idiomas y permite la comunicación. Se prefiere la comunicación de igual a igual (P2P) cuando es factible. El servicio se proporciona \"tal cual\" y \"según disponibilidad\".",
    "general-rules": "3.1 Reglas Generales",
    "general-rules-content": "Durante el uso del servicio, debes cumplir con las leyes aplicables, el orden público y las reglas de la comunidad:",
    "be-respectful": "Sé respetuoso y cortés",
    "follow-laws": "Cumple con las leyes",
    "respect-rights": "Respeta los derechos de los demás",
    "no-spam": "No compartas spam ni contenido dañino",
    "no-threats": "No amenaces la seguridad de la plataforma",
    "prohibited-content": "3.2 Contenido Prohibido",
    "prohibited-content-content": "Los siguientes contenidos y actos están prohibidos:",
    "hate-speech": "Discurso de odio y discriminación",
    "violence": "Contenido violento",
    "obscene-material": "Material obsceno o pornográfico",
    "illegal-activities": "Actividades ilegales",
    "personal-info": "Compartir información personal",
    "false-info": "Difundir información falsa",
    "terms-privacy-security": "4. Privacidad y Seguridad",
    "terms-privacy-security-content": "Lingoano prioriza la privacidad y seguridad del usuario. Sin embargo, el usuario tiene la responsabilidad final de mantener la seguridad en línea:",
    "self-responsibility": "Eres responsable de tu propia seguridad",
    "no-personal-info": "No compartas tu información personal",
    "report-suspicious": "Informa sobre comportamientos sospechosos",
    "support-security": "Apoya las medidas de seguridad de la plataforma",
    "intellectual-property": "5. Propiedad Intelectual",
    "intellectual-property-content": "Las marcas comerciales, logotipos, interfaz, software, textos y elementos visuales de Lingoano están protegidos por las leyes aplicables. Sin permiso por escrito, no pueden ser copiados, reproducidos, distribuidos o utilizados para crear obras derivadas.",
    "service-changes": "6. Cambios en el Servicio",
    "service-changes-content": "Lingoano puede actualizar, suspender o descontinuar el alcance y las funciones del servicio de vez en cuando. Se proporcionará un aviso razonable para cambios materiales.",
    "liability-limitation": "7. Limitación de Responsabilidad",
    "liability-limitation-content": "El servicio se proporciona \"tal cual\" y \"según disponibilidad\". En la máxima medida permitida por la ley, Lingoano no será responsable por daños indirectos, incidentales, especiales, punitivos o consecuentes.",
    "account-suspension": "8. Suspensión y Terminación",
    "account-suspension-content": "En caso de violación de los Términos, el acceso puede ser restringido y la(s) cuenta(s) pueden ser suspendidas o terminadas. Los registros necesarios para la resolución de disputas pueden conservarse en cumplimiento de las leyes aplicables.",
    "applicable-law": "10. Ley Aplicable y Jurisdicción",
    "applicable-law-content": "Estos Términos se rigen e interpretan de acuerdo con las leyes de la República de Turquía. Los tribunales y oficinas de ejecución de Estambul (Central) tendrán jurisdicción sobre las disputas.",
    "terms-email": "Correo electrónico: terms@Lingoano.com",
    
    // Página de Términos de Servicio
    "terms-title": "Términos de Servicio",
    "terms-subtitle": "Reglas y condiciones de uso de la plataforma",
    "usage-rules": "Reglas de Uso",
    "user-responsibilities": "Responsabilidades del Usuario",
    "account-termination": "Terminación de la Cuenta",
    
    // Página de chat
    "chat-title": "Chat",
    "connecting": "Conectando...",
    "waiting-for-match": "Esperando pareja...",
    "connected": "Conectado",
    "disconnected": "Desconectado",
    "partner-left": "Tu compañero de chat se ha ido",
    "new-match": "Nueva Pareja",
    "leave-chat": "Salir del Chat",
    
    // Elementos del menú
    "home": "Inicio",
    "menu": "Menú",
    "close-menu": "Cerrar Menú",
    
    // Términos comunes
    "loading": "Cargando...",
    "error": "Error",
    "success": "Éxito",
    "warning": "Advertencia",
    "info": "Información",
    "continue": "Continuar",
    "cancel": "Cancelar",
    "save": "Guardar",
    "delete": "Eliminar",
    "edit": "Editar",
    "yes": "Sí",
    "no": "No",
    "confirm-leave-chat": "¿Quieres volver a la página de inicio? El chat finalizará.",
    
    // Opciones de formulario
    "select-option": "Seleccionar",
    
    // Opciones de tema
    "default-theme": "Tema Predeterminado",
    "blue-theme": "Tema Azul",
    "purple-theme": "Tema Morado", 
    "green-theme": "Tema Verde",
    
    // Específico de páginas
    "platforms": "Plataformas de Escritorio",
    "mobile-platforms": "Plataformas Móviles",
    "windows": "Windows",
    "mac": "Mac",
    "linux": "Linux",
    "android": "Android",
    "ios": "iOS",
    
    // Etiquetas de la interfaz de usuario
    "menu-toggle-label": "Abrir/cerrar menú",
    "theme-switcher-label": "Cambiador de tema",
    "github-visit": "Visitar perfil de GitHub",
    "privacy-policy": "Política de Privacidad", 
    "terms-of-service": "Términos de Servicio",
    "donate-button": "DONAR",
    "buy-me-coffee": "Buy Me a Coffee",
    "chat-title-page": "Chat de Lingoano - Plataforma de Aprendizaje de Idiomas",
    "logo-alt": "Logo",
    "about-title-page": "Acerca de Lingoano - Plataforma de Aprendizaje de Idiomas",
    "download-title-page": "Descargar Lingoano - Aplicación de Aprendizaje de Idiomas",
    "word-of-day-title-page": "Palabra del Día - Lingoano",
    "language-guides-title-page": "Guías de Idiomas - Lingoano",
    "language-learning-guides": "Guías de Aprendizaje de Idiomas",
    "guides-subtitle": "Reglas gramaticales, tácticas y consejos de aprendizaje",
    "privacy-policy-title-page": "Política de Privacidad - Lingoano",
    "terms-title-page": "Términos de Servicio - Lingoano",
    
    // Contenido de las guías de idiomas
    "english-tab": "🇺🇸 Inglés",
    "german-tab": "🇩🇪 Alemán",
    "spanish-tab": "🇪🇸 Español",
    "turkish-tab": "🇹🇷 Turco", 
    "russian-tab": "🇷🇺 Ruso",
    
    // Sección de gramática inglesa
    "english-grammar-basics": "Conceptos Básicos de Gramática Inglesa",
    "present-simple-title": "Present Simple",
    "present-simple-explanation": "Se usa para hechos generales, hábitos y acciones regulares. La tercera persona del singular lleva la terminación -s.",
    "present-continuous-title": "Present Continuous",
    "present-continuous-explanation": "Se usa para acciones en curso ahora y planes futuros. Estructura Be + V-ing.",
    "past-simple-title": "Past Simple", 
    "past-simple-explanation": "Se usa para acciones completadas en el pasado. Los verbos regulares llevan -ed, los irregulares cambian.",
    "present-perfect-title": "Present Perfect",
    "present-perfect-explanation": "Para acciones que comenzaron en el pasado y continúan hasta ahora o tienen efectos continuos.",
    "future-tenses-title": "Tiempos Futuros",
    "future-tenses-explanation": "Will (futuro incierto), going to (futuro planeado), Present Continuous (futuro cercano).",
    "conditionals-title": "Condicionales",
    "conditionals-explanation": "Cláusulas If: 0 (hechos generales), 1 (futuro posible), 2 (presente hipotético), 3 (pasado hipotético).",
    
    // Sección de recursos
    "learning-resources-title": "Recursos de Aprendizaje",
    "resources-mobile-apps-title": "Aplicaciones Móviles",
    "resources-mobile-apps-desc": "Usa aplicaciones como Duolingo, Memrise, Babbel.",
    "resources-video-content-title": "Contenido en Video",
    "resources-video-content-desc": "Sigue canales de aprendizaje de idiomas en YouTube.",
    "resources-books-title": "Libros",
    "resources-books-desc": "Lee libros de gramática y libros de cuentos.",
    "resources-online-courses-title": "Cursos en Línea",
    "resources-online-courses-desc": "Aprovecha plataformas como Coursera, edX.",

    "descriptiona": "Lingoano está a solo un botón de distancia en todos tus dispositivos",
    "description": "Lingoano es una moderna plataforma de chat diseñada para quienes quieren aprender idiomas. Te permite practicar el idioma en un entorno de conversación real con personas que comparten el mismo objetivo lingüístico. La plataforma está diseñada para que el aprendizaje de idiomas sea fácil y agradable.",
    "learn-content": "A diferencia de los métodos tradicionales de aprendizaje de idiomas, Lingoano se centra en la práctica de conversaciones reales. Proporciona un entorno lingüístico natural donde puedes aprender a tu propio ritmo, mientras interactúas con personas del mismo nivel. Esto te permite practicar de una manera cómoda y efectiva.",
    "why-content": "Aprender un nuevo idioma no es solo aprender nuevas palabras; es descubrir un nuevo mundo. Comprender diferentes culturas, conocer gente nueva y experimentar nuevas oportunidades son parte del viaje. Ya sea que estés interesado en una carrera, educación o crecimiento personal, las habilidades lingüísticas son cada vez más importantes para todos. Lingoano ofrece un punto de partida simple pero efectivo para tu viaje de aprendizaje de idiomas.",
    "career-development-content": "Saber un segundo idioma ofrece grandes ventajas en el mundo de los negocios. Puedes trabajar en empresas internacionales, encontrar oportunidades de trabajo en el extranjero y ganar salarios más altos. El inglés, en particular, es casi esencial en la economía global actual.",
    "cultural-richness-content": "Cada idioma contiene su propia cultura y forma de pensar únicas. Cuando aprendes un nuevo idioma, puedes entender las películas, los libros y la música de esa cultura. Esto te permite apreciar diferentes perspectivas y ampliar tu comprensión del mundo.",
    "travel-freedom-content": "Ser capaz de hablar el idioma local en un país extranjero cambia por completo tu experiencia de viaje. Puedes vivir no solo lugares turísticos, sino experiencias locales reales. Esto te permite conectar con los locales y hacer nuevos amigos en el camino.",
    "brain-health-content": "Aprender idiomas mantiene tu cerebro activo y fortalece tu memoria. Las investigaciones demuestran que las personas multilingües son más resistentes a enfermedades como el Alzheimer.",
    "confidence-content": "Aprender un nuevo idioma aumenta tu confianza en ti mismo. Ver que has logrado un objetivo desafiante te hace más valiente en otras áreas de tu vida.",
    "privacy-content": "Tu privacidad es nuestra máxima prioridad. Los mensajes se almacenan en una red IPFS descentralizada, lo que significa que no se guardan en ningún servidor y no pueden ser monitoreados por nadie más. Esto hace que la plataforma sea resistente a la censura y segura.",

    // Nuevas claves de traducción - Términos de Servicio
    "terms-notice": "Estos Términos de Servicio definen las reglas y condiciones que debes seguir al usar la plataforma Lingoano. Al usar la plataforma, se considera que has aceptado estos términos.",
    "anonymity-notice": "Lingoano se compromete a proteger el anonimato del usuario al más alto nivel. La plataforma no solicita información de identificación personal y no requiere que los usuarios compartan sus identidades reales.",
    "no-harassment": "No acosar a otros usuarios",
    "no-impersonation": "No suplantar a otros",
    "malware": "Compartir software o enlaces maliciosos",
    "commercial-spam": "Spam comercial y contenido publicitario",
    "chat-privacy": "4.1 Privacidad del Chat",
    "chat-privacy-content": "La privacidad es nuestra prioridad en los chats realizados a través de la plataforma:",
    "no-chat-storage": "El historial de chat no se almacena permanentemente",
    "websocket-temporary": "En los chats que usan el protocolo WebSocket, los mensajes se procesan temporalmente y no se registran permanentemente",
    "p2p-communication": "Se prefiere la comunicación de igual a igual cuando es posible",
    "encrypted-transmission": "Los mensajes se transmiten cifrados",
    "session-only": "Los datos del chat solo se retienen temporalmente durante la sesión",
    "secure-connection": "Usa una conexión a internet segura",
    "download-windows": "Windows İçin İndir",
    "download-mac": "Mac İçin İndir", 
    "download-linux": "Linux İçin İndir",
    "download-android": "Android İçin İndir",
    "download-ios": "iOS İçin İndir",
    "download-title": "İndir",
    "download-description": "Lingoano'yu indirin ve dünyanın her yerinde dil öğrenme deneyiminizi geliştirin.",
    "download-button": "İndir",
    "download-platforms": "Platformlar",
    "download-mobile": "Mobil",
    "download-desktop": "Masaüstü",
    "download-windows": "Windows İçin İndir",
    "download-mac": "Mac İçin İndir",
    "download-linux": "Linux İçin İndir",
    "download-android": "Android İçin İndir",
    "download-ios": "iOS İçin İndir",
    "download-title-page": "Lingoano'yu İndir - Dil Öğrenme Uygulaması",
    "word-of-day-title": "Günün Kelimesi",
    "word-of-day-description": "Her gün yeni bir kelime öğrenin ve dil becerilerinizi geliştirin.",
    "word-of-day-button": "Günün Kelimesi",
    "language-guides-title": "Dil Kılavuzları",
    "language-guides-description": "Dil öğrenme kılavuzlarımızla dil becerilerinizi geliştirin.",
    "language-guides-button": "Dil Kılavuzları",
    "privacy-policy-title": "Gizlilik Politikası",
    "privacy-policy-description": "Verilerinizin nasıl korunduğunu öğrenin.",
    "privacy-policy-button": "Gizlilik Politikası",
    "terms-of-service-title": "Kullanım Şartları",
    "terms-of-service-description": "Platformu kullanım şartlarımızı inceleyin.",
    "terms-of-service-button": "Kullanım Şartları",
    "contact-title": "İletişim",
    "contact-description": "Sorularınızı, önerileriniz veya geri bildirimleriniz için bizimle iletişime geçin.",
    "contact-button": "İletişim",
    "contact-email": "E-posta: contact@lingoano.com",
    "contact-response": "Yanıt süresi: 24-48 saat içinde",
    "close": "Kapat"

     }
};
// Language management class
class LanguageManager {
    constructor() {
        this.currentLanguage = localStorage.getItem('Lingoano-site-language') || null;
        this.init();
    }
    
    init() {
        if (this.currentLanguage) {
            // User has already selected a language, use it
            this.setLanguage(this.currentLanguage);
        } else {
            // No language selected, detect from IP
            this.detectLanguageFromIP();
        }
        this.bindEvents();
    }
    
    async detectLanguageFromIP() {
        // Show loading indicator
        this.showLanguageLoading();
        
        // Try multiple IP detection services for better reliability
        const services = [
            'https://ipapi.co/json/',
            'https://ipinfo.io/json',
            'https://api.ipify.org?format=json'
        ];
        
        for (const service of services) {
            try {
                const controller = new AbortController();
                const timeoutId = setTimeout(() => controller.abort(), 5000);
                
                const response = await fetch(service, { 
                    method: 'GET',
                    headers: { 'Accept': 'application/json' },
                    signal: controller.signal
                });
                
                clearTimeout(timeoutId);
                
                if (!response.ok) continue;
                
                const data = await response.json();
                
                // Handle different response formats
                let countryCode = null;
                if (data.country_code) {
                    countryCode = data.country_code.toLowerCase();
                } else if (data.country) {
                    countryCode = data.country.toLowerCase();
                }
                
                if (countryCode) {
                    const detectedLanguage = this.getLanguageFromCountry(countryCode);
                    
                    if (detectedLanguage) {
                        const countryName = data.country_name || data.country || countryCode;
                        console.log(`Detected language from IP: ${detectedLanguage} (Country: ${countryName})`);
                        this.hideLanguageLoading();
                        this.setLanguage(detectedLanguage);
                        return;
                    }
                }
            } catch (error) {
                console.log(`IP detection service ${service} failed:`, error.message);
                continue;
            }
        }
        
        // If all IP services fail, try browser language detection
        console.log('All IP detection services failed, trying browser language...');
        this.detectLanguageFromBrowser();
    }
    
    showLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'flex';
        }
    }
    
    hideLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'none';
        }
    }
    
    getLanguageFromCountry(countryCode) {
        // Map countries to supported languages
        const countryToLanguage = {
            // Turkish speaking countries
            'tr': 'tr',
            'cy': 'tr', // Northern Cyprus
            
            // English speaking countries
            'us': 'en', 'gb': 'en', 'ca': 'en', 'au': 'en', 'nz': 'en', 'ie': 'en',
            'za': 'en', 'in': 'en', 'pk': 'en', 'ng': 'en', 'ke': 'en', 'ug': 'en',
            'tz': 'en', 'gh': 'en', 'zm': 'en', 'zw': 'en', 'mw': 'en', 'bw': 'en',
            'sz': 'en', 'ls': 'en', 'na': 'en', 'mu': 'en', 'sc': 'en', 'mv': 'en',
            'lk': 'en', 'bd': 'en', 'np': 'en', 'bt': 'en', 'mm': 'en', 'kh': 'en',
            'la': 'en', 'vn': 'en', 'my': 'en', 'sg': 'en', 'bn': 'en', 'ph': 'en',
            'fj': 'en', 'pg': 'en', 'sb': 'en', 'vu': 'en', 'nc': 'en', 'pf': 'en',
            'to': 'en', 'ws': 'en', 'ki': 'en', 'tv': 'en', 'nr': 'en', 'pw': 'en',
            'mh': 'en', 'fm': 'en', 'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en',
            'jm': 'en', 'bb': 'en', 'gd': 'en', 'lc': 'en', 'vc': 'en', 'ag': 'en',
            'dm': 'en', 'kn': 'en', 'ai': 'en', 'vg': 'en', 'tc': 'en', 'ms': 'en',
            'ky': 'en', 'bm': 'en', 'fk': 'en', 'gi': 'en', 'sh': 'en', 'io': 'en',
            'pn': 'en', 'ck': 'en', 'nu': 'en', 'tk': 'en', 'wf': 'en', 'as': 'en',
            'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en', 'jm': 'en', 'bb': 'en',
            
            // German speaking countries
            'de': 'de', 'at': 'de', 'ch': 'de', 'li': 'de', 'lu': 'de',
            
            // French speaking countries
            'fr': 'fr', 'be': 'fr', 'mc': 'fr', 'ca': 'fr',

            // Spanish speaking countries
            'es': 'es', 'mx': 'es', 'ar': 'es', 'cl': 'es', 'pe': 'es', 'co': 'es', 'ec': 'es',
            'uy': 'es', 'py': 'es', 'bo': 'es', 've': 'es', 'do': 'es', 'cr': 'es', 'gt': 'es',
            'hn': 'es', 'ni': 'es', 'sv': 'es', 'pa': 'es', 'cu': 'es',
            
            // Russian speaking countries
            'ru': 'ru', 'by': 'ru', 'kz': 'ru', 'kg': 'ru', 'tj': 'ru',
            'uz': 'ru', 'tm': 'ru', 'md': 'ru', 'ge': 'ru', 'am': 'ru',
            'az': 'ru', 'ua': 'ru', 'ee': 'ru', 'lv': 'ru', 'lt': 'ru'
        };
        
        return countryToLanguage[countryCode] || null;
    }
    
    detectLanguageFromBrowser() {
        // Get browser language
        const browserLang = navigator.language || navigator.userLanguage;
        const langCode = browserLang.split('-')[0].toLowerCase();
        
        // Map browser language to supported languages
        const browserToLanguage = {
            'tr': 'tr',
            'en': 'en',
            'de': 'de',
            'fr': 'fr',
            'es': 'es',
            'ru': 'ru'
        };
        
        const detectedLanguage = browserToLanguage[langCode];
        
        if (detectedLanguage) {
            console.log(`Detected language from browser: ${detectedLanguage}`);
            this.hideLanguageLoading();
            this.setLanguage(detectedLanguage);
        } else {
            // Default to Turkish if no match found
            console.log('No language detected, defaulting to Turkish');
            this.hideLanguageLoading();
            this.setLanguage('tr');
        }
    }
    
    setLanguage(lang, saveToStorage = false) {
        if (!translations[lang]) {
            console.warn(`Language ${lang} not found, falling back to Turkish`);
            lang = 'tr';
        }
        
        this.currentLanguage = lang;
        
        // Only save to localStorage if user manually selected
        if (saveToStorage) {
            localStorage.setItem('Lingoano-site-language', lang);
        }
        
        // Update language selectors
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.value = lang;
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.value = lang;
        }
        
        // Update all translatable elements
        this.updatePageContent();
    }
    
    getText(key) {
        return translations[this.currentLanguage][key] || translations['tr'][key] || key;
    }
    
    updatePageContent() {
        // Update elements with data-lang attribute
        const elements = document.querySelectorAll('[data-lang]');
        elements.forEach(element => {
            const key = element.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                if (element.tagName === 'INPUT' && element.hasAttribute('placeholder')) {
                    element.placeholder = translation;
                } else if (element.hasAttribute('title')) {
                    element.title = translation;
                } else if (element.hasAttribute('aria-label')) {
                    element.setAttribute('aria-label', translation);
                } else if (element.hasAttribute('alt')) {
                    element.alt = translation;
                } else {
                    element.innerHTML = translation;
                }
            }
        });
        
        // Update form options
        this.updateFormOptions();
        
        // Update dictionary widget if it exists
        if (window.dictionaryWidget) {
            window.dictionaryWidget.updateLanguage();
        }
    }
    
    updateFormOptions() {
        // Update language form options
        const languageSelect = document.getElementById('language');
        if (languageSelect) {
            const options = languageSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = option.value;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update level form options
        const levelSelect = document.getElementById('level');
        if (levelSelect) {
            const options = levelSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = `level-${option.value.toLowerCase()}`;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update meta description for current language
        const metaDesc = document.querySelector('meta[name="description"]');
        if (metaDesc) {
            const currentLang = this.currentLanguage;
            // This could be expanded to have page-specific descriptions per language
        }
        
        // Update document title if it has data-lang
        const titleElement = document.querySelector('title[data-lang]');
        if (titleElement) {
            const key = titleElement.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                titleElement.textContent = translation;
            }
        }
    }
    
    bindEvents() {
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
    }
}

// Initialize language manager when DOM is loaded
let languageManager;
document.addEventListener('DOMContentLoaded', () => {
    languageManager = new LanguageManager();
    // Make it globally available after initialization
    window.languageManager = languageManager;
});

// Make translations globally available immediately
window.translations = translations;

// Remove AdSense-related translation keys across all languages at runtime
(function removeAdKeys() {
    try {
        const keysToRemove = [
            'google-adsense',
            'google-adsense-content',
            'google-adsense-terms',
            'google-adsense-terms-content',
            'adsense-cookies',
            'adsense-privacy',
            'adsense-opt-out',
            'adsense-compliance'
        ];
        Object.keys(translations || {}).forEach(lang => {
            const dict = translations[lang];
            if (!dict) return;
            keysToRemove.forEach(k => { try { delete dict[k]; } catch (_) {} });
        });
    } catch (_) {}
})();

