const translations = {
    tr: {
        "privacy-policy-title-page": "Gizlilik Politikası - Lingoano",
        "menu-toggle-label": "Menüyü aç/kapat",
        "theme-switcher-label": "Tema değiştirici",
        "default-theme": "Varsayılan Tema",
        "blue-theme": "Mavi Tema",
        "purple-theme": "Mor Tema",
        "green-theme": "Yeşil Tema",
        "chat": "Chat",
        "about": "Lingoano Hakkında",
        "word-of-day": "Günün Kelimesi",
        "language-guides": "Dil Rehberleri",
        "download": "İndir",
        "logo-alt": "Logo",
        "privacy-policy": "Gizlilik Politikası",
        "last-updated": "Son güncelleme: 26 Ağustos 2025",
        "privacy-notice": "Bu Gizlilik Politikası, Lingoano platformunu kullanırken kişisel verilerinizin nasıl işlendiğini açıklar. Platformu kullanarak bu politikayı kabul etmiş sayılırsınız.",
        "introduction": "1. Giriş",
        "introduction-content": "Lingoano (\"Lingoano\", \"biz\" veya \"Şirket\") olarak kişisel verilerin korunmasını ve gizliliğinizi gözetmeyi taahhüt ederiz. İşbu Gizlilik Politikası, platformumuzu kullandığınızda hangi verilerin işlendiğini, bu verilerin hangi amaçlarla ve hangi hukuki sebeplere dayanarak işlendiğini, saklama sürelerini ve haklarınızı açıklar. Bu politika, KVKK (Kişisel Verilerin Korunması Kanunu) ve GDPR (Genel Veri Koruma Yönetmeliği) uyumluluğu sağlar.",
        "anonymity-commitment": "Lingoano, kullanıcı anonimliğini en üst düzeyde korumayı taahhüt eder. Platform, kişisel kimlik bilgileri talep etmez ve kullanıcıların gerçek kimliklerini paylaşmalarını gerektirmez.",
        "information-collected": "2. Topladığımız Bilgiler",
        "personal-information": "2.1 Kişisel Veriler",
        "personal-information-content": "Lingoano, kural olarak ad, soyad, e‑posta, telefon gibi kimliği belirli veya belirlenebilir gerçek kişiye ilişkin verileri talep etmez ve işlemez. Platform, anonim kullanım prensibi ile tasarlanmıştır.",
        "technical-information": "2.2 Teknik/Çevrimiçi Tanımlayıcılar",
        "technical-information-content": "Hizmetin sunulması, güvenliğinin sağlanması ve performansın iyileştirilmesi amacıyla aşağıda sayılan teknik veriler işlenebilir:",
        "browser-type": "Tarayıcı türü ve sürümü",
        "operating-system": "İşletim sistemi ve cihaz bilgileri",
        "ip-address": "IP adresi (mümkün olduğunda maskeleme/anonimleştirme uygulanır)",
        "page-views": "Kullanım/etkileşim istatistikleri (toplu ve anonim)",
        "session-data": "Oturum verileri (geçici olarak)",
        "preferences": "Kullanıcı tercihleri (tema, dil seçimi)",
        "chat-data": "2.3 Sohbet Verileri",
        "chat-data-content": "Platform üzerinden gerçekleştirilen sohbetlerde:",
        "no-permanent-storage": "Mesajlar kalıcı olarak saklanmaz",
        "websocket-temporary": "WebSocket protokolü kullanılan sohbetlerde mesajlar geçici olarak işlenir ve iletim amacıyla sunucudan geçebilir",
        "session-only-data": "Sohbet verileri yalnızca oturum süresince geçici olarak tutulur",
        "no-chat-logs": "Sohbet logları kalıcı olarak kaydedilmez",
        "p2p-preference": "Mümkün olduğunda peer-to-peer iletişim tercih edilir",
        "use-of-information": "3. Bilgilerin Kullanımı",
        "use-of-information-content": "Toplanan/işlenen bilgiler, meşru menfaatler ile hizmetin ifası kapsamında ve aşağıdaki amaçlarla kullanılır:",
        "improve-platform": "Platform performansını iyileştirmek",
        "resolve-issues": "Teknik sorunları çözmek",
        "enhance-experience": "Kullanıcı deneyimini geliştirmek",
        "ensure-security": "Güvenliği sağlamak",
        "match-users": "Kullanıcı eşleştirme hizmetini sunmak",
        "analytics": "Platform kullanım analizi (anonim)",
        "information-sharing": "4. Bilgi Paylaşımı",
        "information-sharing-content": "Lingoano, kullanıcı bilgilerini üçüncü kişilere satmaz ve pazarlama amacıyla paylaşmaz. Yalnızca kanuni yükümlülüklerin yerine getirilmesi ve yetkili makamların usulüne uygun taleplerinin karşılanması kapsamında zorunlu hallerde veri aktarımı yapılabilir. Platform, kullanıcı gizliliğini korumayı öncelik edinir.",
        "cookies-tracking": "5. Çerezler ve İzleme",
        "cookies-tracking-content": "Hizmetin çalışması için zorunlu çerezler ile tercih çerezleri kullanılabilir. Reklam/izleme çerezleri bu sürümde devre dışıdır; kişiselleştirilmiş reklam sunulmamaktadır.",
        "store-theme": "Tema tercihlerinizi saklar",
        "remember-language": "Dil seçiminizi hatırlar",
        "session-info": "Oturum bilgilerinizi korur",
        "essential-cookies": "Zorunlu çerezler hizmet işlevselliği için gereklidir",
        "preference-cookies": "Tercih çerezleri kullanıcı deneyimini iyileştirir",
        "third-party-services": "6. Üçüncü Taraf Hizmetler",
        "third-party-services-content": "Bu sürümde platformda herhangi bir reklam ağı etkin değildir. Üçüncü taraf reklam ve izleme çerezleri devre dışıdır. Zorunlu/tercih çerezleri yalnızca hizmet işlevselliği ve kullanıcı tercihlerini (tema, dil) sağlamak için kullanılır.",
        "data-security": "7. Veri Güvenliği",
        "data-security-content": "Lingoano, veri güvenliğini sağlamak için makul düzeyde teknik ve idari tedbirler uygular:",
        "use-ipfs": "Mümkün olduğunda uçtan uca/peer‑to‑peer iletişim (ör. WebRTC, IPFS) tercih edilir; mümkün olmazsa WebSocket üzerinden geçici işleme yapılabilir",
        "encrypted-communication": "Aktarım sırasında şifreleme kullanılır",
        "no-data-storage": "İçerik saklama yapılmaz; zorunlu günlükler minimaldir",
        "regular-updates": "Bileşenler düzenli olarak güncellenir",
        "access-controls": "Erişim kontrolleri uygulanır",
        "security-audits": "Güvenlik denetimleri yapılır",
        "chat-security": "7.1 Sohbet Güvenliği",
        "chat-security-content": "Sohbet güvenliği için alınan önlemler:",
        "end-to-end-encryption": "Mümkün olduğunda uçtan uca şifreleme",
        "temporary-messages": "Mesajlar geçici olarak işlenir",
        "no-server-storage": "Sunucuda kalıcı mesaj saklanmaz",
        "secure-protocols": "Güvenli protokoller kullanılır",
        "session-timeout": "Oturum zaman aşımı uygulanır",
        "data-retention": "8. Veri Saklama Süreleri",
        "data-retention-content": "Lingoano, minimal veri saklama prensibi ile çalışır:",
        "session-data-retention": "Oturum verileri: Oturum süresince",
        "chat-data-retention": "Sohbet verileri: Oturum süresince (kalıcı saklanmaz)",
        "analytics-retention": "Analitik veriler: 12 ay (anonim)",
        "preferences-retention": "Kullanıcı tercihleri: 2 yıl",
        "log-retention": "Güvenlik logları: 30 gün",
        "legal-retention": "Yasal zorunluluklar: Yasal gereklilik süresince",
        "user-rights": "9. Kullanıcı Hakları",
        "user-rights-content": "Uygulanabilir mevzuat kapsamında kullanıcılarımız aşağıdaki haklara sahiptir:",
        "access-data": "Kişisel verilerinize erişim",
        "correct-data": "Verilerinizin düzeltilmesi",
        "delete-data": "Verilerinizin silinmesi",
        "object-processing": "Veri işlemeye itiraz",
        "data-portability": "Veri taşınabilirliği",
        "withdraw-consent": "Rıza geri çekme",
        "complaint-right": "Şikayet hakkı",
        "rights-exercise": "8.1 Hakların Kullanımı",
        "rights-exercise-content": "Haklarınızı kullanmak için:",
        "contact-privacy": "contact@lingoano.com adresine e-posta gönderin",
        "response-time": "Yanıt süresi: 30 gün içinde",
        "free-service": "Hizmet ücretsizdir",
        "identity-verification": "Kimlik doğrulaması gerekebilir",
        "children-privacy": "10. Çocukların Gizliliği",
        "children-privacy-content": "Lingoano 13 yaş altına yönelik değildir. 13 yaş altından bilerek veri toplanmaz; yanlışlıkla toplandığının anlaşılması halinde makul süre içinde silinir. Platform, COPPA (Children's Online Privacy Protection Act) uyumluluğu sağlar.",
        "international-transfers": "11. Uluslararası Veri Aktarımları",
        "international-transfers-content": "Platform, küresel kullanıcılara hizmet vermektedir. Veri aktarımları, uygun güvenlik önlemleri ile gerçekleştirilir. Üçüncü taraf hizmet sağlayıcıları, yeterli koruma seviyesi sağlayan ülkelerde bulunur.",
        "policy-changes": "12. Politika Değişiklikleri",
        "policy-changes-content": "İşbu Gizlilik Politikası zaman zaman güncellenebilir. Esaslı değişikliklerde yürürlük tarihi güncellenir ve makul yöntemlerle bilgilendirme yapılır. Değişiklikler, yayınlandığı tarihten itibaren geçerli olacaktır.",
        "contact-section": "13. İletişim",
        "contact-content": "Bu Gizlilik Politikası hakkında sorularınızı aşağıdaki kanallardan iletebilirsiniz:",
        "privacy-email": "E‑posta: contact@lingoano.com",
        "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
        "data-protection-officer": "Veri Koruma Sorumlusu: contact@lingoano.com",
        "privacy-commitment": "Lingoano, kullanıcı gizliliğini korumayı en önemli önceliği olarak görür. Bu politika, şeffaflık ve güven ilkeleri doğrultusunda hazırlanmıştır.",
        "contact-us": "Bizimle İletişime Geçin",
        "contact-description": "Sorularınız, önerileriniz veya geri bildirimleriniz için bizimle iletişime geçebilirsiniz.",
        "contact-email": "E-posta: contact@lingoano.com",
        "contact-response": "Yanıt süresi: 24-48 saat içinde",
        "close": "Kapat",
        "contactfooter": "İletişim",
        "terms-of-service": "Kullanım Şartları"
      },
    // English Translations
    en: {
      "privacy-policy-title-page": "Privacy Policy - Lingoano",
      "menu-toggle-label": "Open/close menu",
      "theme-switcher-label": "Theme switcher",
      "default-theme": "Default Theme",
      "blue-theme": "Blue Theme",
      "purple-theme": "Purple Theme",
      "green-theme": "Green Theme",
      "chat": "Chat",
      "about": "About Lingoano",
      "word-of-day": "Word of the Day",
      "language-guides": "Language Guides",
      "download": "Download",
      "logo-alt": "Logo",
      "privacy-policy": "Privacy Policy",
      "last-updated": "Last updated: August 26, 2025",
      "privacy-notice": "This Privacy Policy explains how your personal data is processed when you use the Lingoano platform. By using the platform, you are deemed to have accepted this policy.",
      "introduction": "1. Introduction",
      "introduction-content": "As Lingoano (\"Lingoano\", \"we\", or the \"Company\"), we are committed to protecting personal data and respecting your privacy. This Privacy Policy explains what data is processed when you use our platform, for what purposes and on what legal grounds this data is processed, its retention periods, and your rights. This policy ensures compliance with KVKK (Personal Data Protection Law) and GDPR (General Data Protection Regulation).",
      "anonymity-commitment": "Lingoano is committed to protecting user anonymity at the highest level. The platform does not request personal identification information and does not require users to share their real identities.",
      "information-collected": "2. Information We Collect",
      "personal-information": "2.1 Personal Data",
      "personal-information-content": "As a rule, Lingoano does not request or process data related to an identified or identifiable natural person, such as name, surname, e-mail, or phone number. The platform is designed on the principle of anonymous use.",
      "technical-information": "2.2 Technical/Online Identifiers",
      "technical-information-content": "For the provision of the service, ensuring its security, and improving performance, the following technical data may be processed:",
      "browser-type": "Browser type and version",
      "operating-system": "Operating system and device information",
      "ip-address": "IP address (masking/anonymization is applied where possible)",
      "page-views": "Usage/interaction statistics (aggregated and anonymous)",
      "session-data": "Session data (temporary)",
      "preferences": "User preferences (theme, language selection)",
      "chat-data": "2.3 Chat Data",
      "chat-data-content": "In chats conducted via the platform:",
      "no-permanent-storage": "Messages are not stored permanently",
      "websocket-temporary": "In chats using the WebSocket protocol, messages are processed temporarily and may pass through the server for transmission purposes",
      "session-only-data": "Chat data is only held temporarily during the session",
      "no-chat-logs": "Chat logs are not permanently recorded",
      "p2p-preference": "Peer-to-peer communication is preferred where possible",
      "use-of-information": "3. Use of Information",
      "use-of-information-content": "The collected/processed information is used for the following purposes within the scope of legitimate interests and the performance of the service:",
      "improve-platform": "To improve platform performance",
      "resolve-issues": "To resolve technical issues",
      "enhance-experience": "To enhance user experience",
      "ensure-security": "To ensure security",
      "match-users": "To provide the user matching service",
      "analytics": "Platform usage analysis (anonymous)",
      "information-sharing": "4. Information Sharing",
      "information-sharing-content": "Lingoano does not sell user information to third parties and does not share it for marketing purposes. Data may only be transferred in mandatory cases to fulfill legal obligations and respond to duly authorized requests from authorities. The platform prioritizes protecting user privacy.",
      "cookies-tracking": "5. Cookies and Tracking",
      "cookies-tracking-content": "Essential cookies and preference cookies may be used for the operation of the service. Advertising/tracking cookies are disabled in this version; personalized advertising is not served.",
      "store-theme": "Stores your theme preferences",
      "remember-language": "Remembers your language selection",
      "session-info": "Protects your session information",
      "essential-cookies": "Essential cookies are necessary for service functionality",
      "preference-cookies": "Preference cookies improve the user experience",
      "third-party-services": "6. Third-Party Services",
      "third-party-services-content": "No advertising networks are active on the platform in this version. Third-party advertising and tracking cookies are disabled. Essential/preference cookies are used only to provide service functionality and user preferences (theme, language).",
      "data-security": "7. Data Security",
      "data-security-content": "Lingoano implements reasonable technical and administrative measures to ensure data security:",
      "use-ipfs": "End-to-end/peer-to-peer communication (e.g., WebRTC, IPFS) is preferred where possible; if not possible, temporary processing via WebSocket may be used",
      "encrypted-communication": "Encryption is used during transmission",
      "no-data-storage": "Content is not stored; mandatory logs are minimal",
      "regular-updates": "Components are updated regularly",
      "access-controls": "Access controls are implemented",
      "security-audits": "Security audits are performed",
      "chat-security": "7.1 Chat Security",
      "chat-security-content": "Measures taken for chat security:",
      "end-to-end-encryption": "End-to-end encryption where possible",
      "temporary-messages": "Messages are processed temporarily",
      "no-server-storage": "No permanent message storage on the server",
      "secure-protocols": "Secure protocols are used",
      "session-timeout": "Session timeout is applied",
      "data-retention": "8. Data Retention Periods",
      "data-retention-content": "Lingoano operates on the principle of minimal data retention:",
      "session-data-retention": "Session data: During the session",
      "chat-data-retention": "Chat data: During the session (not stored permanently)",
      "analytics-retention": "Analytics data: 12 months (anonymous)",
      "preferences-retention": "User preferences: 2 years",
      "log-retention": "Security logs: 30 days",
      "legal-retention": "Legal obligations: For the duration required by law",
      "user-rights": "9. User Rights",
      "user-rights-content": "Under applicable legislation, our users have the following rights:",
      "access-data": "Access to your personal data",
      "correct-data": "Correction of your data",
      "delete-data": "Deletion of your data",
      "object-processing": "Objection to data processing",
      "data-portability": "Data portability",
      "withdraw-consent": "Withdrawal of consent",
      "complaint-right": "Right to complain",
      "rights-exercise": "8.1 Exercising Your Rights",
      "rights-exercise-content": "To exercise your rights:",
      "contact-privacy": "Send an e-mail to contact@lingoano.com",
      "response-time": "Response time: Within 30 days",
      "free-service": "The service is free of charge",
      "identity-verification": "Identity verification may be required",
      "children-privacy": "10. Children's Privacy",
      "children-privacy-content": "Lingoano is not intended for children under 13. We do not knowingly collect data from children under 13; if we learn that we have inadvertently collected such data, it will be deleted within a reasonable time. The platform complies with COPPA (Children's Online Privacy Protection Act).",
      "international-transfers": "11. International Data Transfers",
      "international-transfers-content": "The platform serves users globally. Data transfers are carried out with appropriate security measures. Third-party service providers are located in countries that provide an adequate level of protection.",
      "policy-changes": "12. Policy Changes",
      "policy-changes-content": "This Privacy Policy may be updated from time to time. In case of material changes, the effective date will be updated, and notification will be provided through reasonable means. Changes will be effective from the date of publication.",
      "contact-section": "13. Contact",
      "contact-content": "You can send your questions about this Privacy Policy through the following channels:",
      "privacy-email": "E-mail: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "data-protection-officer": "Data Protection Officer: contact@lingoano.com",
      "privacy-commitment": "Lingoano considers protecting user privacy its highest priority. This policy has been prepared in line with the principles of transparency and trust.",
      "contact-us": "Contact Us",
      "contact-description": "You can contact us for your questions, suggestions, or feedback.",
      "contact-email": "E-mail: contact@lingoano.com",
      "contact-response": "Response time: Within 24-48 hours",
      "close": "Close",
      "contactfooter": "Contact",
      "terms-of-service": "Terms of Service"
    },
    // German Translations
    de: {
      "privacy-policy-title-page": "Datenschutzrichtlinie - Lingoano",
      "menu-toggle-label": "Menü öffnen/schließen",
      "theme-switcher-label": "Design-Umschalter",
      "default-theme": "Standard-Design",
      "blue-theme": "Blaues Design",
      "purple-theme": "Lila Design",
      "green-theme": "Grünes Design",
      "chat": "Chat",
      "about": "Über Lingoano",
      "word-of-day": "Wort des Tages",
      "language-guides": "Sprachführer",
      "download": "Herunterladen",
      "logo-alt": "Logo",
      "privacy-policy": "Datenschutzrichtlinie",
      "last-updated": "Letzte Aktualisierung: 26. August 2025",
      "privacy-notice": "Diese Datenschutzrichtlinie erklärt, wie Ihre personenbezogenen Daten bei der Nutzung der Lingoano-Plattform verarbeitet werden. Durch die Nutzung der Plattform erklären Sie sich mit dieser Richtlinie einverstanden.",
      "introduction": "1. Einleitung",
      "introduction-content": "Als Lingoano (\"Lingoano\", \"wir\" oder das \"Unternehmen\") verpflichten wir uns, personenbezogene Daten zu schützen und Ihre Privatsphäre zu respektieren. Diese Datenschutzrichtlinie erläutert, welche Daten bei der Nutzung unserer Plattform verarbeitet werden, zu welchen Zwecken und auf welcher Rechtsgrundlage diese Daten verarbeitet werden, deren Aufbewahrungsfristen und Ihre Rechte. Diese Richtlinie gewährleistet die Einhaltung des KVKK (Gesetz zum Schutz personenbezogener Daten) und der DSGVO (Datenschutz-Grundverordnung).",
      "anonymity-commitment": "Lingoano verpflichtet sich, die Anonymität der Benutzer auf höchstem Niveau zu schützen. Die Plattform fordert keine persönlichen Identifikationsdaten an und verlangt von den Benutzern nicht, ihre wahre Identität preiszugeben.",
      "information-collected": "2. Welche Informationen wir sammeln",
      "personal-information": "2.1 Personenbezogene Daten",
      "personal-information-content": "Lingoano fordert und verarbeitet grundsätzlich keine Daten, die sich auf eine identifizierte oder identifizierbare natürliche Person beziehen, wie Name, Nachname, E-Mail oder Telefonnummer. Die Plattform ist nach dem Prinzip der anonymen Nutzung konzipiert.",
      "technical-information": "2.2 Technische/Online-Identifikatoren",
      "technical-information-content": "Zur Bereitstellung des Dienstes, zur Gewährleistung seiner Sicherheit und zur Verbesserung der Leistung können die folgenden technischen Daten verarbeitet werden:",
      "browser-type": "Browsertyp und -version",
      "operating-system": "Betriebssystem und Geräteinformationen",
      "ip-address": "IP-Adresse (Maskierung/Anonymisierung wird wo möglich angewendet)",
      "page-views": "Nutzungs-/Interaktionsstatistiken (aggregiert und anonym)",
      "session-data": "Sitzungsdaten (temporär)",
      "preferences": "Benutzereinstellungen (Design, Sprachauswahl)",
      "chat-data": "2.3 Chat-Daten",
      "chat-data-content": "In Chats, die über die Plattform geführt werden:",
      "no-permanent-storage": "Nachrichten werden nicht dauerhaft gespeichert",
      "websocket-temporary": "In Chats, die das WebSocket-Protokoll verwenden, werden Nachrichten vorübergehend verarbeitet und können zur Übertragung den Server passieren",
      "session-only-data": "Chat-Daten werden nur vorübergehend während der Sitzung gespeichert",
      "no-chat-logs": "Chat-Protokolle werden nicht dauerhaft aufgezeichnet",
      "p2p-preference": "Peer-to-Peer-Kommunikation wird nach Möglichkeit bevorzugt",
      "use-of-information": "3. Verwendung von Informationen",
      "use-of-information-content": "Die gesammelten/verarbeiteten Informationen werden für die folgenden Zwecke im Rahmen berechtigter Interessen und der Vertragserfüllung verwendet:",
      "improve-platform": "Zur Verbesserung der Plattformleistung",
      "resolve-issues": "Zur Lösung technischer Probleme",
      "enhance-experience": "Zur Verbesserung des Benutzererlebnisses",
      "ensure-security": "Zur Gewährleistung der Sicherheit",
      "match-users": "Zur Bereitstellung des Benutzer-Matching-Dienstes",
      "analytics": "Analyse der Plattformnutzung (anonym)",
      "information-sharing": "4. Informationsweitergabe",
      "information-sharing-content": "Lingoano verkauft keine Benutzerinformationen an Dritte und gibt sie nicht zu Marketingzwecken weiter. Daten können nur in zwingenden Fällen zur Erfüllung gesetzlicher Verpflichtungen und zur Beantwortung ordnungsgemäß autorisierter Anfragen von Behörden übermittelt werden. Die Plattform legt höchsten Wert auf den Schutz der Privatsphäre der Benutzer.",
      "cookies-tracking": "5. Cookies und Tracking",
      "cookies-tracking-content": "Für den Betrieb des Dienstes können notwendige Cookies und Präferenz-Cookies verwendet werden. Werbe-/Tracking-Cookies sind in dieser Version deaktiviert; es wird keine personalisierte Werbung geschaltet.",
      "store-theme": "Speichert Ihre Design-Einstellungen",
      "remember-language": "Merkt sich Ihre Sprachauswahl",
      "session-info": "Schützt Ihre Sitzungsinformationen",
      "essential-cookies": "Notwendige Cookies sind für die Funktionalität des Dienstes erforderlich",
      "preference-cookies": "Präferenz-Cookies verbessern das Benutzererlebnis",
      "third-party-services": "6. Dienste von Drittanbietern",
      "third-party-services-content": "In dieser Version sind keine Werbenetzwerke auf der Plattform aktiv. Werbe- und Tracking-Cookies von Drittanbietern sind deaktiviert. Notwendige/Präferenz-Cookies werden nur zur Bereitstellung der Dienstfunktionalität und der Benutzereinstellungen (Design, Sprache) verwendet.",
      "data-security": "7. Datensicherheit",
      "data-security-content": "Lingoano ergreift angemessene technische und administrative Maßnahmen zur Gewährleistung der Datensicherheit:",
      "use-ipfs": "Ende-zu-Ende-/Peer-to-Peer-Kommunikation (z. B. WebRTC, IPFS) wird nach Möglichkeit bevorzugt; falls nicht möglich, kann eine vorübergehende Verarbeitung über WebSocket erfolgen",
      "encrypted-communication": "Verschlüsselung wird während der Übertragung verwendet",
      "no-data-storage": "Inhalte werden nicht gespeichert; obligatorische Protokolle sind minimal",
      "regular-updates": "Komponenten werden regelmäßig aktualisiert",
      "access-controls": "Zugriffskontrollen werden implementiert",
      "security-audits": "Sicherheitsaudits werden durchgeführt",
      "chat-security": "7.1 Chat-Sicherheit",
      "chat-security-content": "Maßnahmen zur Chat-Sicherheit:",
      "end-to-end-encryption": "Ende-zu-Ende-Verschlüsselung, wo möglich",
      "temporary-messages": "Nachrichten werden vorübergehend verarbeitet",
      "no-server-storage": "Keine dauerhafte Speicherung von Nachrichten auf dem Server",
      "secure-protocols": "Sichere Protokolle werden verwendet",
      "session-timeout": "Sitzungs-Timeout wird angewendet",
      "data-retention": "8. Aufbewahrungsfristen für Daten",
      "data-retention-content": "Lingoano arbeitet nach dem Prinzip der minimalen Datenaufbewahrung:",
      "session-data-retention": "Sitzungsdaten: Während der Sitzung",
      "chat-data-retention": "Chat-Daten: Während der Sitzung (werden nicht dauerhaft gespeichert)",
      "analytics-retention": "Analysedaten: 12 Monate (anonym)",
      "preferences-retention": "Benutzereinstellungen: 2 Jahre",
      "log-retention": "Sicherheitsprotokolle: 30 Tage",
      "legal-retention": "Gesetzliche Verpflichtungen: Für die gesetzlich vorgeschriebene Dauer",
      "user-rights": "9. Benutzerrechte",
      "user-rights-content": "Gemäß der geltenden Gesetzgebung haben unsere Benutzer die folgenden Rechte:",
      "access-data": "Zugriff auf Ihre personenbezogenen Daten",
      "correct-data": "Berichtigung Ihrer Daten",
      "delete-data": "Löschung Ihrer Daten",
      "object-processing": "Widerspruch gegen die Datenverarbeitung",
      "data-portability": "Datenübertragbarkeit",
      "withdraw-consent": "Widerruf der Einwilligung",
      "complaint-right": "Beschwerderecht",
      "rights-exercise": "8.1 Ausübung Ihrer Rechte",
      "rights-exercise-content": "Um Ihre Rechte auszuüben:",
      "contact-privacy": "Senden Sie eine E-Mail an contact@lingoano.com",
      "response-time": "Antwortzeit: Innerhalb von 30 Tagen",
      "free-service": "Der Dienst ist kostenlos",
      "identity-verification": "Eine Identitätsprüfung kann erforderlich sein",
      "children-privacy": "10. Datenschutz von Kindern",
      "children-privacy-content": "Lingoano ist nicht für Kinder unter 13 Jahren bestimmt. Wir sammeln nicht wissentlich Daten von Kindern unter 13 Jahren; wenn wir erfahren, dass wir versehentlich solche Daten gesammelt haben, werden diese innerhalb einer angemessenen Frist gelöscht. Die Plattform entspricht dem COPPA (Children's Online Privacy Protection Act).",
      "international-transfers": "11. Internationale Datenübermittlungen",
      "international-transfers-content": "Die Plattform bedient Benutzer weltweit. Datenübermittlungen werden mit angemessenen Sicherheitsmaßnahmen durchgeführt. Drittanbieter befinden sich in Ländern, die ein angemessenes Schutzniveau bieten.",
      "policy-changes": "12. Änderungen der Richtlinie",
      "policy-changes-content": "Diese Datenschutzrichtlinie kann von Zeit zu Zeit aktualisiert werden. Bei wesentlichen Änderungen wird das Gültigkeitsdatum aktualisiert und eine Benachrichtigung über angemessene Mittel bereitgestellt. Änderungen treten mit dem Datum der Veröffentlichung in Kraft.",
      "contact-section": "13. Kontakt",
      "contact-content": "Sie können Ihre Fragen zu dieser Datenschutzrichtlinie über die folgenden Kanäle senden:",
      "privacy-email": "E-Mail: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "data-protection-officer": "Datenschutzbeauftragter: contact@lingoano.com",
      "privacy-commitment": "Lingoano betrachtet den Schutz der Privatsphäre der Benutzer als höchste Priorität. Diese Richtlinie wurde im Einklang mit den Grundsätzen der Transparenz und des Vertrauens erstellt.",
      "contact-us": "Kontaktieren Sie uns",
      "contact-description": "Sie können uns bei Fragen, Anregungen oder Feedback kontaktieren.",
      "contact-email": "E-Mail: contact@lingoano.com",
      "contact-response": "Antwortzeit: Innerhalb von 24-48 Stunden",
      "close": "Schließen",
      "contactfooter": "Kontakt",
      "terms-of-service": "Nutzungsbedingungen"
    },
    // Spanish Translations
    es: {
      "privacy-policy-title-page": "Política de Privacidad - Lingoano",
      "menu-toggle-label": "Abrir/cerrar menú",
      "theme-switcher-label": "Selector de tema",
      "default-theme": "Tema Predeterminado",
      "blue-theme": "Tema Azul",
      "purple-theme": "Tema Morado",
      "green-theme": "Tema Verde",
      "chat": "Chat",
      "about": "Sobre Lingoano",
      "word-of-day": "Palabra del Día",
      "language-guides": "Guías de Idiomas",
      "download": "Descargar",
      "logo-alt": "Logo",
      "privacy-policy": "Política de Privacidad",
      "last-updated": "Última actualización: 26 de agosto de 2025",
      "privacy-notice": "Esta Política de Privacidad explica cómo se procesan sus datos personales cuando utiliza la plataforma Lingoano. Al utilizar la plataforma, se considera que ha aceptado esta política.",
      "introduction": "1. Introducción",
      "introduction-content": "Como Lingoano (\"Lingoano\", \"nosotros\" o la \"Compañía\"), nos comprometemos a proteger los datos personales y a respetar su privacidad. Esta Política de Privacidad explica qué datos se procesan cuando utiliza nuestra plataforma, con qué fines y sobre qué bases legales se procesan estos datos, sus períodos de retención y sus derechos. Esta política garantiza el cumplimiento de la KVKK (Ley de Protección de Datos Personales) y el RGPD (Reglamento General de Protección de Datos).",
      "anonymity-commitment": "Lingoano se compromete a proteger el anonimato del usuario al más alto nivel. La plataforma no solicita información de identificación personal y no requiere que los usuarios compartan sus identidades reales.",
      "information-collected": "2. Información que Recopilamos",
      "personal-information": "2.1 Datos Personales",
      "personal-information-content": "Como regla general, Lingoano no solicita ni procesa datos relacionados con una persona física identificada o identificable, como nombre, apellido, correo electrónico o número de teléfono. La plataforma está diseñada sobre el principio de uso anónimo.",
      "technical-information": "2.2 Identificadores Técnicos/En Línea",
      "technical-information-content": "Para la prestación del servicio, garantizar su seguridad y mejorar el rendimiento, se pueden procesar los siguientes datos técnicos:",
      "browser-type": "Tipo y versión del navegador",
      "operating-system": "Sistema operativo e información del dispositivo",
      "ip-address": "Dirección IP (se aplica enmascaramiento/anonimización cuando es posible)",
      "page-views": "Estadísticas de uso/interacción (agregadas y anónimas)",
      "session-data": "Datos de sesión (temporales)",
      "preferences": "Preferencias del usuario (tema, selección de idioma)",
      "chat-data": "2.3 Datos del Chat",
      "chat-data-content": "En los chats realizados a través de la plataforma:",
      "no-permanent-storage": "Los mensajes no se almacenan de forma permanente",
      "websocket-temporary": "En los chats que utilizan el protocolo WebSocket, los mensajes se procesan temporalmente y pueden pasar por el servidor con fines de transmisión",
      "session-only-data": "Los datos del chat solo se conservan temporalmente durante la sesión",
      "no-chat-logs": "Los registros de chat no se guardan de forma permanente",
      "p2p-preference": "Se prefiere la comunicación de igual a igual (peer-to-peer) siempre que sea posible",
      "use-of-information": "3. Uso de la Información",
      "use-of-information-content": "La información recopilada/procesada se utiliza para los siguientes fines dentro del alcance de los intereses legítimos y la ejecución del servicio:",
      "improve-platform": "Para mejorar el rendimiento de la plataforma",
      "resolve-issues": "Para resolver problemas técnicos",
      "enhance-experience": "Para mejorar la experiencia del usuario",
      "ensure-security": "Para garantizar la seguridad",
      "match-users": "Para proporcionar el servicio de emparejamiento de usuarios",
      "analytics": "Análisis de uso de la plataforma (anónimo)",
      "information-sharing": "4. Intercambio de Información",
      "information-sharing-content": "Lingoano no vende la información del usuario a terceros y no la comparte con fines de marketing. Los datos solo pueden transferirse en casos obligatorios para cumplir con las obligaciones legales y responder a las solicitudes debidamente autorizadas de las autoridades. La plataforma prioriza la protección de la privacidad del usuario.",
      "cookies-tracking": "5. Cookies y Seguimiento",
      "cookies-tracking-content": "Se pueden utilizar cookies esenciales y cookies de preferencia para el funcionamiento del servicio. Las cookies de publicidad/seguimiento están deshabilitadas en esta versión; no se sirve publicidad personalizada.",
      "store-theme": "Almacena sus preferencias de tema",
      "remember-language": "Recuerda su selección de idioma",
      "session-info": "Protege la información de su sesión",
      "essential-cookies": "Las cookies esenciales son necesarias para la funcionalidad del servicio",
      "preference-cookies": "Las cookies de preferencia mejoran la experiencia del usuario",
      "third-party-services": "6. Servicios de Terceros",
      "third-party-services-content": "No hay redes publicitarias activas en la plataforma en esta versión. Las cookies de publicidad y seguimiento de terceros están deshabilitadas. Las cookies esenciales/de preferencia se utilizan únicamente para proporcionar la funcionalidad del servicio y las preferencias del usuario (tema, idioma).",
      "data-security": "7. Seguridad de los Datos",
      "data-security-content": "Lingoano implementa medidas técnicas y administrativas razonables para garantizar la seguridad de los datos:",
      "use-ipfs": "Se prefiere la comunicación de extremo a extremo/de igual a igual (p. ej., WebRTC, IPFS) siempre que sea posible; si no es posible, se puede utilizar el procesamiento temporal a través de WebSocket",
      "encrypted-communication": "Se utiliza cifrado durante la transmisión",
      "no-data-storage": "El contenido no se almacena; los registros obligatorios son mínimos",
      "regular-updates": "Los componentes se actualizan regularmente",
      "access-controls": "Se implementan controles de acceso",
      "security-audits": "Se realizan auditorías de seguridad",
      "chat-security": "7.1 Seguridad del Chat",
      "chat-security-content": "Medidas tomadas para la seguridad del chat:",
      "end-to-end-encryption": "Cifrado de extremo a extremo cuando sea posible",
      "temporary-messages": "Los mensajes se procesan temporalmente",
      "no-server-storage": "No se almacenan mensajes de forma permanente en el servidor",
      "secure-protocols": "Se utilizan protocolos seguros",
      "session-timeout": "Se aplica un tiempo de espera de la sesión",
      "data-retention": "8. Períodos de Retención de Datos",
      "data-retention-content": "Lingoano opera bajo el principio de retención mínima de datos:",
      "session-data-retention": "Datos de sesión: Durante la sesión",
      "chat-data-retention": "Datos de chat: Durante la sesión (no se almacenan permanentemente)",
      "analytics-retention": "Datos analíticos: 12 meses (anónimos)",
      "preferences-retention": "Preferencias del usuario: 2 años",
      "log-retention": "Registros de seguridad: 30 días",
      "legal-retention": "Obligaciones legales: Durante el tiempo requerido por la ley",
      "user-rights": "9. Derechos del Usuario",
      "user-rights-content": "Según la legislación aplicable, nuestros usuarios tienen los siguientes derechos:",
      "access-data": "Acceso a sus datos personales",
      "correct-data": "Corrección de sus datos",
      "delete-data": "Eliminación de sus datos",
      "object-processing": "Oposición al procesamiento de datos",
      "data-portability": "Portabilidad de datos",
      "withdraw-consent": "Retirada del consentimiento",
      "complaint-right": "Derecho a presentar una queja",
      "rights-exercise": "8.1 Ejercicio de sus Derechos",
      "rights-exercise-content": "Para ejercer sus derechos:",
      "contact-privacy": "Envíe un correo electrónico a contact@lingoano.com",
      "response-time": "Tiempo de respuesta: Dentro de 30 días",
      "free-service": "El servicio es gratuito",
      "identity-verification": "Puede ser necesaria una verificación de identidad",
      "children-privacy": "10. Privacidad de los Niños",
      "children-privacy-content": "Lingoano no está destinado a niños menores de 13 años. No recopilamos deliberadamente datos de niños menores de 13 años; si nos enteramos de que hemos recopilado inadvertidamente dichos datos, se eliminarán en un plazo razonable. La plataforma cumple con la COPPA (Ley de Protección de la Privacidad en Línea de los Niños).",
      "international-transfers": "11. Transferencias Internacionales de Datos",
      "international-transfers-content": "La plataforma atiende a usuarios de todo el mundo. Las transferencias de datos se realizan con las medidas de seguridad adecuadas. Los proveedores de servicios de terceros se encuentran en países que ofrecen un nivel de protección adecuado.",
      "policy-changes": "12. Cambios en la Política",
      "policy-changes-content": "Esta Política de Privacidad puede actualizarse de vez en cuando. En caso de cambios materiales, se actualizará la fecha de entrada en vigor y se notificará a través de medios razonables. Los cambios entrarán en vigor a partir de la fecha de su publicación.",
      "contact-section": "13. Contacto",
      "contact-content": "Puede enviar sus preguntas sobre esta Política de Privacidad a través de los siguientes canales:",
      "privacy-email": "Correo electrónico: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "data-protection-officer": "Delegado de Protección de Datos: contact@lingoano.com",
      "privacy-commitment": "Lingoano considera la protección de la privacidad del usuario como su máxima prioridad. Esta política ha sido preparada de acuerdo con los principios de transparencia y confianza.",
      "contact-us": "Contáctenos",
      "contact-description": "Puede contactarnos para sus preguntas, sugerencias o comentarios.",
      "contact-email": "Correo electrónico: contact@lingoano.com",
      "contact-response": "Tiempo de respuesta: Dentro de 24-48 horas",
      "close": "Cerrar",
      "contactfooter": "Contacto",
      "terms-of-service": "Términos de Servicio"
    },
    // French Translations
    fr: {
      "privacy-policy-title-page": "Politique de Confidentialité - Lingoano",
      "menu-toggle-label": "Ouvrir/fermer le menu",
      "theme-switcher-label": "Sélecteur de thème",
      "default-theme": "Thème par Défaut",
      "blue-theme": "Thème Bleu",
      "purple-theme": "Thème Violet",
      "green-theme": "Thème Vert",
      "chat": "Chat",
      "about": "À propos de Lingoano",
      "word-of-day": "Mot du Jour",
      "language-guides": "Guides Linguistiques",
      "download": "Télécharger",
      "logo-alt": "Logo",
      "privacy-policy": "Politique de Confidentialité",
      "last-updated": "Dernière mise à jour : 26 août 2025",
      "privacy-notice": "Cette Politique de Confidentialité explique comment vos données personnelles sont traitées lorsque vous utilisez la plateforme Lingoano. En utilisant la plateforme, vous êtes réputé avoir accepté cette politique.",
      "introduction": "1. Introduction",
      "introduction-content": "En tant que Lingoano (\"Lingoano\", \"nous\" ou la \"Société\"), nous nous engageons à protéger les données personnelles et à respecter votre vie privée. Cette Politique de Confidentialité explique quelles données sont traitées lorsque vous utilisez notre plateforme, à quelles fins et sur quelles bases légales ces données sont traitées, leurs durées de conservation et vos droits. Cette politique garantit la conformité avec la KVKK (Loi sur la Protection des Données Personnelles) et le RGPD (Règlement Général sur la Protection des Données).",
      "anonymity-commitment": "Lingoano s'engage à protéger l'anonymat des utilisateurs au plus haut niveau. La plateforme ne demande pas d'informations d'identification personnelle et n'exige pas que les utilisateurs partagent leur véritable identité.",
      "information-collected": "2. Informations que nous collectons",
      "personal-information": "2.1 Données Personnelles",
      "personal-information-content": "En règle générale, Lingoano ne demande ni ne traite de données relatives à une personne physique identifiée ou identifiable, telles que le nom, le prénom, l'adresse e-mail ou le numéro de téléphone. La plateforme est conçue sur le principe de l'utilisation anonyme.",
      "technical-information": "2.2 Identifiants Techniques/En Ligne",
      "technical-information-content": "Pour la fourniture du service, la garantie de sa sécurité et l'amélioration des performances, les données techniques suivantes peuvent être traitées :",
      "browser-type": "Type et version du navigateur",
      "operating-system": "Système d'exploitation et informations sur l'appareil",
      "ip-address": "Adresse IP (le masquage/l'anonymisation est appliqué si possible)",
      "page-views": "Statistiques d'utilisation/d'interaction (agrégées et anonymes)",
      "session-data": "Données de session (temporaires)",
      "preferences": "Préférences de l'utilisateur (thème, sélection de la langue)",
      "chat-data": "2.3 Données de Chat",
      "chat-data-content": "Dans les chats effectués via la plateforme :",
      "no-permanent-storage": "Les messages ne sont pas stockés de manière permanente",
      "websocket-temporary": "Dans les chats utilisant le protocole WebSocket, les messages sont traités temporairement et peuvent transiter par le serveur à des fins de transmission",
      "session-only-data": "Les données de chat ne sont conservées que temporairement pendant la session",
      "no-chat-logs": "Les journaux de chat ne sont pas enregistrés de manière permanente",
      "p2p-preference": "La communication de pair à pair est privilégiée lorsque cela est possible",
      "use-of-information": "3. Utilisation des Informations",
      "use-of-information-content": "Les informations collectées/traitées sont utilisées aux fins suivantes dans le cadre d'intérêts légitimes et de l'exécution du service :",
      "improve-platform": "Pour améliorer les performances de la plateforme",
      "resolve-issues": "Pour résoudre les problèmes techniques",
      "enhance-experience": "Pour améliorer l'expérience utilisateur",
      "ensure-security": "Pour assurer la sécurité",
      "match-users": "Pour fournir le service de mise en relation des utilisateurs",
      "analytics": "Analyse de l'utilisation de la plateforme (anonyme)",
      "information-sharing": "4. Partage d'Informations",
      "information-sharing-content": "Lingoano ne vend pas les informations des utilisateurs à des tiers et ne les partage pas à des fins de marketing. Les données ne peuvent être transférées que dans des cas obligatoires pour remplir des obligations légales et répondre à des demandes dûment autorisées des autorités. La plateforme accorde la priorité à la protection de la vie privée des utilisateurs.",
      "cookies-tracking": "5. Cookies et Suivi",
      "cookies-tracking-content": "Des cookies essentiels et des cookies de préférence peuvent être utilisés pour le fonctionnement du service. Les cookies publicitaires/de suivi sont désactivés dans cette version ; aucune publicité personnalisée n'est diffusée.",
      "store-theme": "Stocke vos préférences de thème",
      "remember-language": "Se souvient de votre sélection de langue",
      "session-info": "Protège vos informations de session",
      "essential-cookies": "Les cookies essentiels sont nécessaires au fonctionnement du service",
      "preference-cookies": "Les cookies de préférence améliorent l'expérience utilisateur",
      "third-party-services": "6. Services de Tiers",
      "third-party-services-content": "Aucun réseau publicitaire n'est actif sur la plateforme dans cette version. Les cookies publicitaires et de suivi de tiers sont désactivés. Les cookies essentiels/de préférence sont utilisés uniquement pour fournir la fonctionnalité du service et les préférences de l'utilisateur (thème, langue).",
      "data-security": "7. Sécurité des Données",
      "data-security-content": "Lingoano met en œuvre des mesures techniques et administratives raisonnables pour garantir la sécurité des données :",
      "use-ipfs": "La communication de bout en bout/de pair à pair (par exemple, WebRTC, IPFS) est privilégiée lorsque cela est possible ; si ce n'est pas possible, un traitement temporaire via WebSocket peut être utilisé",
      "encrypted-communication": "Le chiffrement est utilisé pendant la transmission",
      "no-data-storage": "Le contenu n'est pas stocké ; les journaux obligatoires sont minimaux",
      "regular-updates": "Les composants sont mis à jour régulièrement",
      "access-controls": "Des contrôles d'accès sont mis en œuvre",
      "security-audits": "Des audits de sécurité sont effectués",
      "chat-security": "7.1 Sécurité du Chat",
      "chat-security-content": "Mesures prises pour la sécurité du chat :",
      "end-to-end-encryption": "Chiffrement de bout en bout lorsque cela est possible",
      "temporary-messages": "Les messages sont traités temporairement",
      "no-server-storage": "Pas de stockage permanent des messages sur le serveur",
      "secure-protocols": "Des protocoles sécurisés sont utilisés",
      "session-timeout": "Un délai d'expiration de session est appliqué",
      "data-retention": "8. Durées de Conservation des Données",
      "data-retention-content": "Lingoano fonctionne sur le principe de la conservation minimale des données :",
      "session-data-retention": "Données de session : Pendant la session",
      "chat-data-retention": "Données de chat : Pendant la session (non stockées de manière permanente)",
      "analytics-retention": "Données analytiques : 12 mois (anonymes)",
      "preferences-retention": "Préférences de l'utilisateur : 2 ans",
      "log-retention": "Journaux de sécurité : 30 jours",
      "legal-retention": "Obligations légales : Pour la durée requise par la loi",
      "user-rights": "9. Droits des Utilisateurs",
      "user-rights-content": "En vertu de la législation applicable, nos utilisateurs ont les droits suivants :",
      "access-data": "Accès à vos données personnelles",
      "correct-data": "Correction de vos données",
      "delete-data": "Suppression de vos données",
      "object-processing": "Opposition au traitement des données",
      "data-portability": "Portabilité des données",
      "withdraw-consent": "Retrait du consentement",
      "complaint-right": "Droit de porter plainte",
      "rights-exercise": "8.1 Exercice de Vos Droits",
      "rights-exercise-content": "Pour exercer vos droits :",
      "contact-privacy": "Envoyez un e-mail à contact@lingoano.com",
      "response-time": "Délai de réponse : Dans les 30 jours",
      "free-service": "Le service est gratuit",
      "identity-verification": "Une vérification d'identité peut être requise",
      "children-privacy": "10. Confidentialité des Enfants",
      "children-privacy-content": "Lingoano n'est pas destiné aux enfants de moins de 13 ans. Nous ne collectons pas sciemment de données auprès d'enfants de moins de 13 ans ; si nous apprenons que nous avons collecté de telles données par inadvertance, elles seront supprimées dans un délai raisonnable. La plateforme est conforme à la loi COPPA (Children's Online Privacy Protection Act).",
      "international-transfers": "11. Transferts Internationaux de Données",
      "international-transfers-content": "La plateforme dessert des utilisateurs du monde entier. Les transferts de données sont effectués avec des mesures de sécurité appropriées. Les fournisseurs de services tiers sont situés dans des pays offrant un niveau de protection adéquat.",
      "policy-changes": "12. Modifications de la Politique",
      "policy-changes-content": "Cette Politique de Confidentialité peut être mise à jour de temps à autre. En cas de changements importants, la date d'entrée en vigueur sera mise à jour et une notification sera fournie par des moyens raisonnables. Les modifications entreront en vigueur à la date de leur publication.",
      "contact-section": "13. Contact",
      "contact-content": "Vous pouvez envoyer vos questions sur cette Politique de Confidentialité via les canaux suivants :",
      "privacy-email": "E-mail : contact@lingoano.com",
      "github": "GitHub : <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "data-protection-officer": "Délégué à la Protection des Données : contact@lingoano.com",
      "privacy-commitment": "Lingoano considère la protection de la vie privée des utilisateurs comme sa plus haute priorité. Cette politique a été préparée conformément aux principes de transparence et de confiance.",
      "contact-us": "Contactez-nous",
      "contact-description": "Vous pouvez nous contacter pour vos questions, suggestions ou commentaires.",
      "contact-email": "E-mail : contact@lingoano.com",
      "contact-response": "Délai de réponse : Dans les 24-48 heures",
      "close": "Fermer",
      "contactfooter": "Contact",
      "terms-of-service": "Conditions d'Utilisation"
    },
    // Russian Translations
    ru: {
      "privacy-policy-title-page": "Политика Конфиденциальности - Lingoano",
      "menu-toggle-label": "Открыть/закрыть меню",
      "theme-switcher-label": "Переключатель тем",
      "default-theme": "Тема по умолчанию",
      "blue-theme": "Синяя тема",
      "purple-theme": "Фиолетовая тема",
      "green-theme": "Зеленая тема",
      "chat": "Чат",
      "about": "О Lingoano",
      "word-of-day": "Слово дня",
      "language-guides": "Языковые гиды",
      "download": "Скачать",
      "logo-alt": "Логотип",
      "privacy-policy": "Политика Конфиденциальности",
      "last-updated": "Последнее обновление: 26 августа 2025 г.",
      "privacy-notice": "Настоящая Политика Конфиденциальности объясняет, как обрабатываются ваши личные данные при использовании платформы Lingoano. Используя платформу, вы соглашаетесь с этой политикой.",
      "introduction": "1. Введение",
      "introduction-content": "Lingoano (\"Lingoano\", \"мы\" или \"Компания\") обязуется защищать личные данные и уважать вашу конфиденциальность. Настоящая Политика Конфиденциальности объясняет, какие данные обрабатываются при использовании нашей платформы, для каких целей и на каких правовых основаниях, сроки их хранения и ваши права. Эта политика обеспечивает соответствие KVKK (Закон о защите персональных данных) и GDPR (Общий регламент по защите данных).",
      "anonymity-commitment": "Lingoano стремится защищать анонимность пользователей на самом высоком уровне. Платформа не запрашивает личную идентификационную информацию и не требует от пользователей раскрытия их настоящих личностей.",
      "information-collected": "2. Какую информацию мы собираем",
      "personal-information": "2.1 Личные данные",
      "personal-information-content": "Как правило, Lingoano не запрашивает и не обрабатывает данные, относящиеся к идентифицированному или идентифицируемому физическому лицу, такие как имя, фамилия, адрес электронной почты или номер телефона. Платформа разработана по принципу анонимного использования.",
      "technical-information": "2.2 Технические/Онлайн-идентификаторы",
      "technical-information-content": "Для предоставления услуги, обеспечения ее безопасности и улучшения производительности могут обрабатываться следующие технические данные:",
      "browser-type": "Тип и версия браузера",
      "operating-system": "Операционная система и информация об устройстве",
      "ip-address": "IP-адрес (по возможности применяется маскирование/анонимизация)",
      "page-views": "Статистика использования/взаимодействия (агрегированная и анонимная)",
      "session-data": "Данные сеанса (временные)",
      "preferences": "Пользовательские предпочтения (тема, выбор языка)",
      "chat-data": "2.3 Данные чата",
      "chat-data-content": "В чатах, проводимых через платформу:",
      "no-permanent-storage": "Сообщения не хранятся постоянно",
      "websocket-temporary": "В чатах, использующих протокол WebSocket, сообщения обрабатываются временно и могут проходить через сервер для передачи",
      "session-only-data": "Данные чата хранятся только временно во время сеанса",
      "no-chat-logs": "Журналы чатов не записываются постоянно",
      "p2p-preference": "По возможности предпочтение отдается одноранговой (peer-to-peer) связи",
      "use-of-information": "3. Использование информации",
      "use-of-information-content": "Собранная/обработанная информация используется в следующих целях в рамках законных интересов и для выполнения услуг:",
      "improve-platform": "Для улучшения производительности платформы",
      "resolve-issues": "Для решения технических проблем",
      "enhance-experience": "Для улучшения пользовательского опыта",
      "ensure-security": "Для обеспечения безопасности",
      "match-users": "Для предоставления услуги подбора пользователей",
      "analytics": "Анализ использования платформы (анонимный)",
      "information-sharing": "4. Обмен информацией",
      "information-sharing-content": "Lingoano не продает информацию о пользователях третьим лицам и не передает ее в маркетинговых целях. Передача данных может осуществляться только в обязательных случаях для выполнения юридических обязательств и ответа на должным образом авторизованные запросы властей. Платформа уделяет первоочередное внимание защите конфиденциальности пользователей.",
      "cookies-tracking": "5. Файлы cookie и отслеживание",
      "cookies-tracking-content": "Для работы сервиса могут использоваться обязательные и предпочтительные файлы cookie. Рекламные/отслеживающие файлы cookie в этой версии отключены; персонализированная реклама не показывается.",
      "store-theme": "Сохраняет ваши предпочтения по теме",
      "remember-language": "Запоминает ваш выбор языка",
      "session-info": "Защищает информацию о вашем сеансе",
      "essential-cookies": "Обязательные файлы cookie необходимы для функционирования сервиса",
      "preference-cookies": "Предпочтительные файлы cookie улучшают пользовательский опыт",
      "third-party-services": "6. Сторонние сервисы",
      "third-party-services-content": "В этой версии на платформе не активны рекламные сети. Сторонние рекламные и отслеживающие файлы cookie отключены. Обязательные/предпочтительные файлы cookie используются только для обеспечения функциональности сервиса и пользовательских настроек (тема, язык).",
      "data-security": "7. Безопасность данных",
      "data-security-content": "Lingoano применяет разумные технические и административные меры для обеспечения безопасности данных:",
      "use-ipfs": "По возможности предпочтение отдается сквозной/одноранговой связи (например, WebRTC, IPFS); если это невозможно, может использоваться временная обработка через WebSocket",
      "encrypted-communication": "Шифрование используется во время передачи",
      "no-data-storage": "Контент не хранится; обязательные журналы минимальны",
      "regular-updates": "Компоненты регулярно обновляются",
      "access-controls": "Применяются средства контроля доступа",
      "security-audits": "Проводятся аудиты безопасности",
      "chat-security": "7.1 Безопасность чата",
      "chat-security-content": "Меры, принятые для безопасности чата:",
      "end-to-end-encryption": "Сквозное шифрование, где это возможно",
      "temporary-messages": "Сообщения обрабатываются временно",
      "no-server-storage": "Постоянное хранение сообщений на сервере отсутствует",
      "secure-protocols": "Используются безопасные протоколы",
      "session-timeout": "Применяется тайм-аут сессии",
      "data-retention": "8. Сроки хранения данных",
      "data-retention-content": "Lingoano работает по принципу минимального хранения данных:",
      "session-data-retention": "Данные сеанса: Во время сеанса",
      "chat-data-retention": "Данные чата: Во время сеанса (не хранятся постоянно)",
      "analytics-retention": "Аналитические данные: 12 месяцев (анонимные)",
      "preferences-retention": "Пользовательские предпочтения: 2 года",
      "log-retention": "Журналы безопасности: 30 дней",
      "legal-retention": "Юридические обязательства: В течение срока, требуемого законом",
      "user-rights": "9. Права пользователей",
      "user-rights-content": "В соответствии с действующим законодательством наши пользователи имеют следующие права:",
      "access-data": "Доступ к вашим личным данным",
      "correct-data": "Исправление ваших данных",
      "delete-data": "Удаление ваших данных",
      "object-processing": "Возражение против обработки данных",
      "data-portability": "Переносимость данных",
      "withdraw-consent": "Отзыв согласия",
      "complaint-right": "Право на подачу жалобы",
      "rights-exercise": "8.1 Осуществление ваших прав",
      "rights-exercise-content": "Чтобы воспользоваться своими правами:",
      "contact-privacy": "Отправьте электронное письмо по адресу contact@lingoano.com",
      "response-time": "Время ответа: В течение 30 дней",
      "free-service": "Услуга предоставляется бесплатно",
      "identity-verification": "Может потребоваться подтверждение личности",
      "children-privacy": "10. Конфиденциальность детей",
      "children-privacy-content": "Lingoano не предназначен для детей младше 13 лет. Мы сознательно не собираем данные детей младше 13 лет; если мы узнаем, что случайно собрали такие данные, они будут удалены в разумные сроки. Платформа соответствует COPPA (Закон о защите конфиденциальности детей в Интернете).",
      "international-transfers": "11. Международная передача данных",
      "international-transfers-content": "Платформа обслуживает пользователей по всему миру. Передача данных осуществляется с соблюдением соответствующих мер безопасности. Сторонние поставщики услуг находятся в странах, обеспечивающих адекватный уровень защиты.",
      "policy-changes": "12. Изменения в политике",
      "policy-changes-content": "Настоящая Политика Конфиденциальности может время от времени обновляться. В случае существенных изменений дата вступления в силу будет обновлена, и будет предоставлено уведомление разумными способами. Изменения вступают в силу с даты публикации.",
      "contact-section": "13. Контакты",
      "contact-content": "Вы можете направить свои вопросы по поводу этой Политики Конфиденциальности по следующим каналам:",
      "privacy-email": "Электронная почта: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "data-protection-officer": "Ответственный за защиту данных: contact@lingoano.com",
      "privacy-commitment": "Lingoano считает защиту конфиденциальности пользователей своим высшим приоритетом. Эта политика была подготовлена в соответствии с принципами прозрачности и доверия.",
      "contact-us": "Свяжитесь с нами",
      "contact-description": "Вы можете связаться с нами по вопросам, предложениям или для обратной связи.",
      "contact-email": "Электронная почта: contact@lingoano.com",
      "contact-response": "Время ответа: В течение 24-48 часов",
      "close": "Закрыть",
      "contactfooter": "Контакты",
      "terms-of-service": "Условия использования"
    }
  };
// Language management class
class LanguageManager {
    constructor() {
        this.currentLanguage = localStorage.getItem('Lingoano-site-language') || null;
        this.init();
    }
    
    init() {
        if (this.currentLanguage) {
            // User has already selected a language, use it
            this.setLanguage(this.currentLanguage);
        } else {
            // No language selected, detect from IP
            this.detectLanguageFromIP();
        }
        this.bindEvents();
    }
    
    async detectLanguageFromIP() {
        // Show loading indicator
        this.showLanguageLoading();
        
        // Try multiple IP detection services for better reliability
        const services = [
            'https://ipapi.co/json/',
            'https://ipinfo.io/json',
            'https://api.ipify.org?format=json'
        ];
        
        for (const service of services) {
            try {
                const controller = new AbortController();
                const timeoutId = setTimeout(() => controller.abort(), 5000);
                
                const response = await fetch(service, { 
                    method: 'GET',
                    headers: { 'Accept': 'application/json' },
                    signal: controller.signal
                });
                
                clearTimeout(timeoutId);
                
                if (!response.ok) continue;
                
                const data = await response.json();
                
                // Handle different response formats
                let countryCode = null;
                if (data.country_code) {
                    countryCode = data.country_code.toLowerCase();
                } else if (data.country) {
                    countryCode = data.country.toLowerCase();
                }
                
                if (countryCode) {
                    const detectedLanguage = this.getLanguageFromCountry(countryCode);
                    
                    if (detectedLanguage) {
                        const countryName = data.country_name || data.country || countryCode;
                        console.log(`Detected language from IP: ${detectedLanguage} (Country: ${countryName})`);
                        this.hideLanguageLoading();
                        this.setLanguage(detectedLanguage);
                        return;
                    }
                }
            } catch (error) {
                console.log(`IP detection service ${service} failed:`, error.message);
                continue;
            }
        }
        
        // If all IP services fail, try browser language detection
        console.log('All IP detection services failed, trying browser language...');
        this.detectLanguageFromBrowser();
    }
    
    showLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'flex';
        }
    }
    
    hideLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'none';
        }
    }
    
    getLanguageFromCountry(countryCode) {
        // Map countries to supported languages
        const countryToLanguage = {
            // Turkish speaking countries
            'tr': 'tr',
            'cy': 'tr', // Northern Cyprus
            
            // English speaking countries
            'us': 'en', 'gb': 'en', 'ca': 'en', 'au': 'en', 'nz': 'en', 'ie': 'en',
            'za': 'en', 'in': 'en', 'pk': 'en', 'ng': 'en', 'ke': 'en', 'ug': 'en',
            'tz': 'en', 'gh': 'en', 'zm': 'en', 'zw': 'en', 'mw': 'en', 'bw': 'en',
            'sz': 'en', 'ls': 'en', 'na': 'en', 'mu': 'en', 'sc': 'en', 'mv': 'en',
            'lk': 'en', 'bd': 'en', 'np': 'en', 'bt': 'en', 'mm': 'en', 'kh': 'en',
            'la': 'en', 'vn': 'en', 'my': 'en', 'sg': 'en', 'bn': 'en', 'ph': 'en',
            'fj': 'en', 'pg': 'en', 'sb': 'en', 'vu': 'en', 'nc': 'en', 'pf': 'en',
            'to': 'en', 'ws': 'en', 'ki': 'en', 'tv': 'en', 'nr': 'en', 'pw': 'en',
            'mh': 'en', 'fm': 'en', 'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en',
            'jm': 'en', 'bb': 'en', 'gd': 'en', 'lc': 'en', 'vc': 'en', 'ag': 'en',
            'dm': 'en', 'kn': 'en', 'ai': 'en', 'vg': 'en', 'tc': 'en', 'ms': 'en',
            'ky': 'en', 'bm': 'en', 'fk': 'en', 'gi': 'en', 'sh': 'en', 'io': 'en',
            'pn': 'en', 'ck': 'en', 'nu': 'en', 'tk': 'en', 'wf': 'en', 'as': 'en',
            'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en', 'jm': 'en', 'bb': 'en',
            
            // German speaking countries
            'de': 'de', 'at': 'de', 'ch': 'de', 'li': 'de', 'lu': 'de',
            
            // French speaking countries
            'fr': 'fr', 'be': 'fr', 'mc': 'fr', 'ca': 'fr',

            // Spanish speaking countries
            'es': 'es', 'mx': 'es', 'ar': 'es', 'cl': 'es', 'pe': 'es', 'co': 'es', 'ec': 'es',
            'uy': 'es', 'py': 'es', 'bo': 'es', 've': 'es', 'do': 'es', 'cr': 'es', 'gt': 'es',
            'hn': 'es', 'ni': 'es', 'sv': 'es', 'pa': 'es', 'cu': 'es',
            
            // Russian speaking countries
            'ru': 'ru', 'by': 'ru', 'kz': 'ru', 'kg': 'ru', 'tj': 'ru',
            'uz': 'ru', 'tm': 'ru', 'md': 'ru', 'ge': 'ru', 'am': 'ru',
            'az': 'ru', 'ua': 'ru', 'ee': 'ru', 'lv': 'ru', 'lt': 'ru'
        };
        
        return countryToLanguage[countryCode] || null;
    }
    
    detectLanguageFromBrowser() {
        // Get browser language
        const browserLang = navigator.language || navigator.userLanguage;
        const langCode = browserLang.split('-')[0].toLowerCase();
        
        // Map browser language to supported languages
        const browserToLanguage = {
            'tr': 'tr',
            'en': 'en',
            'de': 'de',
            'fr': 'fr',
            'es': 'es',
            'ru': 'ru'
        };
        
        const detectedLanguage = browserToLanguage[langCode];
        
        if (detectedLanguage) {
            console.log(`Detected language from browser: ${detectedLanguage}`);
            this.hideLanguageLoading();
            this.setLanguage(detectedLanguage);
        } else {
            // Default to Turkish if no match found
            console.log('No language detected, defaulting to Turkish');
            this.hideLanguageLoading();
            this.setLanguage('tr');
        }
    }
    
    setLanguage(lang, saveToStorage = false) {
        if (!translations[lang]) {
            console.warn(`Language ${lang} not found, falling back to Turkish`);
            lang = 'tr';
        }
        
        this.currentLanguage = lang;
        
        // Only save to localStorage if user manually selected
        if (saveToStorage) {
            localStorage.setItem('Lingoano-site-language', lang);
        }
        
        // Update language selectors
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.value = lang;
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.value = lang;
        }
        
        // Update all translatable elements
        this.updatePageContent();
    }
    
    getText(key) {
        return translations[this.currentLanguage][key] || translations['tr'][key] || key;
    }
    
    updatePageContent() {
        // Update elements with data-lang attribute
        const elements = document.querySelectorAll('[data-lang]');
        elements.forEach(element => {
            const key = element.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                if (element.tagName === 'INPUT' && element.hasAttribute('placeholder')) {
                    element.placeholder = translation;
                } else if (element.hasAttribute('title')) {
                    element.title = translation;
                } else if (element.hasAttribute('aria-label')) {
                    element.setAttribute('aria-label', translation);
                } else if (element.hasAttribute('alt')) {
                    element.alt = translation;
                } else {
                    element.innerHTML = translation;
                }
            }
        });
        
        // Update form options
        this.updateFormOptions();
        
        // Update dictionary widget if it exists
        if (window.dictionaryWidget) {
            window.dictionaryWidget.updateLanguage();
        }
    }
    
    updateFormOptions() {
        // Update language form options
        const languageSelect = document.getElementById('language');
        if (languageSelect) {
            const options = languageSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = option.value;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update level form options
        const levelSelect = document.getElementById('level');
        if (levelSelect) {
            const options = levelSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = `level-${option.value.toLowerCase()}`;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update meta description for current language
        const metaDesc = document.querySelector('meta[name="description"]');
        if (metaDesc) {
            const currentLang = this.currentLanguage;
            // This could be expanded to have page-specific descriptions per language
        }
        
        // Update document title if it has data-lang
        const titleElement = document.querySelector('title[data-lang]');
        if (titleElement) {
            const key = titleElement.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                titleElement.textContent = translation;
            }
        }
    }
    
    bindEvents() {
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
    }
}

// Initialize language manager when DOM is loaded
let languageManager;
document.addEventListener('DOMContentLoaded', () => {
    languageManager = new LanguageManager();
    // Make it globally available after initialization
    window.languageManager = languageManager;
});

// Make translations globally available immediately
window.translations = translations;

// Remove AdSense-related translation keys across all languages at runtime
(function removeAdKeys() {
    try {
        const keysToRemove = [
            'google-adsense',
            'google-adsense-content',
            'google-adsense-terms',
            'google-adsense-terms-content',
            'adsense-cookies',
            'adsense-privacy',
            'adsense-opt-out',
            'adsense-compliance'
        ];
        Object.keys(translations || {}).forEach(lang => {
            const dict = translations[lang];
            if (!dict) return;
            keysToRemove.forEach(k => { try { delete dict[k]; } catch (_) {} });
        });
    } catch (_) {}
})();

