const translations = {
    // Turkish (TR) - Orijinal metinler
    tr: {
        "websocket-temporary": "WebSocket protokolü kullanılan sohbetlerde mesajlar geçici olarak işlenir ve kalıcı olarak kaydedilmez",
      "terms-title-page": "Kullanım Şartları - Lingoano",
      "menu-toggle-label": "Menüyü aç/kapat",
      "theme-switcher-label": "Tema değiştirici",
      "default-theme": "Varsayılan Tema",
      "blue-theme": "Mavi Tema",
      "purple-theme": "Mor Tema",
      "green-theme": "Yeşil Tema",
      "chat": "Chat",
      "about": "Lingoano Hakkında",
      "word-of-day": "Günün Kelimesi",
      "language-guides": "Dil Rehberleri",
      "download": "İndir",
      "logo-alt": "Logo",
      "terms-of-service": "Kullanım Şartları",
      "advertisements-content": "Bu sürümde platformda herhangi bir reklam ağı etkin değildir. Üçüncü taraf reklam ve izleme çerezleri devre dışıdır.",
      "last-updated": "Son güncelleme: 27 Ağustos 2025",
      "terms-notice": "Bu Kullanım Şartları, Lingoano platformunu kullanırken uymanız gereken kuralları ve koşulları belirler. Platformu kullanarak bu şartları kabul etmiş sayılırsınız.",
      "acceptance": "1. Kabul ve Onay",
      "acceptance-content": "Lingoano hizmetlerine erişmek ve bunları kullanmakla, işbu Kullanım Şartları'nı ve atıf yoluyla dahil edilen tüm politika ve aydınlatmaları kabul etmiş sayılırsınız. Şartları kabul etmiyorsanız hizmeti kullanmamalısınız. Bu şartlar, platform kullanımınızın tüm aşamalarında geçerlidir.",
      "service-description": "2. Hizmet Tanımı",
      "service-description-content": "Lingoano; dil pratiği yapmak isteyen kullanıcıları eşleştiren ve iletişim kurmalarını sağlayan bir platformdur. Mümkün olan durumlarda eşler arası (P2P) iletişim tercih edilir. Hizmet \"olduğu gibi\" ve \"mevcut haliyle\" sunulur. Platform, kullanıcıların anonim olarak dil öğrenme pratiği yapmasını amaçlar.",
      "user-responsibilities": "3. Kullanıcı Sorumlulukları",
      "general-rules": "3.1 Genel Kurallar",
      "general-rules-content": "Hizmet kullanımı sırasında yürürlükteki mevzuata, kamu düzenine ve topluluk kurallarına riayet edilmelidir:",
      "be-respectful": "Saygılı ve kibar olun",
      "follow-laws": "Yasalara uygun davranın",
      "respect-rights": "Başkalarının haklarına saygı gösterin",
      "no-spam": "Spam veya zararlı içerik paylaşmayın",
      "no-threats": "Platform güvenliğini tehdit etmeyin",
      "no-harassment": "Diğer kullanıcıları taciz etmeyin",
      "no-impersonation": "Başkalarının kimliğine bürünmeyin",
      "prohibited-content": "3.2 Yasaklı İçerikler",
      "prohibited-content-content": "Aşağıdaki içerik ve fiiller kesinlikle yasaktır:",
      "hate-speech": "Nefret söylemi ve ayrımcılık",
      "violence": "Şiddet içeren içerik",
      "obscene-material": "Müstehcen veya pornografik materyal",
      "illegal-activities": "Yasadışı faaliyetler",
      "personal-info": "Kişisel bilgilerin paylaşımı",
      "false-info": "Sahte bilgi yayma",
      "malware": "Zararlı yazılım veya bağlantı paylaşımı",
      "commercial-spam": "Ticari spam ve reklam içerikleri",
      "terms-privacy-security": "4. Gizlilik ve Güvenlik",
      "anonymity-notice": "Lingoano, kullanıcı anonimliğini en üst düzeyde korumayı taahhüt eder. Platform, kişisel kimlik bilgileri talep etmez ve kullanıcıların gerçek kimliklerini paylaşmalarını gerektirmez.",
      "terms-privacy-security-content": "Lingoano, kullanıcı gizliliğini ve güvenliğini önceler. Bununla birlikte çevrimiçi güvenliğin sağlanmasında nihai sorumluluk kullanıcıya aittir:",
      "self-responsibility": "Kendi güvenliğinizden siz sorumlusunuz",
      "no-personal-info": "Kişisel bilgilerinizi paylaşmayın",
      "report-suspicious": "Şüpheli davranışları bildirin",
      "support-security": "Platform güvenlik önlemlerini destekleyin",
      "secure-connection": "Güvenli internet bağlantısı kullanın",
      "chat-privacy": "4.2 Sohbet Gizliliği",
      "chat-privacy-content": "Platform üzerinden gerçekleştirilen sohbetlerde gizlilik önceliğimizdir:",
      "no-chat-storage": "Sohbet geçmişi kalıcı olarak saklanmaz",
      "p2p-communication": "Mümkün olduğunda peer-to-peer iletişim tercih edilir",
      "encrypted-transmission": "Mesajlar şifrelenmiş olarak iletilir",
      "session-only": "Sohbet verileri yalnızca oturum süresince geçici olarak tutulur",
      "intellectual-property": "5. Fikri Mülkiyet",
      "intellectual-property-content": "Lingoano'ya ait marka, logo, arayüz, yazılım, metin ve görseller ilgili mevzuatla korunur. Yazılı izin alınmadan kopyalanamaz, çoğaltılamaz, dağıtılamaz veya türev eser oluşturulamaz. Platform içeriği, telif hakkı ve diğer fikri mülkiyet hakları ile korunmaktadır.",
      "service-changes": "6. Hizmette Değişiklik",
      "service-changes-content": "Lingoano, hizmet kapsamını ve işlevlerini zaman zaman güncelleyebilir, askıya alabilir veya durdurabilir. Esaslı değişikliklerde makul bilgilendirme yapılır. Platform, sürekli geliştirme ve iyileştirme sürecindedir.",
      "liability-limitation": "7. Sorumluluğun Sınırlandırılması",
      "liability-limitation-content": "Hizmet, \"olduğu gibi\" ve \"mevcut haliyle\" sunulur. Uygulanabilir mevzuatın izin verdiği azami ölçüde; dolaylı, arızi, özel, cezai veya netice kabilinden doğan zararlar bakımından Lingoano sorumlu tutulamaz. Platform, kullanıcılar arasındaki iletişimden doğabilecek sorunlardan sorumlu değildir.",
      "account-suspension": "8. Askıya Alma ve Sonlandırma",
      "account-suspension-content": "Şartların ihlali halinde erişim kısıtlanabilir, hesap(lar) askıya alınabilir veya sonlandırılabilir. Uyuşmazlıkların çözümü amacıyla gerekli görülen kayıtlar yürürlükteki mevzuata uygun şekilde saklanabilir. Platform, güvenlik ve topluluk kurallarını korumak için gerekli önlemleri alma hakkını saklı tutar.",
      "advertisements": "9. Reklamlar ve Üçüncü Taraf Hizmetler",
      "data-retention": "10. Veri Saklama ve İşleme",
      "data-retention-content": "Lingoano, minimal veri toplama prensibi ile çalışır:",
      "minimal-collection": "Yalnızca hizmet sunumu için gerekli minimum veri toplanır",
      "no-chat-logs": "Sohbet logları kalıcı olarak saklanmaz",
      "temporary-session": "Oturum verileri geçici olarak işlenir",
      "anonymized-analytics": "Analitik veriler anonimleştirilmiş olarak toplanır",
      "user-control": "Kullanıcılar, veri işleme konusunda kontrol sahibidir",
      "applicable-law": "11. Uygulanacak Hukuk ve Yetki",
      "applicable-law-content": "İşbu Şartlar, Türkiye Cumhuriyeti hukuku uyarınca yorumlanır ve uygulanır. Uyuşmazlıklarda İstanbul (Merkez) mahkemeleri ve icra daireleri yetkilidir. Uluslararası kullanıcılar için de Türkiye hukuku geçerlidir.",
      "dispute-resolution": "12. Uyuşmazlık Çözümü",
      "dispute-resolution-content": "Platform ile ilgili uyuşmazlıklar öncelikle görüşme yoluyla çözülmeye çalışılır. Görüşme ile çözülemeyen uyuşmazlıklar için yasal yollara başvurulabilir. Kullanıcılar, haklarını korumak için gerekli belgeleri saklamalıdır.",
      "contact-section": "13. İletişim",
      "contact-content": "İşbu Şartlar hakkında sorularınızı aşağıdaki kanallardan iletebilirsiniz:",
      "terms-email": "E‑posta: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "response-time": "Yanıt süresi: 48 saat içinde",
      "terms-acceptance-notice": "Platformu kullanmaya devam ederek, bu Kullanım Şartları'nın güncel versiyonunu kabul etmiş sayılırsınız. Şartlarda yapılacak değişiklikler, yayınlandığı tarihten itibaren geçerli olacaktır.",
      "contact-us": "Bizimle İletişime Geçin",
      "contact-description": "Sorularınız, önerileriniz veya geri bildirimleriniz için bizimle iletişime geçebilirsiniz.",
      "contact-email": "E-posta: contact@lingoano.com",
      "contact-response": "Yanıt süresi: 24-48 saat içinde",
      "close": "Kapat",
      "privacy-policy": "Gizlilik Politikası",
      "contactfooter": "İletişim"
    },
    // English (EN)
    en: {
        "websocket-temporary": "In chats using the WebSocket protocol, messages are processed temporarily and are not saved permanently",
      "terms-title-page": "Terms of Service - Lingoano",
      "menu-toggle-label": "Open/close menu",
      "theme-switcher-label": "Theme switcher",
      "default-theme": "Default Theme",
      "blue-theme": "Blue Theme",
      "purple-theme": "Purple Theme",
      "green-theme": "Green Theme",
      "chat": "Chat",
      "about": "About Lingoano",
      "word-of-day": "Word of the Day",
      "language-guides": "Language Guides",
      "download": "Download",
      "logo-alt": "Logo",
      "terms-of-service": "Terms of Service",
      "last-updated": "Last updated: August 26, 2025",
      "terms-notice": "These Terms of Service set out the rules and conditions you must follow when using the Lingoano platform. By using the platform, you are deemed to have accepted these terms.",
      "acceptance": "1. Acceptance and Agreement",
      "acceptance-content": "By accessing and using the Lingoano services, you agree to be bound by these Terms of Service and all policies and disclosures incorporated by reference. If you do not agree to the terms, you must not use the service. These terms apply to all stages of your use of the platform.",
      "service-description": "2. Service Description",
      "service-description-content": "Lingoano is a platform that matches users who want to practice a language and enables them to communicate. Peer-to-peer (P2P) communication is preferred where possible. The service is provided \"as is\" and \"as available\". The platform aims to allow users to practice language learning anonymously.",
      "user-responsibilities": "3. User Responsibilities",
      "general-rules": "3.1 General Rules",
      "general-rules-content": "During the use of the service, you must comply with applicable laws, public order, and community rules:",
      "be-respectful": "Be respectful and polite",
      "follow-laws": "Act in accordance with the law",
      "respect-rights": "Respect the rights of others",
      "no-spam": "Do not share spam or malicious content",
      "no-threats": "Do not threaten the security of the platform",
      "no-harassment": "Do not harass other users",
      "no-impersonation": "Do not impersonate others",
      "prohibited-content": "3.2 Prohibited Content",
      "prohibited-content-content": "The following content and actions are strictly prohibited:",
      "hate-speech": "Hate speech and discrimination",
      "violence": "Violent content",
      "obscene-material": "Obscene or pornographic material",
      "illegal-activities": "Illegal activities",
      "personal-info": "Sharing of personal information",
      "false-info": "Spreading false information",
      "malware": "Sharing malicious software or links",
      "commercial-spam": "Commercial spam and advertising",
      "terms-privacy-security": "4. Privacy and Security",
      "anonymity-notice": "Lingoano is committed to protecting user anonymity at the highest level. The platform does not request personal identification information and does not require users to share their real identities.",
      "terms-privacy-security-content": "Lingoano prioritizes user privacy and security. However, the ultimate responsibility for ensuring online security rests with the user:",
      "self-responsibility": "You are responsible for your own safety",
      "no-personal-info": "Do not share your personal information",
      "report-suspicious": "Report suspicious behavior",
      "support-security": "Support the platform's security measures",
      "secure-connection": "Use a secure internet connection",
      "chat-privacy": "4.2 Chat Privacy",
      "chat-privacy-content": "Privacy is our priority in chats conducted via the platform:",
      "no-chat-storage": "Chat history is not stored permanently",
      "p2p-communication": "Peer-to-peer communication is preferred where possible",
      "encrypted-transmission": "Messages are transmitted in encrypted form",
      "session-only": "Chat data is only held temporarily during the session",
      "intellectual-property": "5. Intellectual Property",
      "intellectual-property-content": "The Lingoano brand, logo, interface, software, text, and images are protected by relevant legislation. They may not be copied, reproduced, distributed, or used to create derivative works without written permission. The platform's content is protected by copyright and other intellectual property rights.",
      "service-changes": "6. Changes to the Service",
      "service-changes-content": "Lingoano may update, suspend, or discontinue the scope and functions of the service from time to time. Reasonable notice will be given for substantial changes. The platform is in a continuous process of development and improvement.",
      "liability-limitation": "7. Limitation of Liability",
      "liability-limitation-content": "The service is provided \"as is\" and \"as available\". To the maximum extent permitted by applicable law, Lingoano shall not be liable for any indirect, incidental, special, consequential, or punitive damages. The platform is not responsible for problems that may arise from communication between users.",
      "account-suspension": "8. Suspension and Termination",
      "account-suspension-content": "In case of violation of the terms, access may be restricted, account(s) may be suspended, or terminated. Records deemed necessary for the resolution of disputes may be stored in accordance with applicable legislation. The platform reserves the right to take necessary measures to protect security and community rules.",
      "advertisements": "9. Advertisements and Third-Party Services",
      "data-retention": "10. Data Retention and Processing",
      "data-retention-content": "Lingoano operates on the principle of minimal data collection:",
      "minimal-collection": "Only the minimum data necessary for service delivery is collected",
      "no-chat-logs": "Chat logs are not stored permanently",
      "temporary-session": "Session data is processed temporarily",
      "anonymized-analytics": "Analytics data is collected in an anonymized form",
      "user-control": "Users have control over their data processing",
      "applicable-law": "11. Applicable Law and Jurisdiction",
      "applicable-law-content": "These Terms shall be interpreted and enforced in accordance with the laws of the Republic of Turkey. The courts and enforcement offices of Istanbul (Central) shall have jurisdiction over disputes. Turkish law also applies to international users.",
      "dispute-resolution": "12. Dispute Resolution",
      "dispute-resolution-content": "Disputes related to the platform will first be attempted to be resolved through negotiation. Legal action may be taken for disputes that cannot be resolved through negotiation. Users should keep necessary documents to protect their rights.",
      "contact-section": "13. Contact",
      "advertisements-content": "In this version, no advertising network is active on the platform. Third-party advertising and tracking cookies are disabled.",
      "contact-content": "You can send your questions about these Terms through the following channels:",
      "terms-email": "E-mail: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "response-time": "Response time: Within 48 hours",
      "terms-acceptance-notice": "By continuing to use the platform, you are deemed to have accepted the current version of these Terms of Service. Changes to the terms will be effective from the date of their publication.",
      "contact-us": "Contact Us",
      "contact-description": "You can contact us for your questions, suggestions, or feedback.",
      "contact-email": "E-mail: contact@lingoano.com",
      "contact-response": "Response time: Within 24-48 hours",
      "close": "Close",
      "privacy-policy": "Privacy Policy",
      "contactfooter": "Contact"
    },
    // German (DE)
    de: {
        "websocket-temporary": "In Chats, die das WebSocket-Protokoll verwenden, werden Nachrichten vorübergehend verarbeitet und nicht dauerhaft gespeichert",
      "terms-title-page": "Nutzungsbedingungen - Lingoano",
      "menu-toggle-label": "Menü öffnen/schließen",
      "theme-switcher-label": "Design-Umschalter",
      "default-theme": "Standard-Design",
      "blue-theme": "Blaues Design",
      "purple-theme": "Lila Design",
      "green-theme": "Grünes Design",
      "chat": "Chat",
      "about": "Über Lingoano",
      "word-of-day": "Wort des Tages",
      "language-guides": "Sprachführer",
      "download": "Herunterladen",
      "logo-alt": "Logo",
      "terms-of-service": "Nutzungsbedingungen",
      "last-updated": "Letzte Aktualisierung: 26. August 2025",
      "terms-notice": "Diese Nutzungsbedingungen legen die Regeln und Bedingungen fest, die Sie bei der Nutzung der Lingoano-Plattform befolgen müssen. Durch die Nutzung der Plattform erklären Sie sich mit diesen Bedingungen einverstanden.",
      "acceptance": "1. Annahme und Zustimmung",
      "acceptance-content": "Durch den Zugriff auf und die Nutzung der Lingoano-Dienste erklären Sie sich mit diesen Nutzungsbedingungen und allen durch Verweis einbezogenen Richtlinien und Offenlegungen einverstanden. Wenn Sie den Bedingungen nicht zustimmen, dürfen Sie den Dienst nicht nutzen. Diese Bedingungen gelten für alle Phasen Ihrer Nutzung der Plattform.",
      "service-description": "2. Dienstbeschreibung",
      "service-description-content": "Lingoano ist eine Plattform, die Benutzer, die eine Sprache üben möchten, zusammenbringt und ihnen die Kommunikation ermöglicht. Peer-to-Peer (P2P)-Kommunikation wird nach Möglichkeit bevorzugt. Der Dienst wird \"wie besehen\" und \"wie verfügbar\" bereitgestellt. Die Plattform zielt darauf ab, den Benutzern anonymes Üben des Sprachenlernens zu ermöglichen.",
      "user-responsibilities": "3. Verantwortlichkeiten des Benutzers",
      "general-rules": "3.1 Allgemeine Regeln",
      "general-rules-content": "Während der Nutzung des Dienstes müssen Sie die geltenden Gesetze, die öffentliche Ordnung und die Community-Regeln einhalten:",
      "be-respectful": "Seien Sie respektvoll und höflich",
      "follow-laws": "Handeln Sie gesetzeskonform",
      "respect-rights": "Respektieren Sie die Rechte anderer",
      "no-spam": "Teilen Sie keine Spam- oder schädlichen Inhalte",
      "no-threats": "Gefährden Sie nicht die Sicherheit der Plattform",
      "no-harassment": "Belästigen Sie keine anderen Benutzer",
      "no-impersonation": "Geben Sie sich nicht als jemand anderes aus",
      "prohibited-content": "3.2 Verbotene Inhalte",
      "prohibited-content-content": "Die folgenden Inhalte und Handlungen sind strengstens verboten:",
      "hate-speech": "Hassrede und Diskriminierung",
      "violence": "Gewalttätige Inhalte",
      "obscene-material": "Obszönes oder pornografisches Material",
      "illegal-activities": "Illegale Aktivitäten",
      "personal-info": "Weitergabe persönlicher Informationen",
      "false-info": "Verbreitung von Falschinformationen",
      "malware": "Teilen von bösartiger Software oder Links",
      "commercial-spam": "Kommerzieller Spam und Werbung",
      "terms-privacy-security": "4. Datenschutz und Sicherheit",
      "anonymity-notice": "Lingoano verpflichtet sich, die Anonymität der Benutzer auf höchstem Niveau zu schützen. Die Plattform fordert keine persönlichen Identifikationsdaten an und verlangt von den Benutzern nicht, ihre wahre Identität preiszugeben.",
      "terms-privacy-security-content": "Lingoano legt Wert auf den Datenschutz und die Sicherheit der Benutzer. Die letztendliche Verantwortung für die Gewährleistung der Online-Sicherheit liegt jedoch beim Benutzer:",
      "self-responsibility": "Sie sind für Ihre eigene Sicherheit verantwortlich",
      "no-personal-info": "Teilen Sie Ihre persönlichen Informationen nicht mit",
      "report-suspicious": "Melden Sie verdächtiges Verhalten",
      "support-security": "Unterstützen Sie die Sicherheitsmaßnahmen der Plattform",
      "secure-connection": "Verwenden Sie eine sichere Internetverbindung",
      "chat-privacy": "4.2 Chat-Datenschutz",
      "chat-privacy-content": "Datenschutz hat in Chats, die über die Plattform geführt werden, Priorität:",
      "no-chat-storage": "Der Chatverlauf wird nicht dauerhaft gespeichert",
      "p2p-communication": "Peer-to-Peer-Kommunikation wird nach Möglichkeit bevorzugt",
      "encrypted-transmission": "Nachrichten werden verschlüsselt übertragen",
      "session-only": "Chat-Daten werden nur vorübergehend während der Sitzung gespeichert",
      "intellectual-property": "5. Geistiges Eigentum",
      "intellectual-property-content": "Die Marke, das Logo, die Benutzeroberfläche, die Software, die Texte und die Bilder von Lingoano sind durch die einschlägigen Gesetze geschützt. Sie dürfen ohne schriftliche Genehmigung nicht kopiert, vervielfältigt, verbreitet oder zur Erstellung abgeleiteter Werke verwendet werden. Der Inhalt der Plattform ist durch Urheberrecht und andere geistige Eigentumsrechte geschützt.",
      "service-changes": "6. Änderungen am Dienst",
      "service-changes-content": "Lingoano kann den Umfang und die Funktionen des Dienstes von Zeit zu Zeit aktualisieren, aussetzen oder einstellen. Bei wesentlichen Änderungen wird eine angemessene Benachrichtigung erfolgen. Die Plattform befindet sich in einem kontinuierlichen Entwicklungs- und Verbesserungsprozess.",
      "liability-limitation": "7. Haftungsbeschränkung",
      "liability-limitation-content": "Der Dienst wird \"wie besehen\" und \"wie verfügbar\" bereitgestellt. Soweit nach geltendem Recht zulässig, haftet Lingoano nicht für indirekte, zufällige, besondere, Folge- oder Strafschäden. Die Plattform ist nicht verantwortlich für Probleme, die aus der Kommunikation zwischen Benutzern entstehen können.",
      "account-suspension": "8. Aussetzung und Kündigung",
      "account-suspension-content": "Bei Verstößen gegen die Bedingungen kann der Zugang eingeschränkt, das Konto/die Konten ausgesetzt oder gekündigt werden. Aufzeichnungen, die zur Beilegung von Streitigkeiten als notwendig erachtet werden, können gemäß den geltenden Gesetzen aufbewahrt werden. Die Plattform behält sich das Recht vor, die notwendigen Maßnahmen zum Schutz der Sicherheit und der Community-Regeln zu ergreifen.",
      "advertisements": "9. Werbung und Dienste von Drittanbietern",
      "data-retention": "10. Datenspeicherung und -verarbeitung",
      "data-retention-content": "Lingoano arbeitet nach dem Prinzip der minimalen Datenerfassung:",
      "minimal-collection": "Es werden nur die für die Leistungserbringung erforderlichen Mindestdaten erhoben",
      "no-chat-logs": "Chat-Protokolle werden nicht dauerhaft gespeichert",
      "temporary-session": "Sitzungsdaten werden vorübergehend verarbeitet",
      "anonymized-analytics": "Analysedaten werden in anonymisierter Form erhoben",
      "user-control": "Benutzer haben die Kontrolle über ihre Datenverarbeitung",
      "applicable-law": "11. Anwendbares Recht und Gerichtsstand",
      "applicable-law-content": "Diese Bedingungen werden gemäß den Gesetzen der Republik Türkei ausgelegt und durchgesetzt. Für Streitigkeiten sind die Gerichte und Vollstreckungsämter von Istanbul (Zentral) zuständig. Türkisches Recht gilt auch für internationale Benutzer.",
      "dispute-resolution": "12. Streitbeilegung",
      "dispute-resolution-content": "Streitigkeiten im Zusammenhang mit der Plattform werden zunächst durch Verhandlungen beigelegt. Für Streitigkeiten, die nicht durch Verhandlungen beigelegt werden können, können rechtliche Schritte eingeleitet werden. Benutzer sollten die notwendigen Dokumente aufbewahren, um ihre Rechte zu schützen.",
      "contact-section": "13. Kontakt",
      "advertisements-content": "In dieser Version ist kein Werbenetzwerk auf der Plattform aktiv. Werbe- und Tracking-Cookies von Drittanbietern sind deaktiviert.",

// Spanish (ES)
      "contact-content": "Sie können Ihre Fragen zu diesen Bedingungen über die folgenden Kanäle senden:",
      "terms-email": "E-Mail: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "response-time": "Antwortzeit: Innerhalb von 48 Stunden",
      "terms-acceptance-notice": "Durch die weitere Nutzung der Plattform erklären Sie sich mit der aktuellen Version dieser Nutzungsbedingungen einverstanden. Änderungen der Bedingungen werden ab dem Datum ihrer Veröffentlichung wirksam.",
      "contact-us": "Kontaktieren Sie uns",
      "contact-description": "Sie können uns bei Fragen, Anregungen oder Feedback kontaktieren.",
      "contact-email": "E-Mail: contact@lingoano.com",
      "contact-response": "Antwortzeit: Innerhalb von 24-48 Stunden",
      "close": "Schließen",
      "privacy-policy": "Datenschutzrichtlinie",
      "contactfooter": "Kontakt"
    },
    // Spanish (ES)
    es: {
        "websocket-temporary": "En los chats que utilizan el protocolo WebSocket, los mensajes se procesan temporalmente y no se guardan de forma permanente",
      "advertisements-content": "En esta versión, no hay ninguna red publicitaria activa en la plataforma. Las cookies de publicidad y seguimiento de terceros están desactivadas.",
      "terms-title-page": "Términos de Servicio - Lingoano",
      "menu-toggle-label": "Abrir/cerrar menú",
      "theme-switcher-label": "Selector de tema",
      "default-theme": "Tema Predeterminado",
      "blue-theme": "Tema Azul",
      "purple-theme": "Tema Morado",
      "green-theme": "Tema Verde",
      "chat": "Chat",
      "about": "Sobre Lingoano",
      "word-of-day": "Palabra del Día",
      "language-guides": "Guías de Idiomas",
      "download": "Descargar",
      "logo-alt": "Logo",
      "terms-of-service": "Términos de Servicio",
      "last-updated": "Última actualización: 26 de agosto de 2025",
      "terms-notice": "Estos Términos de Servicio establecen las reglas y condiciones que debe seguir al usar la plataforma Lingoano. Al usar la plataforma, se considera que ha aceptado estos términos.",
      "acceptance": "1. Aceptación y Acuerdo",
      "acceptance-content": "Al acceder y utilizar los servicios de Lingoano, usted acepta estar sujeto a estos Términos de Servicio y a todas las políticas y divulgaciones incorporadas por referencia. Si no está de acuerdo con los términos, no debe utilizar el servicio. Estos términos se aplican a todas las etapas de su uso de la plataforma.",
      "service-description": "2. Descripción del Servicio",
      "service-description-content": "Lingoano es una plataforma que conecta a usuarios que desean practicar un idioma y les permite comunicarse. Se prefiere la comunicación de igual a igual (P2P) cuando es posible. El servicio se proporciona \"tal cual\" y \"según disponibilidad\". La plataforma tiene como objetivo permitir a los usuarios practicar el aprendizaje de idiomas de forma anónima.",
      "user-responsibilities": "3. Responsabilidades del Usuario",
      "general-rules": "3.1 Reglas Generales",
      "general-rules-content": "Durante el uso del servicio, debe cumplir con las leyes aplicables, el orden público y las reglas de la comunidad:",
      "be-respectful": "Sea respetuoso y cortés",
      "follow-laws": "Actúe de acuerdo con la ley",
      "respect-rights": "Respete los derechos de los demás",
      "no-spam": "No comparta spam o contenido malicioso",
      "no-threats": "No amenace la seguridad de la plataforma",
      "no-harassment": "No acose a otros usuarios",
      "no-impersonation": "No suplante la identidad de otros",
      "prohibited-content": "3.2 Contenido Prohibido",
      "prohibited-content-content": "El siguiente contenido y acciones están estrictamente prohibidos:",
      "hate-speech": "Discurso de odio y discriminación",
      "violence": "Contenido violento",
      "obscene-material": "Material obsceno o pornográfico",
      "illegal-activities": "Actividades ilegales",
      "personal-info": "Compartir información personal",
      "false-info": "Difundir información falsa",
      "malware": "Compartir software malicioso o enlaces",
      "commercial-spam": "Spam comercial y publicidad",
      "terms-privacy-security": "4. Privacidad y Seguridad",
      "anonymity-notice": "Lingoano se compromete a proteger el anonimato del usuario al más alto nivel. La plataforma no solicita información de identificación personal y no requiere que los usuarios compartan sus identidades reales.",
      "terms-privacy-security-content": "Lingoano prioriza la privacidad y seguridad del usuario. Sin embargo, la responsabilidad final de garantizar la seguridad en línea recae en el usuario:",
      "self-responsibility": "Usted es responsable de su propia seguridad",
      "no-personal-info": "No comparta su información personal",
      "report-suspicious": "Informe de comportamientos sospechosos",
      "support-security": "Apoye las medidas de seguridad de la plataforma",
      "secure-connection": "Use una conexión a internet segura",
      "chat-privacy": "4.2 Privacidad del Chat",
      "chat-privacy-content": "La privacidad es nuestra prioridad en los chats realizados a través de la plataforma:",
      "no-chat-storage": "El historial de chat no se almacena de forma permanente",
      "p2p-communication": "Se prefiere la comunicación de igual a igual siempre que sea posible",
      "encrypted-transmission": "Los mensajes se transmiten de forma cifrada",
      "session-only": "Los datos del chat solo se conservan temporalmente durante la sesión",
      "intellectual-property": "5. Propiedad Intelectual",
      "intellectual-property-content": "La marca, el logotipo, la interfaz, el software, el texto y las imágenes de Lingoano están protegidos por la legislación pertinente. No pueden ser copiados, reproducidos, distribuidos o utilizados para crear obras derivadas sin permiso por escrito. El contenido de la plataforma está protegido por derechos de autor y otros derechos de propiedad intelectual.",
      "service-changes": "6. Cambios en el Servicio",
      "service-changes-content": "Lingoano puede actualizar, suspender o descontinuar el alcance y las funciones del servicio de vez en cuando. Se dará un aviso razonable para cambios sustanciales. La plataforma se encuentra en un proceso continuo de desarrollo y mejora.",
      "liability-limitation": "7. Limitación de Responsabilidad",
      "liability-limitation-content": "El servicio se proporciona \"tal cual\" y \"según disponibilidad\". En la medida máxima permitida por la ley aplicable, Lingoano no será responsable de ningún daño indirecto, incidental, especial, consecuente o punitivo. La plataforma no es responsable de los problemas que puedan surgir de la comunicación entre usuarios.",
      "account-suspension": "8. Suspensión y Terminación",
      "account-suspension-content": "En caso de violación de los términos, el acceso puede ser restringido, la(s) cuenta(s) puede(n) ser suspendida(s) o cancelada(s). Los registros que se consideren necesarios para la resolución de disputas pueden almacenarse de acuerdo con la legislación aplicable. La plataforma se reserva el derecho de tomar las medidas necesarias para proteger la seguridad y las reglas de la comunidad.",
      "advertisements": "9. Anuncios y Servicios de Terceros",
      "data-retention": "10. Retención y Procesamiento de Datos",
      "data-retention-content": "Lingoano opera bajo el principio de recolección mínima de datos:",
      "minimal-collection": "Solo se recopilan los datos mínimos necesarios para la prestación del servicio",
      "no-chat-logs": "Los registros de chat no se almacenan permanentemente",
      "temporary-session": "Los datos de la sesión se procesan temporalmente",
      "anonymized-analytics": "Los datos analíticos se recopilan de forma anónima",
      "user-control": "Los usuarios tienen control sobre el procesamiento de sus datos",
      "applicable-law": "11. Ley Aplicable y Jurisdicción",
      "applicable-law-content": "Estos Términos se interpretarán y aplicarán de acuerdo con las leyes de la República de Turquía. Los tribunales y oficinas de ejecución de Estambul (Central) tendrán jurisdicción sobre las disputas. La ley turca también se aplica a los usuarios internacionales.",
      "dispute-resolution": "12. Resolución de Disputas",
      "dispute-resolution-content": "Las disputas relacionadas con la plataforma se intentarán resolver primero mediante negociación. Se pueden tomar acciones legales para las disputas que no se puedan resolver mediante negociación. Los usuarios deben conservar los documentos necesarios para proteger sus derechos.",
      "contact-section": "13. Contacto",
      "contact-content": "Puede enviar sus preguntas sobre estos Términos a través de los siguientes canales:",
      "terms-email": "Correo electrónico: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "response-time": "Tiempo de respuesta: Dentro de 48 horas",
      "terms-acceptance-notice": "Al continuar utilizando la plataforma, se considera que ha aceptado la versión actual de estos Términos de Servicio. Los cambios en los términos entrarán en vigor a partir de la fecha de su publicación.",
      "contact-us": "Contáctenos",
      "contact-description": "Puede contactarnos para sus preguntas, sugerencias o comentarios.",
      "contact-email": "Correo electrónico: contact@lingoano.com",
      "contact-response": "Tiempo de respuesta: Dentro de 24-48 horas",
      "close": "Cerrar",
      "privacy-policy": "Política de Privacidad",
      "contactfooter": "Contacto"
    },
    // French (FR)
    fr: {
        "websocket-temporary": "Dans les chats utilisant le protocole WebSocket, les messages sont traités temporairement et ne sont pas enregistrés de façon permanente",

      "advertisements-content": "Dans cette version, aucun réseau publicitaire n'est actif sur la plateforme. Les cookies de publicité et de suivi tiers sont désactivés.",
      "terms-title-page": "Conditions d'Utilisation - Lingoano",
      "menu-toggle-label": "Ouvrir/fermer le menu",
      "theme-switcher-label": "Sélecteur de thème",
      "default-theme": "Thème par Défaut",
      "blue-theme": "Thème Bleu",
      "purple-theme": "Thème Violet",
      "green-theme": "Thème Vert",
      "chat": "Chat",
      "about": "À propos de Lingoano",
      "word-of-day": "Mot du Jour",
      "language-guides": "Guides Linguistiques",
      "download": "Télécharger",
      "logo-alt": "Logo",
      "terms-of-service": "Conditions d'Utilisation",
      "last-updated": "Dernière mise à jour : 26 août 2025",
      "terms-notice": "Ces Conditions d'Utilisation définissent les règles et conditions que vous devez respecter lors de l'utilisation de la plateforme Lingoano. En utilisant la plateforme, vous êtes réputé avoir accepté ces conditions.",
      "acceptance": "1. Acceptation et Accord",
      "acceptance-content": "En accédant et en utilisant les services de Lingoano, vous acceptez d'être lié par ces Conditions d'Utilisation et toutes les politiques et divulgations incorporées par référence. Si vous n'acceptez pas les conditions, vous ne devez pas utiliser le service. Ces conditions s'appliquent à toutes les étapes de votre utilisation de la plateforme.",
      "service-description": "2. Description du Service",
      "service-description-content": "Lingoano est une plateforme qui met en relation des utilisateurs souhaitant pratiquer une langue et leur permet de communiquer. La communication de pair à pair (P2P) est privilégiée lorsque cela est possible. Le service est fourni \"en l'état\" et \"selon la disponibilité\". La plateforme vise à permettre aux utilisateurs de pratiquer l'apprentissage des langues de manière anonyme.",
      "user-responsibilities": "3. Responsabilités de l'Utilisateur",
      "general-rules": "3.1 Règles Générales",
      "general-rules-content": "Lors de l'utilisation du service, vous devez vous conformer aux lois applicables, à l'ordre public et aux règles de la communauté :",
      "be-respectful": "Soyez respectueux et poli",
      "follow-laws": "Agissez conformément à la loi",
      "respect-rights": "Respectez les droits d'autrui",
      "no-spam": "Ne partagez pas de spam ou de contenu malveillant",
      "no-threats": "Ne menacez pas la sécurité de la plateforme",
      "no-harassment": "Ne harcelez pas les autres utilisateurs",
      "no-impersonation": "N'usurpez pas l'identité d'autrui",
      "prohibited-content": "3.2 Contenu Interdit",
      "prohibited-content-content": "Le contenu et les actions suivants sont strictement interdits :",
      "hate-speech": "Discours de haine et discrimination",
      "violence": "Contenu violent",
      "obscene-material": "Matériel obscène ou pornographique",
      "illegal-activities": "Activités illégales",
      "personal-info": "Partage d'informations personnelles",
      "false-info": "Diffusion de fausses informations",
      "malware": "Partage de logiciels malveillants ou de liens",
      "commercial-spam": "Spam commercial et publicité",
      "terms-privacy-security": "4. Confidentialité et Sécurité",
      "anonymity-notice": "Lingoano s'engage à protéger l'anonymat des utilisateurs au plus haut niveau. La plateforme ne demande pas d'informations d'identification personnelle et n'exige pas que les utilisateurs partagent leur véritable identité.",
      "terms-privacy-security-content": "Lingoano accorde la priorité à la confidentialité et à la sécurité des utilisateurs. Cependant, la responsabilité ultime d'assurer la sécurité en ligne incombe à l'utilisateur :",
      "self-responsibility": "Vous êtes responsable de votre propre sécurité",
      "no-personal-info": "Ne partagez pas vos informations personnelles",
      "report-suspicious": "Signalez tout comportement suspect",
      "support-security": "Soutenez les mesures de sécurité de la plateforme",
      "secure-connection": "Utilisez une connexion Internet sécurisée",
      "chat-privacy": "4.2 Confidentialité du Chat",
      "chat-privacy-content": "La confidentialité est notre priorité dans les chats effectués via la plateforme :",
      "no-chat-storage": "L'historique des chats n'est pas stocké de manière permanente",
      "p2p-communication": "La communication de pair à pair est privilégiée lorsque cela est possible",
      "encrypted-transmission": "Les messages sont transmis sous forme cryptée",
      "session-only": "Les données de chat ne sont conservées que temporairement pendant la session",
      "intellectual-property": "5. Propriété Intellectuelle",
      "intellectual-property-content": "La marque, le logo, l'interface, le logiciel, le texte et les images de Lingoano sont protégés par la législation en vigueur. Ils ne peuvent être copiés, reproduits, distribués ou utilisés pour créer des œuvres dérivées sans autorisation écrite. Le contenu de la plateforme est protégé par le droit d'auteur et d'autres droits de propriété intellectuelle.",
      "service-changes": "6. Modifications du Service",
      "service-changes-content": "Lingoano peut mettre à jour, suspendre ou interrompre l'étendue et les fonctions du service de temps à autre. Un préavis raisonnable sera donné pour les changements substantiels. La plateforme est dans un processus continu de développement et d'amélioration.",
      "liability-limitation": "7. Limitation de Responsabilité",
      "liability-limitation-content": "Le service est fourni \"en l'état\" et \"selon la disponibilité\". Dans la mesure maximale autorisée par la loi applicable, Lingoano ne sera pas responsable des dommages indirects, accessoires, spéciaux, consécutifs ou punitifs. La plateforme n'est pas responsable des problèmes pouvant résulter de la communication entre les utilisateurs.",
      "account-suspension": "8. Suspension et Résiliation",
      "account-suspension-content": "En cas de violation des conditions, l'accès peut être restreint, le(s) compte(s) suspendu(s) ou résilié(s). Les enregistrements jugés nécessaires à la résolution des litiges peuvent être conservés conformément à la législation applicable. La plateforme se réserve le droit de prendre les mesures nécessaires pour protéger la sécurité et les règles de la communauté.",
      "advertisements": "9. Publicités et Services de Tiers",
      "data-retention": "10. Conservation et Traitement des Données",
      "data-retention-content": "Lingoano fonctionne sur le principe de la collecte minimale de données :",
      "minimal-collection": "Seules les données minimales nécessaires à la prestation de services sont collectées",
      "no-chat-logs": "Les journaux de discussion ne sont pas stockés en permanence",
      "temporary-session": "Les données de session sont traitées temporairement",
      "anonymized-analytics": "Les données analytiques sont collectées sous une forme anonymisée",
      "user-control": "Les utilisateurs ont le contrôle sur le traitement de leurs données",
      "applicable-law": "11. Droit Applicable et Juridiction",
      "applicable-law-content": "Ces Conditions seront interprétées et appliquées conformément aux lois de la République de Turquie. Les tribunaux et les bureaux d'exécution d'Istanbul (Central) seront compétents pour les litiges. Le droit turc s'applique également aux utilisateurs internationaux.",
      "dispute-resolution": "12. Résolution des Litiges",
      "dispute-resolution-content": "Les litiges liés à la plateforme seront d'abord tentés d'être résolus par la négociation. Des poursuites judiciaires peuvent être engagées pour les litiges qui ne peuvent être résolus par la négociation. Les utilisateurs doivent conserver les documents nécessaires pour protéger leurs droits.",
      "contact-section": "13. Contact",
      "contact-content": "Vous pouvez envoyer vos questions sur ces Conditions via les canaux suivants :",
      "terms-email": "E-mail : contact@lingoano.com",
      "github": "GitHub : <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "response-time": "Délai de réponse : Dans les 48 heures",
      "terms-acceptance-notice": "En continuant à utiliser la plateforme, vous êtes réputé avoir accepté la version actuelle de ces Conditions d'Utilisation. Les modifications des conditions entreront en vigueur à la date de leur publication.",
      "contact-us": "Contactez-nous",
      "contact-description": "Vous pouvez nous contacter pour vos questions, suggestions ou commentaires.",
      "contact-email": "E-mail : contact@lingoano.com",
      "contact-response": "Délai de réponse : Dans les 24-48 heures",
      "close": "Fermer",
      "privacy-policy": "Politique de Confidentialité",
      "contactfooter": "Contact"
    },
    // Russian (RU)
    ru: {
        "websocket-temporary": "В чатах, использующих протокол WebSocket, сообщения обрабатываются временно и не сохраняются постоянно",
      "advertisements-content": "В этой версии на платформе не активны рекламные сети. Сторонние рекламные и отслеживающие файлы cookie отключены.",
      "terms-title-page": "Условия использования - Lingoano",
      "menu-toggle-label": "Открыть/закрыть меню",
      "theme-switcher-label": "Переключатель тем",
      "default-theme": "Тема по умолчанию",
      "blue-theme": "Синяя тема",
      "purple-theme": "Фиолетовая тема",
      "green-theme": "Зеленая тема",
      "chat": "Чат",
      "about": "О Lingoano",
      "word-of-day": "Слово дня",
      "language-guides": "Языковые гиды",
      "download": "Скачать",
      "logo-alt": "Логотип",
      "terms-of-service": "Условия использования",
      "last-updated": "Последнее обновление: 26 августа 2025 г.",
      "terms-notice": "Настоящие Условия использования устанавливают правила и условия, которым вы должны следовать при использовании платформы Lingoano. Используя платформу, вы считаетесь принявшим эти условия.",
      "acceptance": "1. Принятие и Согласие",
      "acceptance-content": "Получая доступ к услугам Lingoano и используя их, вы соглашаетесь соблюдать настоящие Условия использования и все политики и раскрытия, включенные посредством ссылки. Если вы не согласны с условиями, вы не должны использовать сервис. Эти условия применяются на всех этапах использования вами платформы.",
      "service-description": "2. Описание Услуги",
      "service-description-content": "Lingoano — это платформа, которая подбирает пользователей, желающих практиковать язык, и позволяет им общаться. По возможности предпочтение отдается одноранговой (P2P) связи. Услуга предоставляется «как есть» и «по мере доступности». Платформа нацелена на то, чтобы пользователи могли анонимно практиковать изучение языка.",
      "user-responsibilities": "3. Обязанности Пользователя",
      "general-rules": "3.1 Общие Правила",
      "general-rules-content": "Во время использования сервиса вы должны соблюдать действующее законодательство, общественный порядок и правила сообщества:",
      "be-respectful": "Будьте уважительны и вежливы",
      "follow-laws": "Действуйте в соответствии с законом",
      "respect-rights": "Уважайте права других",
      "no-spam": "Не делитесь спамом или вредоносным контентом",
      "no-threats": "Не угрожайте безопасности платформы",
      "no-harassment": "Не преследуйте других пользователей",
      "no-impersonation": "Не выдавайте себя за других",
      "prohibited-content": "3.2 Запрещенный Контент",
      "prohibited-content-content": "Следующий контент и действия строго запрещены:",
      "hate-speech": "Разжигание ненависти и дискриминация",
      "violence": "Насильственный контент",
      "obscene-material": "Непристойные или порнографические материалы",
      "illegal-activities": "Незаконная деятельность",
      "personal-info": "Обмен личной информацией",
      "false-info": "Распространение ложной информации",
      "malware": "Обмен вредоносным ПО или ссылками",
      "commercial-spam": "Коммерческий спам и реклама",
      "terms-privacy-security": "4 Конфиденциальность и Безопасность",
      "anonymity-notice": "Lingoano стремится защищать анонимность пользователей на самом высоком уровне. Платформа не запрашивает личную идентификационную информацию и не требует от пользователей раскрытия их настоящих личностей.",
      "terms-privacy-security-content": "Lingoano уделяет приоритетное внимание конфиденциальности и безопасности пользователей. Однако окончательная ответственность за обеспечение онлайн-безопасности лежит на пользователе:",
      "self-responsibility": "Вы несете ответственность за свою собственную безопасность",
      "no-personal-info": "Не делитесь своей личной информацией",
      "report-suspicious": "Сообщайте о подозрительном поведении",
      "support-security": "Поддерживайте меры безопасности платформы",
      "secure-connection": "Используйте безопасное интернет-соединение",
      "chat-privacy": "4.2 Конфиденциальность Чата",
      "chat-privacy-content": "Конфиденциальность является нашим приоритетом в чатах, проводимых через платформу:",
      "no-chat-storage": "История чата не хранится постоянно",
      "p2p-communication": "По возможности предпочтение отдается одноранговой связи",
      "encrypted-transmission": "Сообщения передаются в зашифрованном виде",
      "session-only": "Данные чата хранятся только временно во время сеанса",
      "intellectual-property": "5. Интеллектуальная Собственность",
      "intellectual-property-content": "Бренд, логотип, интерфейс, программное обеспечение, текст и изображения Lingoano защищены соответствующим законодательством. Их нельзя копировать, воспроизводить, распространять или использовать для создания производных работ без письменного разрешения. Контент платформы защищен авторским правом и другими правами интеллектуальной собственности.",
      "service-changes": "6. Изменения в Услуге",
      "service-changes-content": "Lingoano может время от времени обновлять, приостанавливать или прекращать объем и функции сервиса. О существенных изменениях будет сообщено в разумные сроки. Платформа находится в непрерывном процессе разработки и улучшения.",
      "liability-limitation": "7. Ограничение Ответственности",
      "liability-limitation-content": "Услуга предоставляется «как есть» и «по мере доступности». В максимальной степени, разрешенной действующим законодательством, Lingoano не несет ответственности за любые косвенные, случайные, особые, последующие или штрафные убытки. Платформа не несет ответственности за проблемы, которые могут возникнуть в результате общения между пользователями.",
      "account-suspension": "8. Приостановка и Прекращение",
      "account-suspension-content": "В случае нарушения условий доступ может быть ограничен, учетная(ые) запись(и) приостановлена(ы) или прекращена(ы). Записи, которые считаются необходимыми для разрешения споров, могут храниться в соответствии с действующим законодательством. Платформа оставляет за собой право принимать необходимые меры для защиты безопасности и правил сообщества.",
      "advertisements": "9. Реклама и Сторонние Сервисы",
      "data-retention": "10. Хранение и обработка данных",
      "data-retention-content": "Lingoano работает по принципу минимального сбора данных:",
      "minimal-collection": "Собираются только минимальные данные, необходимые для предоставления услуг",
      "no-chat-logs": "Журналы чатов не хранятся постоянно",
      "temporary-session": "Данные сеанса обрабатываются временно",
      "anonymized-analytics": "Аналитические данные собираются в анонимной форме",
      "user-control": "Пользователи имеют контроль над обработкой своих данных",
      "applicable-law": "11. Применимое Право и Юрисдикция",
      "applicable-law-content": "Настоящие Условия толкуются и применяются в соответствии с законодательством Турецкой Республики. Суды и исполнительные органы Стамбула (Центральный) обладают юрисдикцией в отношении споров. Турецкое законодательство также применяется к международным пользователям.",
      "dispute-resolution": "12. Разрешение Споров",
      "dispute-resolution-content": "Споры, связанные с платформой, сначала будут решаться путем переговоров. В случае споров, которые не могут быть разрешены путем переговоров, могут быть предприняты юридические действия. Пользователи должны хранить необходимые документы для защиты своих прав.",
      "contact-section": "13. Контакты",
      "contact-content": "Вы можете направить свои вопросы по поводу этих Условий по следующим каналам:",
      "terms-email": "Эл. почта: contact@lingoano.com",
      "github": "GitHub: <a href=\"https://github.com/AhmetEfeYSR\" target=\"_blank\" rel=\"noopener noreferrer\">https://github.com/AhmetEfeYSR</a>",
      "response-time": "Время ответа: В течение 48 часов",
      "terms-acceptance-notice": "Продолжая использовать платформу, вы считаетесь принявшим текущую версию настоящих Условий использования. Изменения в условиях вступают в силу с даты их публикации.",
      "contact-us": "Свяжитесь с нами",
      "contact-description": "Вы можете связаться с нами по вопросам, предложениям или для обратной связи.",
      "contact-email": "Эл. почта: contact@lingoano.com",
      "contact-response": "Время ответа: В течение 24-48 часов",
      "close": "Закрыть",
      "privacy-policy": "Политика Конфиденциальности",
      "contactfooter": "Контакты"
    }
  };

  class LanguageManager {
    constructor() {
        this.currentLanguage = localStorage.getItem('Lingoano-site-language') || null;
        this.init();
    }
    
    init() {
        if (this.currentLanguage) {
            // User has already selected a language, use it
            this.setLanguage(this.currentLanguage);
        } else {
            // No language selected, detect from IP
            this.detectLanguageFromIP();
        }
        this.bindEvents();
    }
    
    async detectLanguageFromIP() {
        // Show loading indicator
        this.showLanguageLoading();
        
        // Try multiple IP detection services for better reliability
        const services = [
            'https://ipapi.co/json/',
            'https://ipinfo.io/json',
            'https://api.ipify.org?format=json'
        ];
        
        for (const service of services) {
            try {
                const controller = new AbortController();
                const timeoutId = setTimeout(() => controller.abort(), 5000);
                
                const response = await fetch(service, { 
                    method: 'GET',
                    headers: { 'Accept': 'application/json' },
                    signal: controller.signal
                });
                
                clearTimeout(timeoutId);
                
                if (!response.ok) continue;
                
                const data = await response.json();
                
                // Handle different response formats
                let countryCode = null;
                if (data.country_code) {
                    countryCode = data.country_code.toLowerCase();
                } else if (data.country) {
                    countryCode = data.country.toLowerCase();
                }
                
                if (countryCode) {
                    const detectedLanguage = this.getLanguageFromCountry(countryCode);
                    
                    if (detectedLanguage) {
                        const countryName = data.country_name || data.country || countryCode;
                        console.log(`Detected language from IP: ${detectedLanguage} (Country: ${countryName})`);
                        this.hideLanguageLoading();
                        this.setLanguage(detectedLanguage);
                        return;
                    }
                }
            } catch (error) {
                console.log(`IP detection service ${service} failed:`, error.message);
                continue;
            }
        }
        
        // If all IP services fail, try browser language detection
        console.log('All IP detection services failed, trying browser language...');
        this.detectLanguageFromBrowser();
    }
    
    showLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'flex';
        }
    }
    
    hideLanguageLoading() {
        const loadingElement = document.getElementById('language-loading');
        if (loadingElement) {
            loadingElement.style.display = 'none';
        }
    }
    
    getLanguageFromCountry(countryCode) {
        // Map countries to supported languages
        const countryToLanguage = {
            // Turkish speaking countries
            'tr': 'tr',
            'cy': 'tr', // Northern Cyprus
            
            // English speaking countries
            'us': 'en', 'gb': 'en', 'ca': 'en', 'au': 'en', 'nz': 'en', 'ie': 'en',
            'za': 'en', 'in': 'en', 'pk': 'en', 'ng': 'en', 'ke': 'en', 'ug': 'en',
            'tz': 'en', 'gh': 'en', 'zm': 'en', 'zw': 'en', 'mw': 'en', 'bw': 'en',
            'sz': 'en', 'ls': 'en', 'na': 'en', 'mu': 'en', 'sc': 'en', 'mv': 'en',
            'lk': 'en', 'bd': 'en', 'np': 'en', 'bt': 'en', 'mm': 'en', 'kh': 'en',
            'la': 'en', 'vn': 'en', 'my': 'en', 'sg': 'en', 'bn': 'en', 'ph': 'en',
            'fj': 'en', 'pg': 'en', 'sb': 'en', 'vu': 'en', 'nc': 'en', 'pf': 'en',
            'to': 'en', 'ws': 'en', 'ki': 'en', 'tv': 'en', 'nr': 'en', 'pw': 'en',
            'mh': 'en', 'fm': 'en', 'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en',
            'jm': 'en', 'bb': 'en', 'gd': 'en', 'lc': 'en', 'vc': 'en', 'ag': 'en',
            'dm': 'en', 'kn': 'en', 'ai': 'en', 'vg': 'en', 'tc': 'en', 'ms': 'en',
            'ky': 'en', 'bm': 'en', 'fk': 'en', 'gi': 'en', 'sh': 'en', 'io': 'en',
            'pn': 'en', 'ck': 'en', 'nu': 'en', 'tk': 'en', 'wf': 'en', 'as': 'en',
            'mp': 'en', 'gu': 'en', 'vi': 'en', 'pr': 'en', 'jm': 'en', 'bb': 'en',
            
            // German speaking countries
            'de': 'de', 'at': 'de', 'ch': 'de', 'li': 'de', 'lu': 'de',
            
            // French speaking countries
            'fr': 'fr', 'be': 'fr', 'mc': 'fr', 'ca': 'fr',

            // Spanish speaking countries
            'es': 'es', 'mx': 'es', 'ar': 'es', 'cl': 'es', 'pe': 'es', 'co': 'es', 'ec': 'es',
            'uy': 'es', 'py': 'es', 'bo': 'es', 've': 'es', 'do': 'es', 'cr': 'es', 'gt': 'es',
            'hn': 'es', 'ni': 'es', 'sv': 'es', 'pa': 'es', 'cu': 'es',
            
            // Russian speaking countries
            'ru': 'ru', 'by': 'ru', 'kz': 'ru', 'kg': 'ru', 'tj': 'ru',
            'uz': 'ru', 'tm': 'ru', 'md': 'ru', 'ge': 'ru', 'am': 'ru',
            'az': 'ru', 'ua': 'ru', 'ee': 'ru', 'lv': 'ru', 'lt': 'ru'
        };
        
        return countryToLanguage[countryCode] || null;
    }
    
    detectLanguageFromBrowser() {
        // Get browser language
        const browserLang = navigator.language || navigator.userLanguage;
        const langCode = browserLang.split('-')[0].toLowerCase();
        
        // Map browser language to supported languages
        const browserToLanguage = {
            'tr': 'tr',
            'en': 'en',
            'de': 'de',
            'fr': 'fr',
            'es': 'es',
            'ru': 'ru'
        };
        
        const detectedLanguage = browserToLanguage[langCode];
        
        if (detectedLanguage) {
            console.log(`Detected language from browser: ${detectedLanguage}`);
            this.hideLanguageLoading();
            this.setLanguage(detectedLanguage);
        } else {
            // Default to Turkish if no match found
            console.log('No language detected, defaulting to Turkish');
            this.hideLanguageLoading();
            this.setLanguage('tr');
        }
    }
    
    setLanguage(lang, saveToStorage = false) {
        if (!translations[lang]) {
            console.warn(`Language ${lang} not found, falling back to Turkish`);
            lang = 'tr';
        }
        
        this.currentLanguage = lang;
        
        // Only save to localStorage if user manually selected
        if (saveToStorage) {
            localStorage.setItem('Lingoano-site-language', lang);
        }
        
        // Update language selectors
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.value = lang;
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.value = lang;
        }
        
        // Update all translatable elements
        this.updatePageContent();
    }
    
    getText(key) {
        return translations[this.currentLanguage][key] || translations['tr'][key] || key;
    }
    
    updatePageContent() {
        // Update elements with data-lang attribute
        const elements = document.querySelectorAll('[data-lang]');
        elements.forEach(element => {
            const key = element.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                if (element.tagName === 'INPUT' && element.hasAttribute('placeholder')) {
                    element.placeholder = translation;
                } else if (element.hasAttribute('title')) {
                    element.title = translation;
                } else if (element.hasAttribute('aria-label')) {
                    element.setAttribute('aria-label', translation);
                } else if (element.hasAttribute('alt')) {
                    element.alt = translation;
                } else {
                    element.innerHTML = translation;
                }
            }
        });
        
        // Update form options
        this.updateFormOptions();
        
        // Update dictionary widget if it exists
        if (window.dictionaryWidget) {
            window.dictionaryWidget.updateLanguage();
        }
    }
    
    updateFormOptions() {
        // Update language form options
        const languageSelect = document.getElementById('language');
        if (languageSelect) {
            const options = languageSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = option.value;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update level form options
        const levelSelect = document.getElementById('level');
        if (levelSelect) {
            const options = levelSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value === '') {
                    option.textContent = this.getText('select-option');
                } else if (option.value) {
                    const key = `level-${option.value.toLowerCase()}`;
                    const translation = this.getText(key);
                    if (translation && translation !== key) {
                        option.textContent = translation;
                    }
                }
            });
        }
        
        // Update meta description for current language
        const metaDesc = document.querySelector('meta[name="description"]');
        if (metaDesc) {
            const currentLang = this.currentLanguage;
            // This could be expanded to have page-specific descriptions per language
        }
        
        // Update document title if it has data-lang
        const titleElement = document.querySelector('title[data-lang]');
        if (titleElement) {
            const key = titleElement.getAttribute('data-lang');
            const translation = this.getText(key);
            if (translation && translation !== key) {
                titleElement.textContent = translation;
            }
        }
    }
    
    bindEvents() {
        const languageSelect = document.getElementById('site-language');
        const languageSelectDesktop = document.getElementById('site-language-desktop');
        
        if (languageSelect) {
            languageSelect.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
        
        if (languageSelectDesktop) {
            languageSelectDesktop.addEventListener('change', (e) => {
                // When user manually selects a language, save it to localStorage
                this.setLanguage(e.target.value, true);
            });
        }
    }
}

// Initialize language manager when DOM is loaded
let languageManager;
document.addEventListener('DOMContentLoaded', () => {
    languageManager = new LanguageManager();
    // Make it globally available after initialization
    window.languageManager = languageManager;
});

// Make translations globally available immediately
window.translations = translations;

// Remove AdSense-related translation keys across all languages at runtime
(function removeAdKeys() {
    try {
        const keysToRemove = [
            'google-adsense',
            'google-adsense-content',
            'google-adsense-terms',
            'google-adsense-terms-content',
            'adsense-cookies',
            'adsense-privacy',
            'adsense-opt-out',
            'adsense-compliance'
        ];
        Object.keys(translations || {}).forEach(lang => {
            const dict = translations[lang];
            if (!dict) return;
            keysToRemove.forEach(k => { try { delete dict[k]; } catch (_) {} });
        });
    } catch (_) {}
})();

